 ORG    &h4000  
 DB &HFF    ; This byte is not excuted, it is file editor EOF marker (backwards)

CHESSSTART:
	LDW IX,BOARD-1     ; Initialized board will be relocated to printer screen buffer
	LDW IY,STEPVECS-1
	LDW IZ,&HCC01-1    ; Here will be the board
	CAL &H0008         ; Relocate routine
 LDW IY,&HC800  ; StackPos=0 in memory for large screen buffer
 LD R74,8  ; GameSide=8 for White, 16 for Black
; LDM R64..R71,0  ; Initialise some global variables
 ld R67,128
; R72..R73,0  ; FunctionValue=0
; R69..R70 ; RootEval=0
; LDM R69..R70,0
; R65..R66,0  ; N=0
; R67   ; RootEp
LEVEL EQU 4
 
LP:         ; do {                 Main game loop
 LDM R65..R66,0  ; N=0

 CAL ENTERMOVE      ; Display board and return variables InputFrom and InputTo after Graph is pressed or Range twice
 ; Now prepare parameters to call main search routine
 LD R0,R74    ;                      Side=GameSide;
 BYD R1            ;           Alpha=-INF;
 LD R2,&HE0              
 BYD R3             ;                    Beta=INF;
 LD R4,&H20     
 LDM R5..R6,R69..R70 ;               Eval=RootEval;
 LD R7,R67 ;                         epSqr=RootEp;
 LD R8,8  ;                          LastTo=8; 8 is illegal square, this value indicates root of search tree
 LD R9,2 ;                          Depth=2;
 
 CAL SAVEALL     ;                   SaveAll();

 CAL SEARCH  ;                           Search();

 CAL RESTALL ;                           RestoreAll(); 

 LD R77,9  ;Cursor out of board
 CAL DISP
   ; For the move entered on keyboard, we will return Beta, it will remain INF (&H2000) if we are not in check, and the move is valid
   
    ;            if (FunctionValue==INF) GameSide ^= 24;     Move is legal, flip GameSide between 8 and 16
 TSB R73,&H20
 JMP NZ,LP   ; Invalid move
 XR R74,&H18
 JMP LP  ; } while (1);
; db 0 ; accidentally one jump has FF in it
SEARCH:
 LDW IX,&HCC01        ;  IX points to Board
 LDW IZ,STEPVECS      ;  IZ points to StepVecs
 STM +(IY),R0..R7     ; Store parameter in  registers to memory	, IY is stack for local variables
 STM +(IY),R8..R9
 SBW IY,10            
;    Alpha--;
 SBM R1..R2,1
;    IterDepth = BestFrom = BestTo = 0;
 BYD R29
 BYD R25
 BYD R26
 
;    BestScore=-INF;
 BYD R10
 LD R11,&HE0     ;        
; Completely stupid full-width search in principle tries anything, even the most idiotic moves like taking a defended Pawn with a Queen. 
;  Going into the search 'depth first', on the other hand, tends to dive deep into idiotic variations before realizing they were idiotic, 
; when accidentally hitting upon the proper refutation. 
;while( 1) {          Iterative deeping loop
ITDLOOP:
;       h=0;   Variable h will be zero if we need to exit iterative deeping loop
 BYD R31
;       if (IterDepth++ < Depth)           Depth below 2 half moves     
 LD R88,R29
 AD R29,1
 TSB R88,R9
 JMP NC,ITDDELSE
;         h=1;
 LD R31,1
 JMP ITDENDIF
ITDDELSE:
;       else
;       if   (LastTo==8&InputFrom==0xFE) {         We are at thinked move, root of search
 TSB R8,8
 JMP NZ,ITDENDIF
 TSB R78,&HFE
 JMP NZ,ITDENDIF

;        h=1;      
 LD R31,1
;        if (!(N<2048 & IterDepth<4)) {  // Increasing these constants will make the game smarter, but much slower. Do not increase IterDepth above 12, due to allocated stack space   
 TSB R66,LEVEL  ; 4 * 256 positions to check
 JMP NC,SETIT
 TSB R29,LEVEL  ; 4 half moves depth
 JMP C,ITDENDIF
SETIT: 
;          InputFrom=BestFrom;    // So, we are at root, thinked move and exhausted limit of moves or iteration depth. Set up the best move as it was entered
 LD R78,R25
;          InputTo=BestTo&~M;
 LD R79,R26
 AN R79,&H77
;          IterDepth=2;
 LD R29,2
;          if (BestScore==-INF)   
;            printf ("Check mate\n");
 TSB R11,&HE0   ; Write by putting Sprite CM
 JMP NZ,ITDENDIF
 LD R33,10
 ST (IX+&H44),R33
;        }
;       }
ITDENDIF: 
;       if (! h) 
;          break;        Exit the iterative deeping root
  TSB R31,0
  JMP Z,ENDITDLOOP   
;/* Each iteration consist of a move-generation run, immediately searching      */
;    /* all moves as they are generated. The best move from the previous iter-      */
;    /* ation (still contained in BestFrom, BestTo) is slipped in front, though.    */
;    /* To make this easier, move generation starts at StartSqr = BestFrom.         */
;    /* The highest -bit of BestTo indicates if there is a valid best move to try.         */  
;        FromSqr = StartSqr = BestFrom;    Start from previous best move
  LD R88,R25
  LD R28,R88
  LD R23,R88
;        h = BestTo & S;   
  LD R88,R26
  AN R88,128
  LD R31,R88
;        if (IterDepth > 1)   /* unconsidered:static eval */
  LD R88,1
  TSB R88,R29
  JMP NC,IFITELSE
;            BestScore = -INF;
  BYD R10
  LD R11,&HE0  
  JMP ENDIFIT
;        else
IFITELSE:
;            BestScore = Eval;
  LD R88,R5
  LD R10,R88
  LD R88,R6
  LD R11,R88

ENDIFIT:
;        N=N+1;    /* node count (for timing)  *
  ADM R65..R66,1
;        do {
MAINDO:
;            Piece = Board[FromSqr];   /* scan board looking for  piece */
  LD R88,(IX+R23)
  LD R21,R88
;            if (Piece & Side) {  /*  This players piece */
  AN R88,R0
  JMP Z,ENDPCSIDE
;                StepVec = PieceType = Piece & 7;   /* set StepVec > 0          */
  LD R88,R21
  AN R88,7
  LD R22,R88
  LD R16,R88
;                j = StepVecs[PieceType + 16];  /* first step vector Piece  */ -1 to avoid FF in file editor
  AD R88,16
  LD R32,R88
  LD R88,(IZ+R32)
  SB R88,1
  LD R19,R88
;                while (1) {
DIRLOOP:

;                    if (PieceType > 2 & StepVec < 0)    /* loop over directions o[] */
  LD R88,2
  TSB R88,R22
  JMP NC,BIDIRECT
  TAN R16,128
  JMP Z,BIDIRECT

;                      StepVec = -StepVec;
  CMP R16
  JMP ENDBIDIR
;                    else 
BIDIRECT:
;                      StepVec = -StepVecs[++j]; 
  AD R19,1
  LD R88,(IZ+R19)
  CMP R88
  LD R16,R88
ENDBIDIR:
;                    if (StepVec == 0)
;                      break;
  TSB R16,0
  JMP Z,ENDDIRLOOP
;                    A:   /* resume normal after best */
RESUMENORMAL:
;                     ToSqr = FromSqr;
;           /* For each direction we scan ToSqr along the ray startig at FromSqr.    */

  LD R88,R23
  LD R24,R88
;                    SkipSqr = RookSqr = S;   /* S = 0x80 = dummy square  */
  LD r18,128
  ld r17,128
;                    do {
;            /* FromSqr, ToSqr here scan through all tentative moves. If there      */
;            /* is an old best move to try first, this is indicated in the 8-bit    */
;            /* of BestTo (which was copied from the S-bit), and we overrule the    */
;            /* generated ToSqr (which might ly at other distance or in direction)  */
;            /* We then test if ToSqr is on the board, if we have an e.p. capture,  */
;            /* are blocked by an own piece, and if Pawn moves are valid.           */

DOCAPT:
;                        if (h != 0)
  TSB R31,0
  JMP Z,SETNEWTO
;                            ToSqr = BestTo ^ h;    /* sneak-in prev. best move */
  LD R88,R26
  XR R88,R31
  LD R24,R88
  JMP SETCAPTSQR
;                        else
SETNEWTO:
;                            ToSqr += StepVec;
  LD R88,R16
  AD R24,R88
SETCAPTSQR:
;                        CaptSqr = ToSqr;
  LD R88,R24
  LD R27,R88
;                        if (ToSqr & M) break;  /* board edge hit (M=0x88)  */
  TAN R24,&H88
  JMP NZ,ENDDOCAPT
; We can not castle if in check, or fields that we pass with king are attacked
;                        if ((epSqr - S && Board[epSqr] && ToSqr - epSqr < 2 & epSqr - ToSqr < 2))
  TSB R7,128
  JMP Z,CHECKENPAS
  LD R88,(IX+R7)
  TSB R88,0
  JMP Z,CHECKENPAS
  LD R88,R24
  SB R88,R7
  SB R88,2
  TAN R88,128
  JMP Z,CHECKENPAS
  LD R88,R7
  SB R88,R24
  SB R88,2
  TAN R88,128
  JMP Z,CHECKENPAS
;                            BestScore = INF; /* castling-on-Pawn-check bug fixed */
  BYD R10
  LD R11,&H20
CHECKENPAS:
;                        if (PieceType < 3 & ToSqr == epSqr)  /* shift CaptSqr if e.p.    */
  TSB R22,3
  JMP NC,SETVICTIM
  LD R88,R24
  TSB R88,R7
  JMP NZ,SETVICTIM
;                            CaptSqr ^= 16;
  XR R27,16
SETVICTIM:
;                        Victim = Board[CaptSqr];  Take piece we capture
  LD R88,(IX+R27)
  LD R20,R88
;                        if (Victim & Side                                                    /* capture own              */
;                                  | PieceType < 3 & !(ToSqr - FromSqr & 7) - !Victim)      /* bad pawn move              */
  BYD R89
  LD R88,R24   ; ToSqr
  SB R88,R23   ; From Sqr
  AN R88,7
  JMP Z,SV1
  LD R89,1
SV1:
  BYD R32
  TSB R20,0
  JMP Z,SV2
  LD R32,1
SV2:
  SB R89,R32
  BYD R32
  TSB R22,3
  JMP NC,SV3
  LD R32,1
SV3:
  AN R32,R89
  LD R88,R20
  AN R88,R0
  OR R32,R88  
;                            break;
  JMP NZ,ENDDOCAPT
;                        i = PieceVal[Victim & 7];    /* value of victim piece.16 bit    */
 LD R88,R20
 AN R88,7
 LD R32,R88
 LDW IZ,PIECEVAL
 LD R88,(IZ+R32)
 LD R14,R88
 LDW IZ,PIECEVALHI
 LD R88,(IZ+R32)
 LD R15,R88
 LDW IZ,STEPVECS
;                        if (i < 0)     /* King capture gives maximal score   */
 TAN R15,128
 JMP Z,TESTCUT
;                        BestScore = INF          ; /* castling-on-Pawn-check bug fixed */
 BYD R10
 LD R11,&H20     ;        

TESTCUT:
;                        if (BestScore >= Beta)    /* abort on fail high       */
 LD R91,R10
 LD R92,R11
 SBM R91..R92,R3..R4
 TAN R92,128
 
;                            goto CutOff;
 JMP Z,CUTOFF  
;            /* We now have a move to search. If there is depth left, we different- */
;            /* ially update the evaluation, Make the move, Search it recursively   */
;            /* UnMake it, and update the best score & move. If not, we ignore it.  */

TEST:
;                        if (s = IterDepth - (ToSqr != LastTo)) {    /* remaining depth(-recapt.)*/
 LD R88,R29
 LD R30,R88
 LD  R88,R24
 TSB R88,R8
 JMP Z,SETITDEP
 SB R30,1

SETITDEP:
 TSB R30,0
 JMP Z,ENDSCOREIF
;                            if (PieceType < 6)     /* center positional pts.   */
 LDM R12..R13,0
 BYD R93
 TSB R22,6
 JMP NC,STARTMOVE
;                                Score = Board[FromSqr + 8] - Board[ToSqr + 8];
 LD R88,R23
 AD R88,8
 LD R32,R88
 LD R92,(IX+R32)
 ADM R12..R13,R92..R93
 LD R88,R24
 AD R88,8
 LD R32,R88
 LD R92,(IX+R32)
 SBM R12..R13,R92..R93

;                            else
;                                Score = 0;

STARTMOVE
;              /* Make move & evaluate                                              */

;                            Board[RookSqr] = Board[CaptSqr] = Board[FromSqr] = 0;
 BYD R88
 ST (IX+R17),R88
 ST (IX+R27),R88
 ST (IX+R23),R88

;                            Board[ToSqr] = Piece | 32;  /* do move, set non-virgin bit (Piece moved)*/
 LD R88,R21
 OR R88,32
 ST (IX+R24),R88
;                            if (!(RookSqr & M))  /* castling */
 LD R88,R17
 AN R88,&H88
 JMP NZ,TESTPAWN
;                                Board[SkipSqr] = Side + 6, Score += 30;   Put Rook and Score

 LD R88,R0
 AD R88,6
 ST (IX+R18),R88
 ADM R12..R13,30
TESTPAWN:
;                            if (PieceType < 3) {   /* pawns:                   */
 TSB R22,3
 JMP NC,SETNEWBETA
;                                Score -= 9 * ((FromSqr - 2 & M || Board[FromSqr - 2] - Piece) +  /* structure, undefended    */
;                                    (FromSqr + 2 & M || Board[FromSqr + 2] - Piece) - 1); /* squares plus bias */
 LD R92,10
 BYD R93
 LD R88,R23
 SB R88,2
 LD R32,R88
 AN R88,&h88
 JMP NZ,PAWNPUNIS1
 LD R88,(IX+R32)
 SB R88,R21
 JMP Z,PAWNCHECK2
PAWNPUNIS1:
 SBM R12..R13,R92..R93
PAWNCHECK2
 LD R88,R23
 AD R88,2
 LD R32,R88
 AN R88,&h88
 JMP NZ,PAWNPUNIS2
 LD R88,(IX+R32)
 SB R88,R21
 JMP Z,PAWNAWARD
PAWNPUNIS2:
 SBM R12..R13,R92..R93
PAWNAWARD:
 ADM R12..R13,R92..R93

;                                if (ToSqr + StepVec + 1 & S)   /* promote Pawn  */
 LD R88,R24
 AD R88,R16
 AD R88,1
 AN R88,128
 JMP Z,SETNEWBETA
;                                    Board[ToSqr] |= 7, i += 800;   /* promote Pawn to Queen,  update score */
 LD R88,(IX+R24)
 OR R88,7
 ST (IX+R24),R88
 LD R94,&H84
 LD R95,3
 ADM R14..R15,R94..R95

;                            }
; Now recursive call of Eval function to calculate value of reply
; Set new Beta value to -MAX(BestScore,Alpha)
SETNEWBETA:
;                            if (BestScore > Alpha)
 LD R89,R10
 LD R90,R11
 SBM R89..R90,R1..R2
 JMP Z,NEWALP1
 TAN R90,128
 JMP NZ,NEWALP1
;                                NewBeta = -BestScore;
 LDM R90..R91,R10..R11
 CMPM R90..R91
 LD R32,R90
 LD R33,R91
 JMP REPLYEVAL

;                            else NewBeta = -Alpha;
NEWALP1:
 LDM R89..R90,R1..R2
 CMPM R89..R90
 LD R32,R89
 LD R33,R90

; //                           Score = -Search(24 - Side, -Beta, NewBeta, -Eval - Score - i, SkipSqr, ToSqr, s);
REPLYEVAL:
;                       if (StackPos < 24*32) {
; TSB r121,&HCB             IY Stack checking
; JMP NC,REPLYFINISH
;                            SaveAll();   All local variables to IY stack
   CAL SAVEALL
;                            Side=24-Side;  Flip side
   XR R0,24
;                            Alpha=-Beta;

 LDM R91..R92,R3..R4
 CMPM R91..R92 
 LD R1,R91
 LD R2,R92
;                            Beta=NewBeta;
 LD R88,R32
 LD R3,R88
 LD R88,R33
 LD R4,R88
;                            Eval=(-Eval-Score-i);  /* New Eval                 */
 LD R93,R12
 LD R94,R13
 ADM R5..R6,R93..R94
 LD R93,R14
 LD R94,R15
 ADM R5..R6,R93..R94
 CMPM R5..R6
 
;                            epSqr=SkipSqr;  /* New en passant square */
 LD R88,R18
 LD R7,R88
;                            LastTo=ToSqr;
 LD R88,R24
 LD R8,R88
;                            Depth=s;
 LD R88,R30
 LD R9,R88

;                            Search();  Recursion
 CAL SEARCH
;                            RestoreAll();  Back from IY stack
 CAL RESTALL
;                            Score= -FunctionValue;   Oponent reply is negative
 LD R12,R72
 LD R13,R73
 CMPM R12..R13
;                        }
REPLYFINISH:
;              /* If the Search routine was called as move-legality checker, we     */
;              /* now return before unmaking the move if it was the input move.     */

;                            if (InputFrom != 0xFE)    Here we are if we entered the move, recursion was used for legality check
 TSB R78,&HFE
 JMP Z,TAKEBACK
;                                if (Score + INF && FromSqr == InputFrom & ToSqr == InputTo & LastTo == 8) {  // Move found
 TSB R13,&hE0
 JMP Z,ALTENTERSC
 TSB R23,R78
 JMP NZ,ALTENTERSC
 TSB R24,R79
 JMP NZ,ALTENTERSC
 TSB R8,8
 JMP NZ,ALTENTERSC

 
;                                    RootEval = -Eval - i;   /* update eval, material    */
 LD R94,R5
 LD R95,R6
 ADM R94..R95,R14..R15
 CMPM R94..R95
 STM -(SP),R95..R94
 LDM R69..R70,(SP)+
;                                    RootEp = SkipSqr;
 LD R67,R18
;                                    if (Board[ToSqr] - Piece & 7 && P - InBuf > 5)
;                                        Board[ToSqr] -= InBuf[4] & 3; /* under-promotions */
; NOT IMPLEMENTED
;                                    FunctionValue=Beta;  /* Not in check signal    */
 LD R72,R3
 LD R73,R4
;                                    return;
 RTN
;                                }
ALTENTERSC:
;                                Score = BestScore;   /* (prevent fail-lows on    K-capt. replies)       */
  STM -(SP),R11..R10
  LDM R12..R13,(SP)+

;                            }
TAKEBACK:
;  undo move,RookSqr can be dummy
;                            Board[RookSqr] = Side + 6;
 LD R88,R0
 AD R88,6
 ST (IX+R17),R88
;                            Board[SkipSqr] = Board[ToSqr] = 0;
 BYD R88
 ST (IX+R18),R88
 ST (IX+R24),R88
;                            Board[FromSqr] = Piece;
 LD R88,R21
 ST (IX+R23),R88

;                            Board[CaptSqr] = Victim;
 LD R88,R20
 ST (IX+R27),R88

 ;             /* Process score. If the move just searched was a previous best      */
;              /* move that was tried first, we take its Score and redo the first   */
;              /* ray of this piece. Otherwise update best score and move.          */

 
;                            if (Score > BestScore)
 LD R90,R12
 LD R91,R13
 SBM R90..R91,R10..R11
 JMP Z,TESTH
 TAN R91,128
 JMP NZ,TESTH

;                                BestScore = Score, BestFrom = FromSqr, BestTo = ToSqr | S & SkipSqr;   /* Update and mark non-castling with S  */
  STM -(SP),R13..R12
  LDM R10..R11,(SP)+
  LD R88,R23
  LD R25,R88
  LD R88,128
  AN R88,R18
  OR R88,R24
  LD R26,R88


TESTH:
;                            if (h) {
 TSB R31,0
 JMP Z,ENDSCOREIF
 
;                                h = 0;
 BYD R31
;                                goto A;    Best is first done, now normal search
 JMP RESUMENORMAL
;                            }
;                        }
ENDSCOREIF:
;            /* Determine if we have to continue scanning this ray. We must stop    */
;            /* on a capture, or if the piece is a non-slider, with the exceptions  */
;            /* of double moves for Pawns and King (castlings!). Such double moves  */
;            /* cause setting of the SkipSqr, that otherwise is equal to the dummy S*/
;                        if(PieceType>2) {
 LD R88,2
 TSB R88,R22
 JMP NC,NOPCM
;                          PieceMask=PieceType-3|j-7 ;  /* King moving sideways,          */
 LD R89,R19
 SB R89,7
 LD R90,R22
 SB R90,3
 LD R32,R89
 OR R32,R90
;                          if (! PieceMask) {
 TSB R32,0
 JMP NZ,RAYDECIDE
;                            RookSqr=FromSqr+3^StepVec>>1&7; /* virgin Rook in corner     */
 LD R88,R23
 AD R88,3
 LD R89,R16
 ;LD R90,r16
 ;BIU R90
 ROD R89
 AN R89,7
 LD r17,R88
 XR R17,R89
;                            PieceMask=Board[RookSqr]-Side-6;  /* virgin Rook in corner     */
 LD R88,(IX+R17)
 SB R88,R0
 SB R88,6
 LD R32,R88
;                            if (! PieceMask)
 TSB R32,0
 JMP NZ,RAYDECIDE
;                              PieceMask= Board[RookSqr^1]|Board[RookSqr^2];  /* 2 empty sqrs. next to R */
 LD R88,R17
 XR R88,1
 LD R33,R88
 LD R89,(IX+R33)
 LD R88,R17
 XR R88,2
 LD R33,R88
 LD R90,(IX+R33)
 LD R32,R89
 OR R32,R90
 JMP RAYDECIDE
;                          }
;                         }
;                         else
NOPCM: 
;                           PieceMask=0;
 BYD R32

RAYDECIDE
;                          if(FromSqr+StepVec-ToSqr|Piece&32|PieceMask ) 
 LD R88,R21
 AN R88,32
 OR R88,R32
 LD R89,R23
 AD R89,R16
 SB R89,R24
 LD R32,R88
 OR R32,R89
 JMP Z,SETSKIP
;                           Victim+=PieceType<5;  /* fake capt. for nonsliding pieces */                              
 TSB R22,5
 JMP NC,ENDSETSKIP
 AD R20,1
 JMP ENDSETSKIP
;                        else  
SETSKIP:
;                           SkipSqr=ToSqr;       /* enable e.p. */                           
 LD R88,R24
 LD R18,R88
ENDSETSKIP:
;                       }while(!Victim);   /* if not capt. continue ray */ 
 TSB R20,0
 JMP Z,DOCAPT
ENDDOCAPT:
;                    
;                }
 JMP DIRLOOP
ENDDIRLOOP:
;            }
ENDPCSIDE:
;        } while ((FromSqr = FromSqr + 9 & ~M) - StartSqr); /* next sqr. of board, wrap  */
 AD R23,9
 AN R23,&H77
 LD R88,R23
 SB R88,R28
 JMP NZ,MAINDO
; /* All moves have been searched; wrap up iteration by testing for check- or    */
;    /* stalemate, which leave Score at -INF. Call Search with Depth=1 after null   */
;    /* move to determine if we are in check. Finally store result in hash.         */
 
;        CutOff:
CUTOFF:
;            if (BestScore > INF - M | BestScore < M - INF)
 TSB R11,&H1F
 JMP C,VERLEGAL
 TSB R11,&HE2
 JMP NC,VERLEGAL

FORCEITEREND:
;                IterDepth = 98;
 LD R29,98
VERLEGAL
;        if (BestScore == -INF) {
 TSB R11,&HE0
 JMP NZ,FINISHED

;//            BestScore = -Search(24 - Side, -INF, INF, 0, S, S, 1);


;                            SaveAll();
 CAL SAVEALL
;                            Side=24-Side;
 XR R0,24
;                            Alpha=-INF;
 BYD R1
 LD R2,&HE0
;                            Beta=INF;
 BYD R3
 LD R4,&H20
;                            Eval=0;
 BYD R5
 BYD R6
;                            epSqr=S;
 LD R7,128
;                            LastTo=S;
 LD R8,128
;                            Depth=1;
 LD R9,1
;                            Search();
 CAL SEARCH
;                            RestoreAll();
 CAL RESTALL
;                            BestScore= -FunctionValue;
 LD R10,R72
 LD R11,R73
 CMPM R10..R11

;        }
FINISHED:
;        if (LastTo == 8) printf("%2d ply, %9d searched, %6d by (%2x,%2x)\n",
;            IterDepth - 1, N, BestScore, BestFrom, BestTo & 0x77);
;    }
 JMP ITDLOOP
ENDITDLOOP:
;    BestScore += BestScore < Eval;   /* faster-gain award     */
 LD R93,R10
 LD R94,R11
 SBM R93..R94,R5..R6
 TAN R94,128
 JMP Z,SETFVAL

 ADM R10..R11,1
;    FunctionValue=BestScore;
SETFVAL:
  LD R72,R10
  LD R73,R11
ENDSEARCH:
;    return;
 RTN
 
; THESE TWO SUBROUTINES SAVE AND RESTORE LOCAL VARIABLES 
 
 
SAVEALL:                      ; Save all registers representing local variables
 STM +(IY),R0..R7
 STM +(IY),R8..R15
 STM +(IY),R16..R23
 STM +(IY),R24..R31
 RTN
RESTALL:                     ; Restore all registers representing local variables 
 LDM R31..R24,(IY)-
 LDM R23..R16,(IY)-
 LDM R15..R8,(IY)-
 LDM R7..R0,(IY)-
 RTN
 
; USER INTERFACE, CHECK KEYBOARD AND DISPLAY BOARD 
 
ENTERMOVE
 LDM R78..R79,&H9    ; Initially no move selected
 LD R77,&H44 ; Cursor to center
 BYD R7  ; Flash flag for cursoe
DRAWBOARD:
 AN R77,&H77  ; Wrap cursor  if out of board
 CAL DISP   ; Display the board
 INV R7    ; Flip the cursor flag
 LD R27,2   ; Small loop of 512 passes
DELAY1:
  SBM R26..R27,1
  JMP Z,DRAWBOARD

 GST R32,KI   ; READ KEYBOARD and shift bits to determine keys
 ROD R32
 JMP C,0
 ROD R32
 JMP C,COMPMOVE
 ROD R32
 JMP C,SETFROMTO
 ROD R32
 JMP C,LEFTKEY
 ROD R32
 JMP C,RIGHTKEY
 ROD R32
 JMP C,UPKEY
 ROD R32
 JMP C,DOWNKEY
 JMP DELAY1
; Update cursor for each case  
  
UPKEY:
  SB R77,16
  JMP DRAWBOARD
DOWNKEY:
  AD R77,16
  JMP DRAWBOARD
LEFTKEY:
  SB R77,1
  JMP DRAWBOARD
RIGHTKEY:
  AD R77,1
  JMP DRAWBOARD
COMPMOVE:  ; Graph key, computer moves
  LD R78,&HFE  
  RTN
SETFROMTO:  ; Disp key human moves
  LD R25,R77
  TSB R78,9   ; From field  selected
  JMP NZ,SETTO
  LD R78,R25  
  JMP DRAWBOARD
SETTO:
  LD R79,R25  ; To field selected
  RTN
DISP:
  stm	-(sp),r122..r120  ; Save index registers
  stm	-(sp),r58..r56
  

 LDW IX,&H5A80 ; Start of video memory, clear screen routine
 LDW IY,&H5A80+768
 cal	&H0F99
 LDW IX,&HCC01  ; IX points to Board
 LDW IY,&H5A80+16  ; IY points to video memory, centered board
; LD R5,&HEF
 LD R1,8  ; Row loop counter
 BYD R76
 BYD R6  ; tested position
BRDLP:
 ST +(IY),0  ; First vertical column
 LD R2,8  ; Piece loop counter
BRDPIELP:
 LD R3,(IX)+  ; Take piece from board
 TSB R6,R77  ; Check if position is cursor
 JMP NZ,IGNOREFLAGS  ; if not do not flash
 TSB R7,0             ; Test flash phase on/off
 JMP NZ,IGNOREFLAGS  ; if not do not flash

 LD R3,8  ; This field will be black square
IGNOREFLAGS:
 AN R3,&H0F  ; We ignore upper nibble of piece
 JMP NZ,FNDPSPRITE
 AD R3,R76  ; Blank field will be interchanged as black/white
FNDPSPRITE:  ; Piece value will be multiplied by 8
 BIU R3
 BIU R3
 BIU R3
 LDW IZ,EMPTYFIELD  ; Set address of piece sprites
 XR R76,1       ;  Black/White field
; Sprite loop
 LD R4,8
PCLOOP:
 LD R75,(IZ+R3) ; Take column of piece of field sprite
 TSB R78,R6     ; If the field was previously selected, invert
 JMP NZ,COPYPIECE
 TSB R77,9
 JMP Z,COPYPIECE


 INV R75   ; Invert
COPYPIECE:
 ST +(IY),R75  ; Put the sprite column
 ADW IZ,1   ; move pointer to sprites
 SB R4,1
 JMP NZ,PCLOOP  ;  repeat sprite loop
 AD R6,1    ; increase current postiion
; XR R5,&HEF
 SB R2,1
 JMP NZ,BRDPIELP  ; End piece loop
; XR R5,&HEF
 XR R76,1  ; Next row starts with oposite field color
 ADW IX,8  ; Next row in board
 ADW IY,31 ; Next row in video memory
 AD R6,8   ; increase current position to next row
 SB R1,1
 JMP NZ,BRDLP
 AN R42,&H3F  ; PARAMETER DO REFRESH

 stm -(sp),r71..r64    ; Save global variables
 CAL &H0620   ; SYSTEM CALL REFRESH
 ldm r64..r71,(sp)+   ; Restore global variables

 ldm	r56..r58,(sp)+   ; Restore index registers
 ldm	r120..r122,(sp)+

 RTN
 
; Here are Piece screen definitions  
 
EMPTYFIELD: DB &HEF,&HEF,&HEF,&HEF,&HEF,&HEF,&HEF,&H00
BLACKFIELD: DB &H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00
BLKPAWN:    DB &HEF,&HAF,&HAC,&H28,&HAC,&HAF,&HEF,&H00
BLKKING:    DB &HEF,&H2E,&H2A,&H20,&H2A,&H2E,&HEF,&H00
BLKKNIGHT:  DB &HEC,&HA8,&HA1,&h20,&H20,&H28,&HEF,&H00
BLKBISHOP:  DB &HEF,&HAC,&H2A,&H20,&H28,&HAC,&HEF,&H00
BLKROOK:    DB &HEF,&HA9,&H2C,&H28,&H2C,&HA9,&HEF,&H00
BLKQUEEN:   DB &HEB,&H28,&H2E,&H28,&H2E,&H28,&HEB,&H00
CURSOR:     DB &H18,&H18,&H18,&H18,&H18,&H18,&H18,&H18
WHTPAWN:    DB &HEF,&HAF,&HAC,&H2A,&HAC,&HAF,&HEF,&H00
UNKNOWN3:   DB &H00,&HE7,&H24,&H00,&HE7,&H02,&He7,&H00
WHTKING:    DB &HEF,&H2E,&HAA,&HA0,&HAA,&H2E,&HEF,&H00
WHTKNIGHT:  DB &HEC,&HAA,&HA5,&h24,&HA7,&H28,&HEF,&H00
WHTBISHOP:  DB &HEF,&HAC,&H2B,&H27,&H2B,&HAC,&HEF,&H00
WHTROOK:    DB &HEF,&HA9,&H2C,&HA9,&H2C,&HA9,&HEF,&H00
WHTQUEEN:   DB &HEB,&H28,&HAE,&HA8,&HAE,&H28,&HEB,&H00
; BOARD left half is actual board, right half is field value. To check field legality binary AND the value with &H88
BOARD:     DB 22 ,20,21,23,19,21,20,22,  28,21,16,13,12,13,16,21
           DB 18 ,18,18,18,18,18,18,18,  22,15,10, 7, 6, 7,10,15
           DB  0, 0, 0, 0, 0, 0, 0, 0,   18,11, 6, 3, 2, 3, 6,11
           DB  0, 0, 0, 0, 0, 0, 0, 0,   16, 9, 4, 1, 0, 1, 4, 9
           DB  0, 0, 0, 0, 0, 0, 0, 0,   16, 9, 4, 1, 0, 1, 4, 9
           DB  0, 0, 0, 0, 0, 0, 0, 0,   18,11, 6, 3, 2, 3, 6,11
           DB  9, 9, 9, 9, 9, 9, 9, 9,   22,15,10, 7, 6, 7,10,15
           DB 14,12,13,15,11,13,12,14,   28,21,16,13,12,13,16,21,0

STEPVECS   DB  -16, -15, -17, 0, 1, 16, 0, 1, 16, 15, 17, 0, 14, 18, 31, 33, 0 ; /* step-vector lists */
           DB 7+1, -1+1, 6+1, 11+1, 8+1, 3+1, 6+1  ; /* 1st dir. in StepVecs[] per piece*/
PIECEVAL   DB 0, 100, 100, -2,  44,  44, 244, 132 ; Absolute piece values low bytw   */
PIECEVALHI DB 0,   0,   0, -2,   1,   1,   1, 3   ; High byte
		   

  ORG &H4755
  JMP CHESSSTART
  db 'GUGUGUGU' ; This sequence is also 4755475547554755
  DB 'G :0',&HEC,':]853[Z',&H0E,']034',&H87,'[Z',01
  DB 'CM',00  ; PASSWORD 2 LETTERS
  DB 'SSEHC'  ; Name 5 letters




