unit Cpu;

interface

  procedure CpuReset;
  procedure CpuRun;


implementation

  uses Def, Decode, Exec;

  type Proc1 = procedure;


procedure CpuReset;
begin
  procptr := nil;
  pc := $0000;
  la := $0000;

  ds := 0;
  kc := 0;
  ki := 0;
  ie := 0;
  pd := 0;
  flag := 0;

  asreg := 0;
  pe := 0;
  s4 := 0;
  s5 := 0;
  s6 := 0;
  s7 := 0;
  s8 := 0;
  tm := 0;

  iserv := 0;
  ireq := 0;
  acycles := 0;
  CpuSleep := False;
  CpuWait := False;
end {CpuReset};


{ execute a single instruction }
procedure CpuRun;
var
  i: integer;
begin

{ complete an optional I/O device write }
  if procptr <> nil then
  begin
    Proc1(procptr);
    procptr := nil;
  end {if};

  if CpuSleep or CpuWait then Inc (cycles, 6) else
  begin
{ interrupts }
    i := 0;	{ a FOR loop cannot be used here, because the value of the }
    while i < INTVECTORS do	{ control variable is used outside the loop }
    begin
{ is there a pending interrupt request of higher priority than currently
  serviced? }
      if (iserv and intmask[i]) <> 0 then
      begin
        i := INTVECTORS;
      end
      else if (ie and ireq and intmask[i]) <> 0 then
{ handle an interrupt }
      begin
        iserv := iserv or intmask[i];
        PushPC;
        pc := (word(mr[126-i]) shl 8) or word(mr[62-i]);
        Inc (cycles, 10);
        Break;
      end
      else
{ proceed with the next interrupt }
      begin
        Inc (i);
      end {if};
    end {while};
{ execute an instruction if there wasn't an interrupt to handle }
    if i = INTVECTORS then ExecInstr;
  end {if};
end {CpuRun};

end.
