unit Keyboard;

interface

type

  keyblock = record
    L: integer;		{ left }
    T: integer;		{ top }
    W: integer;		{ width of the key }
    H: integer;		{ height of the key }
    SX: integer;	{ horizontal spacing }
    SY: integer;	{ vertical spacing }
    col: integer;	{ number of columns }
    cnt: integer;	{ number of keys in a block }
  end;

  keycoords = record
    m1: byte;		{ value for the KY register selecting the key }
    m2: byte;		{ returned KY state when the key was pressed }
  end;

const

  KEYPADS = 4;		{ index of the last item in the 'keypad' array }

  keypad: array[0..KEYPADS] of keyblock = (
{ application minimize and close, codes: 1..2 }
    (	L:441;	T:538;	W:17;	H:17;	SX:18;	SY:40;	col:2;	cnt:2	),
{ six white keys below the display, codes: 3..9 }
    (	L:18;	T:214;	W:34;	H:35;	SX:37;	SY:40;	col:7;	cnt:7	),
{ keys right from the display, codes: 10..29 }
    (	L:295;	T:48;	W:36;	H:34;	SX:42;	SY:40;	col:4;	cnt:20	),
{ left group of keys on the lower part, codes: 30..41 }
    (	L:35;	T:342;	W:37;	H:39;	SX:43;	SY:45;	col:3;	cnt:12	),
{ right group of keys on the lower part, codes: 42..61 }
    (	L:168;	T:342;	W:53;	H:39;	SX:59;	SY:45;	col:5;	cnt:20	)
);


  FIRSTKEYCODE = 3;
  LASTKEYCODE = 62;

KeyTab: array[FIRSTKEYCODE..LASTKEYCODE] of keycoords = (
    (	m1: $88;	m2: $40	),	{ 3: M Disp	KC9, KI6 }
    (	m1: $84;	m2: $40	),	{ 4: G<->T	KC8, KI6 }
    (	m1: $82;	m2: $40	),	{ 5: up		KC7, KI6 }
    (	m1: $81;	m2: $40	),	{ 6: down	KC6, KI6 }
    (	m1: $81;	m2: $20	),	{ 7: left	KC6, KI5 }
    (	m1: $82;	m2: $20	),	{ 8: right	KC7, KI5 }
    (	m1: $84;	m2: $20	),	{ 9: INS	KC8, KI5 }
    (	m1: $60;	m2: $10	),	{ 10: sqrt	KC5, KI4 }
    (	m1: $60;	m2: $08	),	{ 11: x^2	KC5, KI3 }
    (	m1: $60;	m2: $04	),	{ 12: log	KC5, KI2 }
    (	m1: $60;	m2: $02	),	{ 13: ln	KC5, KI1 }
    (	m1: $81;	m2: $10	),	{ 14: 1/x	KC6, KI4 }
    (	m1: $81;	m2: $08	),	{ 15: deg,min,sec KC6, KI3 }
    (	m1: $81;	m2: $04	),	{ 16: 10^x	KC6, KI2 }
    (	m1: $81;	m2: $02	),	{ 17: e^x	KC6, KI1 }
    (	m1: $82;	m2: $10	),	{ 18: hyp	KC7, KI4 }
    (	m1: $82;	m2: $08	),	{ 19: sin	KC7, KI3 }
    (	m1: $82;	m2: $04	),	{ 20: cos	KC7, KI2 }
    (	m1: $82;	m2: $02	),	{ 21: tan	KC7, KI1 }
    (	m1: $84;	m2: $10	),	{ 22: ?		KC8, KI4 }
    (	m1: $84;	m2: $08	),	{ 23: -->	KC8, KI3 }
    (	m1: $84;	m2: $04	),	{ 24: (		KC8, KI2 }
    (	m1: $84;	m2: $02	),	{ 25: )		KC8, KI1 }
    (	m1: $88;	m2: $10	),	{ 26: (-)	KC9, KI4 }
    (	m1: $88;	m2: $08	),	{ 27: colon	KC9, KI3 }
    (	m1: $88;	m2: $04	),	{ 28: x^y	KC9, KI2 }
    (	m1: $88;	m2: $02	),	{ 29: root	KC9, KI1 }
    (	m1: $42;	m2: $80	),	{ 30: SHIFT	KC1, KI7 }
    (	m1: $42;	m2: $40	),	{ 31: ALPHA	KC1, KI6 }
    (	m1: $42;	m2: $20	),	{ 32: MODE	KC1, KI5 }
    (	m1: $44;	m2: $80	),	{ 33: Cls	KC2, KI7 }
    (	m1: $44;	m2: $40	),	{ 34: ENG	KC2, KI6 }
    (	m1: $44;	m2: $20	),	{ 35: Prog	KC2, KI5 }
    (	m1: $48;	m2: $80	),	{ 36: Graph	KC3, KI7 }
    (	m1: $48;	m2: $40	),	{ 37: Range	KC3, KI6 }
    (	m1: $48;	m2: $20	),	{ 38: Plot	KC3, KI5 }
    (	m1: $50;	m2: $80	),	{ 39: Trace	KC4, KI7 }
    (	m1: $50;	m2: $40	),	{ 40: Factor	KC4, KI6 }
    (	m1: $50;	m2: $20	),	{ 41: Line	KC4, KI5 }
    (	m1: $42;	m2: $10	),	{ 42: 7		KC1, KI4 }
    (	m1: $42;	m2: $08	),	{ 43: 8		KC1, KI3 }
    (	m1: $42;	m2: $04	),	{ 44: 9		KC1, KI2 }
    (	m1: $42;	m2: $02	),	{ 45: DEL	KC1, KI1 }
    (	m1: $C0;	m2: $01	),	{ 46: AC	KAC, KI0 }
    (	m1: $44;	m2: $10	),	{ 47: 4		KC2, KI4 }
    (	m1: $44;	m2: $08	),	{ 48: 5		KC2, KI3 }
    (	m1: $44;	m2: $04	),	{ 49: 6		KC2, KI2 }
    (	m1: $44;	m2: $02	),	{ 50: multiply	KC2, KI1 }
    (	m1: $44;	m2: $01	),	{ 51: divide	KC2, KI0 }
    (	m1: $48;	m2: $10	),	{ 52: 1		KC3, KI4 }
    (	m1: $48;	m2: $08	),	{ 53: 2		KC3, KI3 }
    (	m1: $48;	m2: $04	),	{ 54: 3		KC3, KI2 }
    (	m1: $48;	m2: $02	),	{ 55: +		KC3, KI1 }
    (	m1: $48;	m2: $01	),	{ 56: -		KC3, KI0 }
    (	m1: $50;	m2: $10	),	{ 57: 0		KC4, KI4 }
    (	m1: $50;	m2: $08	),	{ 58: dec. point KC4, KI3 }
    (	m1: $50;	m2: $04	),	{ 59: EXP	KC4, KI2 }
    (	m1: $50;	m2: $02	),	{ 60: Ans	KC4, KI1 }
    (	m1: $42;	m2: $01	),	{ 61: EXE	KC1, KI0 }
    (	m1: $41;	m2: $80	)	{ 62: init	KC0, KI7 }
);


  var KeyCode: array[1..2] of integer;
  var TestCounter: integer;

  procedure KeyHandle;


implementation

uses Def;

{ the procedure is supposed to be called after any change of the keyboard
  state (i.e. when a key has been pressed/released and when the self-test
  jumper state has changed) and after any KC change }
procedure KeyHandle;
var
  i, x: integer;
begin
  if kc < $40 then Exit;
  if TestCounter <> 0 then ki := $10 else ki := $00;
  if kc = $40 then
  begin			{ check the [AC] key }
    if (KeyCode[1] = 46) or (KeyCode[2] = 46) then ki := ki or $01;
  end
  else
  begin
    for i := 1 to 2 do
    begin
      x := KeyCode[i];
      if (x >= FIRSTKEYCODE) and (x <= LASTKEYCODE) then
      begin
        with KeyTab[x] do
        begin
          if (m1 and kc) = m1 then ki := ki or m2;
        end {with};
      end {if};
    end {for};
  end {if};
  if ki <> 0 then CpuWait := False;
  if (ki and $01) <> 0 then CpuSleep := False;
end {KeyHandle};


end.
