{ NM-326 instruction decoding }

unit Decode;


interface

  procedure ExecInstr;


implementation

  uses Def, Exec;

  type

    Proc2 = procedure (op2: pointer);


{ execute a single instruction }
procedure ExecInstr;
const
  dtab: array[0..4*$A0+$60-1,0..1] of pointer = (
{ code $00 }
    (	@TXreg,		@OpNa		),	{ subcode $00, TNA }
    (	@TYreg,		@OpNa		),	{ subcode $40, TNA }
    (	@Xreg,		@OpNa		),	{ subcode $80, NA }
    (	@Yreg,		@OpNa		),	{ subcode $C0, NA }
{ code $01 }
    (	@TXreg,		@OpXr		),	{ subcode $00, TXR }
    (	@TYreg,		@OpXr		),	{ subcode $40, TXR }
    (	@Xreg,		@OpXr		),	{ subcode $80, XR }
    (	@Yreg,		@OpXr		),	{ subcode $C0, XR }
{ code $02 }
    (	@TXreg,		@OpSbb		),	{ subcode $00, TSBB }
    (	@TYreg,		@OpSbb		),	{ subcode $40, TSBB }
    (	@Xreg,		@OpSbb		),	{ subcode $80, SBB }
    (	@Yreg,		@OpSbb		),	{ subcode $C0, SBB }
{ code $03 }
    (	@TXreg,		@OpSb		),	{ subcode $00, TSB }
    (	@TYreg,		@OpSb		),	{ subcode $40, TSB }
    (	@Xreg,		@OpSb		),	{ subcode $80, SB }
    (	@Yreg,		@OpSb		),	{ subcode $C0, SB }
{ code $04 }
    (	@TXreg,		@OpAn		),	{ subcode $00, TAN }
    (	@TYreg,		@OpAn		),	{ subcode $40, TAN }
    (	@Xreg,		@OpAn		),	{ subcode $80, AN }
    (	@Yreg,		@OpAn		),	{ subcode $C0, AN }
{ code $05 }
    (	@TXreg,		@OpOr		),	{ subcode $00, TOR }
    (	@TYreg,		@OpOr		),	{ subcode $40, TOR }
    (	@Xreg,		@OpOr		),	{ subcode $80, OR }
    (	@Yreg,		@OpOr		),	{ subcode $C0, OR }
{ code $06 }
    (	@TXreg,		@OpAdb		),	{ subcode $00, TADB }
    (	@TYreg,		@OpAdb		),	{ subcode $40, TADB }
    (	@Xreg,		@OpAdb		),	{ subcode $80, ADB }
    (	@Yreg,		@OpAdb		),	{ subcode $C0, ADB }
{ code $07 }
    (	@TXreg,		@OpAd		),	{ subcode $00, TAD }
    (	@TYreg,		@OpAd		),	{ subcode $40, TAD }
    (	@Xreg,		@OpAd		),	{ subcode $80, AD }
    (	@Yreg,		@OpAd		),	{ subcode $C0, AD }
{ code $08 }
    (	@TRegIm8,	@OpNa		),	{ subcode $00, TNA }
    (	@TRegIm8,	@OpNa		),	{ subcode $40, TNA }
    (	@RegIm8,	@OpNa		),	{ subcode $80, NA }
    (	@RegIm8,	@OpNa		),	{ subcode $C0, NA }
{ code $09 }
    (	@TRegIm8,	@OpXr		),	{ subcode $00, TXR }
    (	@TRegIm8,	@OpXr		),	{ subcode $40, TXR }
    (	@RegIm8,	@OpXr		),	{ subcode $80, XR }
    (	@RegIm8,	@OpXr		),	{ subcode $C0, XR }
{ code $0A }
    (	@TRegIm8,	@OpSbb		),	{ subcode $00, TSBB }
    (	@TRegIm8,	@OpSbb		),	{ subcode $40, TSBB }
    (	@RegIm8,	@OpSbb		),	{ subcode $80, SBB }
    (	@RegIm8,	@OpSbb		),	{ subcode $C0, SBB }
{ code $0B }
    (	@TRegIm8,	@OpSb		),	{ subcode $00, TSB }
    (	@TRegIm8,	@OpSb		),	{ subcode $40, TSB }
    (	@RegIm8,	@OpSb		),	{ subcode $80, SB }
    (	@RegIm8,	@OpSb		),	{ subcode $C0, SB }
{ code $0C }
    (	@TRegIm8,	@OpAn		),	{ subcode $00, TAN }
    (	@TRegIm8,	@OpAn		),	{ subcode $40, TAN }
    (	@RegIm8,	@OpAn		),	{ subcode $80, AN }
    (	@RegIm8,	@OpAn		),	{ subcode $C0, AN }
{ code $0D }
    (	@TRegIm8,	@OpOr		),	{ subcode $00, TOR }
    (	@TRegIm8,	@OpOr		),	{ subcode $40, TOR }
    (	@RegIm8,	@OpOr		),	{ subcode $80, OR }
    (	@RegIm8,	@OpOr		),	{ subcode $C0, OR }
{ code $0E }
    (	@TRegIm8,	@OpAdb		),	{ subcode $00, TADB }
    (	@TRegIm8,	@OpAdb		),	{ subcode $40, TADB }
    (	@RegIm8,	@OpAdb		),	{ subcode $80, ADB }
    (	@RegIm8,	@OpAdb		),	{ subcode $C0, ADB }
{ code $0F }
    (	@TRegIm8,	@OpAd		),	{ subcode $00, TAD }
    (	@TRegIm8,	@OpAd		),	{ subcode $40, TAD }
    (	@RegIm8,	@OpAd		),	{ subcode $80, AD }
    (	@RegIm8,	@OpAd		),	{ subcode $C0, AD }
{ code $10 }
    (	@TXary,		@OpNa		),	{ subcode $00, TNAM }
    (	@TYary,		@OpNa		),	{ subcode $40, TNAM }
    (	@Xary,		@OpNa		),	{ subcode $80, NAM }
    (	@Yary,		@OpNa		),	{ subcode $C0, NAM }
{ code $11 }
    (	@TXary,		@OpXr		),	{ subcode $00, TXRM }
    (	@TYary,		@OpXr		),	{ subcode $40, TXRM }
    (	@Xary,		@OpXr		),	{ subcode $80, XRM }
    (	@Yary,		@OpXr		),	{ subcode $C0, XRM }
{ code $12 }
    (	@TXary,		@OpSbb		),	{ subcode $00, TSBBM }
    (	@TYary,		@OpSbb		),	{ subcode $40, TSBBM }
    (	@Xary,		@OpSbb		),	{ subcode $80, SBBM }
    (	@Yary,		@OpSbb		),	{ subcode $C0, SBBM }
{ code $13 }
    (	@TXary,		@OpSb		),	{ subcode $00, TSBM }
    (	@TYary,		@OpSb		),	{ subcode $40, TSBM }
    (	@Xary,		@OpSb		),	{ subcode $80, SBM }
    (	@Yary,		@OpSb		),	{ subcode $C0, SBM }
{ code $14 }
    (	@TXary,		@OpAn		),	{ subcode $00, TANM }
    (	@TYary,		@OpAn		),	{ subcode $40, TANM }
    (	@Xary,		@OpAn		),	{ subcode $80, ANM }
    (	@Yary,		@OpAn		),	{ subcode $C0, ANM }
{ code $15 }
    (	@TXary,		@OpOr		),	{ subcode $00, TORM }
    (	@TYary,		@OpOr		),	{ subcode $40, TORM }
    (	@Xary,		@OpOr		),	{ subcode $80, ORM }
    (	@Yary,		@OpOr		),	{ subcode $C0, ORM }
{ code $16 }
    (	@TXary,		@OpAdb		),	{ subcode $00, TADBM }
    (	@TYary,		@OpAdb		),	{ subcode $40, TADBM }
    (	@Xary,		@OpAdb		),	{ subcode $80, ADBM }
    (	@Yary,		@OpAdb		),	{ subcode $C0, ADBM }
{ code $17 }
    (	@TXary,		@OpAd		),	{ subcode $00, TADM }
    (	@TYary,		@OpAd		),	{ subcode $40, TADM }
    (	@Xary,		@OpAd		),	{ subcode $80, ADM }
    (	@Yary,		@OpAd		),	{ subcode $C0, ADM }
{ code $18 }
    (	@PlaIjmp,	@la		),	{ subcode $00, PLA }
    (	@PlaIjmp,	@la		),	{ subcode $40, PLA }
    (	@PlaIjmp,	@pc		),	{ subcode $80, IJMP }
    (	@PlaIjmp,	@pc		),	{ subcode $C0, IJMP }
{ code $19 }
    (	@TXreg,		@OpBit		),	{ subcode $00, BIT }
    (	@TYreg,		@OpBit		),	{ subcode $40, BIT }
    (	@TRegIm8,	@OpBit		),	{ subcode $80, BIT }
    (	@TRegIm8,	@OpBit		),	{ subcode $C0, BIT }
{ code $1A }
    (	@TAryIm5,	@OpSbb		),	{ subcode $00, TSBBM }
    (	@TAryIm5,	@OpSbb		),	{ subcode $40, TSBBM }
    (	@AryIm5,	@OpSbb		),	{ subcode $80, SBBM }
    (	@AryIm5,	@OpSbb		),	{ subcode $C0, SBBM }
{ code $1B }
    (	@TAryIm5,	@OpSb		),	{ subcode $00, TSBM }
    (	@TAryIm5,	@OpSb		),	{ subcode $40, TSBM }
    (	@AryIm5,	@OpSb		),	{ subcode $80, SBM }
    (	@AryIm5,	@OpSb		),	{ subcode $C0, SBM }
{ code $1C }
    (	@BlockSearch,	@PreDecw	),	{ subcode $00, SDN }
    (	@BlockSearch,	@PreDecw	),	{ subcode $40, SDN }
    (	@BlockSearch,	@PreIncw	),	{ subcode $80, SUP }
    (	@BlockSearch,	@PreIncw	),	{ subcode $C0, SUP }
{ code $1D }
    (	@BlockSearch,	@PreDecw	),	{ subcode $00, ??? }
    (	@BlockSearch,	@PreDecw	),	{ subcode $40, ??? }
    (	@BlockSearch,	@PreIncw	),	{ subcode $80, ??? }
    (	@BlockSearch,	@PreIncw	),	{ subcode $C0, ??? }
{ code $1E }
    (	@TAryIm5,	@OpAdb		),	{ subcode $00, TADBM }
    (	@TAryIm5,	@OpAdb		),	{ subcode $40, TADBM }
    (	@AryIm5,	@OpAdb		),	{ subcode $80, ADBM }
    (	@AryIm5,	@OpAdb		),	{ subcode $C0, ADBM }
{ code $1F }
    (	@TAryIm5,	@OpAd		),	{ subcode $00, TADM }
    (	@TAryIm5,	@OpAd		),	{ subcode $40, TADM }
    (	@AryIm5,	@OpAd		),	{ subcode $80, ADM }
    (	@AryIm5,	@OpAd		),	{ subcode $C0, ADM }
{ code $20 }
    (	@Ld2RegIm8,	nil		),	{ subcode $00, LD }
    (	@Ld2RegIm8,	nil		),	{ subcode $40, LD }
    (	@RegIm8,	@OpLd		),	{ subcode $80, LD }
    (	@RegIm8,	@OpLd		),	{ subcode $C0, LD }
{ code $21 }
    (	@Xreg,		@OpXc		),	{ subcode $00, XC }
    (	@Yreg,		@OpXc		),	{ subcode $40, XC }
    (	@Xreg,		@OpLd		),	{ subcode $80, LD }
    (	@Yreg,		@OpLd		),	{ subcode $C0, LD }
{ code $22 }
    (	@TXreg,		@OpSbb		),	{ subcode $00, TSBBC }
    (	@TYreg,		@OpSbb		),	{ subcode $40, TSBBC }
    (	@Xreg,		@OpSbb		),	{ subcode $80, SBBC }
    (	@Yreg,		@OpSbb		),	{ subcode $C0, SBBC }
{ code $23 }
    (	@TXreg,		@OpSb		),	{ subcode $00, TSBC }
    (	@TYreg,		@OpSb		),	{ subcode $40, TSBC }
    (	@Xreg,		@OpSb		),	{ subcode $80, SBC }
    (	@Yreg,		@OpSb		),	{ subcode $C0, SBC }
{ code $24 }
    (	@Xreg,		@OpSwp2		),	{ subcode $00, SWP }
    (	@Yreg,		@OpSwp2		),	{ subcode $40, SWP }
    (	@Xreg,		@OpSwp		),	{ subcode $80, SWP }
    (	@Yreg,		@OpSwp		),	{ subcode $C0, SWP }
{ code $25 }
    (	@Xreg,		@OpXcs		),	{ subcode $00, XCS }
    (	@Yreg,		@OpXcs		),	{ subcode $40, XCS }
    (	@Xreg,		@OpLds		),	{ subcode $80, LDS }
    (	@Yreg,		@OpLds		),	{ subcode $C0, LDS }
{ code $26 }
    (	@TXreg,		@OpAdb		),	{ subcode $00, TADBC }
    (	@TYreg,		@OpAdb		),	{ subcode $40, TADBC }
    (	@Xreg,		@OpAdb		),	{ subcode $80, ADBC }
    (	@Yreg,		@OpAdb		),	{ subcode $C0, ADBC }
{ code $27 }
    (	@TXreg,		@OpAd		),	{ subcode $00, TADC }
    (	@TYreg,		@OpAd		),	{ subcode $40, TADC }
    (	@Xreg,		@OpAd		),	{ subcode $80, ADC }
    (	@Yreg,		@OpAd		),	{ subcode $C0, ADC }
{ code $28 }
    (	@Xreg,		@OpXcl		),	{ subcode $00, XCL }
    (	@Yreg,		@OpXch		),	{ subcode $40, XCH }
    (	@Xreg,		@OpLdl		),	{ subcode $80, LDL }
    (	@Yreg,		@OpLdh		),	{ subcode $C0, LDH }
{ code $29 }
    (	@Xreg,		@OpXchs		),	{ subcode $00, XCHS }
    (	@Yreg,		@OpXcls		),	{ subcode $40, XCLS }
    (	@Xreg,		@OpLdhs		),	{ subcode $80, LDHS }
    (	@Yreg,		@OpLdls		),	{ subcode $C0, LDLS }
{ code $2A }
    (	@TRegIm8,	@OpSbb		),	{ subcode $00, TSBBC }
    (	@TRegIm8,	@OpSbb		),	{ subcode $40, TSBBC }
    (	@RegIm8,	@OpSbb		),	{ subcode $80, SBBC }
    (	@RegIm8,	@OpSbb		),	{ subcode $C0, SBBC }
{ code $2B }
    (	@TRegIm8,	@OpSb		),	{ subcode $00, TSBC }
    (	@TRegIm8,	@OpSb		),	{ subcode $40, TSBC }
    (	@RegIm8,	@OpSb		),	{ subcode $80, SBC }
    (	@RegIm8,	@OpSb		),	{ subcode $C0, SBC }
{ code $2C }
    (	@Xreg,		@OpXcls		),	{ subcode $00, XCLS }
    (	@Yreg,		@OpXchs		),	{ subcode $40, XCHS }
    (	@Xreg,		@OpLdls		),	{ subcode $80, LDLS }
    (	@Yreg,		@OpLdhs		),	{ subcode $C0, LDHS }
{ code $2D }
    (	@Xreg,		@OpXch		),	{ subcode $00, XCH }
    (	@Yreg,		@OpXcl		),	{ subcode $40, XCL }
    (	@Xreg,		@OpLdh		),	{ subcode $80, LDH }
    (	@Yreg,		@OpLdl		),	{ subcode $C0, LDL }
{ code $2E }
    (	@TRegIm8,	@OpAdb		),	{ subcode $00, TADBC }
    (	@TRegIm8,	@OpAdb		),	{ subcode $40, TADBC }
    (	@RegIm8,	@OpAdb		),	{ subcode $80, ADBC }
    (	@RegIm8,	@OpAdb		),	{ subcode $C0, ADBC }
{ code $2F }
    (	@TRegIm8,	@OpAd		),	{ subcode $00, TADC }
    (	@TRegIm8,	@OpAd		),	{ subcode $40, TADC }
    (	@RegIm8,	@OpAd		),	{ subcode $80, ADC }
    (	@RegIm8,	@OpAd		),	{ subcode $C0, ADC }
{ code $30 }
    (	@Nop,		nil		),	{ subcode $00 }
    (	@Nop,		nil		),	{ subcode $40 }
    (	@AryIm5,	@OpLd		),	{ subcode $80, LDM }
    (	@AryIm5,	@OpLd		),	{ subcode $C0, LDM }
{ code $31 }
    (	@Xary,		@OpXc		),	{ subcode $00, XCM }
    (	@Yary,		@OpXc		),	{ subcode $40, XCM }
    (	@Xary,		@OpLd		),	{ subcode $80, LDM }
    (	@Yary,		@OpLd		),	{ subcode $C0, LDM }
{ code $32 }
    (	@TXary,		@OpSbb		),	{ subcode $00, TSBBCM }
    (	@TYary,		@OpSbb		),	{ subcode $40, TSBBCM }
    (	@Xary,		@OpSbb		),	{ subcode $80, SBBCM }
    (	@Yary,		@OpSbb		),	{ subcode $C0, SBBCM }
{ code $33 }
    (	@TXary,		@OpSb		),	{ subcode $00, TSBCM }
    (	@TYary,		@OpSb		),	{ subcode $40, TSBCM }
    (	@Xary,		@OpSb		),	{ subcode $80, SBCM }
    (	@Yary,		@OpSb		),	{ subcode $C0, SBCM }
{ code $34 }
    (	@Xary,		@OpSwp2		),	{ subcode $00, SWPM }
    (	@Yary,		@OpSwp2		),	{ subcode $40, SWPM }
    (	@Xary,		@OpSwp		),	{ subcode $80, SWPM }
    (	@Yary,		@OpSwp		),	{ subcode $C0, SWPM }
{ code $35 }
    (	@Xary,		@OpXcs		),	{ subcode $00, XCSM }
    (	@Yary,		@OpXcs		),	{ subcode $40, XCSM }
    (	@Xary,		@OpLds		),	{ subcode $80, LDSM }
    (	@Yary,		@OpLds		),	{ subcode $C0, LDSM }
{ code $36 }
    (	@TXary,		@OpAdb		),	{ subcode $00, TADBCM }
    (	@TYary,		@OpAdb		),	{ subcode $40, TADBCM }
    (	@Xary,		@OpAdb		),	{ subcode $80, ADBCM }
    (	@Yary,		@OpAdb		),	{ subcode $C0, ADBCM }
{ code $37 }
    (	@TXary,		@OpAd		),	{ subcode $00, TADCM }
    (	@TYary,		@OpAd		),	{ subcode $40, TADCM }
    (	@Xary,		@OpAd		),	{ subcode $80, ADCM }
    (	@Yary,		@OpAd		),	{ subcode $C0, ADCM }
{ code $38 }
    (	@Xary,		@OpXcl		),	{ subcode $00, XCLM }
    (	@Yary,		@OpXch		),	{ subcode $40, XCHM }
    (	@Xary,		@OpLdl		),	{ subcode $80, LDLM }
    (	@Yary,		@OpLdh		),	{ subcode $C0, LDHM }
{ code $39 }
    (	@Xary,		@OpXchs		),	{ subcode $00, XCHSM }
    (	@Yary,		@OpXcls		),	{ subcode $40, XCLSM }
    (	@Xary,		@OpLdhs		),	{ subcode $80, LDHSM }
    (	@Yary,		@OpLdls		),	{ subcode $C0, LDLSM }
{ code $3A }
    (	@TAryIm5,	@OpSbb		),	{ subcode $00, TSBBCM }
    (	@TAryIm5,	@OpSbb		),	{ subcode $40, TSBBCM }
    (	@AryIm5,	@OpSbb		),	{ subcode $80, SBBCM }
    (	@AryIm5,	@OpSbb		),	{ subcode $C0, SBBCM }
{ code $3B }
    (	@TAryIm5,	@OpSb		),	{ subcode $00, TSBCM }
    (	@TAryIm5,	@OpSb		),	{ subcode $40, TSBCM }
    (	@AryIm5,	@OpSb		),	{ subcode $80, SBCM }
    (	@AryIm5,	@OpSb		),	{ subcode $C0, SBCM }
{ code $3C }
    (	@Xary,		@OpXcls		),	{ subcode $00, XCLSM }
    (	@Yary,		@OpXchs		),	{ subcode $40, XCHSM }
    (	@Xary,		@OpLdls		),	{ subcode $80, LDLSM }
    (	@Yary,		@OpLdhs		),	{ subcode $C0, LDHSM }
{ code $3D }
    (	@Xary,		@OpXch		),	{ subcode $00, XCHM }
    (	@Yary,		@OpXcl		),	{ subcode $40, XCLM }
    (	@Xary,		@OpLdh		),	{ subcode $80, LDHM }
    (	@Yary,		@OpLdl		),	{ subcode $C0, LDLM }
{ code $3E }
    (	@TAryIm5,	@OpAdb		),	{ subcode $00, TADBCM }
    (	@TAryIm5,	@OpAdb		),	{ subcode $40, TADBCM }
    (	@AryIm5,	@OpAdb		),	{ subcode $80, ADBCM }
    (	@AryIm5,	@OpAdb		),	{ subcode $C0, ADBCM }
{ code $3F }
    (	@TAryIm5,	@OpAd		),	{ subcode $00, TADCM }
    (	@TAryIm5,	@OpAd		),	{ subcode $40, TADCM }
    (	@AryIm5,	@OpAd		),	{ subcode $80, ADCM }
    (	@AryIm5,	@OpAd		),	{ subcode $C0, ADCM }
{ code $40 }
    (	@TMemoReg,	@OpNa		),	{ subcode $00, TNA }
    (	@TMemoReg,	@OpNa		),	{ subcode $40, TNA }
    (	@MemoReg,	@OpNa		),	{ subcode $80, NA }
    (	@MemoReg,	@OpNa		),	{ subcode $C0, NA }
{ code $41 }
    (	@TMemoReg,	@OpXr		),	{ subcode $00, TXR }
    (	@TMemoReg,	@OpXr		),	{ subcode $40, TXR }
    (	@MemoReg,	@OpXr		),	{ subcode $80, XR }
    (	@MemoReg,	@OpXr		),	{ subcode $C0, XR }
{ code $42 }
    (	@TMemoReg,	@OpSbb		),	{ subcode $00, TSBB }
    (	@TMemoReg,	@OpSbb		),	{ subcode $40, TSBB }
    (	@MemoReg,	@OpSbb		),	{ subcode $80, SBB }
    (	@MemoReg,	@OpSbb		),	{ subcode $C0, SBB }
{ code $43 }
    (	@TMemoReg,	@OpSb		),	{ subcode $00, TSB }
    (	@TMemoReg,	@OpSb		),	{ subcode $40, TSB }
    (	@MemoReg,	@OpSb		),	{ subcode $80, SB }
    (	@MemoReg,	@OpSb		),	{ subcode $C0, SB }
{ code $44 }
    (	@TMemoReg,	@OpAn		),	{ subcode $00, TAN }
    (	@TMemoReg,	@OpAn		),	{ subcode $40, TAN }
    (	@MemoReg,	@OpAn		),	{ subcode $80, AN }
    (	@MemoReg,	@OpAn		),	{ subcode $C0, AN }
{ code $45 }
    (	@TMemoReg,	@OpOr		),	{ subcode $00, TOR }
    (	@TMemoReg,	@OpOr		),	{ subcode $40, TOR }
    (	@MemoReg,	@OpOr		),	{ subcode $80, OR }
    (	@MemoReg,	@OpOr		),	{ subcode $C0, OR }
{ code $46 }
    (	@TMemoReg,	@OpAdb		),	{ subcode $00, TADB }
    (	@TMemoReg,	@OpAdb		),	{ subcode $40, TADB }
    (	@MemoReg,	@OpAdb		),	{ subcode $80, ADB }
    (	@MemoReg,	@OpAdb		),	{ subcode $C0, ADB }
{ code $47 }
    (	@TMemoReg,	@OpAd		),	{ subcode $00, TAD }
    (	@TMemoReg,	@OpAd		),	{ subcode $40, TAD }
    (	@MemoReg,	@OpAd		),	{ subcode $80, AD }
    (	@MemoReg,	@OpAd		),	{ subcode $C0, AD }
{ code $48 }
    (	@MemoIm8,	@OpNa		),	{ subcode $00, TNA }
    (	@MemoIm8,	@OpNa		),	{ subcode $40, TNA }
    (	@MemoIm8,	@OpNa		),	{ subcode $80, NA }
    (	@MemoIm8,	@OpNa		),	{ subcode $C0, NA }
{ code $49 }
    (	@MemoIm8,	@OpXr		),	{ subcode $00, TXR }
    (	@MemoIm8,	@OpXr		),	{ subcode $40, TXR }
    (	@MemoIm8,	@OpXr		),	{ subcode $80, XR }
    (	@MemoIm8,	@OpXr		),	{ subcode $C0, XR }
{ code $4A }
    (	@MemoIm8,	@OpSbb		),	{ subcode $00, TSBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $40, TSBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $80, SBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $C0, SBB }
{ code $4B }
    (	@MemoIm8,	@OpSb		),	{ subcode $00, TSB }
    (	@MemoIm8,	@OpSb		),	{ subcode $40, TSB }
    (	@MemoIm8,	@OpSb		),	{ subcode $80, SB }
    (	@MemoIm8,	@OpSb		),	{ subcode $C0, SB }
{ code $4C }
    (	@MemoIm8,	@OpAn		),	{ subcode $00, TAN }
    (	@MemoIm8,	@OpAn		),	{ subcode $40, TAN }
    (	@MemoIm8,	@OpAn		),	{ subcode $80, AN }
    (	@MemoIm8,	@OpAn		),	{ subcode $C0, AN }
{ code $4D }
    (	@MemoIm8,	@OpOr		),	{ subcode $00, TOR }
    (	@MemoIm8,	@OpOr		),	{ subcode $40, TOR }
    (	@MemoIm8,	@OpOr		),	{ subcode $80, OR }
    (	@MemoIm8,	@OpOr		),	{ subcode $C0, OR }
{ code $4E }
    (	@MemoIm8,	@OpAdb		),	{ subcode $00, TADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $40, TADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $80, ADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $C0, ADB }
{ code $4F }
    (	@MemoIm8,	@OpAd		),	{ subcode $00, TAD }
    (	@MemoIm8,	@OpAd		),	{ subcode $40, TAD }
    (	@MemoIm8,	@OpAd		),	{ subcode $80, AD }
    (	@MemoIm8,	@OpAd		),	{ subcode $C0, AD }
{ code $50 }
    (	@TMemoReg,	@OpNa		),	{ subcode $00, TNA }
    (	@TMemoReg,	@OpNa		),	{ subcode $40, TNA }
    (	@MemoReg,	@OpNa		),	{ subcode $80, NA }
    (	@MemoReg,	@OpNa		),	{ subcode $C0, NA }
{ code $51 }
    (	@TMemoReg,	@OpXr		),	{ subcode $00, TXR }
    (	@TMemoReg,	@OpXr		),	{ subcode $40, TXR }
    (	@MemoReg,	@OpXr		),	{ subcode $80, XR }
    (	@MemoReg,	@OpXr		),	{ subcode $C0, XR }
{ code $52 }
    (	@TMemoReg,	@OpSbb		),	{ subcode $00, TSBB }
    (	@TMemoReg,	@OpSbb		),	{ subcode $40, TSBB }
    (	@MemoReg,	@OpSbb		),	{ subcode $80, SBB }
    (	@MemoReg,	@OpSbb		),	{ subcode $C0, SBB }
{ code $53 }
    (	@TMemoReg,	@OpSb		),	{ subcode $00, TSB }
    (	@TMemoReg,	@OpSb		),	{ subcode $40, TSB }
    (	@MemoReg,	@OpSb		),	{ subcode $80, SB }
    (	@MemoReg,	@OpSb		),	{ subcode $C0, SB }
{ code $54 }
    (	@TMemoReg,	@OpAn		),	{ subcode $00, TAN }
    (	@TMemoReg,	@OpAn		),	{ subcode $40, TAN }
    (	@MemoReg,	@OpAn		),	{ subcode $80, AN }
    (	@MemoReg,	@OpAn		),	{ subcode $C0, AN }
{ code $55 }
    (	@TMemoReg,	@OpOr		),	{ subcode $00, TOR }
    (	@TMemoReg,	@OpOr		),	{ subcode $40, TOR }
    (	@MemoReg,	@OpOr		),	{ subcode $80, OR }
    (	@MemoReg,	@OpOr		),	{ subcode $C0, OR }
{ code $56 }
    (	@TMemoReg,	@OpAdb		),	{ subcode $00, TADB }
    (	@TMemoReg,	@OpAdb		),	{ subcode $40, TADB }
    (	@MemoReg,	@OpAdb		),	{ subcode $80, ADB }
    (	@MemoReg,	@OpAdb		),	{ subcode $C0, ADB }
{ code $57 }
    (	@TMemoReg,	@OpAd		),	{ subcode $00, TAD }
    (	@TMemoReg,	@OpAd		),	{ subcode $40, TAD }
    (	@MemoReg,	@OpAd		),	{ subcode $80, AD }
    (	@MemoReg,	@OpAd		),	{ subcode $C0, AD }
{ code $58 }
    (	@MemoIm8,	@OpNa		),	{ subcode $00, TNA }
    (	@MemoIm8,	@OpNa		),	{ subcode $40, TNA }
    (	@MemoIm8,	@OpNa		),	{ subcode $80, NA }
    (	@MemoIm8,	@OpNa		),	{ subcode $C0, NA }
{ code $59 }
    (	@MemoIm8,	@OpXr		),	{ subcode $00, TXR }
    (	@MemoIm8,	@OpXr		),	{ subcode $40, TXR }
    (	@MemoIm8,	@OpXr		),	{ subcode $80, XR }
    (	@MemoIm8,	@OpXr		),	{ subcode $C0, XR }
{ code $5A }
    (	@MemoIm8,	@OpSbb		),	{ subcode $00, TSBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $40, TSBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $80, SBB }
    (	@MemoIm8,	@OpSbb		),	{ subcode $C0, SBB }
{ code $5B }
    (	@MemoIm8,	@OpSb		),	{ subcode $00, TSB }
    (	@MemoIm8,	@OpSb		),	{ subcode $40, TSB }
    (	@MemoIm8,	@OpSb		),	{ subcode $80, SB }
    (	@MemoIm8,	@OpSb		),	{ subcode $C0, SB }
{ code $5C }
    (	@MemoIm8,	@OpAn		),	{ subcode $00, TAN }
    (	@MemoIm8,	@OpAn		),	{ subcode $40, TAN }
    (	@MemoIm8,	@OpAn		),	{ subcode $80, AN }
    (	@MemoIm8,	@OpAn		),	{ subcode $C0, AN }
{ code $5D }
    (	@MemoIm8,	@OpOr		),	{ subcode $00, TOR }
    (	@MemoIm8,	@OpOr		),	{ subcode $40, TOR }
    (	@MemoIm8,	@OpOr		),	{ subcode $80, OR }
    (	@MemoIm8,	@OpOr		),	{ subcode $C0, OR }
{ code $5E }
    (	@MemoIm8,	@OpAdb		),	{ subcode $00, TADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $40, TADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $80, ADB }
    (	@MemoIm8,	@OpAdb		),	{ subcode $C0, ADB }
{ code $5F }
    (	@MemoIm8,	@OpAd		),	{ subcode $00, TAD }
    (	@MemoIm8,	@OpAd		),	{ subcode $40, TAD }
    (	@MemoIm8,	@OpAd		),	{ subcode $80, AD }
    (	@MemoIm8,	@OpAd		),	{ subcode $C0, AD }
{ code $60 }
    (	@UnReg,		@OpRod		),	{ subcode $00, ROD }
    (	@UnReg,		@OpRod		),	{ subcode $40, ROD }
    (	@UnReg,		@OpRou		),	{ subcode $80, ROU }
    (	@UnReg,		@OpRou		),	{ subcode $C0, ROU }
{ code $61 }
    (	@UnReg,		@OpDid		),	{ subcode $00, DID }
    (	@UnReg,		@OpDid		),	{ subcode $40, DID }
    (	@UnReg,		@OpDiu		),	{ subcode $80, DIU }
    (	@UnReg,		@OpDiu		),	{ subcode $C0, DIU }
{ code $62 }
    (	@TUnReg,	@OpCmpb		),	{ subcode $00, TCMPB }
    (	@TUnReg,	@OpCmpb		),	{ subcode $40, TCMPB }
    (	@UnReg,		@OpCmpb		),	{ subcode $80, CMPB }
    (	@UnReg,		@OpCmpb		),	{ subcode $C0, CMPB }
{ code $63 }
    (	@TUnReg,	@OpCmp		),	{ subcode $00, TCMP }
    (	@TUnReg,	@OpCmp		),	{ subcode $40, TCMP }
    (	@UnReg,		@OpCmp		),	{ subcode $80, CMP }
    (	@UnReg,		@OpCmp		),	{ subcode $C0, CMP }
{ code $64 }
    (	@UnReg,		@OpByd		),	{ subcode $00, BYD }
    (	@UnReg,		@OpByd		),	{ subcode $40, BYD }
    (	@UnReg,		@OpByu		),	{ subcode $80, BYU }
    (	@UnReg,		@OpByu		),	{ subcode $C0, BYU }
{ code $65 }
    (	@UnReg,		@OpByd		),	{ subcode $00, BND }
    (	@UnReg,		@OpByd		),	{ subcode $40, BND }
    (	@UnReg,		@OpByu		),	{ subcode $80, BNU }
    (	@UnReg,		@OpByu		),	{ subcode $C0, BNU }
{ code $66 }
    (	@TUnReg,	@OpMtb		),	{ subcode $00, TMTB }
    (	@TUnReg,	@OpMtb		),	{ subcode $40, TMTB }
    (	@UnReg,		@OpMtb		),	{ subcode $80, MTB }
    (	@UnReg,		@OpMtb		),	{ subcode $C0, MTB }
{ code $67 }
    (	@TUnReg,	@OpRou		),	{ subcode $00, TBIU }
    (	@TUnReg,	@OpRou		),	{ subcode $40, TBIU }
    (	@UnReg,		@OpRou		),	{ subcode $80, BIU }
    (	@UnReg,		@OpRou		),	{ subcode $C0, BIU }
{ code $68 }
    (	@StMemoReg,	@PostDecw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostDecw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $C0, LD }
{ code $69 }
    (	@StMemoReg,	@PostDecw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostDecw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $C0, LD }
{ code $6A }
    (	@StMemoReg,	@PostDecw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostDecw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $C0, LD }
{ code $6B }
    (	@StMemoReg,	@PostDecw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostDecw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostDecw	),	{ subcode $C0, LD }
{ code $6C }
    (	@StMemoReg,	@PostIncw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostIncw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $C0, LD }
{ code $6D }
    (	@StMemoReg,	@PostIncw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostIncw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $C0, LD }
{ code $6E }
    (	@StMemoReg,	@PostIncw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostIncw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $C0, LD }
{ code $6F }
    (	@StMemoReg,	@PostIncw	),	{ subcode $00, ST }
    (	@StMemoReg,	@PostIncw	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PostIncw	),	{ subcode $C0, LD }
{ code $70 }
    (	@XunAry,	@OpRod		),	{ subcode $00, RODM }
    (	@YunAry,	@OpRod		),	{ subcode $40, RODM }
    (	@XunAry,	@OpRou		),	{ subcode $80, ROUM }
    (	@YunAry,	@OpRou		),	{ subcode $C0, ROUM }
{ code $71 }
    (	@XunAry,	@OpDid		),	{ subcode $00, DIDM }
    (	@YunAry,	@OpDid		),	{ subcode $40, DIDM }
    (	@XunAry,	@OpDiu		),	{ subcode $80, DIUM }
    (	@YunAry,	@OpDiu		),	{ subcode $C0, DIUM }
{ code $72 }
    (	@TXunAry,	@OpCmpb		),	{ subcode $00, TCMPBM }
    (	@TYunAry,	@OpCmpb		),	{ subcode $40, TCMPBM }
    (	@XunAry,	@OpCmpb		),	{ subcode $80, CMPBM }
    (	@YunAry,	@OpCmpb		),	{ subcode $C0, CMPBM }
{ code $73 }
    (	@TXunAry,	@OpCmp		),	{ subcode $00, TCMPM }
    (	@TYunAry,	@OpCmp		),	{ subcode $40, TCMPM }
    (	@XunAry,	@OpCmp		),	{ subcode $80, CMPM }
    (	@YunAry,	@OpCmp		),	{ subcode $C0, CMPM }
{ code $74 }
    (	@XunAry,	@OpByd		),	{ subcode $00, BYDM }
    (	@YunAry,	@OpByd		),	{ subcode $40, BYDM }
    (	@XunAry,	@OpByu		),	{ subcode $80, BYUM }
    (	@YunAry,	@OpByu		),	{ subcode $C0, BYUM }
{ code $75 }
    (	@XunAry,	@OpByd		),	{ subcode $00, BNDM }
    (	@YunAry,	@OpByd		),	{ subcode $40, BNDM }
    (	@XunAry,	@OpByu		),	{ subcode $80, BNUM }
    (	@YunAry,	@OpByu		),	{ subcode $C0, BNUM }
{ code $76 }
    (	@TXunAry,	@OpMtb		),	{ subcode $00, TMTBM }
    (	@TYunAry,	@OpMtb		),	{ subcode $40, TMTBM }
    (	@XunAry,	@OpMtb		),	{ subcode $80, MTBM }
    (	@YunAry,	@OpMtb		),	{ subcode $C0, MTBM }
{ code $77 }
    (	@TXunAry,	@OpRou		),	{ subcode $00, TBIUM }
    (	@TYunAry,	@OpRou		),	{ subcode $40, TBIUM }
    (	@XunAry,	@OpRou		),	{ subcode $80, BIUM }
    (	@YunAry,	@OpRou		),	{ subcode $C0, BIUM }
{ code $78 }
    (	@XmemoAry,	@PreDecw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreDecw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostDecw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostDecw	),	{ subcode $C0, LDM }
{ code $79 }
    (	@XmemoAry,	@PreDecw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreDecw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostDecw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostDecw	),	{ subcode $C0, LDM }
{ code $7A }
    (	@XmemoAry,	@PreDecw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreDecw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostDecw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostDecw	),	{ subcode $C0, LDM }
{ code $7B }
    (	@XmemoAry,	@PreDecw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreDecw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostDecw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostDecw	),	{ subcode $C0, LDM }
{ code $7C }
    (	@XmemoAry,	@PreIncw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreIncw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostIncw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostIncw	),	{ subcode $C0, LDM }
{ code $7D }
    (	@XmemoAry,	@PreIncw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreIncw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostIncw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostIncw	),	{ subcode $C0, LDM }
{ code $7E }
    (	@XmemoAry,	@PreIncw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreIncw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostIncw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostIncw	),	{ subcode $C0, LDM }
{ code $7F }
    (	@XmemoAry,	@PreIncw	),	{ subcode $00, STM }
    (	@YmemoAry,	@PreIncw	),	{ subcode $40, STM }
    (	@XaryMemo,	@PostIncw	),	{ subcode $80, LDM }
    (	@YaryMemo,	@PostIncw	),	{ subcode $C0, LDM }
{ code $80 }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $C0, LD }
{ code $81 }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $C0, LD }
{ code $82 }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $C0, LD }
{ code $83 }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@MinusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@MinusOffset8	),	{ subcode $C0, LD }
{ code $84 }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $C0, LD }
{ code $85 }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $C0, LD }
{ code $86 }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $C0, LD }
{ code $87 }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $00, ST }
    (	@StMemoReg,	@PlusOffset8	),	{ subcode $40, ST }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $80, LD }
    (	@LdRegMemo,	@PlusOffset8	),	{ subcode $C0, LD }
{ code $88 }
    (	@PstIm8,	@OpIe		),	{ subcode $00, PST }
    (	@PstIm8,	@OpIe		),	{ subcode $40, PST }
    (	@PstIm8,	@OpIe		),	{ subcode $80, PST }
    (	@PstIm8,	@OpIe		),	{ subcode $C0, PST }
{ code $89 }
    (	@PstIm8,	@OpDs		),	{ subcode $00, PST }
    (	@PstIm8,	@OpDs		),	{ subcode $40, PST }
    (	@PstIm8,	@OpDs		),	{ subcode $80, PST }
    (	@PstIm8,	@OpDs		),	{ subcode $C0, PST }
{ code $8A }
    (	@PstIm8,	@OpKc		),	{ subcode $00, PST }
    (	@PstIm8,	@OpKc		),	{ subcode $40, PST }
    (	@PstIm8,	@OpKc		),	{ subcode $80, PST }
    (	@PstIm8,	@OpKc		),	{ subcode $C0, PST }
{ code $8B }
    (	@PstIm8,	@OpPd		),	{ subcode $00, PST }
    (	@PstIm8,	@OpPd		),	{ subcode $40, PST }
    (	@PstIm8,	@OpPd		),	{ subcode $80, PST }
    (	@PstIm8,	@OpPd		),	{ subcode $C0, PST }
{ code $8C }
    (	@PstIm7,	@s4		),	{ subcode $00 }
    (	@PstIm7,	@s4		),	{ subcode $40 }
    (	@PstIm7,	@s8		),	{ subcode $80 }
    (	@PstIm7,	@s8		),	{ subcode $C0 }
{ code $8D }
    (	@PstIm7,	@s5		),	{ subcode $00 }
    (	@PstIm7,	@s5		),	{ subcode $40 }
    (	@PstIm7,	@asreg		),	{ subcode $80 }
    (	@PstIm7,	@asreg		),	{ subcode $C0 }
{ code $8E }
    (	@PstIm7,	@s6		),	{ subcode $00 }
    (	@PstIm7,	@s6		),	{ subcode $40 }
    (	@PstIm7,	@tm		),	{ subcode $80 }
    (	@PstIm7,	@tm		),	{ subcode $C0 }
{ code $8F }
    (	@PstIm7,	@s7		),	{ subcode $00 }
    (	@PstIm7,	@s7		),	{ subcode $40 }
    (	@PstIm7,	@pe		),	{ subcode $80 }
    (	@PstIm7,	@pe		),	{ subcode $C0 }
{ code $90 }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $C0, LDM }
{ code $91 }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $C0, LDM }
{ code $92 }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $C0, LDM }
{ code $93 }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@MinusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@MinusOffset5	),	{ subcode $C0, LDM }
{ code $94 }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $C0, LDM }
{ code $95 }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $C0, LDM }
{ code $96 }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $C0, LDM }
{ code $97 }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $00, STM }
    (	@StmOffsAry,	@PlusOffset5	),	{ subcode $40, STM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $80, LDM }
    (	@LdmAryOffs,	@PlusOffset5	),	{ subcode $C0, LDM }
{ code $98 }
    (	@PstReg,	@OpIe		),	{ subcode $00, PST }
    (	@PstReg,	@OpIe		),	{ subcode $40, PST }
    (	@Gst,		@ie		),	{ subcode $80, GST }
    (	@Gst,		@ie		),	{ subcode $C0, GST }
{ code $99 }
    (	@PstReg,	@OpDs		),	{ subcode $00, PST }
    (	@PstReg,	@OpDs		),	{ subcode $40, PST }
    (	@Gst,		@ds		),	{ subcode $80, GST }
    (	@Gst,		@ds		),	{ subcode $C0, GST }
{ code $9A }
    (	@PstReg,	@OpKc		),	{ subcode $00, PST }
    (	@PstReg,	@OpKc		),	{ subcode $40, PST }
    (	@Gst,		@ki		),	{ subcode $80, GST }
    (	@Gst,		@ki		),	{ subcode $C0, GST }
{ code $9B }
    (	@PstReg,	@OpPd		),	{ subcode $00, PST }
    (	@PstReg,	@OpPd		),	{ subcode $40, PST }
    (	@Gst,		@pd		),	{ subcode $80, GST }
    (	@Gst,		@pd		),	{ subcode $C0, GST }
{ code $9C }
    (	@PstReg,	@OpFl		),	{ subcode $00, PST }
    (	@PstReg,	@OpFl		),	{ subcode $40, PST }
    (	@Gst,		@flag		),	{ subcode $80, GST }
    (	@Gst,		@flag		),	{ subcode $C0, GST }
{ code $9D }
    (	@PstReg,	@OpAs		),	{ subcode $00, PST }
    (	@PstReg,	@OpAs		),	{ subcode $40, PST }
    (	@Gst,		@asreg		),	{ subcode $80, GST }
    (	@Gst,		@asreg		),	{ subcode $C0, GST }
{ code $9E }
    (	@BlockCopy,	@PreDecw	),	{ subcode $00, BDN }
    (	@BlockCopy,	@PreDecw	),	{ subcode $40, BDN }
    (	@BlockCopy,	@PreIncw	),	{ subcode $80, BUP }
    (	@BlockCopy,	@PreIncw	),	{ subcode $C0, BUP }
{ code $9F }
    (	@BlockCopy,	@PreDecw	),	{ subcode $00, BDN }
    (	@BlockCopy,	@PreDecw	),	{ subcode $40, BDN }
    (	@BlockCopy,	@PreIncw	),	{ subcode $80, BUP }
    (	@BlockCopy,	@PreIncw	),	{ subcode $C0, BUP }

    (	@NotKeyCond,	@Jump		),	{ code $A0, JMP }
    (	@NotCond,	@Jump		),	{ code $A1, JMP }
    (	@NotCond,	@Jump		),	{ code $A2, JMP }
    (	@NotCond,	@Jump		),	{ code $A3, JMP }
    (	@NotCond,	@Jump		),	{ code $A4, JMP }
    (	@NotCond,	@Jump		),	{ code $A5, JMP }
    (	@NotCond,	@Jump		),	{ code $A6, JMP }
    (	@NotCond,	@Jump		),	{ code $A7, JMP }
    (	@KeyCond,	@Jump		),	{ code $A8, JMP }
    (	@Cond,		@Jump		),	{ code $A9, JMP }
    (	@Cond,		@Jump		),	{ code $AA, JMP }
    (	@Cond,		@Jump		),	{ code $AB, JMP }
    (	@Cond,		@Jump		),	{ code $AC, JMP }
    (	@Cond,		@Jump		),	{ code $AD, JMP }
    (	@Cond,		@Jump		),	{ code $AE, JMP }
    (	@Off,		nil		),	{ code $AF, OFF }
    (	@NotKeyCond,	@Call		),	{ code $B0, CAL }
    (	@NotCond,	@Call		),	{ code $B1, CAL }
    (	@NotCond,	@Call		),	{ code $B2, CAL }
    (	@NotCond,	@Call		),	{ code $B3, CAL }
    (	@NotCond,	@Call		),	{ code $B4, CAL }
    (	@NotCond,	@Call		),	{ code $B5, CAL }
    (	@NotCond,	@Call		),	{ code $B6, CAL }
    (	@NotCond,	@Call		),	{ code $B7, CAL }
    (	@KeyCond,	@Call		),	{ code $B8, CAL }
    (	@Cond,		@Call		),	{ code $B9, CAL }
    (	@Cond,		@Call		),	{ code $BA, CAL }
    (	@Cond,		@Call		),	{ code $BB, CAL }
    (	@Cond,		@Call		),	{ code $BC, CAL }
    (	@Cond,		@Call		),	{ code $BD, CAL }
    (	@Cond,		@Call		),	{ code $BE, CAL }
    (	@Wai,		nil		),	{ code $BF, WAI }
    (	@NotKeyCond,	@Rtn		),	{ code $C0, RTN }
    (	@NotCond,	@Rtn		),	{ code $C1, RTN }
    (	@NotCond,	@Rtn		),	{ code $C2, RTN }
    (	@NotCond,	@Rtn		),	{ code $C3, RTN }
    (	@NotCond,	@Rtn		),	{ code $C4, RTN }
    (	@NotCond,	@Rtn		),	{ code $C5, RTN }
    (	@NotCond,	@Rtn		),	{ code $C6, RTN }
    (	@NotCond,	@Rtn		),	{ code $C7, RTN }
    (	@KeyCond,	@Rtn		),	{ code $C8, RTN }
    (	@Cond,		@Rtn		),	{ code $C9, RTN }
    (	@Cond,		@Rtn		),	{ code $CA, RTN }
    (	@Cond,		@Rtn		),	{ code $CB, RTN }
    (	@Cond,		@Rtn		),	{ code $CC, RTN }
    (	@Cond,		@Rtn		),	{ code $CD, RTN }
    (	@Cond,		@Rtn		),	{ code $CE, RTN }
    (	@Rti,		nil		),	{ code $CF, RTI }
    (	@Ldw,		nil		),	{ code $D0, LDW }
    (	@Ldw,		nil		),	{ code $D1, LDW }
    (	@Ldw,		nil		),	{ code $D2, LDW }
    (	@Ldw,		nil		),	{ code $D3, LDW }
    (	@Ldw,		nil		),	{ code $D4, LDW }
    (	@Ldw,		nil		),	{ code $D5, LDW }
    (	@Ldw,		nil		),	{ code $D6, LDW }
    (	@Ldw,		nil		),	{ code $D7, LDW }
    (	@AdwSbw,	@PreDecw	),	{ code $D8, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $D9, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $DA, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $DB, SBW }
    (	@AdwSbw,	@PreIncw	),	{ code $DC, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $DD, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $DE, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $DF, ADW }
    (	@NotKeyCond,	@SJump		),	{ code $E0, JMP }
    (	@NotCond,	@SJump		),	{ code $E1, JMP }
    (	@NotCond,	@SJump		),	{ code $E2, JMP }
    (	@NotCond,	@SJump		),	{ code $E3, JMP }
    (	@NotCond,	@SJump		),	{ code $E4, JMP }
    (	@NotCond,	@SJump		),	{ code $E5, JMP }
    (	@NotCond,	@SJump		),	{ code $E6, JMP }
    (	@NotCond,	@SJump		),	{ code $E7, JMP }
    (	@KeyCond,	@SJump		),	{ code $E8, JMP }
    (	@Cond,		@SJump		),	{ code $E9, JMP }
    (	@Cond,		@SJump		),	{ code $EA, JMP }
    (	@Cond,		@SJump		),	{ code $EB, JMP }
    (	@Cond,		@SJump		),	{ code $EC, JMP }
    (	@Cond,		@SJump		),	{ code $ED, JMP }
    (	@Cond,		@SJump		),	{ code $EE, JMP }
    (	@Nop,		nil		),	{ code $EF, NOP }
    (	@NotKeyCond,	@SCall		),	{ code $F0, SCAL }
    (	@NotCond,	@SCall		),	{ code $F1, SCAL }
    (	@NotCond,	@SCall		),	{ code $F2, SCAL }
    (	@NotCond,	@SCall		),	{ code $F3, SCAL }
    (	@NotCond,	@SCall		),	{ code $F4, SCAL }
    (	@NotCond,	@SCall		),	{ code $F5, SCAL }
    (	@NotCond,	@SCall		),	{ code $F6, SCAL }
    (	@NotCond,	@SCall		),	{ code $F7, SCAL }
    (	@KeyCond,	@SCall		),	{ code $F8, SCAL }
    (	@Cond,		@SCall		),	{ code $F9, SCAL }
    (	@Cond,		@SCall		),	{ code $FA, SCAL }
    (	@Cond,		@SCall		),	{ code $FB, SCAL }
    (	@Cond,		@SCall		),	{ code $FC, SCAL }
    (	@Cond,		@SCall		),	{ code $FD, SCAL }
    (	@Cond,		@SCall		),	{ code $FE, SCAL }
    (	@Trap,		nil		)	{ code $FF, TRP }
  );
var
  index: word;
begin
  index := FetchOpcode;
  regstep := 1;					{ default value }
  Proc2 (dtab[index,0]) (dtab[index,1]);
end {ExecInstr};


end.
