{ disassembler Casio HD62076/uPD3055 (NM-326) }

unit Dis;


interface

  function Mnemonic (kod: word) : string;
  function Arguments (kod: word) : string;


implementation

uses SysUtils, Def;

type

  t_kind = (
    NONE,		{ no arguments }
    REG3,		{ Register }
    REG5,		{ Register }
    XSWP,		{ Register }
    YSWP,		{ Register }
    XREG1REG6,		{ Register, Register }
    YREG1REG6,		{ Register, Register }
    REG5REG6,		{ Register, Register }
    REG4REG6,		{ Register, Register or 16-bit register }
    REG5REG5IM8,	{ Register, Register, Immediate byte }
    REG3IM8,		{ Register, Immediate byte }
    REG5IM8,		{ Register, Immediate byte }
    IXYREG7,		{ (IX) or (IY), Register }
    IXYIM8,		{ (IX) or (IY), Immediate byte }
    IRIM7R,		{ IR, Immediate byte or Register }
    IRREG5,		{ -/+(IR),Rxx }
    REG5IR,		{ Rxx,(IR)-/+ }
    XIRARRAY,		{ -/+(IR),Rxx..Ryy }
    YIRARRAY,		{ -/+(IR),Rxx..Ryy }
    XARRAYIR,		{ Rxx..Ryy,(IR)-/+ }
    YARRAYIR,		{ Rxx..Ryy,(IR)-/+ }
    IROF8REG5,		{ (IR+/-Im8),Rxx }
    REG5IROF8,		{ Rxx,(IR+/-Im8) }
    IROF5ARRAY,		{ (IR+/-Im5),Rxx..Ryy }
    ARRAYIROF5,		{ Rxx..Ryy,(IR+/-Im5) }
    XARRAY1,		{ Rxx..Ryy }
    YARRAY1,		{ Rxx..Ryy }
    XARRAY2,		{ Rxx..Ryy, Rxx..Ryy }
    YARRAY2,		{ Rxx..Ryy, Rxx..Ryy }
    ARRAY1IM5,		{ Rxx..Ryy, 5-bit immediate value }
    ARRAY2IM5,		{ Rxx..Ryy, Rxx..Ryy, 5-bit immediate value }
    IM16,		{ 16-bit immediate value }
    WRIM16,		{ Word Register, 16-bit immediate value }
    CC,			{ Condition code }
    CCIM16,		{ Condition code, 16-bit immediate value }
    SHORT,		{ 8-bit short-range jump/call }
    CCSHORT,		{ Condition code, 8-bit short-range jump/call }
    STIM7,		{ status register, immediate data }
    STIM8,		{ status register, immediate data }
    STREG5,		{ status register, data register }
    REG5ST		{ data register, status register }
  );


  tab = record
    str: string[6];
    kind: t_kind;
  end;


const

  mnem: array[0..4*$A0+$60-1] of tab = (
{ code $00 }
	( str:'tna';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tna';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'na';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'na';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $01 }
	( str:'txr';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'txr';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'xr';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'xr';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $02 }
	( str:'tsbb';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tsbb';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'sbb';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'sbb';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $03 }
	( str:'tsb';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tsb';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'sb';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'sb';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $04 }
	( str:'tan';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tan';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'an';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'an';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $05 }
	( str:'tor';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tor';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'or';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'or';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $06 }
	( str:'tadb';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tadb';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'adb';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'adb';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $07 }
	( str:'tad';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tad';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ad';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ad';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $08 }
	( str:'tna';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tna';	kind:REG3IM8	),	{ subcode $40 }
	( str:'na';	kind:REG3IM8	),	{ subcode $80 }
	( str:'na';	kind:REG3IM8	),	{ subcode $C0 }
{ code $09 }
	( str:'txr';	kind:REG3IM8	),	{ subcode $00 }
	( str:'txr';	kind:REG3IM8	),	{ subcode $40 }
	( str:'xr';	kind:REG3IM8	),	{ subcode $80 }
	( str:'xr';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0A }
	( str:'tsbb';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tsbb';	kind:REG3IM8	),	{ subcode $40 }
	( str:'sbb';	kind:REG3IM8	),	{ subcode $80 }
	( str:'sbb';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0B }
	( str:'tsb';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tsb';	kind:REG3IM8	),	{ subcode $40 }
	( str:'sb';	kind:REG3IM8	),	{ subcode $80 }
	( str:'sb';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0C }
	( str:'tan';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tan';	kind:REG3IM8	),	{ subcode $40 }
	( str:'an';	kind:REG3IM8	),	{ subcode $80 }
	( str:'an';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0D }
	( str:'tor';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tor';	kind:REG3IM8	),	{ subcode $40 }
	( str:'or';	kind:REG3IM8	),	{ subcode $80 }
	( str:'or';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0E }
	( str:'tadb';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tadb';	kind:REG3IM8	),	{ subcode $40 }
	( str:'adb';	kind:REG3IM8	),	{ subcode $80 }
	( str:'adb';	kind:REG3IM8	),	{ subcode $C0 }
{ code $0F }
	( str:'tad';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tad';	kind:REG3IM8	),	{ subcode $40 }
	( str:'ad';	kind:REG3IM8	),	{ subcode $80 }
	( str:'ad';	kind:REG3IM8	),	{ subcode $C0 }
{ code $10 }
	( str:'tnam';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tnam';	kind:YARRAY2	),	{ subcode $40 }
	( str:'nam';	kind:XARRAY2	),	{ subcode $80 }
	( str:'nam';	kind:YARRAY2	),	{ subcode $C0 }
{ code $11 }
	( str:'txrm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'txrm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'xrm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'xrm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $12 }
	( str:'tsbbm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tsbbm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'sbbm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'sbbm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $13 }
	( str:'tsbm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tsbm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'sbm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'sbm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $14 }
	( str:'tanm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tanm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'anm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'anm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $15 }
	( str:'torm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'torm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'orm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'orm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $16 }
	( str:'tadbm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tadbm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'adbm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'adbm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $17 }
	( str:'tadm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tadm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'adm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'adm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $18 }
	( str:'pla';	kind:REG4REG6	),	{ subcode $00 }
	( str:'pla';	kind:REG4REG6	),	{ subcode $40 }
	( str:'ijmp';	kind:REG4REG6	),	{ subcode $80 }
	( str:'ijmp';	kind:REG4REG6	),	{ subcode $C0 }
{ code $19 }
	( str:'bit';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'bit';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'bit';	kind:REG5IM8	),	{ subcode $80 }
	( str:'bit';	kind:REG5IM8	),	{ subcode $C0 }
{ code $1A }
	( str:'tsbbm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tsbbm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'sbbm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'sbbm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $1B }
	( str:'tsbm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tsbm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'sbm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'sbm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $1C }
	( str:'sdn';	kind:REG5REG6	),	{ subcode $00 }
	( str:'sdn';	kind:REG5REG6	),	{ subcode $40 }
	( str:'sup';	kind:REG5REG6	),	{ subcode $80 }
	( str:'sup';	kind:REG5REG6	),	{ subcode $C0 }
{ code $1D }
	( str:'[1D00]';	kind:REG5REG6	),	{ subcode $00 }
	( str:'[1D40]';	kind:REG5REG6	),	{ subcode $40 }
	( str:'[1D80]';	kind:REG5REG6	),	{ subcode $80 }
	( str:'[1DC0]';	kind:REG5REG6	),	{ subcode $C0 }
{ code $1E }
	( str:'tadbm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tadbm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'adbm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'adbm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $1F }
	( str:'tadm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tadm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'adm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'adm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $20 }
	( str:'ld';	kind:REG5REG5IM8),	{ subcode $00 }
	( str:'ld';	kind:REG5REG5IM8),	{ subcode $40 }
	( str:'ld';	kind:REG5IM8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IM8	),	{ subcode $C0 }
{ code $21 }
	( str:'xc';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xc';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ld';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ld';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $22 }
	( str:'tsbbc';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tsbbc';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'sbbc';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'sbbc';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $23 }
	( str:'tsbc';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tsbc';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'sbc';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'sbc';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $24 }
	( str:'swp';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'swp';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'swp';	kind:XSWP	),	{ subcode $80 }
	( str:'swp';	kind:YSWP	),	{ subcode $C0 }
{ code $25 }
	( str:'xcs';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xcs';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'lds';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'lds';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $26 }
	( str:'tadbc';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tadbc';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'adbc';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'adbc';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $27 }
	( str:'tadc';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'tadc';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'adc';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'adc';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $28 }
	( str:'xcl';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xch';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ldl';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ldh';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $29 }
	( str:'xchs';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xcls';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ldhs';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ldls';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $2A }
	( str:'tsbbc';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tsbbc';	kind:REG3IM8	),	{ subcode $40 }
	( str:'sbbc';	kind:REG3IM8	),	{ subcode $80 }
	( str:'sbbc';	kind:REG3IM8	),	{ subcode $C0 }
{ code $2B }
	( str:'tsbc';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tsbc';	kind:REG3IM8	),	{ subcode $40 }
	( str:'sbc';	kind:REG3IM8	),	{ subcode $80 }
	( str:'sbc';	kind:REG3IM8	),	{ subcode $C0 }
{ code $2C }
	( str:'xcls';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xchs';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ldls';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ldhs';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $2D }
	( str:'xch';	kind:XREG1REG6	),	{ subcode $00 }
	( str:'xcl';	kind:YREG1REG6	),	{ subcode $40 }
	( str:'ldh';	kind:XREG1REG6	),	{ subcode $80 }
	( str:'ldl';	kind:YREG1REG6	),	{ subcode $C0 }
{ code $2E }
	( str:'tadbc';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tadbc';	kind:REG3IM8	),	{ subcode $40 }
	( str:'adbc';	kind:REG3IM8	),	{ subcode $80 }
	( str:'adbc';	kind:REG3IM8	),	{ subcode $C0 }
{ code $2F }
	( str:'tadc';	kind:REG3IM8	),	{ subcode $00 }
	( str:'tadc';	kind:REG3IM8	),	{ subcode $40 }
	( str:'adc';	kind:REG3IM8	),	{ subcode $80 }
	( str:'adc';	kind:REG3IM8	),	{ subcode $C0 }
{ code $30 }
	( str:'ldm';	kind:ARRAY2IM5	),	{ subcode $00 }
	( str:'ldm';	kind:ARRAY2IM5	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $31 }
	( str:'xcm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xcm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $32 }
	( str:'tsbbcm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tsbbcm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'sbbcm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'sbbcm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $33 }
	( str:'tsbcm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tsbcm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'sbcm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'sbcm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $34 }
	( str:'swpm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'swpm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'swpm';	kind:XARRAY1	),	{ subcode $80 }
	( str:'swpm';	kind:YARRAY1	),	{ subcode $C0 }
{ code $35 }
	( str:'xcsm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xcsm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldsm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldsm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $36 }
	( str:'tadbcm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tadbcm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'adbcm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'adbcm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $37 }
	( str:'tadcm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'tadcm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'adcm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'adcm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $38 }
	( str:'xclm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xchm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldlm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldhm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $39 }
	( str:'xchsm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xclsm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldhsm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldlsm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $3A }
	( str:'tsbbcm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tsbbcm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'sbbcm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'sbbcm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $3B }
	( str:'tsbcm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tsbcm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'sbcm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'sbcm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $3C }
	( str:'xclsm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xchsm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldlsm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldhsm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $3D }
	( str:'xchm';	kind:XARRAY2	),	{ subcode $00 }
	( str:'xclm';	kind:YARRAY2	),	{ subcode $40 }
	( str:'ldhm';	kind:XARRAY2	),	{ subcode $80 }
	( str:'ldlm';	kind:YARRAY2	),	{ subcode $C0 }
{ code $3E }
	( str:'tadbcm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tadbcm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'adbcm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'adbcm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $3F }
	( str:'tadcm';	kind:ARRAY1IM5	),	{ subcode $00 }
	( str:'tadcm';	kind:ARRAY1IM5	),	{ subcode $40 }
	( str:'adcm';	kind:ARRAY1IM5	),	{ subcode $80 }
	( str:'adcm';	kind:ARRAY1IM5	),	{ subcode $C0 }
{ code $40 }
	( str:'tna';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tna';	kind:IXYREG7	),	{ subcode $40 }
	( str:'na';	kind:IXYREG7	),	{ subcode $80 }
	( str:'na';	kind:IXYREG7	),	{ subcode $C0 }
{ code $41 }
	( str:'txr';	kind:IXYREG7	),	{ subcode $00 }
	( str:'txr';	kind:IXYREG7	),	{ subcode $40 }
	( str:'xr';	kind:IXYREG7	),	{ subcode $80 }
	( str:'xr';	kind:IXYREG7	),	{ subcode $C0 }
{ code $42 }
	( str:'tsbb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tsbb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'sbb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'sbb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $43 }
	( str:'tsb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tsb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'sb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'sb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $44 }
	( str:'tan';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tan';	kind:IXYREG7	),	{ subcode $40 }
	( str:'an';	kind:IXYREG7	),	{ subcode $80 }
	( str:'an';	kind:IXYREG7	),	{ subcode $C0 }
{ code $45 }
	( str:'tor';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tor';	kind:IXYREG7	),	{ subcode $40 }
	( str:'or';	kind:IXYREG7	),	{ subcode $80 }
	( str:'or';	kind:IXYREG7	),	{ subcode $C0 }
{ code $46 }
	( str:'tadb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tadb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'adb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'adb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $47 }
	( str:'tad';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tad';	kind:IXYREG7	),	{ subcode $40 }
	( str:'ad';	kind:IXYREG7	),	{ subcode $80 }
	( str:'ad';	kind:IXYREG7	),	{ subcode $C0 }
{ code $48 }
	( str:'na';	kind:IXYIM8	),	{ subcode $00 }
	( str:'na';	kind:IXYIM8	),	{ subcode $40 }
	( str:'na';	kind:IXYIM8	),	{ subcode $80 }
	( str:'na';	kind:IXYIM8	),	{ subcode $C0 }
{ code $49 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $00 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $40 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $80 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4A }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4B }
	( str:'sb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4C }
	( str:'an';	kind:IXYIM8	),	{ subcode $00 }
	( str:'an';	kind:IXYIM8	),	{ subcode $40 }
	( str:'an';	kind:IXYIM8	),	{ subcode $80 }
	( str:'an';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4D }
	( str:'or';	kind:IXYIM8	),	{ subcode $00 }
	( str:'or';	kind:IXYIM8	),	{ subcode $40 }
	( str:'or';	kind:IXYIM8	),	{ subcode $80 }
	( str:'or';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4E }
	( str:'adb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $4F }
	( str:'ad';	kind:IXYIM8	),	{ subcode $00 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $40 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $80 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $C0 }
{ code $50 }
	( str:'tna';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tna';	kind:IXYREG7	),	{ subcode $40 }
	( str:'na';	kind:IXYREG7	),	{ subcode $80 }
	( str:'na';	kind:IXYREG7	),	{ subcode $C0 }
{ code $51 }
	( str:'txr';	kind:IXYREG7	),	{ subcode $00 }
	( str:'txr';	kind:IXYREG7	),	{ subcode $40 }
	( str:'xr';	kind:IXYREG7	),	{ subcode $80 }
	( str:'xr';	kind:IXYREG7	),	{ subcode $C0 }
{ code $52 }
	( str:'tsbb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tsbb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'sbb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'sbb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $53 }
	( str:'tsb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tsb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'sb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'sb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $54 }
	( str:'tan';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tan';	kind:IXYREG7	),	{ subcode $40 }
	( str:'an';	kind:IXYREG7	),	{ subcode $80 }
	( str:'an';	kind:IXYREG7	),	{ subcode $C0 }
{ code $55 }
	( str:'tor';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tor';	kind:IXYREG7	),	{ subcode $40 }
	( str:'or';	kind:IXYREG7	),	{ subcode $80 }
	( str:'or';	kind:IXYREG7	),	{ subcode $C0 }
{ code $56 }
	( str:'tadb';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tadb';	kind:IXYREG7	),	{ subcode $40 }
	( str:'adb';	kind:IXYREG7	),	{ subcode $80 }
	( str:'adb';	kind:IXYREG7	),	{ subcode $C0 }
{ code $57 }
	( str:'tad';	kind:IXYREG7	),	{ subcode $00 }
	( str:'tad';	kind:IXYREG7	),	{ subcode $40 }
	( str:'ad';	kind:IXYREG7	),	{ subcode $80 }
	( str:'ad';	kind:IXYREG7	),	{ subcode $C0 }
{ code $58 }
	( str:'na';	kind:IXYIM8	),	{ subcode $00 }
	( str:'na';	kind:IXYIM8	),	{ subcode $40 }
	( str:'na';	kind:IXYIM8	),	{ subcode $80 }
	( str:'na';	kind:IXYIM8	),	{ subcode $C0 }
{ code $59 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $00 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $40 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $80 }
	( str:'xr';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5A }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'sbb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5B }
	( str:'sb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'sb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5C }
	( str:'an';	kind:IXYIM8	),	{ subcode $00 }
	( str:'an';	kind:IXYIM8	),	{ subcode $40 }
	( str:'an';	kind:IXYIM8	),	{ subcode $80 }
	( str:'an';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5D }
	( str:'or';	kind:IXYIM8	),	{ subcode $00 }
	( str:'or';	kind:IXYIM8	),	{ subcode $40 }
	( str:'or';	kind:IXYIM8	),	{ subcode $80 }
	( str:'or';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5E }
	( str:'adb';	kind:IXYIM8	),	{ subcode $00 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $40 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $80 }
	( str:'adb';	kind:IXYIM8	),	{ subcode $C0 }
{ code $5F }
	( str:'ad';	kind:IXYIM8	),	{ subcode $00 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $40 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $80 }
	( str:'ad';	kind:IXYIM8	),	{ subcode $C0 }
{ code $60 }
	( str:'rod';	kind:REG5	),	{ subcode $00 }
	( str:'rod';	kind:REG5	),	{ subcode $40 }
	( str:'rou';	kind:REG5	),	{ subcode $80 }
	( str:'rou';	kind:REG5	),	{ subcode $C0 }
{ code $61 }
	( str:'did';	kind:REG5	),	{ subcode $00 }
	( str:'did';	kind:REG5	),	{ subcode $40 }
	( str:'diu';	kind:REG5	),	{ subcode $80 }
	( str:'diu';	kind:REG5	),	{ subcode $C0 }
{ code $62 }
	( str:'tcmpb';	kind:REG3	),	{ subcode $00 }
	( str:'tcmpb';	kind:REG3	),	{ subcode $40 }
	( str:'cmpb';	kind:REG3	),	{ subcode $80 }
	( str:'cmpb';	kind:REG3	),	{ subcode $C0 }
{ code $63 }
	( str:'tcmp';	kind:REG3	),	{ subcode $00 }
	( str:'tcmp';	kind:REG3	),	{ subcode $40 }
	( str:'cmp';	kind:REG3	),	{ subcode $80 }
	( str:'cmp';	kind:REG3	),	{ subcode $C0 }
{ code $64 }
	( str:'byd';	kind:REG5	),	{ subcode $00 }
	( str:'byd';	kind:REG5	),	{ subcode $40 }
	( str:'byu';	kind:REG5	),	{ subcode $80 }
	( str:'byu';	kind:REG5	),	{ subcode $C0 }
{ code $65 }
	( str:'bnd';	kind:REG5	),	{ subcode $00 }
	( str:'bnd';	kind:REG5	),	{ subcode $40 }
	( str:'bnu';	kind:REG5	),	{ subcode $80 }
	( str:'bnu';	kind:REG5	),	{ subcode $C0 }
{ code $66 }
	( str:'tmtb';	kind:REG3	),	{ subcode $00 }
	( str:'tmtb';	kind:REG3	),	{ subcode $40 }
	( str:'mtb';	kind:REG3	),	{ subcode $80 }
	( str:'mtb';	kind:REG3	),	{ subcode $C0 }
{ code $67 }
	( str:'tbiu';	kind:REG3	),	{ subcode $00 }
	( str:'tbiu';	kind:REG3	),	{ subcode $40 }
	( str:'biu';	kind:REG3	),	{ subcode $80 }
	( str:'biu';	kind:REG3	),	{ subcode $C0 }
{ code $68 }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $69 }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6A }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6B }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6C }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6D }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6E }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $6F }
	( str:'st';	kind:IRREG5	),	{ subcode $00 }
	( str:'st';	kind:IRREG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IR	),	{ subcode $80 }
	( str:'ld';	kind:REG5IR	),	{ subcode $C0 }
{ code $70 }
	( str:'rodm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'rodm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'roum';	kind:XARRAY1	),	{ subcode $80 }
	( str:'roum';	kind:YARRAY1	),	{ subcode $C0 }
{ code $71 }
	( str:'didm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'didm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'dium';	kind:XARRAY1	),	{ subcode $80 }
	( str:'dium';	kind:YARRAY1	),	{ subcode $C0 }
{ code $72 }
	( str:'tcmpbm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'tcmpbm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'cmpbm';	kind:XARRAY1	),	{ subcode $80 }
	( str:'cmpbm';	kind:YARRAY1	),	{ subcode $C0 }
{ code $73 }
	( str:'tcmpm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'tcmpm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'cmpm';	kind:XARRAY1	),	{ subcode $80 }
	( str:'cmpm';	kind:YARRAY1	),	{ subcode $C0 }
{ code $74 }
	( str:'bydm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'bydm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'byum';	kind:XARRAY1	),	{ subcode $80 }
	( str:'byum';	kind:YARRAY1	),	{ subcode $C0 }
{ code $75 }
	( str:'bndm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'bndm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'bnum';	kind:XARRAY1	),	{ subcode $80 }
	( str:'bnum';	kind:YARRAY1	),	{ subcode $C0 }
{ code $76 }
	( str:'tmtbm';	kind:XARRAY1	),	{ subcode $00 }
	( str:'tmtbm';	kind:YARRAY1	),	{ subcode $40 }
	( str:'mtbm';	kind:XARRAY1	),	{ subcode $80 }
	( str:'mtbm';	kind:YARRAY1	),	{ subcode $C0 }
{ code $77 }
	( str:'tbium';	kind:XARRAY1	),	{ subcode $00 }
	( str:'tbium';	kind:YARRAY1	),	{ subcode $40 }
	( str:'bium';	kind:XARRAY1	),	{ subcode $80 }
	( str:'bium';	kind:YARRAY1	),	{ subcode $C0 }
{ code $78 }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $79 }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7A }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7B }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7C }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7D }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7E }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $7F }
	( str:'stm';	kind:XIRARRAY	),	{ subcode $00 }
	( str:'stm';	kind:YIRARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:XARRAYIR	),	{ subcode $80 }
	( str:'ldm';	kind:YARRAYIR	),	{ subcode $C0 }
{ code $80 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $81 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $82 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $83 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $84 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $85 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $86 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $87 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $00 }
	( str:'st';	kind:IROF8REG5	),	{ subcode $40 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $80 }
	( str:'ld';	kind:REG5IROF8	),	{ subcode $C0 }
{ code $88 }
	( str:'pst';	kind:STIM8	),	{ subcode $00 }
	( str:'pst';	kind:STIM8	),	{ subcode $40 }
	( str:'pst';	kind:STIM8	),	{ subcode $80 }
	( str:'pst';	kind:STIM8	),	{ subcode $C0 }
{ code $89 }
	( str:'pst';	kind:STIM8	),	{ subcode $00 }
	( str:'pst';	kind:STIM8	),	{ subcode $40 }
	( str:'pst';	kind:STIM8	),	{ subcode $80 }
	( str:'pst';	kind:STIM8	),	{ subcode $C0 }
{ code $8A }
	( str:'pst';	kind:STIM8	),	{ subcode $00 }
	( str:'pst';	kind:STIM8	),	{ subcode $40 }
	( str:'pst';	kind:STIM8	),	{ subcode $80 }
	( str:'pst';	kind:STIM8	),	{ subcode $C0 }
{ code $8B }
	( str:'pst';	kind:STIM8	),	{ subcode $00 }
	( str:'pst';	kind:STIM8	),	{ subcode $40 }
	( str:'pst';	kind:STIM8	),	{ subcode $80 }
	( str:'pst';	kind:STIM8	),	{ subcode $C0 }
{ code $8C }
	( str:'pst';	kind:STIM7	),	{ subcode $00 }
	( str:'pst';	kind:STIM7	),	{ subcode $40 }
	( str:'pst';	kind:STIM7	),	{ subcode $80 }
	( str:'pst';	kind:STIM7	),	{ subcode $C0 }
{ code $8D }
	( str:'pst';	kind:STIM7	),	{ subcode $00 }
	( str:'pst';	kind:STIM7	),	{ subcode $40 }
	( str:'pst';	kind:STIM7	),	{ subcode $80 }
	( str:'pst';	kind:STIM7	),	{ subcode $C0 }
{ code $8E }
	( str:'pst';	kind:STIM7	),	{ subcode $00 }
	( str:'pst';	kind:STIM7	),	{ subcode $40 }
	( str:'pst';	kind:STIM7	),	{ subcode $80 }
	( str:'pst';	kind:STIM7	),	{ subcode $C0 }
{ code $8F }
	( str:'pst';	kind:STIM7	),	{ subcode $00 }
	( str:'pst';	kind:STIM7	),	{ subcode $40 }
	( str:'pst';	kind:STIM7	),	{ subcode $80 }
	( str:'pst';	kind:STIM7	),	{ subcode $C0 }
{ code $90 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $91 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $92 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $93 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $94 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $95 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $96 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $97 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $00 }
	( str:'stm';	kind:IROF5ARRAY	),	{ subcode $40 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $80 }
	( str:'ldm';	kind:ARRAYIROF5	),	{ subcode $C0 }
{ code $98 }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $99 }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $9A }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $9B }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $9C }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $9D }
	( str:'pst';	kind:STREG5	),	{ subcode $00 }
	( str:'pst';	kind:STREG5	),	{ subcode $40 }
	( str:'gst';	kind:REG5ST	),	{ subcode $80 }
	( str:'gst';	kind:REG5ST	),	{ subcode $C0 }
{ code $9E }
	( str:'bdn';	kind:REG5	),	{ subcode $00 }
	( str:'bdn';	kind:REG5	),	{ subcode $40 }
	( str:'bup';	kind:REG5	),	{ subcode $80 }
	( str:'bup';	kind:REG5	),	{ subcode $C0 }
{ code $9F }
	( str:'bdn';	kind:REG5	),	{ subcode $00 }
	( str:'bdn';	kind:REG5	),	{ subcode $40 }
	( str:'bup';	kind:REG5	),	{ subcode $80 }
	( str:'bup';	kind:REG5	),	{ subcode $C0 }

	( str:'jmp';	kind:CCIM16	),	{ code $A0 }
	( str:'jmp';	kind:CCIM16	),	{ code $A1 }
	( str:'jmp';	kind:CCIM16	),	{ code $A2 }
	( str:'jmp';	kind:CCIM16	),	{ code $A3 }
	( str:'jmp';	kind:CCIM16	),	{ code $A4 }
	( str:'jmp';	kind:CCIM16	),	{ code $A5 }
	( str:'jmp';	kind:CCIM16	),	{ code $A6 }
	( str:'jmp';	kind:IM16	),	{ code $A7 }
	( str:'jmp';	kind:CCIM16	),	{ code $A8 }
	( str:'jmp';	kind:CCIM16	),	{ code $A9 }
	( str:'jmp';	kind:CCIM16	),	{ code $AA }
	( str:'jmp';	kind:CCIM16	),	{ code $AB }
	( str:'jmp';	kind:CCIM16	),	{ code $AC }
	( str:'jmp';	kind:CCIM16	),	{ code $AD }
	( str:'jmp';	kind:CCIM16	),	{ code $AE }
	( str:'off';	kind:NONE	),	{ code $AF }
	( str:'cal';	kind:CCIM16	),	{ code $B0 }
	( str:'cal';	kind:CCIM16	),	{ code $B1 }
	( str:'cal';	kind:CCIM16	),	{ code $B2 }
	( str:'cal';	kind:CCIM16	),	{ code $B3 }
	( str:'cal';	kind:CCIM16	),	{ code $B4 }
	( str:'cal';	kind:CCIM16	),	{ code $B5 }
	( str:'cal';	kind:CCIM16	),	{ code $B6 }
	( str:'cal';	kind:IM16	),	{ code $B7 }
	( str:'cal';	kind:CCIM16	),	{ code $B8 }
	( str:'cal';	kind:CCIM16	),	{ code $B9 }
	( str:'cal';	kind:CCIM16	),	{ code $BA }
	( str:'cal';	kind:CCIM16	),	{ code $BB }
	( str:'cal';	kind:CCIM16	),	{ code $BC }
	( str:'cal';	kind:CCIM16	),	{ code $BD }
	( str:'cal';	kind:CCIM16	),	{ code $BE }
	( str:'wai';	kind:NONE	),	{ code $BF }
	( str:'rtn';	kind:CC		),	{ code $C0 }
	( str:'rtn';	kind:CC		),	{ code $C1 }
	( str:'rtn';	kind:CC		),	{ code $C2 }
	( str:'rtn';	kind:CC		),	{ code $C3 }
	( str:'rtn';	kind:CC		),	{ code $C4 }
	( str:'rtn';	kind:CC		),	{ code $C5 }
	( str:'rtn';	kind:CC		),	{ code $C6 }
	( str:'rtn';	kind:NONE	),	{ code $C7 }
	( str:'rtn';	kind:CC		),	{ code $C8 }
	( str:'rtn';	kind:CC		),	{ code $C9 }
	( str:'rtn';	kind:CC		),	{ code $CA }
	( str:'rtn';	kind:CC		),	{ code $CB }
	( str:'rtn';	kind:CC		),	{ code $CC }
	( str:'rtn';	kind:CC		),	{ code $CD }
	( str:'rtn';	kind:CC		),	{ code $CE }
	( str:'rti';	kind:NONE	),	{ code $CF }
	( str:'ldw';	kind:WRIM16	),	{ code $D0 }
	( str:'ldw';	kind:WRIM16	),	{ code $D1 }
	( str:'ldw';	kind:WRIM16	),	{ code $D2 }
	( str:'ldw';	kind:WRIM16	),	{ code $D3 }
	( str:'ldw';	kind:WRIM16	),	{ code $D4 }
	( str:'ldw';	kind:WRIM16	),	{ code $D5 }
	( str:'ldw';	kind:WRIM16	),	{ code $D6 }
	( str:'ldw';	kind:WRIM16	),	{ code $D7 }
	( str:'sbw';	kind:IRIM7R	),	{ code $D8 }
	( str:'sbw';	kind:IRIM7R	),	{ code $D9 }
	( str:'sbw';	kind:IRIM7R	),	{ code $DA }
	( str:'sbw';	kind:IRIM7R	),	{ code $DB }
	( str:'adw';	kind:IRIM7R	),	{ code $DC }
	( str:'adw';	kind:IRIM7R	),	{ code $DD }
	( str:'adw';	kind:IRIM7R	),	{ code $DE }
	( str:'adw';	kind:IRIM7R	),	{ code $DF }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E0 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E1 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E2 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E3 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E4 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E5 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E6 }
	( str:'sjmp';	kind:SHORT	),	{ code $E7 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E8 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $E9 }
	( str:'sjmp';	kind:CCSHORT	),	{ code $EA }
	( str:'sjmp';	kind:CCSHORT	),	{ code $EB }
	( str:'sjmp';	kind:CCSHORT	),	{ code $EC }
	( str:'sjmp';	kind:CCSHORT	),	{ code $ED }
	( str:'sjmp';	kind:CCSHORT	),	{ code $EE }
	( str:'nop';	kind:NONE	),	{ code $EF }
	( str:'scal';	kind:CCSHORT	),	{ code $F0 }
	( str:'scal';	kind:CCSHORT	),	{ code $F1 }
	( str:'scal';	kind:CCSHORT	),	{ code $F2 }
	( str:'scal';	kind:CCSHORT	),	{ code $F3 }
	( str:'scal';	kind:CCSHORT	),	{ code $F4 }
	( str:'scal';	kind:CCSHORT	),	{ code $F5 }
	( str:'scal';	kind:CCSHORT	),	{ code $F6 }
	( str:'scal';	kind:SHORT	),	{ code $F7 }
	( str:'scal';	kind:CCSHORT	),	{ code $F8 }
	( str:'scal';	kind:CCSHORT	),	{ code $F9 }
	( str:'scal';	kind:CCSHORT	),	{ code $FA }
	( str:'scal';	kind:CCSHORT	),	{ code $FB }
	( str:'scal';	kind:CCSHORT	),	{ code $FC }
	( str:'scal';	kind:CCSHORT	),	{ code $FD }
	( str:'scal';	kind:CCSHORT	),	{ code $FE }
	( str:'trp';	kind:NONE	)	{ code $FF }
  );



  ir_tab: array[0..3] of string[2] = (
	'ix', 'iy', 'iz', 'sp' );

  wr_tab: array[0..7] of string[2] = (
	'ix', 'iy', 'iz', 'v3', 'v2', 'v1', 'v0', 'sp' );

  cc_tab: array[0..7] of string[2] = (
	'k',  'lz', 'uz', 'z',  'v',  'h',  'c',  '*'  );

  st_tab_i8: array[0..3] of string[2] = (
	'ie', 'ds', 'ky', 'pd' );

  st_tab_i7: array[0..3,0..1] of string[2] = (
	( 's4', 's8' ),
	( 's5', 'as' ),
	( 's6', 'tm' ),
	( 's7', 'pe' )	);

  st_tab_r: array[0..7] of string[2] = (
	'ie', 'ds', 'ky', 'pd', 'f',  'as', '*',  '*'  );


var y, z : byte;	{ second and third byte of the instruction code }


function CaHexB (x: byte) : string;
begin
  CaHexB := '&H' + IntToHex(x,2);
end {CaHexB};


function CondCode (x: byte) : string;
begin
  if (x and $08) = 0 then Result := 'n' else Result := '';
  Result := Result + cc_tab[x and $07];
end {CondCode};


function RegA : byte;
begin
  RegA := (y and $3F) or $40;
end {RegA};


function RegB : byte;
begin
  RegB := ((z shl 3) and $38) or (y and $07);
end {RegB};


function RegC : byte;
begin
  RegC := (y and $38) or (z shr 5) or $40;
end {RegC};


function RegD : byte;
begin
  RegD := (z shr 5) or ((z shl 3) and $38);
end {RegD};


function RegE : byte;
begin
  RegE := (y and $78) or (z shr 5);
end {RegE};


function RegName : char;
begin
  if (z and $10) = 0 then RegName := 'r' else RegName := 'i';
end {RegName};


{ returns the mnemonic }
function Mnemonic (kod: word) : string;
begin
  Mnemonic := mnem[kod].str;
end {Mnemonic};


{ returns the arguments }
function Arguments (kod: word) : string;
var
  x : byte;
  sign : char;
begin
  x := FetchByte;
  if (x and $04) = 0 then sign := '-' else sign := '+';

  case mnem[kod].kind of

    NONE:
      Result := '';

    REG3, REG5:
      Result := 'r' + IntToStr(FetchByte and $7F);

    XSWP:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := RegName + IntToStr(RegD);
      end;

    YSWP:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegA);
      end;

    XREG1REG6:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := RegName + IntToStr(RegD) + ',r' + IntToStr(RegA);
      end;

    YREG1REG6:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegA) + ',' + RegName + IntToStr(RegD);
      end;

    REG5REG6:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(y and $7F) + ',' + RegName + IntToStr(RegD);
      end;

    REG4REG6:
      begin
        y := FetchByte;
        z := FetchByte;
        if ((z and $10) = 0) and ((y and $3F) = RegD) and
		((y and $38) = $38) then
          Result := wr_tab[y and $07]
        else
          Result := 'r' + IntToStr(RegA) + ',' + RegName + IntToStr(RegD);
      end;

    REG5REG5IM8:
      begin
        y := FetchByte and $7F;
        Result := 'r' + IntToStr(y) + ',r' + IntToStr(y xor $40) + ',' +
		CaHexB(FetchByte);
      end;

    REG3IM8, REG5IM8:
      begin
        y := FetchByte and $7F;
        Result := 'r' + IntToStr(y) + ',' + CaHexB(FetchByte);
      end;

    IXYREG7:
      Result := '(' + ir_tab[(x shr 4) and $01] + '),r' +
		IntToStr((FetchByte and $7F) xor $40);

    IXYIM8:
      Result := '(' + ir_tab[(x shr 4) and $01] + '),' + CaHexB(FetchByte);

    IRIM7R:
      begin
        y := FetchByte;
        Result := ir_tab[x and $03] + ',';
        if (y and $80) = 0 then
          Result := Result + CaHexB(y and $7F)
        else
          Result := Result + 'r' + IntToStr(y and $7F);
      end;

    IRREG5:
      Result := sign + '(' + ir_tab[x and $03] + '),r' +
		IntToStr(FetchByte and $7F);

    REG5IR:
      Result := 'r' + IntToStr(FetchByte and $7F) + ',(' + ir_tab[x and $03] +
		')' + sign;

    XIRARRAY:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := sign + '(' + ir_tab[x and $03] + '),r' + IntToStr(RegB) +
		'..r' + IntToStr(RegD);
      end;

    YIRARRAY:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := sign + '(' + ir_tab[x and $03] + '),r' + IntToStr(RegA) +
		'..r' + IntToStr(RegC);
      end;

    XARRAYIR:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegB) + '..r' + IntToStr(RegD) + ',(' +
		ir_tab[x and $03] + ')' + sign;
      end;

    YARRAYIR:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegA) + '..r' + IntToStr(RegC) + ',(' +
		ir_tab[x and $03] + ')' + sign;
      end;

    IROF8REG5:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := '(' + ir_tab[x and $03] + sign;
        if z = $FF then
          Result := Result + '&H100'
        else
          Result := Result + CaHexB(z+1);
	Result := Result + '),r' + IntToStr(y and $7F);
      end;

    REG5IROF8:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(y and $7F) + ',(' + ir_tab[x and $03] +
		sign + CaHexB(z) + ')';
      end;

    IROF5ARRAY:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := '(' + ir_tab[x and $03] + sign + CaHexB((z and $1F) + 1) +
		'),r'+ IntToStr(y and $7F) + '..r' + IntToStr(RegE);
      end;

    ARRAYIROF5:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(y and $7F) + '..r' + IntToStr(RegE) + ',(' +
		ir_tab[x and $03] + sign + CaHexB(z and $1F) + ')';
      end;

    XARRAY1:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := RegName + IntToStr(RegB) + '..' + RegName + IntToStr(RegD);
      end;

    YARRAY1:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegA) + '..r' + IntToStr(RegC);
      end;

    XARRAY2:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := RegName + IntToStr(RegB) + '..' + RegName + IntToStr(RegD) +
		',r' + IntToStr(RegA) + '..r' + IntToStr(RegC);
      end;

    YARRAY2:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(RegA) + '..r' + IntToStr(RegC) + ',' +
		RegName + IntToStr(RegB) + '..' + RegName + IntToStr(RegD);
      end;

    ARRAY1IM5:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(y and $7F) + '..r' + IntToStr(RegE) + ',' +
		CaHexB(z and $1F);
      end;

    ARRAY2IM5:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := 'r' + IntToStr(y and $3F) + '..r' + IntToStr(RegC and $3F) +
		',r' + IntToStr(RegA) + '..r' +
		IntToStr((RegC and $3F) or $40) + ',' + CaHexB(z and $1F);
      end;

    CC:
        Result := CondCode(x);

    CCIM16:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := CondCode(x) + ',' + CaHexB(y) + IntToHex(z,2);
      end;

    IM16:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := CaHexB(y) + IntToHex(z,2);
      end;

    WRIM16:
      begin
        y := FetchByte;
        z := FetchByte;
        Result := wr_tab[x and $07] + ',' + CaHexB(y) + IntToHex(z,2);
      end;

    CCSHORT:
      begin	{ warning: the execution order is important, because
		  FetchByte modifies pc }
        Result := CondCode(x) + ',' + CaHexB(Hi(pc));
        Result := Result + IntToHex(FetchByte,2);
      end;

    SHORT:
      begin	{ the CCSHORT warning applies here, too }
        Result := CaHexB(Hi(pc));
        Result := Result + IntToHex(FetchByte,2);
      end;

    STIM7:
      begin
        y := FetchByte;
        Result := st_tab_i7[x and $03, y shr 7] + ',' + CaHexB(y and $7F);
      end;

    STIM8:
      Result := st_tab_i8[x and $03] + ',' + CaHexB(FetchByte);

    STREG5:
      Result := st_tab_r[x and $07] + ',r' + IntToStr(FetchByte and $7F);

    REG5ST:
      Result := 'r' + IntToStr(FetchByte and $7F) + ',' + st_tab_r[x and $07];

  else
    Result := '';

  end {case};
end {Arguments};


end.
