unit Lcd;

interface

  uses Def;

  const
    LCDWIDTH	= 12;		{ bytes }
    LCDHEIGHT	= 64;		{ lines }
    LCDSIZE     = LCDWIDTH * LCDHEIGHT;


  var
    lcdimage: array[0..LCDSIZE-1] of byte;	{ virtual }


  procedure LcdInit;
  procedure LcdTransfer;


implementation

  var
    line_acc: integer;
    lcd_col: byte;
    lcd_row: byte;
    lcd_timer: byte;


procedure LcdInit;
begin
  line_acc := 0;
  lcd_col := 0;
  lcd_row := 0;
  lcd_timer := 0;
  FillChar (lcdimage, LCDSIZE, 0);
end {LcdInit};


procedure LcdTransfer;
var
  dst: cardinal;
  src, offset: word;
  linecycles: integer;
begin
  if ((s6 and $01) <> 0) and (lcd_col <= s7) then
  begin
    dst := cardinal(lcd_row) * LCDWIDTH + cardinal(lcd_col);
    Inc (lcd_col);
    offset := word(lcd_row) * word(s7+1) + word(lcd_col);
    if (pe and $40) = 0 then src := la - offset else src := la + offset;
    if dst < LCDSIZE then lcdimage[dst] := SrcPtr(DATA_MEM, src)^;
    Inc (cycles,4);
  end {if};
  Inc (line_acc, cycles);
{ assumed is fixed prescaler rate = 16 }
  linecycles := 16 * integer(s5);
  if line_acc >= linecycles then
  begin
    lcd_col := 0;
    Inc (lcd_row);
    if lcd_row > ((s6 and $0E) shl 3) then lcd_row := 0;
    if tm > 0 then
    begin
      Inc (lcd_timer);
      if lcd_timer >= tm then
      begin
        lcd_timer := 0;
        IntReq (3);
      end {if};
    end {if};
    Dec (line_acc, linecycles);
  end {if};
end {LcdTransfer};


end.
