unit Cpu;

interface

  procedure CpuReset;
  procedure IntReq (i: integer);
  function CpuRun : integer;


implementation

  uses Def, Decode, Exec;

  type Proc1 = procedure;


  procedure CpuReset;
  begin
    procptr := nil;
    pc := $0000;
    ko := 0;
    ki := 0;
    asreg := 0;
    flag := 0;
    ie := 0;
    ifreg := 0;
    irqcnt[0] := 0;
    irqcnt[1] := 0;
    irqcnt[2] := 0;
    acycles := 0;
    CpuSleep := False;
  end {CpuReset};


{ interrupt request }
  procedure IntReq (i: integer);
  begin
    if ((ie and INT_enable[i]) <> 0) and (irqcnt[i] = 0) then
	irqcnt[i] := -INT_LATENCY-1;	{ any value less than -INT_LATENCY }
  end {IntReq};


{ execute a single instruction, returns number of clock cycles }
  function CpuRun : integer;
  var
    i: integer;
  begin

    cycles := 0;
    if CpuSleep then Inc (cycles, 6) else
    begin
{ interrupts }
      i := 0;		{ a FOR loop cannot be used here, because the value }
      while i < 3 do	{ of the control variable is used outside the loop }
      begin
{ is there a pending interrupt request of higher priority than currently
  serviced? }
        if (ifreg and INT_serv[i]) <> 0 then
        begin
          i := 3;
        end
        else if irqcnt[i] > 0 then
{ handle an interrupt }
        begin
          ifreg := ifreg or INT_serv[i];
          Call (mr[126-i], mr[62-i]);
          Inc (cycles, 16);
          Break;
        end
        else
{ proceed with the next interrupt }
        begin
          Inc (i);
        end {if};
      end {while};
{ execute an instruction if there wasn't an interrupt to handle }
      if i = 3 then
      begin
        ExecInstr;
{ complete an optional I/O device write }
        if procptr <> nil then
        begin
          Proc1(procptr);
          procptr := nil;
        end {if};
      end {if};
    end {if};

{ update the interrupt request counters }
    for i:=0 to 2 do
    begin
      if irqcnt[i] < -INT_LATENCY then irqcnt[i] := -INT_LATENCY
      else if irqcnt[i] < 0 then Inc (irqcnt[i], cycles);
    end {for};

    CpuRun := cycles;
  end {CpuRun};

end.
