{ NM-320 instruction decoding }

unit Decode;


interface

  procedure ExecInstr;


implementation

  uses Def, Exec;

  type

    Proc2 = procedure (op2: pointer);


{ execute a single instruction }
procedure ExecInstr;
const
  dtab: array[0..511,0..1] of pointer = (
{ bit 7 of the second byte cleared }
    (	@Xreg,		@OpAdb		),	{ code $00, ADB }
    (	@Xreg,		@OpSbb		),	{ code $01, SBB }
    (	@Xreg,		@OpAd		),	{ code $02, AD }
    (	@Xreg,		@OpSb		),	{ code $03, SB }
    (	@Xreg,		@OpAn		),	{ code $04, AN }
    (	@Xreg,		@OpNa		),	{ code $05, NA }
    (	@Xreg,		@OpOr		),	{ code $06, OR }
    (	@Xreg,		@OpXr		),	{ code $07, XR }
    (	@Yreg,		@OpAdb		),	{ code $08, ADB }
    (	@Yreg,		@OpSbb		),	{ code $09, SBB }
    (	@Yreg,		@OpAd		),	{ code $0A, AD }
    (	@Yreg,		@OpSb		),	{ code $0B, SB }
    (	@Yreg,		@OpAn		),	{ code $0C, AN }
    (	@Yreg,		@OpNa		),	{ code $0D, NA }
    (	@Yreg,		@OpOr		),	{ code $0E, OR }
    (	@Yreg,		@OpXr		),	{ code $0F, XR }
    (	@Xary,		@OpAdb		),	{ code $10, ADBM }
    (	@Xary,		@OpSbb		),	{ code $11, SBBM }
    (	@Xary,		@OpAd		),	{ code $12, ADM }
    (	@Xary,		@OpSb		),	{ code $13, SBM }
    (	@Xary,		@OpAn		),	{ code $14, ANM }
    (	@Xary,		@OpNa		),	{ code $15, NAM }
    (	@Xary,		@OpOr		),	{ code $16, ORM }
    (	@Xary,		@OpXr		),	{ code $17, XRM }
    (	@Yary,		@OpAdb		),	{ code $18, ADBM }
    (	@Yary,		@OpSbb		),	{ code $19, SBBM }
    (	@Yary,		@OpAd		),	{ code $1A, ADM }
    (	@Yary,		@OpSb		),	{ code $1B, SBM }
    (	@Yary,		@OpAn		),	{ code $1C, ANM }
    (	@Yary,		@OpNa		),	{ code $1D, NAM }
    (	@Yary,		@OpOr		),	{ code $1E, ORM }
    (	@Yary,		@OpXr		),	{ code $1F, XRM }
    (	@TXreg,		@OpAdb		),	{ code $20, TADB }
    (	@TXreg,		@OpSbb		),	{ code $21, TSBB }
    (	@TXreg,		@OpAd		),	{ code $22, TAD }
    (	@TXreg,		@OpSb		),	{ code $23, TSB }
    (	@TXreg,		@OpAn		),	{ code $24, TAN }
    (	@TXreg,		@OpNa		),	{ code $25, TNA }
    (	@TXreg,		@OpOr		),	{ code $26, TOR }
    (	@TXreg,		@OpXr		),	{ code $27, TXR }
    (	@TYreg,		@OpAdb		),	{ code $28, TADB }
    (	@TYreg,		@OpSbb		),	{ code $29, TSBB }
    (	@TYreg,		@OpAd		),	{ code $2A, TAD }
    (	@TYreg,		@OpSb		),	{ code $2B, TSB }
    (	@TYreg,		@OpAn		),	{ code $2C, TAN }
    (	@TYreg,		@OpNa		),	{ code $2D, TNA }
    (	@TYreg,		@OpOr		),	{ code $2E, TOR }
    (	@TYreg,		@OpXr		),	{ code $2F, TXR }
    (	@TXary,		@OpAdb		),	{ code $30, TADBM }
    (	@TXary,		@OpSbb		),	{ code $31, TSBBM }
    (	@TXary,		@OpAd		),	{ code $32, TADM }
    (	@TXary,		@OpSb		),	{ code $33, TSBM }
    (	@TXary,		@OpAn		),	{ code $34, TANM }
    (	@TXary,		@OpNa		),	{ code $35, TNAM }
    (	@TXary,		@OpOr		),	{ code $36, TORM }
    (	@TXary,		@OpXr		),	{ code $37, TXRM }
    (	@TYary,		@OpAdb		),	{ code $38, TADBM }
    (	@TYary,		@OpSbb		),	{ code $39, TSBBM }
    (	@TYary,		@OpAd		),	{ code $3A, TADM }
    (	@TYary,		@OpSb		),	{ code $3B, TSBM }
    (	@TYary,		@OpAn		),	{ code $3C, TANM }
    (	@TYary,		@OpNa		),	{ code $3D, TNAM }
    (	@TYary,		@OpOr		),	{ code $3E, TORM }
    (	@TYary,		@OpXr		),	{ code $3F, TXRM }
    (	@Ldw,		nil		),	{ code $40, LDW }
    (	@Ldw,		nil		),	{ code $41, LDW }
    (	@Ldw,		nil		),	{ code $42, LDW }
    (	@Ldw,		nil		),	{ code $43, LDW }
    (	@Ldw,		nil		),	{ code $44, LDW }
    (	@Ldw,		nil		),	{ code $45, LDW }
    (	@Ldw,		nil		),	{ code $46, LDW }
    (	@Ldw,		nil		),	{ code $47, LDW }
    (	@AdwSbw,	@PreIncw	),	{ code $48, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $49, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $4A, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $4B, ADW }
    (	@AdwSbw,	@PreDecw	),	{ code $4C, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4D, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4E, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4F, SBW }
    (	@NotCond,	@Ijmp		),	{ code $50, IJMP }
    (	@KeyCond,	@Ijmp		),	{ code $51, IJMP }
    (	@Cond,		@Ijmp		),	{ code $52, IJMP }
    (	@Cond,		@Ijmp		),	{ code $53, IJMP }
    (	@Cond,		@Ijmp		),	{ code $54, IJMP }
    (	@Cond,		@Ijmp		),	{ code $55, IJMP }
    (	@Cond,		@Ijmp		),	{ code $56, IJMP }
    (	@Cond,		@Ijmp		),	{ code $57, IJMP }
    (	@Rtn,		nil		),	{ code $58, RTN }
    (	@NotKeyCond,	@Ijmp		),	{ code $59, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5A, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5B, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5C, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5D, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5E, IJMP }
    (	@NotCond,	@Ijmp		),	{ code $5F, IJMP }
    (	@NotCond,	@Call		),	{ code $60, CAL }
    (	@KeyCond,	@Call		),	{ code $61, CAL }
    (	@Cond,		@Call		),	{ code $62, CAL }
    (	@Cond,		@Call		),	{ code $63, CAL }
    (	@Cond,		@Call		),	{ code $64, CAL }
    (	@Cond,		@Call		),	{ code $65, CAL }
    (	@Cond,		@Call		),	{ code $66, CAL }
    (	@Cond,		@Call		),	{ code $67, CAL }
    (	@Cani,		nil		),	{ code $68, CANI }
    (	@NotKeyCond,	@Call		),	{ code $69, CAL }
    (	@NotCond,	@Call		),	{ code $6A, CAL }
    (	@NotCond,	@Call		),	{ code $6B, CAL }
    (	@NotCond,	@Call		),	{ code $6C, CAL }
    (	@NotCond,	@Call		),	{ code $6D, CAL }
    (	@NotCond,	@Call		),	{ code $6E, CAL }
    (	@NotCond,	@Call		),	{ code $6F, CAL }
    (	@NotCond,	@Jump		),	{ code $70, JMP }
    (	@KeyCond,	@Jump		),	{ code $71, JMP }
    (	@Cond,		@Jump		),	{ code $72, JMP }
    (	@Cond,		@Jump		),	{ code $73, JMP }
    (	@Cond,		@Jump		),	{ code $74, JMP }
    (	@Cond,		@Jump		),	{ code $75, JMP }
    (	@Cond,		@Jump		),	{ code $76, JMP }
    (	@Cond,		@Jump		),	{ code $77, JMP }
    (	@Rti,		nil		),	{ code $78, RTI }
    (	@NotKeyCond,	@Jump		),	{ code $79, JMP }
    (	@NotCond,	@Jump		),	{ code $7A, JMP }
    (	@NotCond,	@Jump		),	{ code $7B, JMP }
    (	@NotCond,	@Jump		),	{ code $7C, JMP }
    (	@NotCond,	@Jump		),	{ code $7D, JMP }
    (	@NotCond,	@Jump		),	{ code $7E, JMP }
    (	@NotCond,	@Jump		),	{ code $7F, JMP }
    (	@StMemoReg,	@PreIncw	),	{ code $80, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $81, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $82, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $83, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $84, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $85, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $86, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $87, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $88, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $89, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $8A, ST }
    (	@StMemoReg,	@PreIncw	),	{ code $8B, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $8C, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $8D, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $8E, ST }
    (	@StMemoReg,	@PreDecw	),	{ code $8F, ST }
    (	@StmMemoAry,	@PreIncw	),	{ code $90, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $91, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $92, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $93, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $94, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $95, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $96, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $97, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $98, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $99, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $9A, STM }
    (	@StmMemoAry,	@PreIncw	),	{ code $9B, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $9C, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $9D, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $9E, STM }
    (	@StmMemoAry,	@PreDecw	),	{ code $9F, STM }
    (	@LdRegMemo,	@PostIncw	),	{ code $A0, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $A1, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $A2, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $A3, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $A4, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $A5, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $A6, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $A7, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $A8, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $A9, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $AA, LD }
    (	@LdRegMemo,	@PostIncw	),	{ code $AB, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $AC, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $AD, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $AE, LD }
    (	@LdRegMemo,	@PostDecw	),	{ code $AF, LD }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B0, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B1, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B2, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B3, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $B4, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $B5, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $B6, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $B7, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B8, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $B9, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $BA, LDM }
    (	@LdmAryMemo,	@PostIncw	),	{ code $BB, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $BC, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $BD, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $BE, LDM }
    (	@LdmAryMemo,	@PostDecw	),	{ code $BF, LDM }
    (	@PstIm8,	@OpKo		),	{ code $C0, PST }
    (	@PstIm8,	@OpIf		),	{ code $C1, PST }
    (	@PstIm8,	@OpAs		),	{ code $C2, PST }
    (	@PstIm8,	@OpIe		),	{ code $C3, PST }
    (	@PstReg,	@OpKo		),	{ code $C4, PST }
    (	@PstReg,	@OpFl		),	{ code $C5, PST }
    (	@PstReg,	@OpAs		),	{ code $C6, PST }
    (	@PstReg,	@OpIe		),	{ code $C7, PST }
    (	@StMemoIm8,	@PreIncw	),	{ code $C8, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $C9, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $CA, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $CB, ST }
    (	@PstReg,	@OpKo		),	{ code $CC, PST }
    (	@PstReg,	@OpFl		),	{ code $CD, PST }
    (	@PstReg,	@OpAs		),	{ code $CE, PST }
    (	@PstReg,	@OpIe		),	{ code $CF, PST }
    (	@StMemoIm8,	@Wreg		),	{ code $D0, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D1, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D2, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D3, ST }
    (	@Gst,		@ko		),	{ code $D4, GST }
    (	@Gst,		@flag		),	{ code $D5, GST }
    (	@Gst,		@asreg		),	{ code $D6, GST }
    (	@Gst,		@ie		),	{ code $D7, GST }
    (	@StMemoIm8,	@PreDecw	),	{ code $D8, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $D9, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $DA, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $DB, ST }
    (	@Gst,		@ko		),	{ code $DC, GST }
    (	@Gst,		@flag		),	{ code $DD, GST }
    (	@Gst,		@asreg		),	{ code $DE, GST }
    (	@Gst,		@ie		),	{ code $DF, GST }
    (	@UnReg,		@OpCmp		),	{ code $E0, CMP }
    (	@UnAry,		@OpCmp		),	{ code $E1, CMPM }
    (	@BlockCopy,	@PreIncw	),	{ code $E2, BUP }
    (   @UnAry,		@OpByu		),	{ code $E3, BYUM }
    (	@UnReg,		@OpCmpb		),	{ code $E4, CMPB }
    (	@UnAry,		@OpDiu		),	{ code $E5, DIUM }
    (	@RotReg,	@OpRou		),	{ code $E6, ROU }
    (	@RotAry,	@OpRou		),	{ code $E7, ROUM }
    (	@UnReg,		@OpCmp		),	{ code $E8, CMP }
    (	@UnAry,		@OpCmp		),	{ code $E9, CMPM }
    (	@Nop,		nil		),	{ code $EA, unsupported }
    (   @UnAry,		@OpByu		),	{ code $EB, BYUM }
    (	@UnReg,		@OpCmpb		),	{ code $EC, CMPB }
    (	@UnAry,		@OpDiu		),	{ code $ED, DIUM }
    (	@RotReg,	@OpRou		),	{ code $EE, ROU }
    (	@RotAry,	@OpRou		),	{ code $EF, ROUM }
    (	@UnReg,		@OpInv		),	{ code $F0, INV }
    (	@UnAry,		@OpInv		),	{ code $F1, INVM }
    (	@BlockCopy,	@PreDecw	),	{ code $F2, BDN }
    (	@UnAry,		@OpByd		),	{ code $F3, BYDM }
    (	@Mtbm,		@OpCmpb		),	{ code $F4, CMPBM }
    (	@UnAry,		@OpDid		),	{ code $F5, DIDM }
    (	@RotReg,	@OpRod		),	{ code $F6, ROD }
    (	@RotAry,	@OpRod		),	{ code $F7, RODM }
    (	@UnReg,		@OpInv		),	{ code $F8, INV }
    (	@UnAry,		@OpInv		),	{ code $F9, INVM }
    (	@Nop,		nil		),	{ code $FA, NOP }
    (	@UnAry,		@OpByd		),	{ code $FB, BYDM }
    (	@Mtbm,		@OpCmpb		),	{ code $FC, CMPBM }
    (	@UnAry,		@OpDid		),	{ code $FD, DIDM }
    (	@RotReg,	@OpRod		),	{ code $FE, ROD }
    (	@RotAry,	@OpRod		),	{ code $FF, RODM }
{ bit 7 of the second byte set }
    (	@RegIm8,	@OpAdb		),	{ code $00, ADB }
    (	@RegIm8,	@OpSbb		),	{ code $01, SBB }
    (	@RegIm8,	@OpAd		),	{ code $02, AD }
    (	@RegIm8,	@OpSb		),	{ code $03, SB }
    (	@RegIm8,	@OpAn		),	{ code $04, AN }
    (	@RegIm8,	@OpNa		),	{ code $05, NA }
    (	@RegIm8,	@OpOr		),	{ code $06, OR }
    (	@RegIm8,	@OpXr		),	{ code $07, XR }
    (	@RegIm8,	@OpAdb		),	{ code $08, ADB }
    (	@RegIm8,	@OpSbb		),	{ code $09, SBB }
    (	@RegIm8,	@OpAd		),	{ code $0A, AD }
    (	@RegIm8,	@OpSb		),	{ code $0B, SB }
    (	@RegIm8,	@OpAn		),	{ code $0C, AN }
    (	@RegIm8,	@OpNa		),	{ code $0D, NA }
    (	@RegIm8,	@OpOr		),	{ code $0E, OR }
    (	@RegIm8,	@OpXr		),	{ code $0F, XR }
    (	@AryIm6,	@OpAdb		),	{ code $10, ADBM }
    (	@AryIm6,	@OpSbb		),	{ code $11, SBBM }
    (	@AryIm6,	@OpAd		),	{ code $12, ADM }
    (	@AryIm6,	@OpSb		),	{ code $13, SBM }
    (	@ExchReg,	@OpSwp2		),	{ code $14, SWP }
    (	@ExchAry,	@OpSwp2		),	{ code $15, SWPM }
    (	@ExchReg,	@OpXcls		),	{ code $16, XCLS }
    (	@ExchAry,	@OpXcls		),	{ code $17, XCLSM }
    (	@AryIm6,	@OpAdb		),	{ code $18, ADBM }
    (	@AryIm6,	@OpSbb		),	{ code $19, SBBM }
    (	@AryIm6,	@OpAd		),	{ code $1A, ADM }
    (	@AryIm6,	@OpSb		),	{ code $1B, SBM }
    (	@ExchReg,	@OpXc		),	{ code $1C, XC }
    (	@ExchAry,	@OpXc		),	{ code $1D, XCM }
    (	@ExchReg,	@OpXchs		),	{ code $1E, XCHS }
    (	@ExchAry,	@OpXchs		),	{ code $1F, XCHSM }
    (	@TRegIm8,	@OpAdb		),	{ code $20, TADB }
    (	@TRegIm8,	@OpSbb		),	{ code $21, TSBB }
    (	@TRegIm8,	@OpAd		),	{ code $22, TAD }
    (	@TRegIm8,	@OpSb		),	{ code $23, TSB }
    (	@TRegIm8,	@OpAn		),	{ code $24, TAN }
    (	@TRegIm8,	@OpNa		),	{ code $25, TNA }
    (	@TRegIm8,	@OpOr		),	{ code $26, TOR }
    (	@TRegIm8,	@OpXr		),	{ code $27, TXR }
    (	@TRegIm8,	@OpAdb		),	{ code $28, TADB }
    (	@TRegIm8,	@OpSbb		),	{ code $29, TSBB }
    (	@TRegIm8,	@OpAd		),	{ code $2A, TAD }
    (	@TRegIm8,	@OpSb		),	{ code $2B, TSB }
    (	@TRegIm8,	@OpAn		),	{ code $2C, TAN }
    (	@TRegIm8,	@OpNa		),	{ code $2D, TNA }
    (	@TRegIm8,	@OpOr		),	{ code $2E, TOR }
    (	@TRegIm8,	@OpXr		),	{ code $2F, TXR }
    (	@TAryIm6,	@OpAdb		),	{ code $30, TADBM }
    (	@TAryIm6,	@OpSbb		),	{ code $31, TSBBM }
    (	@TAryIm6,	@OpAd		),	{ code $32, TADM }
    (	@TAryIm6,	@OpSb		),	{ code $33, TSBM }
    (	@BlockSearch,	@PreIncw	),	{ code $34, SUP }
    (	@BlockSearch,	@PreIncw	),	{ code $35, search +(IY) }
    (	@BlockSearch,	@PreIncw	),	{ code $36, search +(IZ) }
    (	@BlockSearch,	@PreIncw	),	{ code $37, search +(SP) }
    (	@TAryIm6,	@OpAdb		),	{ code $38, TADBM }
    (	@TAryIm6,	@OpSbb		),	{ code $39, TSBBM }
    (	@TAryIm6,	@OpAd		),	{ code $3A, TADM }
    (	@TAryIm6,	@OpSb		),	{ code $3B, TSBM }
    (	@BlockSearch,	@PreDecw	),	{ code $3C, SDN }
    (	@BlockSearch,	@PreDecw	),	{ code $3D, search -(IY) }
    (	@BlockSearch,	@PreDecw	),	{ code $3E, search -(IZ) }
    (	@BlockSearch,	@PreDecw	),	{ code $3F, search -(SP) }
    (	@Ldw,		nil		),	{ code $40, LDW }
    (	@Ldw,		nil		),	{ code $41, LDW }
    (	@Ldw,		nil		),	{ code $42, LDW }
    (	@Ldw,		nil		),	{ code $43, LDW }
    (	@Ldw,		nil		),	{ code $44, LDW }
    (	@Ldw,		nil		),	{ code $45, LDW }
    (	@Ldw,		nil		),	{ code $46, LDW }
    (	@Ldw,		nil		),	{ code $47, LDW }
    (	@AdwSbw,	@PreIncw	),	{ code $48, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $49, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $4A, ADW }
    (	@AdwSbw,	@PreIncw	),	{ code $4B, ADW }
    (	@AdwSbw,	@PreDecw	),	{ code $4C, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4D, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4E, SBW }
    (	@AdwSbw,	@PreDecw	),	{ code $4F, SBW }
    (	@Off,		nil		),	{ code $50, OFF }
    (	@Gst,		@ki		),	{ code $51, GST }
    (	@TRegIm8,	@OpBit		),	{ code $52, BIT }
    (	@TXreg,		@OpBit		),	{ code $53, BIT }
    (	@Xreg,		@OpLd		),	{ code $54, LD }
    (	@Xary,		@OpLd		),	{ code $55, LDM }
    (	@RegIm8,	@OpLd		),	{ code $56, LD }
    (	@AryIm6,	@OpLd		),	{ code $57, LDM }
    (	@Rtn,		nil		),	{ code $58, RTN }
    (	@Gst,		@ki		),	{ code $59, GST }
    (	@TRegIm8,	@OpBit		),	{ code $5A, BIT }
    (	@TYreg,		@OpBit		),	{ code $5B, BIT }
    (	@Yreg,		@OpLd		),	{ code $5C, LD }
    (	@Yary,		@OpLd		),	{ code $5D, LDM }
    (	@RegIm8,	@OpLd		),	{ code $5E, LD }
    (	@AryIm6,	@OpLd		),	{ code $5F, LDM }
    (	@NotCond,	@Call		),	{ code $60, CAL }
    (	@KeyCond,	@Call		),	{ code $61, CAL }
    (	@Cond,		@Call		),	{ code $62, CAL }
    (	@Cond,		@Call		),	{ code $63, CAL }
    (	@Cond,		@Call		),	{ code $64, CAL }
    (	@Cond,		@Call		),	{ code $65, CAL }
    (	@Cond,		@Call		),	{ code $66, CAL }
    (	@Cond,		@Call		),	{ code $67, CAL }
    (	@Cani,		nil		),	{ code $68, CANI }
    (	@NotKeyCond,	@Call		),	{ code $69, CAL }
    (	@NotCond,	@Call		),	{ code $6A, CAL }
    (	@NotCond,	@Call		),	{ code $6B, CAL }
    (	@NotCond,	@Call		),	{ code $6C, CAL }
    (	@NotCond,	@Call		),	{ code $6D, CAL }
    (	@NotCond,	@Call		),	{ code $6E, CAL }
    (	@NotCond,	@Call		),	{ code $6F, CAL }
    (	@NotCond,	@Jump		),	{ code $70, JMP }
    (	@KeyCond,	@Jump		),	{ code $71, JMP }
    (	@Cond,		@Jump		),	{ code $72, JMP }
    (	@Cond,		@Jump		),	{ code $73, JMP }
    (	@Cond,		@Jump		),	{ code $74, JMP }
    (	@Cond,		@Jump		),	{ code $75, JMP }
    (	@Cond,		@Jump		),	{ code $76, JMP }
    (	@Cond,		@Jump		),	{ code $77, JMP }
    (	@Rti,		nil		),	{ code $78, RTI }
    (	@NotKeyCond,	@Jump		),	{ code $79, JMP }
    (	@NotCond,	@Jump		),	{ code $7A, JMP }
    (	@NotCond,	@Jump		),	{ code $7B, JMP }
    (	@NotCond,	@Jump		),	{ code $7C, JMP }
    (	@NotCond,	@Jump		),	{ code $7D, JMP }
    (	@NotCond,	@Jump		),	{ code $7E, JMP }
    (	@NotCond,	@Jump		),	{ code $7F, JMP }
    (	@StRegOffsReg,	@PlusOffset	),	{ code $80, ST }
    (	@StRegOffsReg,	@PlusOffset	),	{ code $81, ST }
    (	@StRegOffsReg,	@PlusOffset	),	{ code $82, ST }
    (	@StRegOffsReg,	@PlusOffset	),	{ code $83, ST }
    (	@StRegOffsReg,	@MinusOffset	),	{ code $84, ST }
    (	@StRegOffsReg,	@MinusOffset	),	{ code $85, ST }
    (	@StRegOffsReg,	@MinusOffset	),	{ code $86, ST }
    (	@StRegOffsReg,	@MinusOffset	),	{ code $87, ST }
    (	@StImOffsReg,	@PlusOffset	),	{ code $88, ST }
    (	@StImOffsReg,	@PlusOffset	),	{ code $89, ST }
    (	@StImOffsReg,	@PlusOffset	),	{ code $8A, ST }
    (	@StImOffsReg,	@PlusOffset	),	{ code $8B, ST }
    (	@StImOffsReg,	@MinusOffset	),	{ code $8C, ST }
    (	@StImOffsReg,	@MinusOffset	),	{ code $8D, ST }
    (	@StImOffsReg,	@MinusOffset	),	{ code $8E, ST }
    (	@StImOffsReg,	@MinusOffset	),	{ code $8F, ST }
    (	@StmRegOffsAry,	@PlusOffset	),	{ code $90, STM }
    (	@StmRegOffsAry,	@PlusOffset	),	{ code $91, STM }
    (	@StmRegOffsAry,	@PlusOffset	),	{ code $92, STM }
    (	@StmRegOffsAry,	@PlusOffset	),	{ code $93, STM }
    (	@StmRegOffsAry,	@MinusOffset	),	{ code $94, STM }
    (	@StmRegOffsAry,	@MinusOffset	),	{ code $95, STM }
    (	@StmRegOffsAry,	@MinusOffset	),	{ code $96, STM }
    (	@StmRegOffsAry,	@MinusOffset	),	{ code $97, STM }
    (	@StmImOffsAry,	@PlusOffset	),	{ code $98, STM }
    (	@StmImOffsAry,	@PlusOffset	),	{ code $99, STM }
    (	@StmImOffsAry,	@PlusOffset	),	{ code $9A, STM }
    (	@StmImOffsAry,	@PlusOffset	),	{ code $9B, STM }
    (	@StmImOffsAry,	@MinusOffset	),	{ code $9C, STM }
    (	@StmImOffsAry,	@MinusOffset	),	{ code $9D, STM }
    (	@StmImOffsAry,	@MinusOffset	),	{ code $9E, STM }
    (	@StmImOffsAry,	@MinusOffset	),	{ code $9F, STM }
    (	@LdRegRegOffs,	@PlusOffset	),	{ code $A0, LD }
    (	@LdRegRegOffs,	@PlusOffset	),	{ code $A1, LD }
    (	@LdRegRegOffs,	@PlusOffset	),	{ code $A2, LD }
    (	@LdRegRegOffs,	@PlusOffset	),	{ code $A3, LD }
    (	@LdRegRegOffs,	@MinusOffset	),	{ code $A4, LD }
    (	@LdRegRegOffs,	@MinusOffset	),	{ code $A5, LD }
    (	@LdRegRegOffs,	@MinusOffset	),	{ code $A6, LD }
    (	@LdRegRegOffs,	@MinusOffset	),	{ code $A7, LD }
    (	@LdRegImOffs,	@PlusOffset	),	{ code $A8, LD }
    (	@LdRegImOffs,	@PlusOffset	),	{ code $A9, LD }
    (	@LdRegImOffs,	@PlusOffset	),	{ code $AA, LD }
    (	@LdRegImOffs,	@PlusOffset	),	{ code $AB, LD }
    (	@LdRegImOffs,	@MinusOffset	),	{ code $AC, LD }
    (	@LdRegImOffs,	@MinusOffset	),	{ code $AD, LD }
    (	@LdRegImOffs,	@MinusOffset	),	{ code $AE, LD }
    (	@LdRegImOffs,	@MinusOffset	),	{ code $AF, LD }
    (	@LdmAryRegOffs,	@PlusOffset	),	{ code $B0, LDM }
    (	@LdmAryRegOffs,	@PlusOffset	),	{ code $B1, LDM }
    (	@LdmAryRegOffs,	@PlusOffset	),	{ code $B2, LDM }
    (	@LdmAryRegOffs,	@PlusOffset	),	{ code $B3, LDM }
    (	@LdmAryRegOffs,	@MinusOffset	),	{ code $B4, LDM }
    (	@LdmAryRegOffs,	@MinusOffset	),	{ code $B5, LDM }
    (	@LdmAryRegOffs,	@MinusOffset	),	{ code $B6, LDM }
    (	@LdmAryRegOffs,	@MinusOffset	),	{ code $B7, LDM }
    (	@LdmAryImOffs,	@PlusOffset	),	{ code $B8, LDM }
    (	@LdmAryImOffs,	@PlusOffset	),	{ code $B9, LDM }
    (	@LdmAryImOffs,	@PlusOffset	),	{ code $BA, LDM }
    (	@LdmAryImOffs,	@PlusOffset	),	{ code $BB, LDM }
    (	@LdmAryImOffs,	@MinusOffset	),	{ code $BC, LDM }
    (	@LdmAryImOffs,	@MinusOffset	),	{ code $BD, LDM }
    (	@LdmAryImOffs,	@MinusOffset	),	{ code $BE, LDM }
    (	@LdmAryImOffs,	@MinusOffset	),	{ code $BF, LDM }
    (	@PstIm8,	@OpKo		),	{ code $C0, PST }
    (	@PstIm8,	@OpIf		),	{ code $C1, PST }
    (	@PstIm8,	@OpAs		),	{ code $C2, PST }
    (	@PstIm8,	@OpIe		),	{ code $C3, PST }
    (	@Ldle,		nil		),	{ code $C4, LDLE }
    (	@Ldlo,		nil		),	{ code $C5, LDLO }
    (	@Stle,		nil		),	{ code $C6, STLE }
    (	@Stlo,		nil		),	{ code $C7, STLO }
    (	@StMemoIm8,	@PreIncw	),	{ code $C8, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $C9, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $CA, ST }
    (	@StMemoIm8,	@PreIncw	),	{ code $CB, ST }
    (	@Ldle,		nil		),	{ code $CC, LDLE }
    (	@Ldlo,		nil		),	{ code $CD, LDLO }
    (	@Stle,		nil		),	{ code $CE, STLE }
    (	@Stlo,		nil		),	{ code $CF, STLO }
    (	@StMemoIm8,	@Wreg		),	{ code $D0, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D1, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D2, ST }
    (	@StMemoIm8,	@Wreg		),	{ code $D3, ST }
    (	@Ldlem,		nil		),	{ code $D4, LDLEM }
    (	@Ldlom,		nil		),	{ code $D5, LDLOM }
    (	@Stlem,		nil		),	{ code $D6, STLEM }
    (	@Stlom,		nil		),	{ code $D7, STLOM }
    (	@StMemoIm8,	@PreDecw	),	{ code $D8, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $D9, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $DA, ST }
    (	@StMemoIm8,	@PreDecw	),	{ code $DB, ST }
    (	@Ldlem,		nil		),	{ code $DC, LDLEM }
    (	@Ldlom,		nil		),	{ code $DD, LDLOM }
    (	@Stlem,		nil		),	{ code $DE, STLEM }
    (	@Stlom,		nil		),	{ code $DF, STLOM }
    (	@UnReg,		@OpSwp1		),	{ code $E0, SWP }
    (	@Nop,		nil		),	{ code $E1, unsupported }
    (	@BlockCopy,	@PreIncw	),	{ code $E2, BUP }
    (	@UnReg,		@OpByu		),	{ code $E3, BYU }
    (	@UnReg,		@OpRou		),	{ code $E4, BIU }
    (	@UnReg,		@OpDiu		),	{ code $E5, DIU }
    (	@UnReg,		@OpMtb		),	{ code $E6, MTB }
    (	@Trap,		nil		),	{ code $E7, TRP }
    (	@UnReg,		@OpSwp1		),	{ code $E8, SWP }
    (	@Nop,		nil		),	{ code $E9, unsupported }
    (	@Nop,		nil		),	{ code $EA, unsupported }
    (	@UnReg,		@OpByu		),	{ code $EB, BYU }
    (	@UnReg,		@OpRou		),	{ code $EC, BIU }
    (	@UnReg,		@OpDiu		),	{ code $ED, DIU }
    (	@UnReg,		@OpMtb		),	{ code $EE, MTB }
    (	@Trap,		nil		),	{ code $EF, TRP }
    (	@UnAry,		@OpBnus		),	{ code $F0, BNUSM }
    (	@Gst,		@ifreg		),	{ code $F1, GST }
    (	@BlockCopy,	@PreDecw	),	{ code $F2, BDN }
    (   @UnReg,		@OpByd		),	{ code $F3, BYD }
    (	@UnAry,		@OpRou		),	{ code $F4, BIUM }
    (	@UnReg,		@OpDid		),	{ code $F5, DID }
    (	@Mtbm,		@OpMtb		),	{ code $F6, MTBM }
    (	@Trap,		nil		),	{ code $F7, TRP }
    (	@UnAry,		@OpBnus		),	{ code $F8, BNUSM }
    (	@Gst,		@ifreg		),	{ code $F9, GST }
    (	@Nop,		nil		),	{ code $FA, NOP }
    (   @UnReg,		@OpByd		),	{ code $FB, BYD }
    (	@UnAry,		@OpRou		),	{ code $FC, BIUM }
    (	@UnReg,		@OpDid		),	{ code $FD, DID }
    (	@Mtbm,		@OpMtb		),	{ code $FE, MTBM }
    (	@Trap,		nil		)	{ code $FF, TRP }
  );
var
  kod: word;		{ 9-bit instruction opcode }
begin
  kod := FetchOpcode;
  regbank := (not opcode[0] shl 3) and $40;	{ default value }
  regstep := 1;					{ default value }
  Proc2 (dtab[kod,0]) (dtab[kod,1]);
end {ExecInstr};


end.
