unit Keyboard;

interface

  var KeyCode: array[1..3] of integer;
  var TestCounter: integer;

  procedure KeyHandle;


implementation

uses Def;

type

  keycoords = record
    m1: byte;		{ value for the KO register selecting the key }
    m2: byte;		{ returned KI state when the key was pressed }
  end;

const

KeyTab: array[1..53] of keycoords = (
    (	m1: $42;	m2: $01	),	{ 1: SHIFT	KO2, KI0 }
    (	m1: $42;	m2: $02	),	{ 2: ALPHA	KO2, KI1 }
    (	m1: $50;	m2: $04	),	{ 3: Prog	KO5, KI2 }
    (	m1: $44;	m2: $08	),	{ 4: left	KO3, KI3 }
    (	m1: $44;	m2: $10	),	{ 5: right	KO3, KI4 }
    (	m1: $42;	m2: $04	),	{ 6: MODE	KO2, KI2 }
    (	m1: $44;	m2: $01	),	{ 7: M Disp	KO3, KI0 }
    (	m1: $44;	m2: $02	),	{ 8: Graph	KO3, KI1 }
    (	m1: $44;	m2: $04	),	{ 9: Range	KO3, KI2 }
    (	m1: $44;	m2: $20	),	{ 10: up	KO3, KI5 }
    (	m1: $44;	m2: $40	),	{ 11: down	KO3, KI6 }
    (	m1: $44;	m2: $80	),	{ 12: G<->T	KO3, KI7 }
    (	m1: $50;	m2: $01	),	{ 13: colon	KO5, KI0 }
    (	m1: $50;	m2: $02	),	{ 14: Eng	KO5, KI1 }
    (	m1: $50;	m2: $08	),	{ 15: sqrt	KO5, KI3 }
    (	m1: $50;	m2: $10	),	{ 16: x^2	KO5, KI4 }
    (	m1: $50;	m2: $20	),	{ 17: log	KO5, KI5 }
    (	m1: $50;	m2: $40	),	{ 18: ln	KO5, KI6 }
    (	m1: $60;	m2: $02	),	{ 19: 1/x	KO6, KI1 }
    (	m1: $60;	m2: $04	),	{ 20: deg,min,sec KO6, KI2 }
    (	m1: $60;	m2: $08	),	{ 21: hyp	KO6, KI3 }
    (	m1: $60;	m2: $10	),	{ 22: sin	KO6, KI4 }
    (	m1: $60;	m2: $20	),	{ 23: cos	KO6, KI5 }
    (	m1: $50;	m2: $80	),	{ 24: tan	KO5, KI7 }
    (	m1: $60;	m2: $01	),	{ 25: (-)	KO6, KI0 }
    (	m1: $84;	m2: $08	),	{ 26: -->	KO9, KI3 }
    (	m1: $84;	m2: $10	),	{ 27: (		KO9, KI4 }
    (	m1: $84;	m2: $20	),	{ 28: )		KO9, KI5 }
    (	m1: $60;	m2: $40	),	{ 29: x^y	KO6, KI6 }
    (	m1: $60;	m2: $80	),	{ 30: x^-y	KO6, KI7 }
    (	m1: $81;	m2: $01	),	{ 31: 7		KO7, KI0 }
    (	m1: $81;	m2: $02	),	{ 32: 8		KO7, KI1 }
    (	m1: $81;	m2: $04	),	{ 33: 9		KO7, KI2 }
    (	m1: $84;	m2: $40	),	{ 34: DEL	KO9, KI6 }
    (	m1: $41;	m2: $01	),	{ 35: AC	KO1, KI0 }
    (	m1: $81;	m2: $08	),	{ 36: 4		KO7, KI3 }
    (	m1: $81;	m2: $10	),	{ 37: 5		KO7, KI4 }
    (	m1: $81;	m2: $20	),	{ 38: 6		KO7, KI5 }
    (	m1: $81;	m2: $40	),	{ 39: multiply	KO7, KI6 }
    (	m1: $81;	m2: $80	),	{ 40: divide	KO7, KI7 }
    (	m1: $82;	m2: $01	),	{ 41: 1		KO8, KI0 }
    (	m1: $82;	m2: $02	),	{ 42: 2		KO8, KI1 }
    (	m1: $82;	m2: $04	),	{ 43: 3		KO8, KI2 }
    (	m1: $82;	m2: $40	),	{ 44: +		KO8, KI6 }
    (	m1: $82;	m2: $80	),	{ 45: -		KO8, KI7 }
    (	m1: $82;	m2: $08	),	{ 46: 0		KO8, KI3 }
    (	m1: $82;	m2: $10	),	{ 47: dec. point KO8, KI4 }
    (	m1: $82;	m2: $20	),	{ 48: EXP	KO8, KI5 }
    (	m1: $84;	m2: $80	),	{ 49: Ans	KO9, KI7 }
    (	m1: $42;	m2: $08	),	{ 50: EXE	KO2, KI3 }
    (	m1: $42;	m2: $40	),	{ 51: OFF	KO2, KI6 }
    (	m1: $42;	m2: $80	),	{ 52: init	KO2, KI7 }
    (	m1: $A0;	m2: $80	)	{ 53: HD	KO12, KI7 }
);


{ the procedure is supposed to be called after any change of the keyboard
  state (i.e. when a key has been pressed/released and when the self-test
  jumper state has changed) and after any KO change }
procedure KeyHandle;
var
  i, x: integer;
begin
  if ko < $40 then Exit;
  if TestCounter <> 0 then ki := $10 else ki := $00;
  for i := 1 to 2 do
  begin
    x := KeyCode[i];
    if (x >= 1) and (x <= 53) then
    begin
      with KeyTab[x] do
      begin
        if (m1 and ko) = m1 then ki := ki or m2;
      end {with};
    end {if};
  end {for};
  if (ki and $01) <> 0 then CpuSleep := False;
end {KeyHandle};


end.
