unit Main;

interface

uses
  SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, IniFiles, LCLType;

type
  TMainForm = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    Button1: TSpeedButton;
    Button2: TSpeedButton;
    Button3: TSpeedButton;
    Button4: TSpeedButton;
    Button5: TSpeedButton;
    Button6: TSpeedButton;
    Button7: TSpeedButton;
    Button8: TSpeedButton;
    Button9: TSpeedButton;
    Button10: TSpeedButton;
    Button11: TSpeedButton;
    Button12: TSpeedButton;
    Button13: TSpeedButton;
    Button14: TSpeedButton;
    Button15: TSpeedButton;
    Button16: TSpeedButton;
    Button17: TSpeedButton;
    Button18: TSpeedButton;
    Button19: TSpeedButton;
    Button20: TSpeedButton;
    Button21: TSpeedButton;
    Button22: TSpeedButton;
    Button23: TSpeedButton;
    Button24: TSpeedButton;
    Button25: TSpeedButton;
    Button26: TSpeedButton;
    Button27: TSpeedButton;
    Button28: TSpeedButton;
    Button29: TSpeedButton;
    Button30: TSpeedButton;
    Button31: TSpeedButton;
    Button32: TSpeedButton;
    Button33: TSpeedButton;
    Button34: TSpeedButton;
    Button35: TSpeedButton;
    Button36: TSpeedButton;
    Button37: TSpeedButton;
    Button38: TSpeedButton;
    Button39: TSpeedButton;
    Button40: TSpeedButton;
    Button41: TSpeedButton;
    Button42: TSpeedButton;
    Button43: TSpeedButton;
    Button44: TSpeedButton;
    Button45: TSpeedButton;
    Button46: TSpeedButton;
    Button47: TSpeedButton;
    Button48: TSpeedButton;
    Button49: TSpeedButton;
    Button50: TSpeedButton;
    PrintBevel: TBevel;
    PowerBevel: TBevel;
    PrintSwitch: TShape;
    PowerSwitch: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RefreshTimer: TTimer;
    RunTimer: TTimer;
    LcdImage: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OnRefreshTimer(Sender: TObject);
    procedure OnRunTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SwitchMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses
    Def, Cpu, Debug, Keyboard, Lcd;

const
    KeysName: string = 'keys.bmp';
    ChrName: string = 'charset.bin';
    IniName: string = 'fx8000g.ini';
    Rom0Name: string = 'rom0.bin';
    Rom1Name: string = 'rom1.bin';
    RamName: string = 'ram.bin';
    RegName: string = 'register.bin';
    LoadMsg: string = 'Failed to load the file ';
    SaveMsg: string = 'Failed to save the file ';

var
    LcdBmp: TBitMap;
    RedrawReq: boolean;		{ true if the LcdBmp image has changed and
				  needs to be redrawn }


{ LCD }
    BkColor: TColor = clWhite;
    ScrMem: array[0..LCDSIZE-1] of nibble; { shadow LCD data memory }
    ScrCtrl: byte;			{ shadow LCD control register }

{ CPU }
    CpuSpeed: integer;		{ how many instructions executes the emulated
				  CPU at each RunTimer event call }
    OnCounter: integer;


procedure ButtonGlyphs;
var
  KeyBmp, TempBmp: TBitMap;
begin
  if not FileExists (KeysName) then
  begin
    MessageDlg (LoadMsg + KeysName, mtWarning, [mbOk], 0);
    Exit;
  end {if};
  KeyBmp := TBitMap.Create;
  KeyBmp.Transparent := False;
  KeyBmp.Width := 210;
  KeyBmp.Height := 99;
  KeyBmp.LoadFromFile (KeysName);
  TempBmp := TBitMap.Create;
{ Lazarus under Windows recognizes the lower-left pixel of a bitmap as the
  transparency color, but the glyph area on a TSpeedButton object that should
  be transparent is white. Explicitly assigning the TransparentColor seems to
  help. }
  TempBmp.TransparentColor := clWhite;
  TempBmp.Transparent := False;
  TempBmp.Width := 35;
  TempBmp.Height := 11;
  with TempBmp.Canvas, MainForm do
  begin
    Draw (0, 0, KeyBmp);
    Button1.Glyph := TempBmp;
    Draw (-35, 0, KeyBmp);
    Button2.Glyph := TempBmp;
    Draw (-70, 0, KeyBmp);
    Button3.Glyph := TempBmp;
    Draw (-105, 0, KeyBmp);
    Button4.Glyph := TempBmp;
    Draw (-140, 0, KeyBmp);
    Button5.Glyph := TempBmp;
    Draw (-175, 0, KeyBmp);
    Button6.Glyph := TempBmp;

    Draw (0, -11, KeyBmp);
    Button7.Glyph := TempBmp;
    Draw (-35, -11, KeyBmp);
    Button8.Glyph := TempBmp;
    Draw (-70, -11, KeyBmp);
    Button9.Glyph := TempBmp;
    Draw (-105, -11, KeyBmp);
    Button10.Glyph := TempBmp;
    Draw (-140, -11, KeyBmp);
    Button11.Glyph := TempBmp;
    Draw (-175, -11, KeyBmp);
    Button12.Glyph := TempBmp;

    Draw (0, -22, KeyBmp);
    Button13.Glyph := TempBmp;
    Draw (-35, -22, KeyBmp);
    Button14.Glyph := TempBmp;
    Draw (-70, -22, KeyBmp);
    Button15.Glyph := TempBmp;
    Draw (-105, -22, KeyBmp);
    Button16.Glyph := TempBmp;
    Draw (-140, -22, KeyBmp);
    Button17.Glyph := TempBmp;
    Draw (-175, -22, KeyBmp);
    Button18.Glyph := TempBmp;

    Draw (0, -33, KeyBmp);
    Button19.Glyph := TempBmp;
    Draw (-35, -33, KeyBmp);
    Button20.Glyph := TempBmp;
    Draw (-70, -33, KeyBmp);
    Button21.Glyph := TempBmp;
    Draw (-105, -33, KeyBmp);
    Button22.Glyph := TempBmp;
    Draw (-140, -33, KeyBmp);
    Button23.Glyph := TempBmp;
    Draw (-175, -33, KeyBmp);
    Button24.Glyph := TempBmp;

    Draw (0, -44, KeyBmp);
    Button25.Glyph := TempBmp;
    Draw (-35, -44, KeyBmp);
    Button26.Glyph := TempBmp;
    Draw (-70, -44, KeyBmp);
    Button27.Glyph := TempBmp;
    Draw (-105, -44, KeyBmp);
    Button28.Glyph := TempBmp;
    Draw (-140, -44, KeyBmp);
    Button29.Glyph := TempBmp;
    Draw (-175, -44, KeyBmp);
    Button30.Glyph := TempBmp;

    Draw (0, -55, KeyBmp);
    Button31.Glyph := TempBmp;
    Draw (-35, -55, KeyBmp);
    Button32.Glyph := TempBmp;
    Draw (-70, -55, KeyBmp);
    Button33.Glyph := TempBmp;
    Draw (-105, -55, KeyBmp);
    Button34.Glyph := TempBmp;
    Draw (-140, -55, KeyBmp);
    Button35.Glyph := TempBmp;

    Draw (0, -66, KeyBmp);
    Button36.Glyph := TempBmp;
    Draw (-35, -66, KeyBmp);
    Button37.Glyph := TempBmp;
    Draw (-70, -66, KeyBmp);
    Button38.Glyph := TempBmp;
    Draw (-105, -66, KeyBmp);
    Button39.Glyph := TempBmp;
    Draw (-140, -66, KeyBmp);
    Button40.Glyph := TempBmp;

    Draw (0, -77, KeyBmp);
    Button41.Glyph := TempBmp;
    Draw (-35, -77, KeyBmp);
    Button42.Glyph := TempBmp;
    Draw (-70, -77, KeyBmp);
    Button43.Glyph := TempBmp;
    Draw (-105, -77, KeyBmp);
    Button44.Glyph := TempBmp;
    Draw (-140, -77, KeyBmp);
    Button45.Glyph := TempBmp;

    Draw (0, -88, KeyBmp);
    Button46.Glyph := TempBmp;
    Draw (-35, -88, KeyBmp);
    Button47.Glyph := TempBmp;
    Draw (-70, -88, KeyBmp);
    Button48.Glyph := TempBmp;
    Draw (-105, -88, KeyBmp);
    Button49.Glyph := TempBmp;
    Draw (-140, -88, KeyBmp);
    Button50.Glyph := TempBmp;
  end {with};
  TempBmp.Free;
  KeyBmp.Free;
end {ButtonGlyphs};


procedure ResetAll;
begin
  lcdctrl := 0;
  LcdInit;
  OnCounter := 0;
  TestCounter := SelfTest;
  CpuReset;
  DoPorts;
end {ResetAll};


{ draw the LCD contents }
procedure View;
var
  Row, Col, Hc, Pixel, Index, X, Y: Integer;
  Data: nibble;
begin
  with LcdBmp.Canvas do
  begin
    Brush.Style := bsSolid;

{ handle the LCD control register }
    if ScrCtrl <> lcdctrl then
    begin
      RedrawReq := True;
      ScrCtrl := lcdctrl;
      if (ScrCtrl and VDD2_bit) <> 0 then
      begin	{turn the display on}
{ it is assummed that the lcdimage is cleared when the LCD is turned off }
        FillChar (ScrMem, LCDSIZE, 0);
        Brush.Color := BkColor;
      end
      else
      begin	{turn the display off}
        Brush.Color := clLtGray;
      end {if};
      FillRect (Rect(0, 0, 192, 128));
    end {if};

{ draw the pixels }
    if (ScrCtrl and VDD2_bit) = 0 then Exit;	{display turned off}
    Index := 0;
    X := 0;
    Y := 0;
    for Row := 0 to 7 do
    begin
      for Col := 0 to 95 do
      begin
        for Hc := 0 to 1 do
        begin
          Data := lcdimage[Index];
          if ScrMem[Index] <> Data then
          begin
            RedrawReq := True;
            ScrMem[Index] := Data;
            for Pixel := 0 to 3 do
            begin
              if (Data and $8) <> 0 then Brush.Color := clBlack
                                    else Brush.Color := BkColor;
              Data := Data shl 1;
              FillRect (Rect(X, Y, X+2, Y+2));
              Inc (Y, 2);
            end {for Pixel};
          end
          else
          begin
            Inc (Y, 8);
          end {if};
          Inc (Index);
        end {for Hc};
        Dec (Y, 16);
        Inc (X, 2);
      end {for Col};
      Dec (X, 192);
      Inc (Y, 16)
    end {for Row};
  end {with};
end; {proc View}


procedure TMainForm.OnRefreshTimer(Sender: TObject);
begin
  LcdRender;
  View;
  if RedrawReq = True then LcdImage.Picture.Bitmap := LcdBmp;
  RedrawReq := False;
  if TestCounter > 0 then
  begin
    Dec (TestCounter);
    KeyHandle;
  end {if};
end;


{ load the memory images }
procedure MemLoad;
var
  f: file;
  transferred, i, size: integer;
begin
{ load the LCD character ROM image }
  if FileExists (ChrName) then
  begin
    AssignFile (f, ChrName);
    Reset (f, 1);
    BlockRead (f, lcdchr, CHRSIZE div 2, transferred);
    CloseFile (f);
  end
  else MessageDlg (LoadMsg + ChrName, mtWarning, [mbOk], 0);
{ convert the LCD character ROM image to 4-bit }
  for size := 127 downto 0 do
  begin
    for i := 15 downto 0 do
    begin
      lcdchr[2*size + i div 8, 2*(i mod 8)] := lcdchr[size,i] shr 4;
      lcdchr[2*size + i div 8, 2*(i mod 8) + 1] := lcdchr[size,i] and $F;
    end {for};
  end {for};
{ load the ROM0 image }
  if FileExists (Rom0Name) then
  begin
    AssignFile (f, Rom0Name);
    Reset (f, 3);
    BlockRead (f, rom0, ROM0SIZE, transferred);
    CloseFile (f);
  end
  else MessageDlg (LoadMsg + Rom0Name, mtWarning, [mbOk], 0);
{ load the ROM1 image (optional, hence no warning message if absent) }
  if FileExists (Rom1Name) then
  begin
    AssignFile (f, Rom1Name);
    Reset (f, 1);
    BlockRead (f, rom1, ROM1SIZE, transferred);
    CloseFile (f);
  end
  else FillChar (rom1, ROM1SIZE, $FF);
{ load the RAM image }
  if FileExists (RamName) then
  begin
    AssignFile (f, RamName);
    Reset (f, 1);
    BlockRead (f, ram, RAMSIZE, transferred);
    CloseFile (f);
  end {if};
{ load the register file image }
  if FileExists (RegName) then
  begin
    AssignFile (f, RegName);
    Reset (f, 1);
    BlockRead (f, mr, 128, transferred);
    CloseFile (f);
  end {if};
end {MemLoad};


procedure IniLoad;
var
  Ini1: TIniFile;
begin
  Ini1 := TIniFile.Create (ExpandFileName(IniName));
  with Ini1 do
  begin
    OscFreq := ReadInteger ('Settings', 'OscFreq', 910);
    SelfTest := ReadInteger ('Settings', 'SelfTest', 0);
  end {with};
  Ini1.Free;
end {IniLoad};


{ initialise the application }
procedure TMainForm.FormCreate(Sender: TObject);
begin
  LcdBmp := TBitMap.Create;
  LcdBmp.Width := 192;
  LcdBmp.Height := 128;
  IniLoad;
  MemLoad;
  LcdInit;
end;


{ save the memory images }
procedure MemSave;
var
  f: file;
begin
  {$I-}
{ save the RAM image }
  AssignFile (f, RamName);
  Rewrite (f, 1);
  BlockWrite (f, ram, RamSize);
  CloseFile (f);
  if IOResult <> 0 then MessageDlg (SaveMsg + RamName, mtWarning, [mbOk], 0);
{ save the register file image }
  AssignFile (f, RegName);
  Rewrite (f, 1);
  BlockWrite (f, mr, 128);
  CloseFile (f);
  if IOResult <> 0 then MessageDlg (SaveMsg + RamName, mtWarning, [mbOk], 0);
  {$I+}
end {MemSave};


{ terminate the application }
procedure TMainForm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
{ As the memory appears to be deallocated before destroying the timers, it is
  necessary to prevent the emulated CPU to access the memory after it has been
  freed. }
  CpuStop := True;
  RunTimer.Enabled := False;
  RefreshTimer.Enabled := False;
  MemSave;
  LcdBmp.Free;
end;


procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
const
{ key codes FIRST to FIRST+COUNT-1 }
  FIRST = 19;
  ALPHA = 31;
  COUNT = ALPHA + 21;
  Letters: string[COUNT] = 
	'ABCDEFGHIJKLMNOaaPQRSTUVWXYZ[] ()aa789aa456*/123+-0.';
var
  i: integer;
begin
  Key := UpCase(Key);
  if Key = '"' then KeyCode[2] := 3 else
  if Key = ':' then KeyCode[2] := 13 else
  for i := 1 to COUNT do
  begin
    if Key = Letters[i] then
    begin
      if i > ALPHA then KeyCode[2] := i+(FIRST-ALPHA+7) else
	KeyCode[2] := i+(FIRST-1);
      KeyHandle;
      Break;
    end {if};
  end {for};
end;


procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_F3:	DebugForm.Show;
    VK_HOME:	KeyCode[2] := 1;	{ SHIFT }
    VK_END:	KeyCode[2] := 2;	{ ALPHA }
    VK_ESCAPE:	KeyCode[2] := 35;	{ AC }
    VK_DELETE:	KeyCode[2] := 34;	{ DEL }
    VK_RETURN:  KeyCode[2] := 50;	{ EXE }
    VK_LEFT:	KeyCode[2] := 4;	{ left }
    VK_RIGHT:	KeyCode[2] := 5;	{ right }
    VK_UP:	KeyCode[2] := 10;	{ up }
    VK_DOWN:	KeyCode[2] := 11;	{ down }
    VK_F8:	KeyCode[2] := 52;	{ Init }
  end {case};
  if KeyCode[2] <> 0 then KeyHandle;
end;


procedure TMainForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  KeyCode[2] := 0;
  KeyHandle;
end;


procedure TMainForm.FormShow(Sender: TObject);
begin
  KeyCode[1] := 0;
  KeyCode[2] := 0;
  KeyCode[3] := 0;
  CpuStop := False;
  CpuDelay := 0;
  CpuSteps := -1;
  BreakPoint := -1;
  ButtonGlyphs;
{ clear the LCD area }
  with LcdBmp.Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := clLtGray;
    FillRect (Rect(0, 0, 192, 128));
  end {with};
  CpuSpeed := OscFreq * integer(RunTimer.Interval);
  ResetAll;
  ScrCtrl := not lcdctrl;	{ invalidate the shadow LCD control register }
  RunTimer.Enabled := True;
  RefreshTimer.Enabled := True;
  RedrawReq := True;
end;


procedure TMainForm.SwitchMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  bev: TBevel;
  sh: TShape;
begin
  sh := TShape (Sender);
  if sh = PrintSwitch then
  begin
    bev := PrintBevel;
    if sh.Tag > 0 then KeyCode[3] := 0 else KeyCode[3] := 53;
    KeyHandle;
  end
  else if sh = PowerSwitch then
  begin
    bev := PowerBevel;
    ResetAll;
    RunTimer.Enabled := (sh.Tag > 0);
  end
  else Exit; { safety measure, should never happen }
{ move the switch, the new Shape position is calculated following way:
  leftspace := sh.Left - bev.Left;
  rightspace := bev.Left + bev.Width - (sh.Left + sh.Width + 1);
  sh.Left := sh.Left + rightspace - leftspace;
  sh.Tag stores the switch state, left when negative, right when positive }
  sh.Tag := 2*(bev.Left - sh.Left) + bev.Width - sh.Width - 1;
  sh.Left := sh.Left + sh.Tag;
end;


procedure TMainForm.ButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  KeyCode[1] := TSpeedButton(Sender).Tag;
  KeyHandle;
end;


procedure TMainForm.ButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  KeyCode[1] := 0;
  KeyHandle;
end;


procedure TMainForm.OnRunTimer(Sender: TObject);
var
  x: integer;
begin
  if CpuDelay > 0 then
  begin
    Dec (CpuDelay);
    acycles := 0;
    Exit;
  end {if};
  Inc (acycles, CpuSpeed);
  while acycles > 0 do
  begin
    if CpuStop then
    begin
      acycles := 0;
      break;
    end {if};

{ clock modes }
    case (ie and $84) of
      $80: x := 2;		{ slow mode }
      $84: x := 4 * onrate;	{ external clock }
      else x := 1;		{ fast mode }
    end {case};
    x := x * CpuRun;
    Dec (acycles, x);

{ INT1 interrupt from the LCD controller }
    if ((lcdctrl and VDD2_bit) = 0) or ((ie and $84) = $84) then
    begin
      OnCounter := 2 * onrate;
      ifreg := ifreg and not INT_input[1];
    end
    else
    begin
      Dec (OnCounter, x);
      if OnCounter < 0 then
      begin
        Inc (OnCounter, 2 * onrate);
        if OnCounter < 0 then OnCounter := 2 * onrate;
        ifreg := ifreg xor INT_input[1];
        if (ifreg and INT_input[1]) <> 0 then IntReq (1);
      end {if};
    end {if};

    if CpuSteps > 0 then
    begin
      Dec (CpuSteps);
      if CpuSteps = 0 then
      begin
        CpuStop := True;
        acycles := 0;
        DebugForm.Show;
        break;
      end {if};
    end {if};

    if (BreakPoint >= 0) and (BreakPoint = pc) then
    begin
      CpuStop := True;
      acycles := 0;
      DebugForm.Show;
      break;
    end {if};

  end {while};
end;


end.
