   ORG &H44F0
; Put in Prog "ALIEN", file editor,
; Registers
; R24 alien lines counter
; R25 empty lines
; R120,R56 - index register IX
; R121,R57 - index register IY
; R122,R58 - index register IZ
; R10 - coded direction of every alien line
; R23 - ROWMOVE loop counter
; R101 - help register, to calculate ROWMOVE position
; R83 - Test bit during row move
; R82 - bomb shape
; R34 - check if edge is empty
; R26, R27 delay loop counter
; R29 - relative bomb position
; R81 - Bomb position increment
; R80 - empty vertical strip of 8 pixels
; R31 - relative cannon position
; R42 - required by ROM
; R84 - Bomb column
; R85 - Cannon position
; R22 - Lives
; R21 - Unclean rows
; R100,R41 bullet pos
; R40 - bullet is flying
 db &HFF  ; EOF marker
STARTPROG
LIFE: 
  LDM R80..R81,0
  INV R80  ; Avoid code FF in binary in order not to damage file editor
  LD R22,3
  ldm	r77..r79,&H30	;'0', three ASCII digits of the score


LEVEL:
  LD R40,0 ; Bullet is not fired
  LDW IX,&H5A80 ; Start of video memory
  LD R27,3    ; CLSLOOP 3*256 bytes
  LD R26,0
CLS:
  ST +(IX),R80 ; R80 contains &HFF, which is empty verical strip of 8 pixels
  SBM R26..R27,1
  JMP NZ,CLS
  
TOP:
   LDW IX,&H5A80  ; Start of video memory
   LD R29,0 ; Bomb position
   LD R24,4 ; 4 rows of aliens
   LD R25,16 ; aliens start from the 16 column
   LD R82,&H0F ; Bomb is four pixels
   LD R85,0   ; cannon is on the left of the screen
   LD R84,44 ; bomb starts from the 44 column
LPSCENE1:
   ST +(IX),R80  ; &HFF is space at the begin of aliens
   SB R25,1 
   JMP NZ,LPSCENE1
   LD R25,08 ; Now plot 8 aliens in loop
LPSCENE2:
   ST +(IX),&HDE ; this is shape of the alien
   ST +(IX),&H9c
   ST +(IX),&H7A
   ST +(IX),&H70
   ST +(IX),&H7A
   ST +(IX),&H9C
   ST +(IX),&HDE
   ST +(IX),R80 ; space between aliens
   SB R25,1 
   JMP NZ,LPSCENE2
   LD R25,32 ; in the remaining rows the space is 32 pixels, 16 to the right edge and 16 from the left edge
   SB R24,1 
   JMP NZ,LPSCENE1 ; after this loop all four rows (total 32 aliens) are displayed
   LDW IX,&H5CD0  ; IX points to the row with shields in the video memory
   LD R23,4 ; four shields
SHIELDLOOP:
   LD R24,8  ; shield is a simple block of 8x8 pixels
SHIELDPLOT:
   ST +(IX),&H00
   SB R24,1 
   JMP NZ,SHIELDPLOT ; at the end of the loop shield is plotted
   ADW IX,10 ; space between shields
   SB R23,1 
   JMP NZ,SHIELDLOOP ; and repeat until all four are plotted
GAMELOOP:
   LD R10,&H0A ; Lower nibble of R10 contains code where to move row of aliens. Each row has one bit, value 0 moves the row left, value 1 right
ROWMOVEOOP:

   TSB R40,1 ; If the bullet is flying, R40 will be 1
   JMP NZ,MOVEALIENS ; If not, just skip deleting the bullet

   CAL XCGIXRP ; get bullet position
   SBW IX,1 ; put the empty vertical strip of 8 pixels at bullet position
   ST +(IX),R80 ; Due to instruction set and requirement that byte with &HFF is forbiden it is a few bytes longer than should be
   SBW IX,96 ; Put the bullet position one row above (8 pixels)
   CAL XCGIXRP ; store bullet position
   TSB R120,&H5A ; Check if IX is below 5A80 (video memory)
   JMP NZ,MOVEALIENS
   TSB R56,&H80
   JMP NC,MOVEALIENS
   LD R40,0 ; bullet is out of screen, so it is no longer active
MOVEALIENS:
   LD R83,&H10 ; This is bit mask used for testing R19
   LD R23,4  ; Four rows
MULTIROWMOVE:
   ROD R83  ; Move mask, it will be 00001000 00000100 00000010 or 00000001
   AN R83,&HF  ; after setting upper bits to 0
   BIT R10,R83 ; Binary test for this row
   JMP NZ,TORIGHT
TOLEFT: ; Move the row to left
   LDW IY,&H5A80  ; Set up registers for moving the row
   LDW IZ,&H5A21
   LDW IX,&H5A21
   CAL OTHERROW  ; add 96*R23 to all three index registers
   LD R34,(IZ)- ; Test if there is space on the screen 
   TSB R34,R80  
   JMP NZ,NOROWMOVE ; if not, change direction
   CAL &H0008 ; bup instruction will move the alien row one pixel left
   JMP ENDROWMOVE
TORIGHT: ; Move the row to the right
   LDW IY,&H5A20 ; Set up registers for moving the row
   LDW IZ,&H5A7E
   LDW IX,&H5A7E
   CAL OTHERROW ; add 96*R23 to all three index registers
   LD R34,(IZ)+  ; Test if there is space on the screen 
   TSB R34,R80 ; &HFF
   JMP NZ,NOROWMOVE ; if not, change direction
   CAL &H000A ; bdn instruction will move the alien row one pixel right
   JMP ENDROWMOVE
NOROWMOVE:
   XR R10,R83 ; XOR with mask will flip the direction bit
ENDROWMOVE:
   SB R23,1
   JMP NZ,MULTIROWMOVE ; Repeat until all four rows of aliens are moved
   LD R21,4 ; We will check four rows if they are empty
   INV R82 ; negate bomb shape from upper four pixel line to lower four pixel line
   XR R81,&H60; Bomb position is changed by 96 or 0 every two passes
   LDW IX,&H5C00 ; calculate video memory area where bomb appears
   AD R56,R84 ; lower byte of IX
   ST (IX+R29),R80 ; put the bomb
   AD R29,R81  ; increment bomb position
   JMP NC,MOVEBOMB ; if bomb did not reach the end



   LD R29,0 ; erase the bomb
   ST (IX+R29),R80
TESTKILL:
   LD R121,&H5D ; take cannon row in video memory
   LD R57,R84
   AD R57,&H20
   LD R26,(IY)+ ; check position in cannon row, bomb column
   TSB R26,R80; &HFF if not empty skip
   JMP Z,NOTKILLED
   SB R22,1 ; Reduce life counter
   JMP Z,0  ; exit from program if life=0
NEWLIFE:
   LDW IX,&H5D20  ; delete cannon row
   CAL CLLINE
   LD R85,0  ; cannon to the left

NOTKILLED:
   LD R121,&H5B  ; We need to fire new bomb, because previous one reached ground
   LD R57,R84
   AD R57,&HA0 ; It is in row which starts in video memory at 5BA0

FINDBOMBERRT:
   LD R26,(IY)+ ; Now search for byte &H70 (middle of alien) starting from the current position
   TSB R26,&H70
   JMP Z,BOMBERPOS
   TSB R57,R80  ; &HFF at 5BFF is end of the row of the bombing aliens
   JMP NZ,FINDBOMBERRT
   LD R57,&HA0
FINDBOMBERLT:
   LD R26,(IY)+ ; search again, but now from the start of the bottom aliens row
   TSB R26,&H70
   JMP Z,BOMBERPOS
   TSB R57,R80 ;&HFF
   JMP NZ,FINDBOMBERLT
; All aliens in bottom row are killed, move them down
   LDW IX,&H5BA0
   LDW IY,&H5A80
   LDW IZ,&H5C00
   CAL &H000A
   LDW IX,&H5A80 ; delete the top row
   CAL CLLINE

   SB R21,1
   JMP Z,LEVEL ; after four aliens rows moved, down restart the level
   JMP NOTKILLED
; Row killed!
BOMBERPOS:
   LD R84,R57
   SB R84,&HA0 ; Now we have relative bomb position

   JMP TESTKBD

MOVEBOMB:
   LD R72,(IX+R29) ; get the byte from the bomb position
   ST (IX+R29),R82 ; put the bomb shape
   TSB R72,0 ; Is it part of shield?
   JMP NZ,TESTKBD ; if not skip shield damaging
   ST (IX+R29),R80  ; erase one strip of the shield
   LD R29,0  ; move bomb to the top
TESTKBD:
   PST KO,&H00 ; Enable all test kbd lines
   GST R72,KI   ; Read keyboard
   TSB R72,&H10  ; Check if right key is pressed
   JMP Z,RIGHTKEY
   TSB R72,&H08 ; Check if left key is pressed
   JMP Z,LEFTKEY
   TSB R72,&H20  ; Check if up key is pressed
   JMP Z,FIREROCKET
   JMP DRAWCANON

RIGHTKEY:
   TSB R85,86 ; Check for right border of the screen
   JMP Z,DRAWCANON
   AD R85,1 ; Move cannon position
   JMP DRAWCANON
LEFTKEY:
   TSB R85,0 ; Check for left border of the screen
   JMP Z,DRAWCANON
   SB R85,1 ; Move cannon position
   JMP DRAWCANON
FIREROCKET:
   TSB R40,1 ; If the bullet is currently flying you can not fire the new one
   JMP Z,DRAWCANON
   LD R40,1
   LDW IX,&H5CC4; Bullet position, one row above cannon
   AD R56,R85 ; lower IX
   JMP NC,STOREROCKETPOS
   AD R120,1 ; 8 bit arithmetic is used
STOREROCKETPOS:

  CAL XCGIXRP ; Remember IX
DRAWCANON:
   LDW IX,&H5D20 ; Now find cannon position
   AD R56,R85 ; lower IX
   ST +(IX),R80 ; Cannon shape
   ST +(IX),&H0f
   ST +(IX),&H0f
   ST +(IX),&H08
   ST +(IX),&H0f
   ST +(IX),&H0f
   ST +(IX),R80

   TSB R40,1 ; If bullet is not flying skip plotting
   JMP NZ,REFRESH

   LD R120,R41  ; restore bullet position
   LD R56,R100
   LD R34,(IX+0) ; check what it is there
   TSB R34,R80 ; if empty space &HFF 
   JMP Z,PLOTROCKET ; jump to plot the bullet

FINDHOLE: 
   LD R40,0 ; Bump into alien or shield
   LD R34,(IX)- ; find the beginning of the shape
   TSB R34,R80 ;&HFF
   JMP NZ,FINDHOLE

   LD R26,8 ; delete alien or shield
   CAL CLLINE1
   ADB R77,1 ; increase score lowest digit
   JMP NH,REFRESH ; BCD arithmetic, after '9' the H flag will be set
   LD	R77,&H30	; reset lowest digit to '0'
   ADB R78,1 ; increase tens
   JMP NH,REFRESH
   LD	R78,&H30	;'0'
   AD R79,1 ; increase hundreds, after 999 killed aliens, score will look strange
   JMP REFRESH
PLOTROCKET:
; Plot the bullet
   ST (IX),&H70

REFRESH:
   AN R42,&H3F  ; PARAMETER DO REFRESH
   CAL &H0620   ; Call ROM routine to show changes in video memory
   ldm	r72..r76,&H20
   ldm	r64..r71,&H20
   ld r55,&H7D   ; screen position is stored in R55
   cal	&H0100		;display the string R79..R64

  LD R27,3  ; delay loop 768 times to make game not too fast
DELAY1:
  SBM R26..R27,1 ; Machine code is amazing, even at 900kHz
  JMP NZ,DELAY1 

   JMP ROWMOVEOOP ; Go to inner loop
OTHERROW: ; adjust index registers to point to the correct row of the aliens
   LD R101,R23
OTHER1:
   ADW IX,96
   ADW IY,96
   ADW IZ,96
   SB R101,1 
   JMP NZ,OTHER1
   RTN
CLLINE:  ; delete row of the screen
   LD R26,96
CLLINE1:  ; delete part of the screen
   ST +(IX),R80
   SB R26,1
   JMP NZ,CLLINE1
   RTN

XCGIXRP:  ; store and restore bullet position
   XC R41,R120
   XC R100,R56
   RTN
  ORG &H4755
  JMP STARTPROG
  db 'GUGUGUGU' ; This sequence is also 4755475547554755
  DB 'G :0',&HEC,':]853[Z',&H0E,']034',&H87,'[Z',01
  DB 'CM',00  ; PASSWORD 2 LETTERS
  DB 'NEILA'  ; Name 5 letters

