  ORG &H435F
 db &HFF  ; EOF marker
; R28 Player row
; R29 Player column
; R32 Generated room row
; R33 Generated room column
; R36 View direction 0 N, 1 E, 2 S, 3 W
; R81 Distance to Minotaur 0 far, 1 distant, 2 medium, 3 near 4 in battle 5+ invisible




RESTART:
  ldm r38..r39,'0'  ; Score Theseus-Minotaur

  LD R29,&H19 ; Initial position in the Labyrinth, column
  LDM R27..R28,&H3 ; Initial position in the Labyrinth, row and upper byte of Minotaur arrival counter
   
  LD R81,5
  byd r26 ; set byte of Minotaur arrival counter  to zero
  byd R36

  LDM r10..r11,1 ; sword, first attack east
  byd R85
  inv R85 ; This register contains FF byte, which is not allowed to be in code because it is EOF marker 
  JMP REF
LP:
 TSB R39,'9'    ; If the score of Theseus is '9' 
 JMP Z,MINDEAD  ; Minotaur is dead, no move 
 SBM R26..R27,1  ; Decrement counter,
 JMP NZ,TESTKBD  ; TIMED EVENTS
 LD R27,3        ; Reset timer
 CAL APPROACH    ; Make Minotaur closer
 TSB R81,6       ; If Minotaur is visible refresh screen
 JMP C,REF
 JMP TESTKBD     ; Else just read keyboard
MINDEAD:
 TSB R28,&H9B  ; minotaur room row
 JMP NZ,TESTKBD
 TSB R29,&H8D ; minotaur room column
 JMP NZ,TESTKBD 
WIN:  ; Minotaur is dead and Theseus is in Minotaur's room
  ldw	ix,&H36AF  ; ROM message "Please" used for victory
WINANDLOSE:
 cal	&HA1BA ; Display 16 letters message
GAMEEND:
  CAL TESTKB1  ; Read keyboarb byte and check keys for exit and restart the game
  JMP C,RESTART
  JMP GAMEEND
LOSE:
  LDW IX, &H8384  ; ROM message "Did not pass" used for lose
  JMP WINANDLOSE

TESTKB1:  
 GST R72,KI   ; READ KEYBOARD
 ROD R72      ; Disp/AC exit the game
 JMP C,0
 ROD R72
 RTN
TESTKBD:
 CAL TESTKB1   ; Read keyboard byte and shift it , then execute keyboard actions
 ROD R72
 JMP C,RANGEFIRE
 ROD R72
 JMP C,LEFTKEY
 ROD R72
 JMP C,RIGHTKEY
 ROD R72
 JMP C,FORWARDKEY
 
 TSB R10,1   ; No key pressed and sword is up
 JMP NZ,REF1
 byd R10    ; Then pull the sword flag
 JMP REF
RIGHTKEY:  ; Rotating updates lowest two bits of R36
  AD R36,1
  JMP LF1
LEFTKEY:
  SB R36,1
LF1:  
  AN R36,3
  JMP REF
RANGEFIRE ; Range Key pulls the sword
  TSB R10,1  ; But if it is already up just plot it, because we want to kill Minotaur if we pull the sword when he is at near position
  JMP Z,REF1
  LD R10,1  ; Sword UP
  TSB  R81,3  ; Minotaur at position near
  JMP NZ,REF
  LD R104,R11 ; And the Minotaur direction is facing to us
  TSB R104,R36 
  JMP NZ,REF
  LD  R81,&H5 ; Minotaur passed
  XR R11,2  ; Attack flips east-west
  AD R39,1  ; Theseus won the round
  JMP REF
  
FORWARDKEY:
  CAL MAKEROOMBITMAP  ; Generate in three registers bitmap structure of the forward landscape
  TAN R19,1  ; If the wall is in front us do not move
  JMP NZ,REF
  TSB R36,1   ; Else move in the correct direction
  JMP C,GONORTH
  JMP Z,GOEAST
  TSB R36,3
  JMP C,GOSOUTH
  JMP Z,GOWEST

  JMP REF  ; Plot the landscape

GONORTH:
  SB R28,1  ; change location
GN1:  
  CAL APPROAC1 ; If we are facing to Minotaur, make him faster approach
  JMP REF
GOEAST:
  AD R29,1
  JMP GN1
GOSOUTH:
  AD R28,1
  JMP GN1
GOWEST:
  SB R29,1
  JMP GN1


REF:
  CAL MAKEROOMBITMAP ; Generate landscape codes
  CAL SCENE  ; Display the scene
  AN R42,&H3F  ; PARAMETER DO REFRESH
  CAL &H0620   ; SYSTEM CALL REFRESH
  
  cal &H0B53 ; clear string
  LD R64,r38  ; Score Minotaur
  LD R66,R39   ; Score Theseus
  LDW IY,DIRECTIONCODES
  LD R68,(IY+R36) ; Arrows in Casio character set for Theseus direction
  LD R67,(IY+R11) ; Arrows in Casio character set for Minotaur direction

  STM -(SP),R29..R28 ; Dismangle player row and column four nibbles to four bytes
  STM -(SP),R29..R28
  LDM R76..R79,(SP)+
  DIDM R79..R78
  LDM R4..R7,&H0F
  ANM R76..R79,R4..R7
  
  AD R76,&H90 ; Greek letter offset
  AD R77,&H90 ; 
  AD R78,&H90 ; 
  AD R79,&H90 ; 
  
  byd r55  ; upper corner
  cal	&H0100		;display the string R79..R64 
REF1: 
  JMP LP  ; Return to main loop
SCENE:
  LDW IX,&H5A80 ; Start of video memory
  LDW IY,&H5A80+768
  cal	&H0F99   ; This ROM routine with these parameters will clear the screen

  LD R14,4       ; Scene is drawn from four zones
  LDW IY,ZONES   ; whose starting x coordinate is pointed by IY
SCENELP:
  byd R12
  ROD R18
  CAL MAZESHAPE  ; Left wall
  LD R12,1
  ROD R17
  CAL MAZESHAPE  ; Right wall
  ROD R19        ; Middle wall
  JMP C,DEADEND
  ADW IY,1       ; Pointer to the next starting row
  SB R14,1
  JMP NZ,SCENELP
  JMP MINOTAUR1
DEADEND:        ; Plot the wall in front of us
  TSB R14,4     ; Test if we bump into wall
  JMP NZ,PLOTDEADEND  ; Skip if not
HIDE:
  LD R104,R11   ; If we are just behind the wall, facing Minotaur
  TSB R104,R36 
  JMP NZ,PLOTDEADEND
  TSB R81,6
  JMP NC,PLOTDEADEND
  LD R81,5   ; He will disappear
PLOTDEADEND:  ; Wall in front us consists of lines of the same height
  LD R21,(IY+1) ;from x=pointed by IY+1
  LD R80,R21
  LD R84,96  
  AD R21,1
  SB R84,R21 ; to 95-x
DELOOP:
  CAL CALCLINEHL ; Calculate line height
  LD R23,4  ; Pattern parallel line
  TAN R21,3 ; every 4tg pattern is vertical line
  JMP NZ,DEBRICK
  byd R23
DEBRICK:  
  CAL VLINE  ; Draw vertical line for front wall
  AD R21,1
  TSB R21,R84
  JMP NZ,DELOOP
MINOTAUR: 
  TSB R14,R81
  JMP NC,SWORD
  
MINOTAUR1:  
  LD R104,R11  ; Check if Minotaur is facing Theseus
  TSB R104,R36 
  JMP NZ,SWORD
  TSB R81,4
  JMP NC,SWORD ; Check if Minotaur is nearby
  LDW IX,&H5B6F+96 ; Screen position of Minotaur
  LD R24,R81  ; Number of sprite is Minotaur distance code
  CAL SPRITE

SWORD:
  TSB R10,1
  JMP NZ,ENDDRAW ; if sword is pulled skip painting
  LDW IX,&H5CEE  ; Position of the sword definition
  LD R24,4     ; Sword is sprite number 4
  CAL SPRITE
ENDDRAW:
  RTN

SPRITE: ; Sprite draw routine
  LDW IY,SPROFFSET
  AD R24,1
MST:  ; Find sprite definition 
  LD R58,(IY)+
  LD R122,(IY)+  ; HERE IS LITTLE ENDIAN, assembler property. However upd1007 often uses big endian
  SB R24,1     ; IZ points to the sprite definition
  JMP NZ,MST
  LDM R24..R25,(IZ)+ ; Take number of rows (8pixels) and columns (1 pixel) in sprite definition
MST1:  ; Nested loop
  LD R80,R25
  LD R13,R80
MST2:
  LD R80,(IZ)+
  ST (IX+R13),R80
  ST (IX-R13),R80  ; All sprites are symetric to save RAM
  SB R13,1
  JMP NZ,MST2
  LD R13,(IZ)+ ; The middle is stored at end
  ST (IX+0),R13
  ADW IX,96  ; Next sprite row
  SB R24,1
  JMP NZ,MST1
ENDSPRITE:
  RTN  

MAZESHAPE: ; IY points to X position, R12 + carry type
  ROU R12
  LD R13,(IY+1)
SETENDLINE:  
  LD R80,R13
  LD R13,(IY+0)
; Input: R12 type, R80 endline R13 Startline
MAZEPART: ; Plot left and right side of the maze.
  SB R13,1
  LD R84,17
MPLOOP:
  LD R21,R80
  TAN R12,2  ; left or right wall
  JMP Z,MPLOOP1
  SB R21,95 ; this is right side
  CMP R21
MPLOOP1:
  LD R23,R80 ; make pattern code from the current line
  AN R23,3
  CAL CALCLINEHL ; Calculate height from x (R80)
  TSB R84,17
  JMP NZ,SKIPLENREM
  LD R84,R24 ; Remember wall height
  AD R13,1
SKIPLENREM: ; If there is side wall plot the lines in zone with different height.
  TAN R12,1 ; If there is side hole the lines in zone are with same height.
  JMP NZ,DRAWLINE
  LD R24,R84  ; side walls are different, undo CALCLINEHL
  TSB R23,0
  JMP Z,DRAWLINE
  LD R23,4 ; thin brick
DRAWLINE:  ; Now call vertical line
  CAL VLINE
  SB R80,1 ; next x coordinate
  TSB R80,R13
  JMP NZ,MPLOOP
  RTN
CALCLINEHL: ; Calculates vertical line height from x position
  LD R22,1
  LD R24,R80
  ROD R24
  ROD R24
  AN R24,&H3F
  SB R24,16
  CMP R24
  RTN
; Draw vertical line. Parameters R21 - column, R22 - row/8, R23 - pattern, R24 - repeat, 

VLINE:
  LD R83,R24
  AD R24,0 ; Divide repeat by 2
  ROD R24
  AD R22,1 ; Initial skip
  LDW IX,VMASKS
  LD R82,(IX+R23) ; get the pattern from pattern number
  LDW IX,&H5A80-96
VLINEST:
  ADW IX,96
  SB R22,1
  JMP NZ,VLINEST
VLINEF:
  ST (IX+R21),R82
  ADW IX,96
  SB R24,1
  JMP NZ,VLINEF
  TAN R83,1  ; Due to vertical byte organizatiobn of video memory every second vertical line will have additional nibble
  JMP Z,ENDVLINE
  OR R82,&HF0 ; Mask the nible
  ST (IX+R21),R82  ; Put it to screen
ENDVLINE:
  RTN


ROOMCALC:
; R32 row of generated room
; R33 column of generated room
; This routine uses calculation randomized by reading ROM from x and y room coordinate and returns 1 (wall) or 0 (room)
  LDW IX,&H3700 ; partrom
  LDW IY,&H3800  ; partrom2
  byd R100  ;  mazepos1:=0;
  TAN R32,1 ;   if y and 1 =0 then mazepos1:=1;
  JMP NZ,ROOMCALC1  
  LD R100,1
; if ((partrom[(y - x) mod 256] and 15) =  (partrom2[(y xor x) mod 256] and 15)) and (x mod 2 =1)then  mazepos1:=0;
ROOMCALC1:
  TAN R33,1 
  JMP Z,ROOMCALC2
  LD R101,R32
  SB R101,R33
  LD R34,R101
  LD R101,(IX+R34) 
  AN R101,15

  LD R102,R32
  XR R102,R33
  LD R34,R102
  LD R102,(IY+R34) 
  AN R102,15
  LD R34,R102
  TSB R101,R34
  JMP NZ,ROOMCALC2
  byd R100
; if (partrom2[x] xor partrom[y]) and 31 =0  then  mazepos1:=1;
ROOMCALC2:
  LD R101,(IY+R33)
  LD R102,(IX+R32)
  LD R34,R101
  XR R34,R102
  AN R34,31
  JMP Z,MAZEBORDER
ROOMCALC3:
; if x=0 or x=255 or y=0 or y=255 then mazepos1:=1;
  TSB R33,0
  JMP Z,MAZEBORDER  
  TSB R33,r85
  JMP Z,MAZEBORDER  
  TSB R32,0
  JMP Z,MAZEBORDER  
  TSB R32,r85
  JMP NZ,ROOMCALCFIN  
MAZEBORDER:
  LD R100,1
ROOMCALCFIN: 
  RTN

; This is format returned by MAKEROOMBITMAP
;  R18  R19  R17
;        X
;   X    X    X
;   X    X    X
;   X    X    X
;   X  Plyr   X


MAKEROOMBITMAP: ; This routine looks 12 rooms in front of player and stores their configuration in bits of registers R17,R18 and R19.

 LDM R17..R19,0
 LDW IZ,NORTH-8 ; IZ points to the table , depending of direction where we look on
 LD R100,R36
 AD R100,1
SIDEDETERMINE:
 ADW IZ,8
 SB R100,1
 JMP NZ,SIDEDETERMINE ; Aftrer this loop IZ will point to the increment table for visiting neighbour rooms
 LD R14,4

 STM -(SP),R29..R28
 LDM R32..R33,(SP)+ ; coordinates of examined rooms

 CAL NEXTIZ ; increment x and y to go to the neighbour room
LOOKNORTHLP:
 CAL ROOMCALC  ; left
 BIU R18 
 AD R18,R100
 CAL NEXTIZ  ; medium 
 CAL ROOMCALC
 BIU R19
 AD R19,R100
 CAL NEXTIZ ; right
 CAL ROOMCALC
 BIU R17
 AD R17,R100
 CAL NEXTIZ
 SBW IZ,6
 SB R14,1
 JMP NZ,LOOKNORTHLP 
 RTN
NEXTIZ:
 LDM R104..R105,(IZ)+
 XR R104,&H80
 AD R33,R104
 XR R105,&H80
 AD R32,R105

 
 RTN 
APPROAC1:
 LD R104,R11
 TSB R104,R36 
 JMP NZ,ENDEVENT
APPROACH:
 AD R81,1  ; Test counter of Minotaur
 TSB R81,4
 JMP NZ,ENDEVENT
 LD R81,&h5 ; If he arrrved and sword was not pulled
 XR R11,2
 AD R38,1
 TSB R38,58
 JMP Z,LOSE ; One lose mort
ENDEVENT: 
 RTN
; Table of directions is XOR-ed with 128 to avoid prohibited code FF in memory
NORTH:
; DB -1,-3,  1,-1,  1,1,   -2,1
 DB 127,125,  129,127,  129,129,  126,129
 ;   dx,dy, dx,dy  dx,dy   dx,dy
EAST:
;  DB 3,-1,  1,1,  -1,1,  -1,-2
 db 131,127,129,129,127,129,127,126
SOUTH:
; DB 1,3,  -1,1,  -1,-1,   2,-1
 db 129,131,127,129,127,127,130,127
WEST:
;  DB -3,1,  -1,-1,  1,-1,  1,2
 db 125,129,127,127,129,127,129,130
DIRECTIONCODES:
 db 8,7,9,6
 
ZONES:
  DB 0,16,28,36,40
VMASKS: 
  DB &H00,&HCC,&H99,&H33,&HEE

SPROFFSET:
  DW VFARMINDATA,FARMINDATA,MEDMINDATAR1,NEARMINDATAR1,SWORDDATA
; Minotaur   and sword definition
VFARMINDATA:
  DB 1,1,&HFA,&HF1
FARMINDATA:
  DB 1,3,&HB7,&H09,&H18,&H1A
MEDMINDATAR1:
  DB 2,4,&H73,&H28,&H0C,&H09,&H48
MEDMINDATAR2:
  DB &H70,&HE3,&H00,&H70,&HF0
NEARMINDATAR1:
  DB 3,5,&HF3,&H38,&H0E,&H0C,&H39,&H18
NEARMINDATAR2:
  DB &H0C,&H08,&HF8,&H00,&H00 ,&H00
NEARMINDATAR3:
  DB &H0C,&H08,&HE0,&HF1,&HF3,&HF7  
SWORDDATA:
  DB 2,3, &HEF,&H0C,&HFB,&H00
  db      &H00,&HEF,&HEF,&H00   
  ORG &H4755
  JMP RESTART
  db 'GUGUGUGU' ; This sequence is also 4755475547554755
  DB 'G :0',&HEC,':]853[Z',&H0E,']034',&H87,'[Z',01
  DB 'CM',00  ; PASSWORD 2 LETTERS
  DB 'TONIM'  ; Name 5 letters
