; Instruction set test routine for the Casio uPD1007 (NM-320) microprocessor.

IM8	EQU	&H56
IM16	EQU	&H9ABC

	ORG	&H7800


; no operands

	RTN				;58
	CANI				;68
	RTI				;78
	BUP				;E2
	BDN				;F2
	NOP				;FA


; byte size

	CMP	R10			;E8 12
	CMP	R70			;E0 06
	CMPB	R25			;EC 31
	CMPB	R75			;E4 13
	ROU	R33			;EE 41
	ROU	R84			;E6 24
	INV	R39			;F8 47
	INV	R92			;F0 34
	ROD	R46			;FE 56
	ROD	R100			;F6 44
	BYU	R35			;EB C3
	BYU	R99			;E3 C3
	BIU	R36			;EC C4
	BIU	R97			;E4 C1
	DIU	R37			;ED C5
	DIU	R95			;E5 B7
	MTB	R38			;EE C6
	MTB	R93			;E6 B5
	BYD	R40			;FB D0
	BYD	R90			;F3 B2
	DID	R42			;FD D2
	DID	R87			;F5 A7

	GST	R10,KO			;DC 12
	GST	R80,KO			;D4 20
	GST	R12,F			;DD 14
	GST	R82,F			;D5 22
	GST	R14,AS			;DE 16
	GST	R84,AS			;D6 24
	GST	R16,IE			;DF 20
	GST	R86,IE			;D7 26
	GST	R18,KI			;59 A2
	GST	R88,KI			;51 B0
	GST	R20,IF			;F9 A4
	GST	R90,IF			;F1 B2

	PST	KO,R40			;CC 50
	PST	KO,R105			;C4 51
	PST	F,R31			;CD 37
	PST	F,R100			;C5 44
	PST	AS,R22			;CE 26
	PST	AS,R99			;C6 43
	PST	IE,R13			;CF 15
	PST	IE,R77			;C7 15

	PST	KO,IM8			;C0 56
	PST	IF,&H3A			;C1 3A
	PST	AS,22			;C2 16
	PST	IE,130			;C3 82

	ADB	R10,R80			;08 12 02
	ADB	R100,R56		;00 70 84
	SBB	R32,R95			;09 40 E3
	SBB	R99,R44			;01 54 64
	AD	R1,R82			;0A 01 42
	AD	R84,R3			;02 03 82
	SB	R6,R85			;0B 06 A2
	SB	R97,R8			;03 10 24
	AN	R50,R109		;0C 62 A5
	AN	R108,R47		;04 57 85
	NA	R5,R66			;0D 05 40
	NA	R68,R7			;05 07 80
	OR	R18,R97			;0E 22 24
	OR	R100,R49		;06 61 84
	XR	R7,R67			;0F 07 60
	XR	R67,R7			;07 07 60

	ADB	R10,I80			;08 12 12
	ADB	I100,R56		;00 70 94
	SBB	R32,I95			;09 40 F3
	SBB	I99,R44			;01 54 74
	AD	R1,I82			;0A 01 52
	AD	I84,R3			;02 03 92
	SB	R6,I85			;0B 06 B2
	SB	I97,R8			;03 10 34
	AN	R50,I109		;0C 62 B5
	AN	I108,R47		;04 57 95
	NA	R5,I66			;0D 05 50
	NA	I68,R7			;05 07 90
	OR	R18,I97			;0E 22 34
	OR	I100,R49		;06 61 94
	XR	R7,I67			;0F 07 70
	XR	I67,R7			;07 07 70

	ADB	R10,IM8			;08 92 56
	ADB	R76,&HF3		;00 94 F3
	SBB	R32,160			;09 C0 A0
	SBB	R99,211			;01 C3 D3
	AD	R1,0			;0A 81 00
	AD	R103,IM8+1		;02 C7 57
	SB	R45,IM8+&H2A		;0B D5 80
	SB	R97,IM8+&H81		;03 C1 D7
	AN	R50,IM8-1		;0C E2 55
	AN	R108,IM8-90		;04 D4 FC
	NA	R5,IM8-2		;0D 85 54
	NA	R75,IM8-253		;05 93 59
	OR	R18,16			;0E A2 10
	OR	R100,10			;06 C4 0A
	XR	R7,88			;0F 87 58
	XR	R67,99			;07 83 63

	TADB	R10,R80			;28 12 02
	TADB	R100,R56		;20 70 84
	TSBB	R32,R95			;29 40 E3
	TSBB	R99,R44			;21 54 64
	TAD	R1,R82			;2A 01 42
	TAD	R84,R3			;22 03 82
	TSB	R6,R85			;2B 06 A2
	TSB	R97,R8			;23 10 24
	TAN	R50,R109		;2C 62 A5
	TAN	R108,R47		;24 57 85
	TNA	R5,R66			;2D 05 40
	TNA	R68,R7			;25 07 80
	TOR	R18,R97			;2E 22 24
	TOR	R100,R49		;26 61 84
	TXR	R7,R67			;2F 07 60
	TXR	R67,R7			;27 07 60

	TADB	R10,I80			;28 12 12
	TADB	I100,R56		;20 70 94
	TSBB	R32,I95			;29 40 F3
	TSBB	I99,R44			;21 54 74
	TAD	R1,I82			;2A 01 52
	TAD	I84,R3			;22 03 92
	TSB	R6,I85			;2B 06 B2
	TSB	I97,R8			;23 10 34
	TAN	R50,I109		;2C 62 B5
	TAN	I108,R47		;24 57 95
	TNA	R5,I66			;2D 05 50
	TNA	I68,R7			;25 07 90
	TOR	R18,I97			;2E 22 34
	TOR	I100,R49		;26 61 94
	TXR	R7,I67			;2F 07 70
	TXR	I67,R7			;27 07 70

	TADB	R10,IM8			;28 92 56
	TADB	R76,&HF3		;20 94 F3
	TSBB	R32,160			;29 C0 A0
	TSBB	R99,211			;21 C3 D3
	TAD	R1,0			;2A 81 00
	TAD	R103,IM8+1		;22 C7 57
	TSB	R45,IM8+&H2A		;2B D5 80
	TSB	R97,IM8+&H81		;23 C1 D7
	TAN	R50,IM8-1		;2C E2 55
	TAN	R108,IM8-90		;24 D4 FC
	TNA	R5,IM8-2		;2D 85 54
	TNA	R75,IM8-253		;25 93 59
	TOR	R18,16			;2E A2 10
	TOR	R100,10			;26 C4 0A
	TXR	R7,88			;2F 87 58
	TXR	R67,99			;27 83 63

	BIT	R19,R91			;5B A3 63
	BIT	R83,R51			;53 E3 62
	BIT	R19,I91			;5B A3 73
	BIT	I83,R51			;53 E3 72
	BIT	R47,&H64		;5A D7 64
	BIT	R107,135		;52 D3 87

	LDLE	R50,IM8			;CC E2 56
	LDLE	R70,IM8+2		;C4 86 58
	LDLO	R55,99			;CD E7 63
	LDLO	R75,202			;C5 93 CA
	STLE	R60,&H20		;CE F4 20
	STLE	R80,&HAA		;C6 A0 AA
	STLO	R30,&H01		;CF B6 01
	STLO	R85,&H21		;C7 A5 21

	SWP	R34			;E8 C2
	SWP	R101			;E0 C5
	SWP	R50,R66			;14 E2 40
	SWP	R66,R50			;14 E2 40
	SWP	R50,I66			;14 E2 50
	SWP	I66,R50			;14 E2 50

	XC	R14,R75			;1C 96 61
	XC	R75,R14			;1C 96 61
	XC	R14,I75			;1C 96 71
	XC	I75,R14			;1C 96 71

	XCLS	R28,R86			;1E B4 C2
	XCLS	R86,R28			;16 B4 C2
	XCLS	R28,I86			;1E B4 D2
	XCLS	I86,R28			;16 B4 D2
	XCHS	R28,R86			;16 B4 C2
	XCHS	R86,R28			;1E B4 C2
	XCHS	R28,I86			;16 B4 D2
	XCHS	I86,R28			;1E B4 D2

	LD	R45,R95			;5C D5 E3
	LD	R95,R45			;54 D5 E3
	LD	R45,I95			;5C D5 F3
	LD	I95,R45			;54 D5 F3
	LD	R22,IM8			;5E A6 56
	LD	R77,225			;56 95 E1

	LD	R90,(IX)+		;A0 32
	LD	R20,(IX)+		;A8 24
	LD	R100,(IY)+		;A1 44
	LD	R33,(IY)+		;A9 41
	LD	R78,(IZ)+		;A2 16
	LD	R48,(IZ)+		;AA 60
	LD	R87,(SP)+		;A3 27
	LD	R52,(SP)+		;AB 64
	LD	R101,(IX)-		;A4 45
	LD	R0,(IX)-		;AC 00
	LD	R75,(IY)-		;A5 13
	LD	R44,(IY)-		;AD 54
	LD	R85,(IZ)-		;A6 25
	LD	R25,(IZ)-		;AE 31
	LD	R113,(SP)-		;A7 61
	LD	R13,(SP)-		;AF 15

	LD	R20,(IX+IM8)		;A8 A4 56
	LD	R33,(IY+&H00)		;A9 C1 00
	LD	R39,(IZ+&H50)		;AA C7 50
	LD	R47,(SP+&HFF)		;AB D7 FF
	LD	R0,(IX-IM8)		;AC 80 56
	LD	R44,(IY-&H00)		;AD D4 00
	LD	R55,(IZ-&H50)		;AE E7 50
	LD	R29,(SP-&HFF)		;AF B5 FF

	LD	R110,(IX+R20)		;A0 A4 C5
	LD	R107,(IY+R33)		;A1 C1 65
	LD	R94,(IZ+R39)		;A2 C7 C3
	LD	R89,(SP+R47)		;A3 D7 23
	LD	R86,(IX-R0)		;A4 80 C2
	LD	R79,(IY-R44)		;A5 D4 E1
	LD	R71,(IZ-R55)		;A6 E7 E0
	LD	R68,(SP-R29)		;A7 B5 80

	LD	I110,(IX+R20)		;A0 A4 D5
	LD	I107,(IY+R33)		;A1 C1 75
	LD	I94,(IZ+R39)		;A2 C7 D3
	LD	I89,(SP+R47)		;A3 D7 33
	LD	I86,(IX-R0)		;A4 80 D2
	LD	I79,(IY-R44)		;A5 D4 F1
	LD	I71,(IZ-R55)		;A6 E7 F0
	LD	I68,(SP-R29)		;A7 B5 90

	ST	(IX),IM8		;D0 56
	ST	(IY),0			;D1 00
	ST	(IZ),100		;D2 64
	ST	(SP),&HC8		;D3 C8

	ST	+(IX),IM8		;C8 56
	ST	+(IY),0			;C9 00
	ST	+(IZ),100		;CA 64
	ST	+(SP),&HC8		;CB C8

	ST	-(IX),IM8		;D8 56
	ST	-(IY),0			;D9 00
	ST	-(IZ),100		;DA 64
	ST	-(SP),&HC8		;DB C8

	ST	+(IX),R90		;80 32
	ST	+(IX),R20		;88 24
	ST	+(IY),R100		;81 44
	ST	+(IY),R33		;89 41
	ST	+(IZ),R78		;82 16
	ST	+(IZ),R48		;8A 60
	ST	+(SP),R87		;83 27
	ST	+(SP),R52		;8B 64

	ST	-(IX),R101		;84 45
	ST	-(IX),R0		;8C 00
	ST	-(IY),R75		;85 13
	ST	-(IY),R44		;8D 54
	ST	-(IZ),R85		;86 25
	ST	-(IZ),R25		;8E 31
	ST	-(SP),R113		;87 61
	ST	-(SP),R13		;8F 15

	ST	(IX+IM8),R20		;88 A4 56
	ST	(IY+0),R33		;89 C1 00
	ST	(IZ+80),R39		;8A C7 50
	ST	(SP+255),R47		;8B D7 FF
	ST	(IX-IM8),R0		;8C 80 56
	ST	(IY-0),R44		;8D D4 00
	ST	(IZ-80),R55		;8E E7 50
	ST	(SP-255),R29		;8F B5 FF

	ST	(IX+R20),R110		;80 A4 C5
	ST	(IY+R33),R107		;81 C1 65
	ST	(IZ+R39),R94		;82 C7 C3
	ST	(SP+R47),R89		;83 D7 23
	ST	(IX-R0),R86		;84 80 C2
	ST	(IY-R44),R79		;85 D4 E1
	ST	(IZ-R55),R71		;86 E7 E0
	ST	(SP-R29),R68		;87 B5 80

	ST	(IX+R20),I110		;80 A4 D5
	ST	(IY+R33),I107		;81 C1 75
	ST	(IZ+R39),I94		;82 C7 D3
	ST	(SP+R47),I89		;83 D7 33
	ST	(IX-R0),I86		;84 80 D2
	ST	(IY-R44),I79		;85 D4 F1
	ST	(IZ-R55),I71		;86 E7 F0
	ST	(SP-R29),I68		;87 B5 90


; word size

	ADW	IX,IM8			;48 56
	ADW	IY,&HF3			;49 F3
	ADW	IZ,160			;4A A0
	ADW	SP,211			;4B D3
	SBW	IX,0			;4C 00
	SBW	IY,IM8+1		;4D 57
	SBW	IZ,IM8+&H2A		;4E 80
	SBW	SP,IM8+&H81		;4F D7

	LDW	IX,IM16			;40 9A BC
	LDW	IY,IM16+5		;41 9A C1
	LDW	IZ,IM16-5		;42 9A B7
	LDW	V3,&H79BD		;43 79 BD
	LDW	V2,32767		;44 7F FF
	LDW	V1,32768		;45 80 00
	LDW	V0,32769		;46 80 01
	LDW	SP,65535		;47 FF FF

	IJMP	IX			;50 70 07
	IJMP	K,IY			;51 71 27
	IJMP	LZ,IZ			;52 72 47
	IJMP	UZ,V3			;53 73 67
	IJMP	NZ,V2			;54 74 87
	IJMP	V,V1			;55 75 A7
	IJMP	H,V0			;56 76 C7
	IJMP	C,SP			;57 77 E7
	IJMP	NK,IX			;59 70 07
	IJMP	NLZ,IY			;5A 71 27
	IJMP	NUZ,I122,R58		;5B 72 57
	IJMP	Z,I73,R29		;5C 35 31
	IJMP	NV,R100,R10		;5D 12 84
	IJMP	NH,R85,R31		;5E 37 A2
	IJMP	NC,R75,R52		;5F 64 61

	CAL	IM16			;60 9A BC
	CAL	K,IM16			;61 9A BC
	CAL	LZ,IM8			;62 00 56
	CAL	UZ,IM8			;63 00 56
	CAL	NZ,L1			;64 xx xx
	CAL	V,L1			;65 xx xx
	CAL	H,L1			;66 xx xx
	CAL	C,L1			;67 xx xx
	CAL	NK,L1			;69 xx xx
	CAL	NLZ,L1			;6A xx xx
	CAL	NUZ,L1			;6B xx xx
	CAL	Z,L1			;6C xx xx
	CAL	NV,L1			;6D xx xx
	CAL	NH,L1			;6E xx xx
L1:	CAL	NC,L1			;6F xx xx

	JMP	L1			;70 xx xx
	JMP	K,L1			;71 xx xx
	JMP	LZ,L1			;72 xx xx
	JMP	UZ,L1			;73 xx xx
	JMP	NZ,L1			;74 xx xx
	JMP	V,L1			;75 xx xx
	JMP	H,L1			;76 xx xx
	JMP	C,L1			;77 xx xx
	JMP	NK,L1			;79 xx xx
	JMP	NLZ,L1			;7A xx xx
	JMP	NUZ,L1			;7B xx xx
	JMP	Z,IM8			;7C 00 56
	JMP	NV,IM8			;7D 00 56
	JMP	NH,IM16			;7E 9A BC
	JMP	NC,IM16			;7F 9A BC


; multibyte

	ADBM	R10..R10,R66..R66	;18 12 40
	ADBM	R66..R66,R18..R18	;10 22 40
	SBBM	R33..R34,R97..R98	;19 41 44
	SBBM	R99..R100,R43..R44	;11 53 84
	ADM	R3..R5,R75..R77		;1A 03 A1
	ADM	R101..R103,R5..R7	;12 05 E4
	SBM	R9..R12,R81..R84	;1B 11 82
	SBM	R96..R99,R24..R27	;13 30 64
	ANM	R50..R54,R114..R118	;1C 62 C6
	ANM	R83..R87,R51..R55	;14 63 E2
	NAM	R2..R7,R66..R71		;1D 02 E0
	NAM	R65..R70,R33..R38	;15 41 C0
	ORM	R16..R22,R72..R78	;1E 20 C1
	ORM	R105..R111,R9..R15	;16 11 E5
	XRM	R40..R47,R104..R111	;1F 50 E5
	XRM	R80..R87,R8..R15	;17 10 E2

	ADBM	R10..R10,I66..I66	;18 12 50
	ADBM	I66..I66,R18..R18	;10 22 50
	SBBM	R33..R34,I97..I98	;19 41 54
	SBBM	I99..I100,R43..R44	;11 53 94
	ADM	R3..R5,I75..I77		;1A 03 B1
	ADM	I101..I103,R5..R7	;12 05 F4
	SBM	R9..R12,I81..I84	;1B 11 92
	SBM	I96..I99,R24..R27	;13 30 74
	ANM	R50..R54,I114..I118	;1C 62 D6
	ANM	I83..I87,R51..R55	;14 63 F2
	NAM	R2..R7,I66..I71		;1D 02 F0
	NAM	I65..I70,R33..R38	;15 41 D0
	ORM	R16..R22,I72..I78	;1E 20 D1
	ORM	I105..I111,R9..R15	;16 11 F5
	XRM	R40..R47,I104..I111	;1F 50 F5
	XRM	I80..I87,R8..R15	;17 10 F2

	TADBM	R10..R10,R66..R66	;38 12 40
	TADBM	R66..R66,R18..R18	;30 22 40
	TSBBM	R33..R34,R97..R98	;39 41 44
	TSBBM	R99..R100,R43..R44	;31 53 84
	TADM	R3..R5,R75..R77		;3A 03 A1
	TADM	R101..R103,R5..R7	;32 05 E4
	TSBM	R9..R12,R81..R84	;3B 11 82
	TSBM	R96..R99,R24..R27	;33 30 64
	TANM	R50..R54,R114..R118	;3C 62 C6
	TANM	R83..R87,R51..R55	;34 63 E2
	TNAM	R2..R7,R66..R71		;3D 02 E0
	TNAM	R65..R70,R33..R38	;35 41 C0
	TORM	R16..R22,R72..R78	;3E 20 C1
	TORM	R105..R111,R9..R15	;36 11 E5
	TXRM	R40..R47,R104..R111	;3F 50 E5
	TXRM	R80..R87,R8..R15	;37 10 E2

	TADBM	R10..R10,I66..I66	;38 12 50
	TADBM	I66..I66,R18..R18	;30 22 50
	TSBBM	R33..R34,I97..I98	;39 41 54
	TSBBM	I99..I100,R43..R44	;31 53 94
	TADM	R3..R5,I75..I77		;3A 03 B1
	TADM	I101..I103,R5..R7	;32 05 F4
	TSBM	R9..R12,I81..I84	;3B 11 92
	TSBM	I96..I99,R24..R27	;33 30 74
	TANM	R50..R54,I114..I118	;3C 62 D6
	TANM	I83..I87,R51..R55	;34 63 F2
	TNAM	R2..R7,I66..I71		;3D 02 F0
	TNAM	I65..I70,R33..R38	;35 41 D0
	TORM	R16..R22,I72..I78	;3E 20 D1
	TORM	I105..I111,R9..R15	;36 11 F5
	TXRM	R40..R47,I104..I111	;3F 50 F5
	TXRM	I80..I87,R8..R15	;37 10 F2

	ADBM	R14..R14,1		;18 9E C1
	ADBM	R91..R92,0		;10 BB 80
	SBBM	R17..R20,&H0C		;19 A9 8C
	SBBM	R90..R92,6		;11 BA 86
	ADM	R24..R28,25		;1A B8 99
	ADM	R81..R87,&H2E		;12 A1 EE
	SBM	R25..R30,56		;1B B1 D8
	SBM	R104..R111,&H39		;13 D0 F9

	TADBM	R14..R14,1		;38 9E C1
	TADBM	R91..R92,0		;30 BB 80
	TSBBM	R17..R20,&H0C		;39 A9 8C
	TSBBM	R90..R92,6		;31 BA 86
	TADM	R24..R28,25		;3A B8 99
	TADM	R81..R87,&H2E		;32 A1 EE
	TSBM	R25..R30,56		;3B B1 D8
	TSBM	R104..R111,&H39		;33 D0 F9

	LDLEM	R14..R14,1		;DC 9E C1
	LDLEM	R91..R92,0		;D4 BB 80
	LDLOM	R17..R20,&H0C		;DD A9 8C
	LDLOM	R90..R92,6		;D5 BA 86
	STLEM	R24..R28,25		;DE B8 99
	STLEM	R81..R87,&H2E		;D6 A1 EE
	STLOM	R25..R30,56		;DF B1 D8
	STLOM	R104..R111,&H39		;D7 D0 F9

	SWPM	R99..R100,R43..R44	;15 D3 84
	SWPM	R43..R44,R99..R100	;15 D3 84
	XCM	R101..R103,R5..R7	;1D 85 E4
	XCM	R5..R7,R101..R103	;1D 85 E4
	XCLSM	R96..R99,R24..R27	;17 B0 64
	XCLSM	R24..R27,R96..R99	;1F B0 64
	XCHSM	R83..R87,R51..R55	;1F E3 E2
	XCHSM	R51..R55,R83..R87	;17 E3 E2

	SWPM	I99..I100,R43..R44	;15 D3 94
	SWPM	R43..R44,I99..I100	;15 D3 94
	XCM	I101..I103,R5..R7	;1D 85 F4
	XCM	R5..R7,I101..I103	;1D 85 F4
	XCLSM	I96..I99,R24..R27	;17 B0 74
	XCLSM	R24..R27,I96..I99	;1F B0 74
	XCHSM	I83..I87,R51..R55	;1F E3 F2
	XCHSM	R51..R55,I83..I87	;17 E3 F2

	LDM	R16..R22,R72..R78	;5D A0 C1
	LDM	R105..R111,R9..R15	;55 91 E5
	LDM	R16..R22,I72..I78	;5D A0 D1
	LDM	I105..I111,R9..R15	;55 91 F5

	LDM	R24..R28,25		;5F B8 99
	LDM	R81..R87,&H2E		;57 A1 EE

	LDM	R90..R90,(IX)+		;B0 32 40
	LDM	R20..R21,(IX)+		;B8 24 A0
	LDM	R100..R102,(IY)+	;B1 44 C0
	LDM	R33..R36,(IY)+		;B9 41 80
	LDM	R75..R79,(IZ)+		;B2 13 E0
	LDM	R48..R53,(IZ)+		;BA 60 A0
	LDM	R89..R95,(SP)+		;B3 31 E0
	LDM	R40..R47,(SP)+		;BB 50 E0
	LDM	R111..R104,(IX)-	;B4 57 00
	LDM	R7..R1,(IX)-		;BC 07 20
	LDM	R78..R73,(IY)-		;B5 16 20
	LDM	R47..R43,(IY)-		;BD 57 60
	LDM	R85..R82,(IZ)-		;B6 25 40
	LDM	R27..R25,(IZ)-		;BE 33 20
	LDM	R114..R113,(SP)-	;B7 62 20
	LDM	R13..R13,(SP)-		;BF 15 A0

	LDM	R90..R90,(IX+R2)	;B0 82 43
	LDM	R100..R102,(IY+R12)	;B1 94 C4
	LDM	R75..R79,(IZ+R19)	;B2 A3 E1
	LDM	R89..R95,(SP+R25)	;B3 B1 E3
	LDM	R111..R104,(IX-R39)	;B4 C7 05
	LDM	R78..R73,(IY-R46)	;B5 D6 21
	LDM	R85..R82,(IZ-R53)	;B6 E5 42
	LDM	R114..R113,(SP-R58)	;B7 F2 26

	LDM	R20..R21,(IX+0)		;B8 AC A0
	LDM	R33..R36,(IY+20)	;B9 C9 94
	LDM	R48..R53,(IZ+40)	;BA E0 A8
	LDM	R40..R47,(SP+&H32)	;BB D0 F2
	LDM	R7..R1,(IX-60)		;BC 87 3C
	LDM	R47..R43,(IY-&H2C)	;BD D7 6C
	LDM	R27..R25,(IZ-&H17)	;BE BB 37
	LDM	R13..R13,(SP-&H01)	;BF 9D A1

	STM	+(IX),R90..R90		;90 32 40
	STM	+(IX),R20..R21		;98 24 A0
	STM	+(IY),R100..R102	;91 44 C0
	STM	+(IY),R33..R36		;99 41 80
	STM	+(IZ),R75..R79		;92 13 E0
	STM	+(IZ),R48..R53		;9A 60 A0
	STM	+(SP),R89..R95		;93 31 E0
	STM	+(SP),R40..R47		;9B 50 E0
	STM	-(IX),R111..R104	;94 57 00
	STM	-(IX),R7..R1		;9C 07 20
	STM	-(IY),R78..R73		;95 16 60
	STM	-(IY),R47..R43		;9D 57 60
	STM	-(IZ),R85..R82		;96 25 40
	STM	-(IZ),R27..R25		;9E 33 20
	STM	-(SP),R114..R113	;97 62 20
	STM	-(SP),R13..R13		;9F 15 A0

	STM	(IX+R2),R90..R90	;90 82 43
	STM	(IY+R12),R100..R102	;91 94 C4
	STM	(IZ+R19),R75..R79	;92 A3 E1
	STM	(SP+R25),R89..R95	;93 B1 E3
	STM	(IX-R39),R111..R104	;94 C7 05
	STM	(IY-R46),R78..R73	;95 D6 61
	STM	(IZ-R53),R85..R82	;96 E5 42
	STM	(SP-R58),R114..R113	;97 F2 26

	STM	(IX+0),R20..R21		;98 AC A0
	STM	(IY+20),R33..R36	;99 C9 94
	STM	(IZ+40),R48..R53	;9A E0 A8
	STM	(SP+&H32),R40..R47	;9B D0 F2
	STM	(IX-60),R7..R1		;9C 87 3C
	STM	(IY-&H2C),R47..R43	;9D D7 6C
	STM	(IZ-&H17),R27..R25	;9E BB 37
	STM	(SP-1),R13..R13		;9F 9D A1

	CMPM	R10..R10		;E9 12 40
	CMPM	R83..R87		;E1 03 E2
	BYUM	R33..R34		;EB 41 40
	BYUM	R65..R70		;E3 01 C0
	DIUM	R3..R5			;ED 03 A0
	DIUM	R105..R111		;E5 01 E5
	ROUM	R9..R12			;EF 11 80
	ROUM	R80..R87		;E7 00 E2
	INVM	R40..R47		;F9 50 E0
	INVM	R96..R99		;F1 00 64
	BIUM	R10..R10		;FC 92 40
	BIUM	R83..R87		;F4 83 E2

	BYDM	R22..R16		;FB 26 00
	BYDM	R103..R101		;F3 07 A4
	DIDM	R54..R50		;FD 66 40
	DIDM	R66..R66		;F5 02 40
	RODM	R37..R33		;FF 45 20
	RODM	R77..R75		;F7 05 61

	CMPM	I83..I87		;E1 03 F2
	BYUM	I65..I70		;E3 01 D0
	DIUM	I105..I111		;E5 01 F5
	ROUM	I80..I87		;E7 00 F2
	INVM	I96..I99		;F1 00 74
	BIUM	I83..I87		;F4 83 F2

	BYDM	I103..I101		;F3 07 B4
	DIDM	I66..I66		;F5 02 50
	RODM	I77..I75		;F7 05 71

	CMPBM	R2..R7			;FC 02 E0
	CMPBM	R99..R100		;F4 43 80
	MTBM	R33..R36		;FE C1 80
	MTBM	R77..R79		;F6 95 E0

	SUP	R100			;34 C4
	SDN	R10			;3C 92

	BNUSM	R19..R23		;F8 A3 E0
	BNUSM	R81..R83		;F0 81 62
	BNUSM	I81..I83		;F0 81 72

	OFF				;50 80
	TRP				;FF 80
