; Instruction set test for the Casio microprocessor NM-326 / uPD3055 / HD62076

IM8	EQU	&H56
IM16	EQU	&H9ABC

	ORG	&H7824

L1:	SJMP	NK,L1			;E0 24
	SJMP	NLZ,L1			;E1 24
	SJMP	NUZ,L1			;E2 24
	SJMP	NZ,L1			;E3 24
	SJMP	NV,L1			;E4 24
	SJMP	NH,L1			;E5 24
	SJMP	NC,L1			;E6 24
	SJMP	L1			;E7 24
	SJMP	K,L1			;E8 24
	SJMP	LZ,L1			;E9 24
	SJMP	UZ,L1			;EA 24
	SJMP	Z,L1			;EB 24
	SJMP	V,L1			;EC 24
	SJMP	H,L1			;ED 24
	SJMP	C,L1			;EE 24

	NOP				;EF

	SCAL	NK,L1			;F0 24
	SCAL	NLZ,L1			;F1 24
	SCAL	NUZ,L1			;F2 24
	SCAL	NZ,L1			;F3 24
	SCAL	NV,L1			;F4 24
	SCAL	NH,L1			;F5 24
	SCAL	NC,L1			;F6 24
	SCAL	L1			;F7 24
	SCAL	K,L1			;F8 24
	SCAL	LZ,L1			;F9 24
	SCAL	UZ,L1			;FA 24
	SCAL	Z,L1			;FB 24
	SCAL	V,L1			;FC 24
	SCAL	H,L1			;FD 24
	SCAL	C,L1			;FE 24

	TRP				;FF

	TNA	R10,R80			;00 10 41
	NA	R56,R100		;00 A4 07
	TXR	R32,R95			;01 1F 04
	XR	R99,R44			;01 E3 85
	TSBB	R1,R82			;02 12 20
	SBB	R3,R84			;02 94 60
	TSB	R85,R6			;03 55 C0
	SB	R97,R8			;03 E1 01
	TAN	R50,R109		;04 2D 46
	AN	R108,R47		;04 EC E5
	TOR	R5,R66			;05 02 A0
	OR	R7,R68			;05 84 E0
	TADB	R100,R49		;06 64 26
	ADB	R18,R97			;06 A1 42
	TAD	R7,R67			;07 03 E0
	AD	R67,R7			;07 C3 E0

	TNA	I10,R80			;00 10 51
	NA	I56,R100		;00 A4 17
	TXR	I32,R95			;01 1F 14
	XR	R99,I44			;01 E3 95
	TSBB	I1,R82			;02 12 30
	SBB	I3,R84			;02 94 70
	TSB	R85,I6			;03 55 D0
	SB	R97,I8			;03 E1 11
	TAN	I50,R109		;04 2D 56
	AN	R108,I47		;04 EC F5
	TOR	I5,R66			;05 02 B0
	OR	I7,R68			;05 84 F0
	TADB	R100,I49		;06 64 36
	ADB	I18,R97			;06 A1 52
	TAD	I7,R67			;07 03 F0
	AD	R67,I7			;07 C3 F0

	TNA	R10,IM8			;08 0A 56
	NA	R56,&HF3		;08 B8 F3
	TXR	R32,160			;09 20 A0
	XR	R99,211			;09 E3 D3
	TSBB	R1,0			;0A 01 00
	SBB	R3,IM8+1		;0A 83 57
	TSB	R85,IM8+&H2A		;0B 55 80
	SB	R97,IM8+&H81		;0B E1 D7
	TAN	R50,IM8-1		;0C 32 55
	AN	R108,IM8-90		;0C EC FC
	TOR	R5,IM8+128		;0D 05 D6
	OR	R7,IM8-253		;0D 87 59
	TADB	R100,10			;0E 64 0A
	ADB	R18,16			;0E 92 10
	TAD	R7,88			;0F 07 58
	AD	R67,99			;0F C3 63

	TNAM	R10..R10,R66..R66	;10 02 41
	NAM	R66..R66,R18..R18	;10 C2 42
	TXRM	R33..R34,R97..R98	;11 21 44
	XRM	R99..R100,R43..R44	;11 E3 85
	TSBBM	R101..R103,R5..R7	;12 65 E0
	SBBM	R3..R5,R75..R77		;12 8B A0
	TSBM	R96..R99,R24..R27	;13 60 63
	SBM	R9..R12,R81..R84	;13 91 81
	TANM	R50..R54,R114..R118	;14 32 C6
	ANM	R83..R87,R51..R55	;14 D3 E6
	TORM	R2..R7,R66..R71		;15 02 E0
	ORM	R65..R70,R33..R38	;15 C1 C4
	TADBM	R105..R111,R9..R15	;16 69 E1
	ADBM	R16..R22,R72..R78	;16 88 C2
	TADM	R80..R87,R8..R15	;17 50 E1
	ADM	R40..R47,R104..R111	;17 A8 E5

	TNAM	I10..I10,R66..R66	;10 02 51
	NAM	R66..R66,I18..I18	;10 C2 52
	TXRM	I33..I34,R97..R98	;11 21 54
	XRM	R99..R100,I43..I44	;11 E3 95
	TSBBM	R101..R103,I5..I7	;12 65 F0
	SBBM	I3..I5,R75..R77		;12 8B B0
	TSBM	R96..R99,I24..I27	;13 60 73
	SBM	I9..I12,R81..R84	;13 91 91
	TANM	I50..I54,R114..R118	;14 32 D6
	ANM	R83..R87,I51..I55	;14 D3 F6
	TORM	I2..I7,R66..R71		;15 02 F0
	ORM	R65..R70,I33..I38	;15 C1 D4
	TADBM	R105..R111,I9..I15	;16 69 F1
	ADBM	I16..I22,R72..R78	;16 88 D2
	TADM	R80..R87,I8..I15	;17 50 F1
	ADM	I40..I47,R104..R111	;17 A8 F5

	PLA	IX			;18 38 07
	PLA	IY			;18 39 27
	PLA	IZ			;18 3A 47
	PLA	V3			;18 3B 67
	PLA	V2			;18 3C 87
	PLA	V1			;18 3D A7
	PLA	V0			;18 3E C7
	PLA	SP			;18 3F E7
	PLA	R122,R44		;18 3A 85
	PLA	R122,I44		;18 3A 95

	IJMP	IX			;18 B8 07
	IJMP	IY			;18 B9 27
	IJMP	IZ			;18 BA 47
	IJMP	V3			;18 BB 67
	IJMP	V2			;18 BC 87
	IJMP	V1			;18 BD A7
	IJMP	V0			;18 BE C7
	IJMP	SP			;18 BF E7
	IJMP	R122,R44		;18 BA 85
	IJMP	R122,I44		;18 BA 95

	BIT	R10,R100		;19 24 41
	BIT	R90,R41			;19 5A 25
	BIT	I10,R100		;19 24 51
	BIT	R90,I41			;19 5A 35
	BIT	R35,IM8			;19 A3 56
	BIT	R105,127		;19 E9 7F

	SBBM	R44..R46,&H1A		;1A AC DA
	TSBBM	R97..R101,&H09		;1A 61 A9
	SBM	R75..R79,25		;1B CB F9
	TSBM	R24..R31,11		;1B 18 EB

	SDN	R84,R50			;1C 54 46
	SDN	R84,I50			;1C 54 56
	SUP	R93,R39			;1C DD E4
	SUP	R93,I39			;1C DD F4

	LD	R39,IM8			;20 A7 56
	LD	R86,IM8			;20 D6 56
	LD	R39,R103,IM8		;20 27 56
	LD	R86,R22,IM8		;20 56 56

	XC	R44,R99			;21 23 85
	XC	R99,R44			;21 63 85
	LD	R15,R70			;21 86 E1
	LD	R70,R15			;21 C6 E1
	SWP	R30,R88			;24 18 C3
	SWP	R88,R30			;24 58 C3
	SWP	R40			;24 80 05
	SWP	R90			;24 DA 00
	XCS	R55,R66			;25 02 E6
	XCS	R66,R55			;25 42 E6
	LDS	R1,R100			;25 A4 20
	LDS	R100,R1			;25 E4 20

	XC	I44,R99			;21 23 95
	XC	R99,I44			;21 63 95
	LD	I15,R70			;21 86 F1
	LD	R70,I15			;21 C6 F1
	SWP	I30,R88			;24 18 D3
	SWP	R88,I30			;24 58 D3
	SWP	I40			;24 80 15
	XCS	I55,R66			;25 02 F6
	XCS	R66,I55			;25 42 F6
	LDS	I1,R100			;25 A4 30
	LDS	R100,I1			;25 E4 30

	TSBBC	R22,R90			;22 1A C2
	SBBC	R107,R50		;22 EB 46
	TSBC	R85,R10			;23 55 41
	SBC	R20,R77			;23 8D 82
	TADBC	R2,R101			;26 25 40
	ADBC	R102,R3			;26 E6 60
	TADC	R103,R4			;27 67 80
	ADC	R5,R104			;27 A8 A0

	TSBBC	I22,R90			;22 1A D2
	SBBC	R107,I50		;22 EB 56
	TSBC	R85,I10			;23 55 51
	SBC	I20,R77			;23 8D 92
	TADBC	I2,R101			;26 25 50
	ADBC	R102,I3			;26 E6 70
	TADC	R103,I4			;27 67 90
	ADC	I5,R104			;27 A8 B0

	XCL	R6,R99			;28 23 C0
	XCH	R98,R7			;28 62 E0
	LDL	R8,R97			;28 A1 01
	LDH	R96,R9			;28 E0 21
	XCH	R20,R86			;2D 16 82
	XCL	R85,R21			;2D 55 A2
	LDH	R22,R85			;2D 95 C2
	LDL	R84,R23			;2D D4 E2

	XCL	I6,R99			;28 23 D0
	XCH	R98,I7			;28 62 F0
	LDL	I8,R97			;28 A1 11
	LDH	R96,I9			;28 E0 31
	XCH	I20,R86			;2D 16 92
	XCL	R85,I21			;2D 55 B2
	LDH	I22,R85			;2D 95 D2
	LDL	R84,I23			;2D D4 F2

	XCHS	R10,R95			;29 1F 41
	XCLS	R94,R11			;29 5E 61
	LDHS	R12,R93			;29 9D 81
	LDLS	R92,R13			;29 DC A1
	XCLS	R16,R89			;2C 19 02
	XCHS	R88,R17			;2C 58 22
	LDLS	R18,R87			;2C 97 42
	LDHS	R86,R19			;2C D6 62

	XCHS	I10,R95			;29 1F 51
	XCLS	R94,I11			;29 5E 71
	LDHS	I12,R93			;29 9D 91
	LDLS	R92,I13			;29 DC B1
	XCLS	I16,R89			;2C 19 12
	XCHS	R88,I17			;2C 58 32
	LDLS	I18,R87			;2C 97 52
	LDHS	R86,I19			;2C D6 72

	TSBBC	R14,IM8			;2A 0E 56
	SBBC	R91,100			;2A DB 64
	TSBC	R90,6			;2B 5A 06
	SBC	R15,&HAC		;2B 8F AC
	TADBC	R24,IM8			;2E 18 56
	ADBC	R25,&H51		;2E 99 51
	TADC	R83,&HDE		;2F 53 DE
	ADC	R82,&HB9		;2F D2 B9

	LDM	R25..R26,R89..R90,&H1A	;30 19 5A
	LDM	R89..R90,R25..R26,&H1A	;30 59 5A
	LDM	R75..R76,9		;30 CB 89

	XCM	R74..R74,R26..R26	;31 4A 43
	XCM	R26..R26,R74..R74	;31 0A 43
	LDM	R75..R76,R27..R28	;31 CB 83
	LDM	R27..R28,R75..R76	;31 8B 83
	TSBBCM	R28..R30,R76..R78	;32 0C C3
	SBBCM	R80..R83,R32..R35	;32 D0 64
	TSBCM	R33..R37,R81..R85	;33 11 A4
	SBCM	R82..R87,R34..R39	;33 D2 E4
	SWPM	R99..R101,R51..R53	;34 63 A6
	SWPM	R51..R53,R99..R101	;34 23 A6
	SWPM	R99..R101		;34 E3 A0
	SWPM	R33..R35		;34 81 64
	XCSM	R83..R86,R43..R46	;35 53 C5
	XCSM	R43..R46,R83..R86	;35 13 C5
	LDSM	R9..R13,R113..R117	;35 B1 A1
	TADBCM	R114..R119,R10..R15	;36 72 E1
	ADBCM	R16..R22,R112..R118	;36 B0 C2
	TADCM	R104..R111,R24..R31	;37 68 E3
	ADCM	R25..R25,R105..R105	;37 A9 23

	XCM	R74..R74,I26..I26	;31 4A 53
	XCM	I26..I26,R74..R74	;31 0A 53
	LDM	R75..R76,I27..I28	;31 CB 93
	LDM	I27..I28,R75..R76	;31 8B 93
	TSBBCM	I28..I30,R76..R78	;32 0C D3
	SBBCM	R80..R83,I32..I35	;32 D0 74
	TSBCM	I33..I37,R81..R85	;33 11 B4
	SBCM	R82..R87,I34..I39	;33 D2 F4
	SWPM	R99..R101,I51..I53	;34 63 B6
	SWPM	I51..I53,R99..R101	;34 23 B6
	SWPM	I33..I35		;34 81 74
	XCSM	R83..R86,I43..I46	;35 53 D5
	XCSM	I43..I46,R83..R86	;35 13 D5
	LDSM	I9..I13,R113..R117	;35 B1 B1
	TADBCM	R114..R119,I10..I15	;36 72 F1
	ADBCM	I16..I22,R112..R118	;36 B0 D2
	TADCM	R104..R111,I24..I31	;37 68 F3
	ADCM	I25..I25,R105..R105	;37 A9 33

	XCLM	R3..R3,R99..R99		;38 23 60
	XCHM	R97..R98,R9..R10	;38 61 41
	LDLM	R12..R14,R100..R102	;38 A4 C1
	LDHM	R83..R86,R51..R54	;38 D3 C6
	XCHM	R50..R54,R74..R78	;3D 0A C6
	XCLM	R65..R70,R33..R38	;3D 41 C4
	LDHM	R40..R46,R72..R78	;3D 88 C5
	LDLM	R88..R95,R24..R31	;3D D8 E3

	XCLM	I3..I3,R99..R99		;38 23 70
	XCHM	R97..R98,I9..I10	;38 61 51
	LDLM	I12..I14,R100..R102	;38 A4 D1
	LDHM	R83..R86,I51..I54	;38 D3 D6
	XCHM	I50..I54,R74..R78	;3D 0A D6
	XCLM	R65..R70,I33..I38	;3D 41 D4
	LDHM	I40..I46,R72..R78	;3D 88 D5
	LDLM	R88..R95,I24..I31	;3D D8 F3

	XCHSM	R37..R37,R101..R101	;39 25 A4
	XCLSM	R102..R103,R14..R15	;39 66 E1
	LDHSM	R34..R36,R106..R108	;39 AA 84
	LDLSM	R107..R110,R51..R54	;39 EB C6
	XCLSM	R17..R21,R89..R93	;3C 19 A2
	XCHSM	R90..R95,R18..R23	;3C 5A E2
	LDLSM	R48..R54,R88..R94	;3C 98 C6
	LDHSM	R96..R103,R32..R39	;3C E0 E4

	XCHSM	I37..I37,R101..R101	;39 25 B4
	XCLSM	R102..R103,I14..I15	;39 66 F1
	LDHSM	I34..I36,R106..R108	;39 AA 94
	LDLSM	R107..R110,I51..I54	;39 EB D6
	XCLSM	I17..I21,R89..R93	;3C 19 B2
	XCHSM	R90..R95,I18..I23	;3C 5A F2
	LDLSM	I48..I54,R88..R94	;3C 98 D6
	LDHSM	R96..R103,I32..I39	;3C E0 F4

	TSBBCM	R14..R14,1		;3A 0E C1
	SBBCM	R91..R92,0		;3A DB 80
	TSBCM	R90..R92,6		;3B 5A 86
	SBCM	R17..R20,&H0C		;3B 91 8C
	TADBCM	R24..R28,15		;3E 18 8F
	ADBCM	R25..R30,16		;3E 99 D0
	TADCM	R81..R87,&H1E		;3F 51 FE
	ADCM	R104..R111,&H19		;3F E8 F9

	TNA	(IX),R0			;40 40
	NA	(IX),R10		;40 CA
	TXR	(IX),R20		;41 54
	XR	(IX),R30		;41 DE
	TSBB	(IX),R40		;42 68
	SBB	(IX),R50		;42 F2
	TSB	(IX),R60		;43 7C
	SB	(IX),R70		;43 86
	TAN	(IX),R80		;44 10
	AN	(IX),R90		;44 9A
	TOR	(IX),R100		;45 24
	OR	(IX),R110		;45 AE
	TADB	(IX),R120		;46 38
	ADB	(IX),R14		;46 CE
	TAD	(IX),R41		;47 69
	AD	(IX),R7			;47 C7

	NA	(IX),IM8		;48 56
	XR	(IX),50			;49 32
	SBB	(IX),&H50		;4A 50
	SB	(IX),-70		;4B BA
	AN	(IX),&H9A		;4C 9A
	OR	(IX),111		;4D 6F
	ADB	(IX),200		;4E C8
	AD	(IX),&HE5		;4F E5

	TNA	(IY),R0			;50 40
	NA	(IY),R10		;50 CA
	TXR	(IY),R20		;51 54
	XR	(IY),R30		;51 DE
	TSBB	(IY),R40		;52 68
	SBB	(IY),R50		;52 F2
	TSB	(IY),R60		;53 7C
	SB	(IY),R70		;53 86
	TAN	(IY),R80		;54 10
	AN	(IY),R90		;54 9A
	TOR	(IY),R100		;55 24
	OR	(IY),R110		;55 AE
	TADB	(IY),R120		;56 38
	ADB	(IY),R14		;56 CE
	TAD	(IY),R41		;57 69
	AD	(IY),R7			;57 C7

	NA	(IY),IM8		;58 56
	XR	(IY),50			;59 32
	SBB	(IY),&H50		;5A 50
	SB	(IY),-70		;5B BA
	AN	(IY),&H9A		;5C 9A
	OR	(IY),111		;5D 6F
	ADB	(IY),200		;5E C8
	AD	(IY),&HE5		;5F E5

	ROD	R0			;60 00
	ROU	R70			;60 C6
	DID	R75			;61 4B
	DIU	R50			;61 B2
	TCMPB	R45			;62 2D
	CMPB	R89			;62 D9
	TCMP	R90			;63 5A
	CMP	R44			;63 AC
	BYD	R100			;64 64
	BYU	R50			;64 B2
	BND	R25			;65 19
	BNU	R75			;65 CB
	TMTB	R10			;66 0A
	MTB	R105			;66 E9
	TBIU	R106			;67 6A	
	BIU	R20			;67 94

	ST	-(IX),R0		;68 00
	ST	-(IX),R101		;68 65
	ST	-(IY),R44		;69 2C
	ST	-(IY),R75		;69 4B
	ST	-(IZ),R85		;6A 55
	ST	-(IZ),R25		;6A 19
	ST	-(SP),R113		;6B 71
	ST	-(SP),R11		;6B 0B
	ST	+(IX),R90		;6C 5A
	ST	+(IX),R20		;6C 14
	ST	+(IY),R100		;6D 64
	ST	+(IY),R33		;6D 21
	ST	+(IZ),R78		;6E 4E
	ST	+(IZ),R48		;6E 30
	ST	+(SP),R87		;6F 57
	ST	+(SP),R52		;6F 34

	LD	R0,(IX)-		;68 80
	LD	R101,(IX)-		;68 E5
	LD	R75,(IY)-		;69 CB
	LD	R44,(IY)-		;69 AC
	LD	R85,(IZ)-		;6A D5
	LD	R25,(IZ)-		;6A 99
	LD	R113,(SP)-		;6B F1
	LD	R13,(SP)-		;6B 8D
	LD	R90,(IX)+		;6C DA
	LD	R20,(IX)+		;6C 94
	LD	R100,(IY)+		;6D E4
	LD	R33,(IY)+		;6D A1
	LD	R78,(IZ)+		;6E CE
	LD	R48,(IZ)+		;6E B0
	LD	R87,(SP)+		;6F D7
	LD	R52,(SP)+		;6F B4

	RODM	R0..R0			;70 00 00
	ROUM	R70..R71		;70 C6 E0
	DIDM	R75..R77		;71 4B A0
	DIUM	R50..R53		;71 82 A6 
	TCMPBM	R42..R46		;72 02 C5
	CMPBM	R89..R94		;72 D9 C0
	TCMPM	R89..R95		;73 59 E0
	CMPM	R40..R47		;73 80 E5
	BYDM	R100..R100		;74 64 80
	BYUM	R50..R51		;74 82 66
	BNDM	R25..R27		;75 01 63
	BNUM	R75..R78		;75 CB C0
	TMTBM	R10..R14		;76 02 C1
	MTBM	R105..R110		;76 E9 C0
	TBIUM	R104..R110		;77 68 C0	
	BIUM	R24..R31		;77 80 E3

	RODM	I0..I0			;70 00 10
	ROUM	I10..I13		;70 82 B1
	DIDM	I50..I53		;71 02 B6
	DIUM	I50..I53		;71 82 B6 
	TCMPBM	I42..I46		;72 02 D5
	CMPBM	I42..I46		;72 82 D5
	TCMPM	I40..I47		;73 00 F5
	CMPM	I40..I47		;73 80 F5
	BYDM	I50..I51		;74 02 76
	BYUM	I50..I51		;74 82 76
	BNDM	I25..I27		;75 01 73
	BNUM	I25..I27		;75 81 73
	TMTBM	I10..I14		;76 02 D1
	MTBM	I10..I14		;76 82 D1
	TBIUM	I24..I31		;77 00 F3	
	BIUM	I24..I31		;77 80 F3

	STM	-(IX),R0..R0		;78 00 00
	STM	-(IY),R44..R43		;79 04 65
	STM	-(IZ),R85..R83		;7A 55 60
	STM	-(SP),R116..R113	;7B 74 20
	STM	+(IX),R19..R23		;7C 03 E2 
	STM	+(IY),R33..R38		;7D 01 C4
	STM	+(IZ),R81..R87		;7E 51 E0
	STM	+(SP),R72..R79		;7F 48 E0

	STLM	-(IX),R0..R0		;78 00 08
	STLM	-(IY),R44..R43		;79 04 6D
	STLM	-(IZ),R85..R83		;7A 55 68
	STLM	-(SP),R116..R113	;7B 74 28
	STLM	+(IX),R19..R23		;7C 03 EA 
	STLM	+(IY),R33..R38		;7D 01 CC
	STLM	+(IZ),R81..R87		;7E 51 E8
	STLM	+(SP),R72..R79		;7F 48 E8

	LDM	R1..R1,(IX)-		;78 81 20
	LDM	R44..R43,(IY)-		;79 84 65
	LDM	R85..R83,(IZ)-		;7A D5 60
	LDM	R116..R113,(SP)-	;7B F4 20
	LDM	R19..R23,(IX)+		;7C 83 E2
	LDM	R33..R38,(IY)+		;7D 81 C4
	LDM	R81..R87,(IZ)+		;7E D1 E0
	LDM	R72..R79,(SP)+		;7F C8 E0

	ST	(IX-IM8),R0		;80 00 55
	ST	(IY-1),R44		;81 2C 00
	ST	(IZ-80),R85		;82 55 4F
	ST	(SP-256),R113		;83 71 FF
	ST	(IX+IM8),R20		;84 14 55
	ST	(IY+1),R33		;85 21 00
	ST	(IZ+80),R78		;86 4E 4F
	ST	(SP+256),R87		;87 57 FF

	LD	R0,(IX-IM8)		;80 80 56
	LD	R44,(IY-0)		;81 AC 00
	LD	R85,(IZ-&H50)		;82 D5 50
	LD	R113,(SP-&HFF)		;83 F1 FF
	LD	R20,(IX+IM8)		;84 94 56
	LD	R33,(IY+0)		;85 A1 00
	LD	R78,(IZ+&H50)		;86 CE 50
	LD	R87,(SP+&HFF)		;87 D7 FF

	PST	IE,IM8			;88 56
	PST	DS,&HF3			;89 F3
	PST	KY,&H41			;8A 41
	PST	PD,&H82			;8B 82
	PST	S4,100			;8C 64
	PST	S8,100			;8C E4
	PST	S5,&H7C			;8D 7C
	PST	AS,&H7C			;8D FC
	PST	S6,&H26			;8E 26
	PST	TM,&H26			;8E A6
	PST	S7,&H37			;8F 37
	PST	PE,&H37			;8F B7

	STM	(IX-5),R2..R2		;90 02 44
	STM	(IY-1),R44..R43		;91 2C 60
	STM	(IZ-&H0E),R85..R83	;92 55 6D
	STM	(SP-&H20),R116..R113	;93 74 3F
	STM	(IX+7),R19..R23		;94 13 E6
	STM	(IY+1),R33..R38		;95 21 C0
	STM	(IZ+&H18),R81..R87	;96 51 F7
	STM	(SP+32),R72..R79	;97 48 FF

	LDM	R3..R3,(IX-3)		;90 83 63
	LDM	R44..R43,(IY-0)		;91 AC 60
	LDM	R85..R83,(IZ-&H05)	;92 D5 65
	LDM	R116..R113,(SP-&H11)	;93 F4 31
	LDM	R19..R23,(IX+5)		;94 93 E5
	LDM	R33..R38,(IY+&H00)	;95 A1 C0
	LDM	R81..R87,(IZ+&H05)	;96 D1 E5
	LDM	R72..R79,(SP+&H11)	;97 C8 F1

	PST	IE,R22			;98 16
	PST	IE,R99			;98 63
	GST	R14,IE			;98 8E
	GST	R84,IE			;98 D4
	PST	DS,R13			;99 0D
	PST	DS,R77			;99 4D
	GST	R16,DS			;99 90
	GST	R86,DS			;99 D6
	PST	KY,R40			;9A 28
	PST	KY,R105			;9A 69
	GST	R10,KY			;9A 8A
	GST	R80,KY			;9A D0
	PST	PD,R55			;9B 37
	PST	PD,R70			;9B 46
	GST	R52,PD			;9B B4
	GST	R68,PD			;9B C4
	PST	F,R31			;9C 1F
	PST	F,R100			;9C 64
	GST	R12,F			;9C 8C
	GST	R82,F			;9C D2
	PST	AS,R18			;9D 12
	PST	AS,R88			;9D 58
	GST	R20,AS			;9D 94
	GST	R90,AS			;9D DA

	BDN	R45			;9E 2D
	BUP	R89			;9E D9

	JMP	NK,L1			;A0 78 24
	JMP	NLZ,L1			;A1 78 24
	JMP	NUZ,L1			;A2 78 24
	JMP	NZ,L1			;A3 78 24
	JMP	NV,L1			;A4 78 24
	JMP	NH,L1			;A5 78 24
	JMP	NC,L1			;A6 78 24
	JMP	L1			;A7 78 24
	JMP	K,L1			;A8 78 24
	JMP	LZ,L1			;A9 78 24
	JMP	UZ,L1			;AA 78 24
	JMP	Z,L1			;AB 78 24
	JMP	V,L1			;AC 78 24
	JMP	H,L1			;AD 78 24
	JMP	C,L1			;AE 78 24

	OFF				;AF

	CAL	NK,L1			;B0 78 24
	CAL	NLZ,L1			;B1 78 24
	CAL	NUZ,L1			;B2 78 24
	CAL	NZ,L1			;B3 78 24
	CAL	NV,L1			;B4 78 24
	CAL	NH,L1			;B5 78 24
	CAL	NC,L1			;B6 78 24
	CAL	L1			;B7 78 24
	CAL	K,L1			;B8 78 24
	CAL	LZ,L1			;B9 78 24
	CAL	UZ,L1			;BA 78 24
	CAL	Z,L1			;BB 78 24
	CAL	V,L1			;BC 78 24
	CAL	H,L1			;BD 78 24
	CAL	C,L1			;BE 78 24

	WAIT				;BF

	RTN	NK			;C0
	RTN	NLZ			;C1
	RTN	NUZ			;C2
	RTN	NZ			;C3
	RTN	NV			;C4
	RTN	NH			;C5
	RTN	NC			;C6
	RTN				;C7
	RTN	K			;C8
	RTN	LZ			;C9
	RTN	UZ			;CA
	RTN	Z			;CB
	RTN	V			;CC
	RTN	H			;CD
	RTN	C			;CE

	RTI				;CF

	LDW	IX,&HBFFF		;D0 BF FF
	LDW	IY,&H1234		;D1 12 34
	LDW	IZ,&H5678		;D2 56 78
	LDW	V3,IM16			;D3 9A BC
	LDW	V2,&HDEF0		;D4 DE F0
	LDW	V1,23456		;D5 5B A0
	LDW	V0,56789		;D6 DD D5
	LDW	SP,&HFEDC		;D7 FE DC

	SBW	IX,IM8			;D8 56
	SBW	IY,66			;D9 42
	SBW	IZ,127			;DA 7F
	SBW	SP,&H11			;DB 11
	ADW	IX,&H33			;DC 33
	ADW	IY,55			;DD 37
	ADW	IZ,IM8			;DE 56
	ADW	SP,0			;DF 00

	SBW	IX,R0			;D8 80
	SBW	IY,R20			;D9 94
	SBW	IZ,R40			;DA A8
	SBW	SP,R50			;DB B2
	ADW	IX,R70			;DC C6
	ADW	IY,R90			;DD DA
	ADW	IZ,R100			;DE E4
	ADW	SP,R110			;DF EE
