/* disassembler for following Casio microprocessors:
   NM-325 / uPD1037 / HD62023
   NM-326 / uPD3055 / HD62076	*/

#include <stdio.h>
#include <ctype.h>	/* isxdigit */

typedef unsigned int uint;

/* global variables */
uint loc;		/* location pointer */
#define INBUFSIZE 8
uint inbuf[INBUFSIZE];
uint head, tail;	/* indexes to the inbuf */


enum {
  NONE,		/* no arguments */
  REG3,		/* Register */
  REG5,		/* Register */
  XSWP,		/* Register */
  YSWP,		/* Register */
  XREG1REG6,	/* Register, Register */
  YREG1REG6,	/* Register, Register */
  REG5REG6,	/* Register, Register */
  REG4REG6,	/* Register, Register or 16-bit register */
  REG5REG5IM8,	/* Register, Register, Immediate byte */
  REG3IM8,	/* Register, Immediate byte */
  REG5IM8,	/* Register, Immediate byte */
  IXYREG7,	/* (IX) or (IY), Register */
  IXYIM8,	/* (IX) or (IY), Immediate byte */
  IRIM7R,	/* IR, Immediate byte or Register */
  IRREG5,	/* -/+(IR),Rxx */
  REG5IR,	/* Rxx,(IR)-/+ */
  XIRARRAY,	/* -/+(IR),Rxx..Ryy */
  YIRARRAY,	/* -/+(IR),Rxx..Ryy */
  XARRAYIR,	/* Rxx..Ryy,(IR)-/+ */
  YARRAYIR,	/* Rxx..Ryy,(IR)-/+ */
  IROF8REG5,	/* (IR+/-Im8),Rxx */
  REG5IROF8,	/* Rxx,(IR+/-Im8) */
  IROF5ARRAY,	/* (IR+/-Im5),Rxx..Ryy */
  ARRAYIROF5,	/* Rxx..Ryy,(IR+/-Im5) */
  XARRAY1,	/* Rxx..Ryy */
  YARRAY1,	/* Rxx..Ryy */
  XARRAY2,	/* Rxx..Ryy, Rxx..Ryy */
  YARRAY2,	/* Rxx..Ryy, Rxx..Ryy */
  ARRAY1IM5,	/* Rxx..Ryy, 5-bit immediate value */
  ARRAY2IM5,	/* Rxx..Ryy, Rxx..Ryy, 5-bit immediate value */
  IM16,		/* 16-bit immediate value */
  WRIM16,	/* Word Register, 16-bit immediate value */
  CC,		/* Condition code */
  CCIM16,	/* Condition code, 16-bit immediate value */
  SHORT,	/* 8-bit short-range jump/call */
  CCSHORT,	/* Condition code, 8-bit short-range jump/call */
  STIM7,	/* status register, immediate data */
  STIM8,	/* status register, immediate data */
  STREG5,	/* status register, data register */
  REG5ST	/* data register, status register */
};


struct tab {
  char *str;
  int kind;
};


struct tab mnem1[160][4] = {
  {						/* code 0x00 */
	{ "tna",	XREG1REG6	},	/* subcode 0x00 */
	{ "tna",	YREG1REG6	},	/* subcode 0x40 */
	{ "na",		XREG1REG6	},	/* subcode 0x80 */
	{ "na",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x01 */
	{ "txr",	XREG1REG6	},	/* subcode 0x00 */
	{ "txr",	YREG1REG6	},	/* subcode 0x40 */
	{ "xr",		XREG1REG6	},	/* subcode 0x80 */
	{ "xr",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x02 */
	{ "tsbb",	XREG1REG6	},	/* subcode 0x00 */
	{ "tsbb",	YREG1REG6	},	/* subcode 0x40 */
	{ "sbb",	XREG1REG6	},	/* subcode 0x80 */
	{ "sbb",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x03 */
	{ "tsb",	XREG1REG6	},	/* subcode 0x00 */
	{ "tsb",	YREG1REG6	},	/* subcode 0x40 */
	{ "sb",		XREG1REG6	},	/* subcode 0x80 */
	{ "sb",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x04 */
	{ "tan",	XREG1REG6	},	/* subcode 0x00 */
	{ "tan",	YREG1REG6	},	/* subcode 0x40 */
	{ "an",		XREG1REG6	},	/* subcode 0x80 */
	{ "an",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x05 */
	{ "tor",	XREG1REG6	},	/* subcode 0x00 */
	{ "tor",	YREG1REG6	},	/* subcode 0x40 */
	{ "or",		XREG1REG6	},	/* subcode 0x80 */
	{ "or",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x06 */
	{ "tadb",	XREG1REG6	},	/* subcode 0x00 */
	{ "tadb",	YREG1REG6	},	/* subcode 0x40 */
	{ "adb",	XREG1REG6	},	/* subcode 0x80 */
	{ "adb",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x07 */
	{ "tad",	XREG1REG6	},	/* subcode 0x00 */
	{ "tad",	YREG1REG6	},	/* subcode 0x40 */
	{ "ad",		XREG1REG6	},	/* subcode 0x80 */
	{ "ad",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x08 */
	{ "tna",	REG3IM8		},	/* subcode 0x00 */
	{ "tna",	REG3IM8		},	/* subcode 0x40 */
	{ "na",		REG3IM8		},	/* subcode 0x80 */
	{ "na",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x09 */
	{ "txr",	REG3IM8		},	/* subcode 0x00 */
	{ "txr",	REG3IM8		},	/* subcode 0x40 */
	{ "xr",		REG3IM8		},	/* subcode 0x80 */
	{ "xr",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0A */
	{ "tsbb",	REG3IM8		},	/* subcode 0x00 */
	{ "tsbb",	REG3IM8		},	/* subcode 0x40 */
	{ "sbb",	REG3IM8		},	/* subcode 0x80 */
	{ "sbb",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0B */
	{ "tsb",	REG3IM8		},	/* subcode 0x00 */
	{ "tsb",	REG3IM8		},	/* subcode 0x40 */
	{ "sb",		REG3IM8		},	/* subcode 0x80 */
	{ "sb",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0C */
	{ "tan",	REG3IM8		},	/* subcode 0x00 */
	{ "tan",	REG3IM8		},	/* subcode 0x40 */
	{ "an",		REG3IM8		},	/* subcode 0x80 */
	{ "an",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0D */
	{ "tor",	REG3IM8		},	/* subcode 0x00 */
	{ "tor",	REG3IM8		},	/* subcode 0x40 */
	{ "or",		REG3IM8		},	/* subcode 0x80 */
	{ "or",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0E */
	{ "tadb",	REG3IM8		},	/* subcode 0x00 */
	{ "tadb",	REG3IM8		},	/* subcode 0x40 */
	{ "adb",	REG3IM8		},	/* subcode 0x80 */
	{ "adb",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x0F */
	{ "tad",	REG3IM8		},	/* subcode 0x00 */
	{ "tad",	REG3IM8		},	/* subcode 0x40 */
	{ "ad",		REG3IM8		},	/* subcode 0x80 */
	{ "ad",		REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x10 */
	{ "tnam",	XARRAY2		},	/* subcode 0x00 */
	{ "tnam",	YARRAY2		},	/* subcode 0x40 */
	{ "nam",	XARRAY2		},	/* subcode 0x80 */
	{ "nam",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x11 */
	{ "txrm",	XARRAY2		},	/* subcode 0x00 */
	{ "txrm",	YARRAY2		},	/* subcode 0x40 */
	{ "xrm",	XARRAY2		},	/* subcode 0x80 */
	{ "xrm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x12 */
	{ "tsbbm",	XARRAY2		},	/* subcode 0x00 */
	{ "tsbbm",	YARRAY2		},	/* subcode 0x40 */
	{ "sbbm",	XARRAY2		},	/* subcode 0x80 */
	{ "sbbm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x13 */
	{ "tsbm",	XARRAY2		},	/* subcode 0x00 */
	{ "tsbm",	YARRAY2		},	/* subcode 0x40 */
	{ "sbm",	XARRAY2		},	/* subcode 0x80 */
	{ "sbm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x14 */
	{ "tanm",	XARRAY2		},	/* subcode 0x00 */
	{ "tanm",	YARRAY2		},	/* subcode 0x40 */
	{ "anm",	XARRAY2		},	/* subcode 0x80 */
	{ "anm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x15 */
	{ "torm",	XARRAY2		},	/* subcode 0x00 */
	{ "torm",	YARRAY2		},	/* subcode 0x40 */
	{ "orm",	XARRAY2		},	/* subcode 0x80 */
	{ "orm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x16 */
	{ "tadbm",	XARRAY2		},	/* subcode 0x00 */
	{ "tadbm",	YARRAY2		},	/* subcode 0x40 */
	{ "adbm",	XARRAY2		},	/* subcode 0x80 */
	{ "adbm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x17 */
	{ "tadm",	XARRAY2		},	/* subcode 0x00 */
	{ "tadm",	YARRAY2		},	/* subcode 0x40 */
	{ "adm",	XARRAY2		},	/* subcode 0x80 */
	{ "adm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x18 */
	{ "pla",	REG4REG6	},	/* subcode 0x00 */
	{ "pla",	REG4REG6	},	/* subcode 0x40 */
	{ "ijmp",	REG4REG6	},	/* subcode 0x80 */
	{ "ijmp",	REG4REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x19 */
	{ "bit",	XREG1REG6	},	/* subcode 0x00 */
	{ "bit",	YREG1REG6	},	/* subcode 0x40 */
	{ "bit",	REG5IM8		},	/* subcode 0x80 */
	{ "bit",	REG5IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x1A */
	{ "tsbbm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tsbbm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "sbbm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "sbbm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x1B */
	{ "tsbm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tsbm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "sbm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "sbm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x1C */
	{ "sdn",	REG5REG6	},	/* subcode 0x00 */
	{ "sdn",	REG5REG6	},	/* subcode 0x40 */
	{ "sup",	REG5REG6	},	/* subcode 0x80 */
	{ "sup",	REG5REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x1D */
	{ "[1D00]",	REG5REG6	},	/* subcode 0x00 */
	{ "[1D40]",	REG5REG6	},	/* subcode 0x40 */
	{ "[1D80]",	REG5REG6	},	/* subcode 0x80 */
	{ "[1DC0]",	REG5REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x1E */
	{ "tadbm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tadbm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "adbm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "adbm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x1F */
	{ "tadm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tadm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "adm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "adm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x20 */
	{ "ld",		REG5REG5IM8	},	/* subcode 0x00 */
	{ "ld",		REG5REG5IM8	},	/* subcode 0x40 */
	{ "ld",		REG5IM8		},	/* subcode 0x80 */
	{ "ld",		REG5IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x21 */
	{ "xc",		XREG1REG6	},	/* subcode 0x00 */
	{ "xc",		YREG1REG6	},	/* subcode 0x40 */
	{ "ld",		XREG1REG6	},	/* subcode 0x80 */
	{ "ld",		YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x22 */
	{ "tsbbc",	XREG1REG6	},	/* subcode 0x00 */
	{ "tsbbc",	YREG1REG6	},	/* subcode 0x40 */
	{ "sbbc",	XREG1REG6	},	/* subcode 0x80 */
	{ "sbbc",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x23 */
	{ "tsbc",	XREG1REG6	},	/* subcode 0x00 */
	{ "tsbc",	YREG1REG6	},	/* subcode 0x40 */
	{ "sbc",	XREG1REG6	},	/* subcode 0x80 */
	{ "sbc",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x24 */
	{ "swp",	XREG1REG6	},	/* subcode 0x00 */
	{ "swp",	YREG1REG6	},	/* subcode 0x40 */
	{ "swp",	XSWP		},	/* subcode 0x80 */
	{ "swp",	YSWP		}	/* subcode 0xC0 */
  },

  {						/* code 0x25 */
	{ "xcs",	XREG1REG6	},	/* subcode 0x00 */
	{ "xcs",	YREG1REG6	},	/* subcode 0x40 */
	{ "lds",	XREG1REG6	},	/* subcode 0x80 */
	{ "lds",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x26 */
	{ "tadbc",	XREG1REG6	},	/* subcode 0x00 */
	{ "tadbc",	YREG1REG6	},	/* subcode 0x40 */
	{ "adbc",	XREG1REG6	},	/* subcode 0x80 */
	{ "adbc",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x27 */
	{ "tadc",	XREG1REG6	},	/* subcode 0x00 */
	{ "tadc",	YREG1REG6	},	/* subcode 0x40 */
	{ "adc",	XREG1REG6	},	/* subcode 0x80 */
	{ "adc",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x28 */
	{ "xcl",	XREG1REG6	},	/* subcode 0x00 */
	{ "xch",	YREG1REG6	},	/* subcode 0x40 */
	{ "ldl",	XREG1REG6	},	/* subcode 0x80 */
	{ "ldh",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x29 */
	{ "xchs",	XREG1REG6	},	/* subcode 0x00 */
	{ "xcls",	YREG1REG6	},	/* subcode 0x40 */
	{ "ldhs",	XREG1REG6	},	/* subcode 0x80 */
	{ "ldls",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x2A */
	{ "tsbbc",	REG3IM8		},	/* subcode 0x00 */
	{ "tsbbc",	REG3IM8		},	/* subcode 0x40 */
	{ "sbbc",	REG3IM8		},	/* subcode 0x80 */
	{ "sbbc",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x2B */
	{ "tsbc",	REG3IM8		},	/* subcode 0x00 */
	{ "tsbc",	REG3IM8		},	/* subcode 0x40 */
	{ "sbc",	REG3IM8		},	/* subcode 0x80 */
	{ "sbc",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x2C */
	{ "xcls",	XREG1REG6	},	/* subcode 0x00 */
	{ "xchs",	YREG1REG6	},	/* subcode 0x40 */
	{ "ldls",	XREG1REG6	},	/* subcode 0x80 */
	{ "ldhs",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x2D */
	{ "xch",	XREG1REG6	},	/* subcode 0x00 */
	{ "xcl",	YREG1REG6	},	/* subcode 0x40 */
	{ "ldh",	XREG1REG6	},	/* subcode 0x80 */
	{ "ldl",	YREG1REG6	}	/* subcode 0xC0 */
  },

  {						/* code 0x2E */
	{ "tadbc",	REG3IM8		},	/* subcode 0x00 */
	{ "tadbc",	REG3IM8		},	/* subcode 0x40 */
	{ "adbc",	REG3IM8		},	/* subcode 0x80 */
	{ "adbc",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x2F */
	{ "tadc",	REG3IM8		},	/* subcode 0x00 */
	{ "tadc",	REG3IM8		},	/* subcode 0x40 */
	{ "adc",	REG3IM8		},	/* subcode 0x80 */
	{ "adc",	REG3IM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x30 */
	{ "ldm",	ARRAY2IM5	},	/* subcode 0x00 */
	{ "ldm",	ARRAY2IM5	},	/* subcode 0x40 */
	{ "ldm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "ldm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x31 */
	{ "xcm",	XARRAY2		},	/* subcode 0x00 */
	{ "xcm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x32 */
	{ "tsbbcm",	XARRAY2		},	/* subcode 0x00 */
	{ "tsbbcm",	YARRAY2		},	/* subcode 0x40 */
	{ "sbbcm",	XARRAY2		},	/* subcode 0x80 */
	{ "sbbcm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x33 */
	{ "tsbcm",	XARRAY2		},	/* subcode 0x00 */
	{ "tsbcm",	YARRAY2		},	/* subcode 0x40 */
	{ "sbcm",	XARRAY2		},	/* subcode 0x80 */
	{ "sbcm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x34 */
	{ "swpm",	XARRAY2		},	/* subcode 0x00 */
	{ "swpm",	YARRAY2		},	/* subcode 0x40 */
	{ "swpm",	XARRAY1		},	/* subcode 0x80 */
	{ "swpm",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x35 */
	{ "xcsm",	XARRAY2		},	/* subcode 0x00 */
	{ "xcsm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldsm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldsm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x36 */
	{ "tadbcm",	XARRAY2		},	/* subcode 0x00 */
	{ "tadbcm",	YARRAY2		},	/* subcode 0x40 */
	{ "adbcm",	XARRAY2		},	/* subcode 0x80 */
	{ "adbcm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x37 */
	{ "tadcm",	XARRAY2		},	/* subcode 0x00 */
	{ "tadcm",	YARRAY2		},	/* subcode 0x40 */
	{ "adcm",	XARRAY2		},	/* subcode 0x80 */
	{ "adcm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x38 */
	{ "xclm",	XARRAY2		},	/* subcode 0x00 */
	{ "xchm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldlm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldhm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x39 */
	{ "xchsm",	XARRAY2		},	/* subcode 0x00 */
	{ "xclsm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldhsm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldlsm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x3A */
	{ "tsbbcm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tsbbcm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "sbbcm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "sbbcm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x3B */
	{ "tsbcm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tsbcm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "sbcm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "sbcm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x3C */
	{ "xclsm",	XARRAY2		},	/* subcode 0x00 */
	{ "xchsm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldlsm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldhsm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x3D */
	{ "xchm",	XARRAY2		},	/* subcode 0x00 */
	{ "xclm",	YARRAY2		},	/* subcode 0x40 */
	{ "ldhm",	XARRAY2		},	/* subcode 0x80 */
	{ "ldlm",	YARRAY2		}	/* subcode 0xC0 */
  },

  {						/* code 0x3E */
	{ "tadbcm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tadbcm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "adbcm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "adbcm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x3F */
	{ "tadcm",	ARRAY1IM5	},	/* subcode 0x00 */
	{ "tadcm",	ARRAY1IM5	},	/* subcode 0x40 */
	{ "adcm",	ARRAY1IM5	},	/* subcode 0x80 */
	{ "adcm",	ARRAY1IM5	}	/* subcode 0xC0 */
  },

  {						/* code 0x40 */
	{ "tna",	IXYREG7		},	/* subcode 0x00 */
	{ "tna",	IXYREG7		},	/* subcode 0x40 */
	{ "na",		IXYREG7		},	/* subcode 0x80 */
	{ "na",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x41 */
	{ "txr",	IXYREG7		},	/* subcode 0x00 */
	{ "txr",	IXYREG7		},	/* subcode 0x40 */
	{ "xr",		IXYREG7		},	/* subcode 0x80 */
	{ "xr",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x42 */
	{ "tsbb",	IXYREG7		},	/* subcode 0x00 */
	{ "tsbb",	IXYREG7		},	/* subcode 0x40 */
	{ "sbb",	IXYREG7		},	/* subcode 0x80 */
	{ "sbb",	IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x43 */
	{ "tsb",	IXYREG7		},	/* subcode 0x00 */
	{ "tsb",	IXYREG7		},	/* subcode 0x40 */
	{ "sb",		IXYREG7		},	/* subcode 0x80 */
	{ "sb",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x44 */
	{ "tan",	IXYREG7		},	/* subcode 0x00 */
	{ "tan",	IXYREG7		},	/* subcode 0x40 */
	{ "an",		IXYREG7		},	/* subcode 0x80 */
	{ "an",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x45 */
	{ "tor",	IXYREG7		},	/* subcode 0x00 */
	{ "tor",	IXYREG7		},	/* subcode 0x40 */
	{ "or",		IXYREG7		},	/* subcode 0x80 */
	{ "or",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x46 */
	{ "tadb",	IXYREG7		},	/* subcode 0x00 */
	{ "tadb",	IXYREG7		},	/* subcode 0x40 */
	{ "adb",	IXYREG7		},	/* subcode 0x80 */
	{ "adb",	IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x47 */
	{ "tad",	IXYREG7		},	/* subcode 0x00 */
	{ "tad",	IXYREG7		},	/* subcode 0x40 */
	{ "ad",		IXYREG7		},	/* subcode 0x80 */
	{ "ad",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x48 */
	{ "na",		IXYIM8		},	/* subcode 0x00 */
	{ "na",		IXYIM8		},	/* subcode 0x40 */
	{ "na",		IXYIM8		},	/* subcode 0x80 */
	{ "na",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x49 */
	{ "xr",		IXYIM8		},	/* subcode 0x00 */
	{ "xr",		IXYIM8		},	/* subcode 0x40 */
	{ "xr",		IXYIM8		},	/* subcode 0x80 */
	{ "xr",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4A */
	{ "sbb",	IXYIM8		},	/* subcode 0x00 */
	{ "sbb",	IXYIM8		},	/* subcode 0x40 */
	{ "sbb",	IXYIM8		},	/* subcode 0x80 */
	{ "sbb",	IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4B */
	{ "sb",		IXYIM8		},	/* subcode 0x00 */
	{ "sb",		IXYIM8		},	/* subcode 0x40 */
	{ "sb",		IXYIM8		},	/* subcode 0x80 */
	{ "sb",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4C */
	{ "an",		IXYIM8		},	/* subcode 0x00 */
	{ "an",		IXYIM8		},	/* subcode 0x40 */
	{ "an",		IXYIM8		},	/* subcode 0x80 */
	{ "an",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4D */
	{ "or",		IXYIM8		},	/* subcode 0x00 */
	{ "or",		IXYIM8		},	/* subcode 0x40 */
	{ "or",		IXYIM8		},	/* subcode 0x80 */
	{ "or",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4E */
	{ "adb",	IXYIM8		},	/* subcode 0x00 */
	{ "adb",	IXYIM8		},	/* subcode 0x40 */
	{ "adb",	IXYIM8		},	/* subcode 0x80 */
	{ "adb",	IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x4F */
	{ "ad",		IXYIM8		},	/* subcode 0x00 */
	{ "ad",		IXYIM8		},	/* subcode 0x40 */
	{ "ad",		IXYIM8		},	/* subcode 0x80 */
	{ "ad",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x50 */
	{ "tna",	IXYREG7		},	/* subcode 0x00 */
	{ "tna",	IXYREG7		},	/* subcode 0x40 */
	{ "na",		IXYREG7		},	/* subcode 0x80 */
	{ "na",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x51 */
	{ "txr",	IXYREG7		},	/* subcode 0x00 */
	{ "txr",	IXYREG7		},	/* subcode 0x40 */
	{ "xr",		IXYREG7		},	/* subcode 0x80 */
	{ "xr",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x52 */
	{ "tsbb",	IXYREG7		},	/* subcode 0x00 */
	{ "tsbb",	IXYREG7		},	/* subcode 0x40 */
	{ "sbb",	IXYREG7		},	/* subcode 0x80 */
	{ "sbb",	IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x53 */
	{ "tsb",	IXYREG7		},	/* subcode 0x00 */
	{ "tsb",	IXYREG7		},	/* subcode 0x40 */
	{ "sb",		IXYREG7		},	/* subcode 0x80 */
	{ "sb",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x54 */
	{ "tan",	IXYREG7		},	/* subcode 0x00 */
	{ "tan",	IXYREG7		},	/* subcode 0x40 */
	{ "an",		IXYREG7		},	/* subcode 0x80 */
	{ "an",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x55 */
	{ "tor",	IXYREG7		},	/* subcode 0x00 */
	{ "tor",	IXYREG7		},	/* subcode 0x40 */
	{ "or",		IXYREG7		},	/* subcode 0x80 */
	{ "or",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x56 */
	{ "tadb",	IXYREG7		},	/* subcode 0x00 */
	{ "tadb",	IXYREG7		},	/* subcode 0x40 */
	{ "adb",	IXYREG7		},	/* subcode 0x80 */
	{ "adb",	IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x57 */
	{ "tad",	IXYREG7		},	/* subcode 0x00 */
	{ "tad",	IXYREG7		},	/* subcode 0x40 */
	{ "ad",		IXYREG7		},	/* subcode 0x80 */
	{ "ad",		IXYREG7		}	/* subcode 0xC0 */
  },

  {						/* code 0x58 */
	{ "na",		IXYIM8		},	/* subcode 0x00 */
	{ "na",		IXYIM8		},	/* subcode 0x40 */
	{ "na",		IXYIM8		},	/* subcode 0x80 */
	{ "na",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x59 */
	{ "xr",		IXYIM8		},	/* subcode 0x00 */
	{ "xr",		IXYIM8		},	/* subcode 0x40 */
	{ "xr",		IXYIM8		},	/* subcode 0x80 */
	{ "xr",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5A */
	{ "sbb",	IXYIM8		},	/* subcode 0x00 */
	{ "sbb",	IXYIM8		},	/* subcode 0x40 */
	{ "sbb",	IXYIM8		},	/* subcode 0x80 */
	{ "sbb",	IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5B */
	{ "sb",		IXYIM8		},	/* subcode 0x00 */
	{ "sb",		IXYIM8		},	/* subcode 0x40 */
	{ "sb",		IXYIM8		},	/* subcode 0x80 */
	{ "sb",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5C */
	{ "an",		IXYIM8		},	/* subcode 0x00 */
	{ "an",		IXYIM8		},	/* subcode 0x40 */
	{ "an",		IXYIM8		},	/* subcode 0x80 */
	{ "an",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5D */
	{ "or",		IXYIM8		},	/* subcode 0x00 */
	{ "or",		IXYIM8		},	/* subcode 0x40 */
	{ "or",		IXYIM8		},	/* subcode 0x80 */
	{ "or",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5E */
	{ "adb",	IXYIM8		},	/* subcode 0x00 */
	{ "adb",	IXYIM8		},	/* subcode 0x40 */
	{ "adb",	IXYIM8		},	/* subcode 0x80 */
	{ "adb",	IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x5F */
	{ "ad",		IXYIM8		},	/* subcode 0x00 */
	{ "ad",		IXYIM8		},	/* subcode 0x40 */
	{ "ad",		IXYIM8		},	/* subcode 0x80 */
	{ "ad",		IXYIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x60 */
	{ "rod",	REG5		},	/* subcode 0x00 */
	{ "rod",	REG5		},	/* subcode 0x40 */
	{ "rou",	REG5		},	/* subcode 0x80 */
	{ "rou",	REG5		}	/* subcode 0xC0 */
  },

  {						/* code 0x61 */
	{ "did",	REG5		},	/* subcode 0x00 */
	{ "did",	REG5		},	/* subcode 0x40 */
	{ "diu",	REG5		},	/* subcode 0x80 */
	{ "diu",	REG5		}	/* subcode 0xC0 */
  },

  {						/* code 0x62 */
	{ "tcmpb",	REG3		},	/* subcode 0x00 */
	{ "tcmpb",	REG3		},	/* subcode 0x40 */
	{ "cmpb",	REG3		},	/* subcode 0x80 */
	{ "cmpb",	REG3		}	/* subcode 0xC0 */
  },

  {						/* code 0x63 */
	{ "tcmp",	REG3		},	/* subcode 0x00 */
	{ "tcmp",	REG3		},	/* subcode 0x40 */
	{ "cmp",	REG3		},	/* subcode 0x80 */
	{ "cmp",	REG3		}	/* subcode 0xC0 */
  },

  {						/* code 0x64 */
	{ "byd",	REG5		},	/* subcode 0x00 */
	{ "byd",	REG5		},	/* subcode 0x40 */
	{ "byu",	REG5		},	/* subcode 0x80 */
	{ "byu",	REG5		}	/* subcode 0xC0 */
  },

  {						/* code 0x65 */
	{ "bnd",	REG5		},	/* subcode 0x00 */
	{ "bnd",	REG5		},	/* subcode 0x40 */
	{ "bnu",	REG5		},	/* subcode 0x80 */
	{ "bnu",	REG5		}	/* subcode 0xC0 */
  },

  {						/* code 0x66 */
	{ "tmtb",	REG3		},	/* subcode 0x00 */
	{ "tmtb",	REG3		},	/* subcode 0x40 */
	{ "mtb",	REG3		},	/* subcode 0x80 */
	{ "mtb",	REG3		}	/* subcode 0xC0 */
  },

  {						/* code 0x67 */
	{ "tbiu",	REG3		},	/* subcode 0x00 */
	{ "tbiu",	REG3		},	/* subcode 0x40 */
	{ "biu",	REG3		},	/* subcode 0x80 */
	{ "biu",	REG3		}	/* subcode 0xC0 */
  },

  {						/* code 0x68 */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x69 */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6A */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6B */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6C */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6D */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6E */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x6F */
	{ "st",		IRREG5		},	/* subcode 0x00 */
	{ "st",		IRREG5		},	/* subcode 0x40 */
	{ "ld",		REG5IR		},	/* subcode 0x80 */
	{ "ld",		REG5IR		}	/* subcode 0xC0 */
  },

  {						/* code 0x70 */
	{ "rodm",	XARRAY1		},	/* subcode 0x00 */
	{ "rodm",	YARRAY1		},	/* subcode 0x40 */
	{ "roum",	XARRAY1		},	/* subcode 0x80 */
	{ "roum",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x71 */
	{ "didm",	XARRAY1		},	/* subcode 0x00 */
	{ "didm",	YARRAY1		},	/* subcode 0x40 */
	{ "dium",	XARRAY1		},	/* subcode 0x80 */
	{ "dium",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x72 */
	{ "tcmpbm",	XARRAY1		},	/* subcode 0x00 */
	{ "tcmpbm",	YARRAY1		},	/* subcode 0x40 */
	{ "cmpbm",	XARRAY1		},	/* subcode 0x80 */
	{ "cmpbm",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x73 */
	{ "tcmpm",	XARRAY1		},	/* subcode 0x00 */
	{ "tcmpm",	YARRAY1		},	/* subcode 0x40 */
	{ "cmpm",	XARRAY1		},	/* subcode 0x80 */
	{ "cmpm",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x74 */
	{ "bydm",	XARRAY1		},	/* subcode 0x00 */
	{ "bydm",	YARRAY1		},	/* subcode 0x40 */
	{ "byum",	XARRAY1		},	/* subcode 0x80 */
	{ "byum",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x75 */
	{ "bndm",	XARRAY1		},	/* subcode 0x00 */
	{ "bndm",	YARRAY1		},	/* subcode 0x40 */
	{ "bnum",	XARRAY1		},	/* subcode 0x80 */
	{ "bnum",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x76 */
	{ "tmtbm",	XARRAY1		},	/* subcode 0x00 */
	{ "tmtbm",	YARRAY1		},	/* subcode 0x40 */
	{ "mtbm",	XARRAY1		},	/* subcode 0x80 */
	{ "mtbm",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x77 */
	{ "tbium",	XARRAY1		},	/* subcode 0x00 */
	{ "tbium",	YARRAY1		},	/* subcode 0x40 */
	{ "bium",	XARRAY1		},	/* subcode 0x80 */
	{ "bium",	YARRAY1		}	/* subcode 0xC0 */
  },

  {						/* code 0x78 */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x79 */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7A */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7B */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7C */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7D */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7E */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x7F */
	{ "stm",	XIRARRAY	},	/* subcode 0x00 */
	{ "stm",	YIRARRAY	},	/* subcode 0x40 */
	{ "ldm",	XARRAYIR	},	/* subcode 0x80 */
	{ "ldm",	YARRAYIR	}	/* subcode 0xC0 */
  },

  {						/* code 0x80 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x81 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x82 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x83 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x84 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x85 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x86 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x87 */
	{ "st",		IROF8REG5	},	/* subcode 0x00 */
	{ "st",		IROF8REG5	},	/* subcode 0x40 */
	{ "ld",		REG5IROF8	},	/* subcode 0x80 */
	{ "ld",		REG5IROF8	}	/* subcode 0xC0 */
  },

  {						/* code 0x88 */
	{ "pst",	STIM8		},	/* subcode 0x00 */
	{ "pst",	STIM8		},	/* subcode 0x40 */
	{ "pst",	STIM8		},	/* subcode 0x80 */
	{ "pst",	STIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x89 */
	{ "pst",	STIM8		},	/* subcode 0x00 */
	{ "pst",	STIM8		},	/* subcode 0x40 */
	{ "pst",	STIM8		},	/* subcode 0x80 */
	{ "pst",	STIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x8A */
	{ "pst",	STIM8		},	/* subcode 0x00 */
	{ "pst",	STIM8		},	/* subcode 0x40 */
	{ "pst",	STIM8		},	/* subcode 0x80 */
	{ "pst",	STIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x8B */
	{ "pst",	STIM8		},	/* subcode 0x00 */
	{ "pst",	STIM8		},	/* subcode 0x40 */
	{ "pst",	STIM8		},	/* subcode 0x80 */
	{ "pst",	STIM8		}	/* subcode 0xC0 */
  },

  {						/* code 0x8C */
	{ "pst",	STIM7		},	/* subcode 0x00 */
	{ "pst",	STIM7		},	/* subcode 0x40 */
	{ "pst",	STIM7		},	/* subcode 0x80 */
	{ "pst",	STIM7		}	/* subcode 0xC0 */
  },

  {						/* code 0x8D */
	{ "pst",	STIM7		},	/* subcode 0x00 */
	{ "pst",	STIM7		},	/* subcode 0x40 */
	{ "pst",	STIM7		},	/* subcode 0x80 */
	{ "pst",	STIM7		}	/* subcode 0xC0 */
  },

  {						/* code 0x8E */
	{ "pst",	STIM7		},	/* subcode 0x00 */
	{ "pst",	STIM7		},	/* subcode 0x40 */
	{ "pst",	STIM7		},	/* subcode 0x80 */
	{ "pst",	STIM7		}	/* subcode 0xC0 */
  },

  {						/* code 0x8F */
	{ "pst",	STIM7		},	/* subcode 0x00 */
	{ "pst",	STIM7		},	/* subcode 0x40 */
	{ "pst",	STIM7		},	/* subcode 0x80 */
	{ "pst",	STIM7		}	/* subcode 0xC0 */
  },

  {						/* code 0x90 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x91 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x92 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x93 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x94 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x95 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x96 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x97 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x00 */
	{ "stm",	IROF5ARRAY	},	/* subcode 0x40 */
	{ "ldm",	ARRAYIROF5	},	/* subcode 0x80 */
	{ "ldm",	ARRAYIROF5	}	/* subcode 0xC0 */
  },

  {						/* code 0x98 */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x99 */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x9A */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x9B */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x9C */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x9D */
	{ "pst",	STREG5		},	/* subcode 0x00 */
	{ "pst",	STREG5		},	/* subcode 0x40 */
	{ "gst",	REG5ST		},	/* subcode 0x80 */
	{ "gst",	REG5ST		}	/* subcode 0xC0 */
  },

  {						/* code 0x9E */
	{ "bdn",	REG5		},	/* subcode 0x00 */
	{ "bdn",	REG5		},	/* subcode 0x40 */
	{ "bup",	REG5		},	/* subcode 0x80 */
	{ "bup",	REG5		}	/* subcode 0xC0 */
  },

  {						/* code 0x9F */
	{ "bdn",	REG5		},	/* subcode 0x00 */
	{ "bdn",	REG5		},	/* subcode 0x40 */
	{ "bup",	REG5		},	/* subcode 0x80 */
	{ "bup",	REG5		}	/* subcode 0xC0 */
  }
};


struct tab mnem2[96] = {
  { "jmp",	CCIM16		},	/* code 0xA0 */
  { "jmp",	CCIM16		},	/* code 0xA1 */
  { "jmp",	CCIM16		},	/* code 0xA2 */
  { "jmp",	CCIM16		},	/* code 0xA3 */
  { "jmp",	CCIM16		},	/* code 0xA4 */
  { "jmp",	CCIM16		},	/* code 0xA5 */
  { "jmp",	CCIM16		},	/* code 0xA6 */
  { "jmp",	IM16		},	/* code 0xA7 */
  { "jmp",	CCIM16		},	/* code 0xA8 */
  { "jmp",	CCIM16		},	/* code 0xA9 */
  { "jmp",	CCIM16		},	/* code 0xAA */
  { "jmp",	CCIM16		},	/* code 0xAB */
  { "jmp",	CCIM16		},	/* code 0xAC */
  { "jmp",	CCIM16		},	/* code 0xAD */
  { "jmp",	CCIM16		},	/* code 0xAE */
  { "off",	NONE		},	/* code 0xAF */
  { "cal",	CCIM16		},	/* code 0xB0 */
  { "cal",	CCIM16		},	/* code 0xB1 */
  { "cal",	CCIM16		},	/* code 0xB2 */
  { "cal",	CCIM16		},	/* code 0xB3 */
  { "cal",	CCIM16		},	/* code 0xB4 */
  { "cal",	CCIM16		},	/* code 0xB5 */
  { "cal",	CCIM16		},	/* code 0xB6 */
  { "cal",	IM16		},	/* code 0xB7 */
  { "cal",	CCIM16		},	/* code 0xB8 */
  { "cal",	CCIM16		},	/* code 0xB9 */
  { "cal",	CCIM16		},	/* code 0xBA */
  { "cal",	CCIM16		},	/* code 0xBB */
  { "cal",	CCIM16		},	/* code 0xBC */
  { "cal",	CCIM16		},	/* code 0xBD */
  { "cal",	CCIM16		},	/* code 0xBE */
  { "wai",	NONE		},	/* code 0xBF */
  { "rtn",	CC		},	/* code 0xC0 */
  { "rtn",	CC		},	/* code 0xC1 */
  { "rtn",	CC		},	/* code 0xC2 */
  { "rtn",	CC		},	/* code 0xC3 */
  { "rtn",	CC		},	/* code 0xC4 */
  { "rtn",	CC		},	/* code 0xC5 */
  { "rtn",	CC		},	/* code 0xC6 */
  { "rtn",	NONE		},	/* code 0xC7 */
  { "rtn",	CC		},	/* code 0xC8 */
  { "rtn",	CC		},	/* code 0xC9 */
  { "rtn",	CC		},	/* code 0xCA */
  { "rtn",	CC		},	/* code 0xCB */
  { "rtn",	CC		},	/* code 0xCC */
  { "rtn",	CC		},	/* code 0xCD */
  { "rtn",	CC		},	/* code 0xCE */
  { "rti",	NONE		},	/* code 0xCF */
  { "ldw",	WRIM16		},	/* code 0xD0 */
  { "ldw",	WRIM16		},	/* code 0xD1 */
  { "ldw",	WRIM16		},	/* code 0xD2 */
  { "ldw",	WRIM16		},	/* code 0xD3 */
  { "ldw",	WRIM16		},	/* code 0xD4 */
  { "ldw",	WRIM16		},	/* code 0xD5 */
  { "ldw",	WRIM16		},	/* code 0xD6 */
  { "ldw",	WRIM16		},	/* code 0xD7 */
  { "sbw",	IRIM7R		},	/* code 0xD8 */
  { "sbw",	IRIM7R		},	/* code 0xD9 */
  { "sbw",	IRIM7R		},	/* code 0xDA */
  { "sbw",	IRIM7R		},	/* code 0xDB */
  { "adw",	IRIM7R		},	/* code 0xDC */
  { "adw",	IRIM7R		},	/* code 0xDD */
  { "adw",	IRIM7R		},	/* code 0xDE */
  { "adw",	IRIM7R		},	/* code 0xDF */
  { "sjmp",	CCSHORT		},	/* code 0xE0 */
  { "sjmp",	CCSHORT		},	/* code 0xE1 */
  { "sjmp",	CCSHORT		},	/* code 0xE2 */
  { "sjmp",	CCSHORT		},	/* code 0xE3 */
  { "sjmp",	CCSHORT		},	/* code 0xE4 */
  { "sjmp",	CCSHORT		},	/* code 0xE5 */
  { "sjmp",	CCSHORT		},	/* code 0xE6 */
  { "sjmp",	SHORT		},	/* code 0xE7 */
  { "sjmp",	CCSHORT		},	/* code 0xE8 */
  { "sjmp",	CCSHORT		},	/* code 0xE9 */
  { "sjmp",	CCSHORT		},	/* code 0xEA */
  { "sjmp",	CCSHORT		},	/* code 0xEB */
  { "sjmp",	CCSHORT		},	/* code 0xEC */
  { "sjmp",	CCSHORT		},	/* code 0xED */
  { "sjmp",	CCSHORT		},	/* code 0xEE */
  { "nop",	NONE		},	/* code 0xEF */
  { "scal",	CCSHORT		},	/* code 0xF0 */
  { "scal",	CCSHORT		},	/* code 0xF1 */
  { "scal",	CCSHORT		},	/* code 0xF2 */
  { "scal",	CCSHORT		},	/* code 0xF3 */
  { "scal",	CCSHORT		},	/* code 0xF4 */
  { "scal",	CCSHORT		},	/* code 0xF5 */
  { "scal",	CCSHORT		},	/* code 0xF6 */
  { "scal",	SHORT		},	/* code 0xF7 */
  { "scal",	CCSHORT		},	/* code 0xF8 */
  { "scal",	CCSHORT		},	/* code 0xF9 */
  { "scal",	CCSHORT		},	/* code 0xFA */
  { "scal",	CCSHORT		},	/* code 0xFB */
  { "scal",	CCSHORT		},	/* code 0xFC */
  { "scal",	CCSHORT		},	/* code 0xFD */
  { "scal",	CCSHORT		},	/* code 0xFE */
  { "trp",	NONE		}	/* code 0xFF */
};

char *ir_tab[] = { "ix", "iy", "iz", "sp" };
char *wr_tab[] = { "ix", "iy", "iz", "v3", "v2", "v1", "v0", "sp" };
char *cc_tab[] = { "k", "lz", "uz", "z", "v", "h", "c", "*" };
char *st_tab_i8[] = { "ie", "ds", "ky", "pd" };
char *st_tab_i7[4][2] = {
	{ "s4", "s8" },
	{ "s5", "as" },
	{ "s6", "tm" },
	{ "s7", "pe" }	};
char *st_tab_r[] = { "ie", "ds", "ky", "pd", "f", "as", "*", "*" };


void CondCode (uint x)
{
  if ((x & 0x08) == 0)
  {
    (void) putchar ('n');
  }
  printf ("%s", cc_tab[x & 0x07]);
}


uint rega (void)
{
  return (inbuf[head] & 0x3F) | 0x40;
}


uint regb (void)
{
  return ((inbuf[head+1] << 3) & 0x38) | (inbuf[head] & 0x07);
}


uint regc (void)
{
  return (inbuf[head] & 0x38) | 0x40 | ((inbuf[head+1] >> 5) & 0x07);
}


uint regd (void)
{
  return ((inbuf[head+1] >> 5) & 0x07) | ((inbuf[head+1] << 3) & 0x38);
}


uint rege (void)
{
  return (inbuf[head] & 0x78) | ((inbuf[head+1] >> 5) & 0x07);
}


void Arguments (int argkind)
{
  uint opcode, x, y, z, count;
  char sign, name;

  opcode = inbuf[head-1];
  sign = ((opcode & 0x04) == 0) ? '-' : '+';
  z = inbuf[head];
  y = inbuf[head+1];
  x = z & 0x7F;
  name = ((y & 0x10) != 0) ? 'i' : 'r';

  switch (argkind)
  {
    case REG3:
    case REG5:
      printf ("r%u", x);
      count=1;
      break;

    case XSWP:
      printf ("%c%u", name, regd());
      count=2;
      break;

    case YSWP:
      printf ("r%u", rega());
      count=2;
      break;

    case XREG1REG6:
      printf ("%c%u,r%u", name, regd(), rega());
      count=2;
      break;

    case YREG1REG6:
      printf ("r%u,%c%u", rega(), name, regd());
      count=2;
      break;

    case REG5REG6:
      printf ("r%u,%c%u", x, name, regd());
      count=2;
      break;

    case REG4REG6:
      z = regd();
      if ((y & 0x10) == 0 && (x & 0x3F) == z && (x & 0x38) == 0x38)
      {
        printf ("%s", wr_tab[x & 0x07]);
      }
      else
      {
        printf ("r%u,%c%u", x | 0x40, name, z);
      }
      count=2;
      break;

    case REG5REG5IM8:
      printf ("r%u,r%u,&H%02X", x, x ^ 0x40, y);
      count=2;
      break;

    case REG3IM8:
    case REG5IM8:
      printf ("r%u,&H%02X", x, y);
      count=2;
      break;

    case IXYREG7:
      printf ("(%s),r%u", ir_tab[(opcode >> 4) & 0x01], x ^ 0x40);
      count=1;
      break;

    case IXYIM8:
      printf ("(%s),&H%02X", ir_tab[(opcode >> 4) & 0x01], z);
      count=1;
      break;

    case IRIM7R:
      if ((z & 0x80) != 0)
      {
        printf ("%s,r%u", ir_tab[opcode & 0x03], x);
      }
      else
      {
        printf ("%s,&H%02X", ir_tab[opcode & 0x03], x);
      }
      count=1;
      break;

    case IRREG5:
      printf ("%c(%s),r%u", sign, ir_tab[opcode & 0x03], x);
      count=1;
      break;

    case REG5IR:
      printf ("r%u,(%s)%c", x, ir_tab[opcode & 0x03], sign);
      count=1;
      break;

    case XIRARRAY:
      printf ("%c(%s),r%u..r%u", sign, ir_tab[opcode & 0x03], regb(), regd());
      count=2;
      break;

    case YIRARRAY:
      printf ("%c(%s),r%u..r%u", sign, ir_tab[opcode & 0x03], rega(), regc());
      count=2;
      break;

    case XARRAYIR:
      printf ("r%u..r%u,(%s)%c", regb(), regd(), ir_tab[opcode & 0x03], sign);
      count=2;
      break;

    case YARRAYIR:
      printf ("r%u..r%u,(%s)%c", rega(), regc(), ir_tab[opcode & 0x03], sign);
      count=2;
      break;

    case IROF8REG5:
      printf ("(%s%c&H%02X),r%u", ir_tab[opcode & 0x03], sign, y+1, x);
      count=2;
      break;

    case REG5IROF8:
      printf ("r%u,(%s%c&H%02X)", x, ir_tab[opcode & 0x03], sign, y);
      count=2;
      break;

    case IROF5ARRAY:
      printf ("(%s%c&H%02X),r%u..r%u",
		ir_tab[opcode & 0x03], sign, (y & 0x1F) + 1, x, rege());
      count=2;
      break;

    case ARRAYIROF5:
      printf ("r%u..r%u,(%s%c&H%02X)",
		x, rege(), ir_tab[opcode & 0x03], sign, y & 0x1F);
      count=2;
      break;

    case XARRAY1:
      printf ("%c%u..%c%u", name, regb(), name, regd());
      count=2;
      break;

    case YARRAY1:
      printf ("r%u..r%u", rega(), regc());
      count=2;
      break;

    case XARRAY2:
      printf ("%c%u..%c%u,r%u..r%u",
		name, regb(), name, regd(), rega(), regc());
      count=2;
      break;

    case YARRAY2:
      printf ("r%u..r%u,%c%u..%c%u",
		rega(), regc(), name, regb(), name, regd());
      count=2;
      break;

    case ARRAY1IM5:
      printf ("r%u..r%u,&H%02X", x, rege(), y & 0x1F);
      count=2;
      break;

    case ARRAY2IM5:
      x &= 0x3F;		/* first register */
      z = regc() & 0x3F;	/* last register */
      printf ("r%u..r%u,r%u..r%u,&H%02X", x, z, x | 0x40, z | 0x40, y & 0x1F);
      count=2;
      break;

    case CC:
      CondCode (opcode);
      count=0;
      break;

    case CCIM16:
      CondCode (opcode);
      (void) putchar (',');
/*@fallthrough@*/
    case IM16:
      printf ("&H%04X", (z<<8) | y);
      count=2;
      break;

    case WRIM16:
      printf ("%s,&H%04X", wr_tab[opcode & 0x07], (z<<8) | y);
      count=2;
      break;

    case CCSHORT:
      CondCode (opcode);
      (void) putchar (',');
/*@fallthrough@*/
    case SHORT:
      x = (loc - 1) & 0xFF00;	/* memory page where the opcode is stored */
      printf ("&H%04X", x | z);
      count=1;
      break;

    case STIM7:
      printf ("%s,&H%02X", st_tab_i7[opcode & 0x03][z>>7], x);
      count=1;
      break;

    case STIM8:
      printf ("%s,&H%02X", st_tab_i8[opcode & 0x03], z);
      count=1;
      break;

    case STREG5:
      printf ("%s,r%u", st_tab_r[opcode & 0x07], x);
      count=1;
      break;

    case REG5ST:
      printf ("r%u,%s", x, st_tab_r[opcode & 0x07]);
      count=1;
      break;

    default:
      count=0;
      break;
  }

  loc+=count;
  head+=count;
}


int main (int argc, char *argv[])
{
  int x;
  uint i;
  struct tab *mnemptr;
  FILE *fp;

  if (argc < 2)
  {
    fprintf (stderr, "\nNo input file specified\n");
    return 1;
  }

  if ((fp = fopen(*++argv, "rb")) == NULL)
  {
    fprintf(stderr, "\nCannot open the input file %s\n", *argv);
    return 1;
  }

  loc = 0;
  while (argc-->2)
  {
    argv++;
    if (isxdigit(**argv))
    {
      (void) sscanf(*argv, "%x", &loc);
    }
    else if (**argv == '/' || **argv == '-')
    {
      switch (*(*argv+1))
      {
/* reserved for future expansions */
        default:
          fprintf(stderr, "\nUnrecognised switch: %s\n", *argv+1);
          break;
      }
    }
    else
    {
      fprintf(stderr, "\nUnrecognised parameter: %s\n", *argv);
    }
  }
  head = 0;
  tail = 0;

  do {

/* shift the bytes in the inbuf */
    i = 0;
    while (head<tail)
    {
      inbuf[i++] = inbuf[head++];
    }
    tail = i;
    head = 0;
/* fill the inbuf */
    while ((tail<INBUFSIZE) && ((x=getc(fp))!=EOF))
    {
      inbuf[tail++] = (uint) x;
    }
/* disassemble */
    printf ("%04X:\t", loc++);
    i = inbuf[head++];
    mnemptr = (i<160) ? &mnem1[i][(inbuf[head] >> 6) & 0x03] : &mnem2[i-160];
    printf ("%s", (i >= 0x78 && i < 0x80 && (inbuf[head] & 0x80) == 0 &&
	(inbuf[head+1] & 0x08) != 0) ? "stlm" : mnemptr->str);
    if (mnemptr->kind != NONE)
    {
      (void) putchar ('\t');
      Arguments (mnemptr->kind);
    }
    printf ("\n");

  } while (tail!=0);

  (void) fclose (fp);
  return 0;
}
