/* This C cross compiler is a translation of the original Casio PB-2000C
   P-code compiler to C language. It was written with the intention to match
   the original program structure and algorithms as closely as possible.
  
   Warning: following expression is incorrectly compiled by Turbo C++ 3.0
   for DOS (the variable x is of dword type, the variable y is of byte type):
   x = (x << 4) | (dword) (y & (byte) 0x0F);
   As a workaround, the OR operator was replaced with a sum.
*/

#include <stdio.h>
#include <stdlib.h>	/* exit */

typedef unsigned long dword;
typedef unsigned short word;
typedef unsigned char byte;


typedef struct {
  word code;
  char *string;
} tcode;

tcode keywords1[] = {
  { 0x0330, "!" },
  { 0x033A, "%" }, 
  { 0x032E, "&" },
  { 0x0329, "(" },
  { 0x035B, ")" },
  { 0x032D, "*" },
  { 0x033B, "+" },
  { 0x0356, "," },
  { 0x032F, "-" },
  { 0x032B, "." },
  { 0x0339, "/" },
  { 0x035F, ":" },
  { 0x033F, "<" },
  { 0x034B, "=" },
  { 0x0340, ">" },
  { 0x034A, "?" },
  { 0x032A, "[" },
  { 0x035C, "]" },
  { 0x0346, "^" },
  { 0x0347, "|" },
  { 0x0331, "~" },
  { 0x0360, ";" },
  { 0x035D, "{" },
  { 0x035E, "}" },
  { 0x0000, "" }
};

tcode keywords2[] = {
  { 0x0344, "!=" },
  { 0x0350, "%=" },
  { 0x0348, "&&" },
  { 0x0353, "&=" },
  { 0x034E, "*=" },
  { 0x0332, "++" },
  { 0x034C, "+=" },
  { 0x0334, "--" },
  { 0x034D, "-=" },
  { 0x032C, "->" },
  { 0x034F, "/=" },
  { 0x033E, "<<" },
  { 0x0341, "<=" },
  { 0x0343, "==" },
  { 0x0342, ">=" },
  { 0x033D, ">>" },
  { 0x0354, "^=" },
  { 0x0355, "|=" },
  { 0x0349, "||" },
  { 0x021B, "do" },
  { 0x0218, "if" },
  { 0x0000, "" }
};

tcode keywords3[] = {
  { 0x0352, "<<=" },
  { 0x0351, ">>=" },
  { 0x021C, "for" },
  { 0x010B, "int" },
  { 0x0565, "abs" },
  { 0x0567, "cos" },
  { 0x0568, "exp" },
  { 0x0569, "log" },
  { 0x056A, "pow" },
  { 0x056B, "sin" },
  { 0x056C, "tan" },
  { 0x0000, "" }
};

tcode keywords4[] = {
  { 0x0001, "auto" },
  { 0x021E, "case" },
  { 0x0109, "char" },
  { 0x0219, "else" },
  { 0x0113, "enum" },
  { 0x0223, "goto" },
  { 0x010C, "long" },
  { 0x0108, "void" },
  { 0x056D, "acos" },
  { 0x056E, "asin" },
  { 0x056F, "atan" },
  { 0x0570, "beep" },
  { 0x0571, "cosh" },
  { 0x0573, "exit" },
  { 0x0574, "feof" },
  { 0x0575, "free" },
  { 0x0576, "getc" },
  { 0x0577, "gets" },
  { 0x0572, "line" },
  { 0x0578, "putc" },
  { 0x0579, "puts" },
  { 0x057A, "sinh" },
  { 0x057B, "sqrt" },
  { 0x057C, "tanh" },
  { 0x0000, "" }
};

tcode keywords5[] = {
  { 0x0220, "break" },
  { 0x0112, "const" },
  { 0x010E, "float" },
  { 0x010A, "short" },
  { 0x0111, "union" },
  { 0x021A, "while" },
  { 0x057D, "abort" },
  { 0x057E, "acosh" },
  { 0x057F, "angle" },
  { 0x0580, "asinh" },
  { 0x0581, "atanh" },
  { 0x0583, "fgetc" },
  { 0x0584, "fgets" },
  { 0x0585, "fopen" },
  { 0x0586, "fputc" },
  { 0x0587, "fputs" },
  { 0x0588, "fread" },
  { 0x0589, "getch" },
  { 0x0582, "linec" },
  { 0x058A, "log10" },
  { 0x058B, "scanf" },
  { 0x0000, "" }
};

tcode keywords6[] = {
  { 0x010F, "double" },
  { 0x0003, "extern" },
  { 0x0222, "return" },
  { 0x0114, "signed" },
  { 0x0336, "sizeof" },
  { 0x0002, "static" },
  { 0x0110, "struct" },
  { 0x021D, "switch" },
  { 0x058C, "calloc" },
  { 0x0566, "clrscr" },
  { 0x058D, "fclose" },
  { 0x058E, "ferror" },
  { 0x058F, "fflush" },
  { 0x0590, "fscanf" },
  { 0x0591, "fwrite" },
  { 0x0592, "gotoxy" },
  { 0x0593, "malloc" },
  { 0x0594, "printf" },
  { 0x0595, "remove" },
  { 0x0596, "rename" },
  { 0x0597, "sscanf" },
  { 0x0598, "strcat" },
  { 0x0599, "strchr" },
  { 0x059A, "strcmp" },
  { 0x059B, "strcpy" },
  { 0x059C, "strlen" },
  { 0x059D, "ungetc" },
  { 0x0000, "" }
};

tcode keywords7[] = {
  { 0x021F, "default" },
  { 0x0005, "typedef" },
  { 0x059E, "breakpt" },
  { 0x059F, "fprintf" },
  { 0x05A0, "getchar" },
  { 0x05A1, "putchar" },
  { 0x05A2, "sprintf" },
  { 0x0000, "" }
};

tcode keywords8[] = {
  { 0x0221, "continue" },
  { 0x0004, "register" },
  { 0x010D, "unsigned" },
  { 0x0115, "volatile" },
  { 0x05A3, "clearerr" },
  { 0x0000, "" }
};

tcode *allkeywords[] = {
  keywords1, keywords2, keywords3, keywords4,
  keywords5, keywords6, keywords7, keywords8	};


byte tab9f7b [33][33] = {
  { (byte) 0x21, (byte) 0x01, (byte) 0x00, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x50, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x11, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x01, (byte) 0x01, (byte) 0x00, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x00, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01, (byte) 0x11,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x01, (byte) 0x01, (byte) 0x02, (byte) 0x31, (byte) 0x31,
    (byte) 0x31, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01,
    (byte) 0x10, (byte) 0x10, (byte) 0x11, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x11, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x01, (byte) 0x01, (byte) 0x02, (byte) 0x31, (byte) 0x31,
    (byte) 0x31, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x01,
    (byte) 0x10, (byte) 0x10, (byte) 0x11, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x02, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x26, (byte) 0x01, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x01, (byte) 0x02, (byte) 0x02, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x02, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x21, (byte) 0x01, (byte) 0x00, (byte) 0x11, (byte) 0x11,
    (byte) 0x11, (byte) 0x11, (byte) 0x11, (byte) 0x00, (byte) 0x11,
    (byte) 0x00, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01, (byte) 0x01,
    (byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x01 },
  { (byte) 0x03, (byte) 0x00, (byte) 0x12, (byte) 0x32, (byte) 0x32,
    (byte) 0x32, (byte) 0x02, (byte) 0x42, (byte) 0x02, (byte) 0x42,
    (byte) 0x02, (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x10, (byte) 0x12, (byte) 0x12, (byte) 0x03,
    (byte) 0x10, (byte) 0x10, (byte) 0x12, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x04 },
  { (byte) 0x00, (byte) 0x13, (byte) 0x12, (byte) 0x32, (byte) 0x32,
    (byte) 0x32, (byte) 0x02, (byte) 0x42, (byte) 0x02, (byte) 0x42,
    (byte) 0x02, (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x10, (byte) 0x12, (byte) 0x12, (byte) 0x00,
    (byte) 0x10, (byte) 0x10, (byte) 0x12, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00 },
  { (byte) 0x20, (byte) 0x00, (byte) 0x02, (byte) 0x12, (byte) 0x12,
    (byte) 0x12, (byte) 0x12, (byte) 0x12, (byte) 0x02, (byte) 0x12,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x05, (byte) 0x02, (byte) 0x02, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x00 },
  { (byte) 0x00, (byte) 0x00, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02, (byte) 0x02,
    (byte) 0x02, (byte) 0x00, (byte) 0x02, (byte) 0x02, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x02, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x04 },
  { (byte) 0x10, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00 },
  { (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x30, (byte) 0x30,
    (byte) 0x30, (byte) 0x00, (byte) 0x40, (byte) 0x00, (byte) 0x40,
    (byte) 0x00, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x00,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00 },
  { (byte) 0x00, (byte) 0x10, (byte) 0x10, (byte) 0x30, (byte) 0x30,
    (byte) 0x30, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x00,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00 },
  { (byte) 0x20, (byte) 0x00, (byte) 0x00, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x10, (byte) 0x00, (byte) 0x10,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
    (byte) 0x10, (byte) 0x00, (byte) 0x00, (byte) 0x10, (byte) 0x10,
    (byte) 0x10, (byte) 0x10, (byte) 0x00 }
};


/* data types */
#define	TYPE_IDENT	((byte) 0x00)	/* identifier */
#define	TYPE_VOID	((byte) 0x00)	/* empty data type */
#define TYPE_CHAR	((byte) 0x01)	/* signed 8-bit */
#define TYPE_UCHAR	((byte) 0x02)	/* unsigned 8-bit */
#define TYPE_INT	((byte) 0x03)	/* signed 16-bit */
#define TYPE_UINT	((byte) 0x04)	/* unsigned 16-bit */
#define TYPE_LONG	((byte) 0x05)	/* signed 32-bit */
#define TYPE_ULONG	((byte) 0x06)	/* unsigned 32-bit */
#define TYPE_FLOAT	((byte) 0x07)	/* floating point 32-bit */
#define TYPE_DOUBLE	((byte) 0x08)	/* floating point 64-bit, native */
#define TYPE_STRUCT	((byte) 0x09)	/* struct */
#define TYPE_UNION	((byte) 0x0A)	/* union */
#define TYPE_ARRAY	((byte) 0x0B)	/* array */
#define TYPE_PTR	((byte) 0x10)	/* pointer */
#define TYPE_STRING	(TYPE_PTR+TYPE_CHAR)	/* string */


/* structure of a symbol table entry */
#define OFFSET_SYMTYPE ((word) 0)	/* byte: symbol type */
#define OFFSET_IDADDR ((word) 1)	/* word: pointer to the identifier
					   buffer entry */
#define OFFSET_STORCLASS ((word) 3)	/* byte: storage class */
#define OFFSET_VALTYPE ((word) 4)	/* byte: value type */
#define OFFSET_VALADDR ((word) 5)	/* word: pointer to the value */
#define OFFSET_VALSIZE ((word) 7)	/* word: size of the value */
#define OFFSET_ARYLINK ((word) 9)	/* word: link to next array dimension
					   entry or 0 when last in chain */
#define OFFSET_DIMENSION ((word) 11)	/* word: dimension size of an array,
					   number of function arguments */
#define OFFSET_MEMBLINK ((word) 13)	/* word: link to the member list */
#define OFFSET_LINK ((word) 15)		/* word: link to the next symbol table
					   entry or 0 when last in chain */
#define OFFSET_17 ((word) 17)		/* byte: */
#define OFFSET_18 ((word) 18)		/* byte: */
#define OFFSET_19 ((word) 19)		/* word: */
#define OFFSET_21 ((word) 21)		/* word: */

#define SYMTAB_ENTRY_SIZE 17


/* addresses of system variables in the PB-2000C RAM */
#define SYMB1 ((word) 0x1558)
#define SYMB2 ((word) 0x156F)
#define SYMB3 ((word) 0x1586)


/* symbol types */
#define	VAR_OR_FUNC	((byte) 0x10)	/* variable or function */
#define TYPE_VARIABLE	((byte) 0x11)
#define TYPE_FUNCTION	((byte) 0x12)
#define	STRUCT_UNION	((byte) 0x21)	/* struct/union */
#define TYPE_SUMEMBER	((byte) 0x22)	/* struct/union member */
#define TYPE_LABEL	((byte) 0x31)


/* storage class */
#define CLASS_GLOBAL	((byte) 0x00)	/* global variable */
#define CLASS_EXTERN	((byte) 0x01)
#define CLASS_STATIC	((byte) 0x02)
#define CLASS_ARGUMENT	((byte) 0x04)	/* function argument */
#define CLASS_LOCAL	((byte) 0x05)	/* local variable */


/* bits of the variable "flags2" - compiler state */
#define STATE_DEFINE	0x80	/* #define directive processed */
#define STATE_EXPAN	0x40	/* macro expansion, tokens are fetched from
				   the #define token string buffer */
#define STATE_NAME	0x20	/* macro name following the #define directive
				   processed */


/* values of the variable "scope" */
typedef enum {
  SCOPE_GLOBAL = 0,	/* variables are declared outside a function */
  SCOPE_ARGUMENT = 1,	/* declaration of function arguments */
  SCOPE_LOCAL = 2,	/* variables are declared within a function */
  SCOPE_NONE = 3	/* definition of statements, variables cannot be
			   declared */
} tscope;


/* dummy value written to the P-code buffer, replaced later with an address */
#define PLACEHOLDER	((word) 0)


/* structure of a flow control stack entry */
typedef struct {
  word token;
  int level;
  word addr;
} tflow;


/* global system variables without PB-2000C equivalents */
FILE *ramfp;		/* RAM image file handle */
#define MAX_RECURSION_DEPTH 100
int recursion_depth;


/* global system variables equivalent to the PB-2000C ones */
unsigned int flags1;	/* &H1298, compiler state */
FILE *infp;		/* &H1300, C source file handle */
word token[3];		/* &H1304, three consecutive tokens fetched from the
			   input stream, the latest one first */
word var130a;		/* &H130A, copy of the latest token */
byte ungetbuf[3];	/* &H130C, "unget" buffer for excess bytes read from
			   the C source file */
int loadindex;		/* &H130F, index of the LOAD file table */
unsigned int lineno;	/* &H1311, C source file line number */
word idbuflink;		/* &H1315, top of the linked list of identifiers in
			   the identifier and constant buffer */
byte gpbuf[258];	/* &H1317, general purpose buffer */
unsigned int gpindex;	/* &H1419, general purpose index */
unsigned int flags2;	/* &H141B, compiler state */
unsigned int incldepth;	/* &H141C, include depth, also replaces the variable
			   &H180E, file handle */
tscope scope;		/* &H141D, scope of declared variables */
int var141e;		/* &H141E */
word argcnt;		/* &H141F, number of function arguments */
int var1421;		/* &H1421, branch/loop nesting level */
byte var1422;		/* &H1422, && || ?: nesting level */
int var1423;		/* &H1423 */

#define STK1_SIZE 50
word *stkptr1;		/* &H1424, pointer to the array dimension / expression
			   parser stack */
word stack1[STK1_SIZE];	/* &H1426, stack area */

#define STK2_SIZE 25
tflow *stkptr2;		/* &H148A, pointer to the stack */
tflow stack2[STK2_SIZE]; /* &H148C, stack area */

#define BCTABSIZE 25
tflow *btabptr;		/* &H14F0, pointer to the break table */
tflow *ctabptr;		/* &H14F2, pointer to the continue table */
tflow bctab[BCTABSIZE];	/* &H14F4, break/continue table */

word var159d;		/* &H159D, pointer to ... */
word symvartop;		/* &H159F, top of the linked list of variables in the
			   symbol table */
word var15a3;		/* &H15A3, pointer to ... */
word var15a5;		/* &H15A5, pointer to ... */
word var15a7;		/* &H15A7, pointer to a symbol identifier */
word var15a9;		/* &H15A9 */
word var15ab;		/* &H15AB, size of a structure/union member */
word symfunctop;	/* &H15AD, top of the linked list of functions in the
			   symbol table */


/* #include stack, functional equivalent of the last 2 entries of the original
   table at the address &H16D3 */
#define MAXINCLDEPTH 9
struct {
  FILE *handle;
  unsigned int lineno;
} incl_stack [MAXINCLDEPTH];


/* function prototypes */

void error1 (char *msg);
void error2 (char *msg);
void ram_write (word address, byte *data, int count);
void ram_read (word address, byte *data, int count);
int ram_compare (word address, byte *data, int count);
void ram_clear (word address, int count);
void ram_copy (word dst, word src, int count);
void poke (word address, word data);
word peek (word address);
void cpoke (word address, byte data);
byte cpeek (word address);
unsigned int strtogpbuf (char *name);
int cmpstrgpbuf (char *name);
void wordtogpbuf (int index, word data);
word wordfromgpbuf (int index);
void is_filename (byte *name);

/* &H7643: */ void predsymbols (void);
/* &H76D5: */ void func76D5 (char *name, byte valtype);
/* &H7A14: */ void clear_code (void);
/* &H7A2D: */ void clear_symb (void);
/* &H7A46: */ void clear_define (void);
/* &H7A5F: */ int lexer2 (void);
/* &H7A7B: */ void init (void);
/* &H7AA8: */ word lexer1 (void);
/* &H7B6E: */ void comment (void);
/* &H7B92: */ word identifier (byte x);
/* &H7BF8: */ word str_const (void);
/* &H7C48: */ word char_const (void);
/* &H7C80: */ int escseq (byte *value);
/* &H7D5C: */ word num_const (byte x);
/* &H7D88: */ void eval_decimal (void);
/* &H7E4A: */ void fraction (byte x);
/* &H7E62: */ void eval_float (void);
/* &H7E88: */ int exponent (byte x);
/* &H7F08: */ void eval_octal (void);
/* &H7F3C: */ void eval_hex (void);
/* &H7F78: */ void eval_size (dword x);
/* &H8008: */ int preprocessor (void);
/* &H8082: */ void do_include (void);
/* &H80E1: */ void predmacros (void);
/* &H8240: */ word do_define (void);
/* &H82BA: */ word nextdeftoken (void);
/* &H82DE: */ word nonalpha (byte x);
/* &H831A: */ void to_gpbuf (byte x);
/* &H8367: */ word is_keyword (void);
/* &H87A9: */ word to_idbuf (void);
/* &H8819: */ word seek_idbuf (void);
/* &H884C: */ word to_defidbuf (void);
/* &H88A3: */ word seek_defidbuf (void);
/* &H88E0: */ word to_deftokbuf (word code);
/* &H8972: */ int is_space (byte x);
/* &H8988: */ int is_decimal (byte x);
/* &H8999: */ int is_firstidchar (byte x);
/* &H89D4: */ int is_octal (byte x);
/* &H89E5: */ int is_hex (byte x);
/* &H8A0D: */ int skiptoend (void);
/* &H8A35: */ void open_src (byte *name);
/* &H8A57: */ void close_src (void);
/* &H8A6E: */ byte inbyte (void);
/* &H8AA7: */ void load_check (byte *name);
/* &H8AFD: */ void load_append (byte *name);
/* &H8B58: */ void incl_save (FILE *nfp);
/* &H8BA4: */ void incl_restore (void);
/* &H8BC5: */ void compile_all (void);
/* &H8C17: */ int decl_storage_class (void);
/* &H8C78: */ int decl_data_type (void);
/* &H8D01: */ byte func8D01 (byte u1, /*@out@*/ word *size);
/* &H8DAA: */ void decl_struct (void);
/* &H8E71: */ void func8E71 (void);
/* &H8EAF: */ void func8EAF (void);
/* &H8F45: */ void func8F45 (void);
/* &H8FA6: */ int decl_identifier (void);
/* &H90B3: */ void func90B3 (void);
/* &H90F5: */ void decl_array (void);
/* &H911D: */ void dim_array (void);
/* &H9192: */ void pushdim (word x);
/* &H91AE: */ word popdim (/*@out@*/ int *status);
/* &H91D1: */ void arysize (word x);
/* &H91E8: */ void decl_assign (void);
/* &H928E: */ void func928E (void);
/* &H92B6: */ void func92B6 (void);
/* &H9360: &H9393: */ void check_redef_symbol (word addr, byte symtype);
/* &H939D: */ void check_redef_struct (word ix, word iz);
/* &H93FC: */ void check_redef_array (word ix, word iz);
/* &H942E: */ void parse_function (void);
/* &H9460: */ void decl_function (void);
/* &H94AD: */ void argument_list (void);
/* &H94FA: */ void func94FA (void);
/* &H9519: */ void decl_arguments (void);
/* &H9545: */ void func9545 (void);
/* &H95A8: */ void func95A8 (void);
/* &H95CF: */ void func95CF (void);
/* &H9634: */ void func9634 (void);
/* &H96AE: */ void func96AE (void);
/* &H96C0: */ void func96C0 (void);
/* &H96F8: */ void parse_block (void);
/* &H97A7: */ void out_lineno (void);
/* &H97BD: */ void parse_if (void);
/* &H98B3: */ void parse_while (void);
/* &H994F: */ void parse_do (void);
/* &H99FF: */ void parse_for (void);
/* &H9AE1: */ void parse_break (void);
/* &H9B16: */ void check_break (void);
/* &H9B3F: */ void update_break (void);
/* &H9B7F: */ void parse_continue (void);
/* &H9BB4: */ void check_continue (void);
/* &H9BDD: */ void update_continue (void);
/* &H9C19: */ void parse_return (void);
/* &H9C2D: */ void out_return (void);
/* &H9C44: */ void parse_goto (void);
/* &H9C71: */ void parse_label (void);
/* &H9CC0: */ word addr_from_stack2 (void);
/* &H9CD0: */ void push_stack2 (void);
/* &H9CEF: */ void pop_stack2 (void);
/* &H9CEF: */ void drop_stack2 (void);
/* &H9D0E: */ void append_break (void);
/* &H9D30: */ void append_continue (void);
/* &H9D52: */ void func9D52 (void);
/* &H9D78: */ void func9D78 (void);
/* &H9DF4: */ void func9DF4 (void);
/* &H9E73: */ void func9E73 (void);
/* &H9EAB: */ int func9EAB (word code);
/* &HA3BD: */ void funcA3BD (void);
/* &HA42C: */ void funcA42C (void);
/* &HA468: */ void funcA468 (void);
/* &HA4CB: */ void funcA4CB (void);
/* &HA4F5: */ int funcA4F5 (void);
/* &HA5D8: */ int funcA5D8 (void);
/* &HA665: */ int funcA665 (void);
/* &HA6A7: */ int funcA6A7 (void);
/* &HA6CB: */ int funcA6CB (void);
/* &HA6FF: */ void push_stack1 (word x);
/* &HA718: */ word pop_stack1 (void);
/* &HA731: */ void out_word (word x);
/* &HA74E: */ byte funcA74E (void);
/* &HA762: */ void funcA762 (void);
/* &HA7AC: */ void funcA7AC (void);
/* &HA7F8: */ void to_symtab3 (word src);
/* &HA823: */ void to_symtab4 (word src);
/* &HA863: */ void to_symtab5 (word src);
/* &HA889: */ void to_symtab2 (word src);
/* &HA89D: */ void to_symtab1 (word src);
/* &HA8C2: */ word symtab_first (int mode, byte symtype);
/* &HA8F3: */ word funcA8F3 (int mode, byte symtype, word addr);
/* &HA96F: */ word symtab_next (int mode, byte symtype, word addr);
/* &HA975: */ word funcA975 (int *mode, word addr);


int main (int argc, char **argv)
{
  if (argc <= 1)
  {
    printf ("Missing C source file name\n");
    return 1;
  }

  ramfp = fopen ("ram0.bin", "r+b");
  if (ramfp == NULL)
  {
    printf ("Cannot open the RAM image file \"ram0.bin\"\n");
    return 1;
  }

/* NEW */
  clear_code ();
  clear_symb ();
  predsymbols ();

/* LOAD */
  recursion_depth = 0;
  clear_define ();
  init ();
  lineno = 0;
  open_src ((byte*) *++argv);
  lineno = 1;
  var159d = 0;
  compile_all ();
  lineno = 0;
  close_src ();
  printf ("Ready\n");

  (void) fclose (ramfp);
  return 0;
}


/* error handle routine */
void error1 (char *msg)
{
  printf ("(%u) : %s\n", lineno, msg);
  exit (EXIT_FAILURE);
}


/* error handle routine, displays an identifier pointed to by the "var15a7"
   variable (function equivalent to the &HF73D system one) followed by an
   error message */
void error2 (char *msg)
{
  int length;
  length = (int) (word) cpeek (var15a7+1);
  ram_read (var15a7+4, gpbuf, length);
  gpbuf[length] = (byte) 0;
  printf ("(%u) : '%s' %s\n", lineno, (char*) gpbuf, msg);
  exit (EXIT_FAILURE);
}


/* write to the RAM image file */
void ram_write (word address, byte *data, int count)
{
  if (fseek (ramfp, (long) (unsigned long) address, SEEK_SET) != 0 ||
	fwrite (data, sizeof(byte), (size_t) count, ramfp) != (size_t) count)
  {
    error1 ("RAM image file access error");
  }
}


/* read from the RAM image file */
void ram_read (word address, byte *data, int count)
{
  if (fseek (ramfp, (long) (unsigned long) address, SEEK_SET) != 0 ||
	fread (data, sizeof(byte), (size_t) count, ramfp) != (size_t) count)
  {
    error1 ("RAM image file access error");
  }
}


/* compare a string with the RAM image file, returns 0 if they match */
int ram_compare (word address, byte *data, int count)
{
  static byte x;
  if (fseek (ramfp, (long) address, SEEK_SET) != 0)
  {
    error1 ("RAM image file access error");
  }
  while (count-- != 0)
  {
    if (fread (&x, sizeof(byte), (size_t) 1, ramfp) != (size_t) 1)
    {
      error1 ("RAM image file access error");
    }
    if (*data++ != x)
    {
      return 1;
    }
  }
  return 0;
}


/* clear a memory block within the RAM image file with zeros */
void ram_clear (word address, int count)
{
  byte x = (byte) 0;
  if (fseek (ramfp, (long) address, SEEK_SET) != 0)
  {
    error1 ("RAM image file access error");
  }
  while (count-- != 0)
  {
    if (fwrite (&x, sizeof(byte), (size_t) 1, ramfp) != (size_t) 1)
    {
      error1 ("RAM image file access error");
    }
  }
}


/* copy a memory block within the RAM image file */
void ram_copy (word dst, word src, int count)
{
  while (count-- != 0)
  {
    cpoke (dst++, cpeek (src++));
  }
}


/* write a word to the RAM image file */
void poke (word address, word data)
{
  static byte x[2];
  x[0] = (byte) data;
  x[1] = (byte) (data >> 8);
  ram_write (address, x, 2);
}


/* read a word from the RAM image file */
word peek (word address)
{
  static byte x[2];
  ram_read (address, x, 2);
  return (word) x[0] + (((word) x[1]) << 8);
}


/* write a byte to the RAM image file */
void cpoke (word address, byte data)
{
  ram_write (address, &data, 1);
}


/* read a byte from the RAM image file */
byte cpeek (word address)
{
  static byte x;
  ram_read (address, &x, 1);
  return x;
}


/* copy an identifier string along with the terminating '\0' to the gpbuf,
   returns the string length; */
unsigned int strtogpbuf (char *name)
{
  unsigned int i = 0;
  while (((gpbuf+4)[i] = (byte) name[i]) != (byte) 0)
  {
    i++;
  }
  gpbuf[1] = (byte) (i);	/* string length */
  return i;
}


/* compare an identifier string with the contents of the gpbuf,
   returns 0 if they match */
int cmpstrgpbuf (char *name)
{
  byte *ptr = gpbuf+4;
  char c;
  while ((c = *name++) != '\0')
  {
    if (c != (char) *ptr++)
    {
      return 1;
    }
  }
  return 0;
}


/* write a word to two consecutive bytes of "gpbuf" */
void wordtogpbuf (int index, word data)
{
  gpbuf[index] = (byte) data;
  gpbuf[++index] = (byte) (data >> 8);
}



/* read a word from two consecutive bytes of "gpbuf" */
word wordfromgpbuf (int index)
{
  return (word) gpbuf[index] | (((word) gpbuf[index+1]) << 8);
}


/* check if the zero terminated string "name" is a valid file name */
void is_filename (byte *name)
{
  int i,j;
  byte x;

  i = 0;
  j = 8;
  while ((x = *name++) != (byte) 0)
  {
    if (x == (byte) '.')
    {
      i = 0;
      j -= 5;
    }
    else if (is_firstidchar (x) != 0 || is_decimal (x) != 0 || x == (byte) '$')
    {
      i++;
    }
    else
    {
      j = -1;
    }
    if (i > j)
    {
      error1 ("Illegal file name");
    }
  }
}


/* &H7643: pre-defined symbols */
void predsymbols (void)
{
  scope = SCOPE_GLOBAL;
  symvartop = 0;
  idbuflink = 0;
  flags2 = 0;
  funcA762 ();
  funcA7AC ();
  cpoke (SYMB1+OFFSET_SYMTYPE, (byte) 0);
  to_symtab3 (SYMB1);
  func76D5 ("stdin", TYPE_STRING);
  func76D5 ("stdout", TYPE_STRING);
  func76D5 ("stderr", TYPE_STRING);
  func76D5 ("errno", TYPE_INT);
}


/* &H76D5: add a predefined symbol to the identifier buffer and the symbol
   table */
void func76D5 (char *name, byte valtype)
{
  unsigned int length;
  cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_VARIABLE);
  cpoke (SYMB1+OFFSET_VALTYPE, valtype);
  gpbuf[0] = TYPE_IDENT;
  length = strtogpbuf (name);
  gpbuf[1] = (byte) length;
  wordtogpbuf (2, 0x0000);
  gpindex = length + 4;
  poke (SYMB1+OFFSET_IDADDR, to_idbuf ());
  to_symtab3 (SYMB1);
}


/* &H7A14: clear the code area */
void clear_code (void)
{
  poke (0x0A82, peek (0x0A80));
  poke (0x0A84, peek (0x0A86));
}


/* &H7A2D: clear the symbol area */
void clear_symb (void)
{
  poke (0x0A8A, peek (0x0A88));
  poke (0x0A8C, peek (0x0A8E));
}


/* &H7A46: clear the define/global/stack area */
void clear_define (void)
{
  poke (0x0A92, peek (0x0A90));
  poke (0x0A94, peek (0x0A96));
}


/* &H7A5F: fetches a token from the input stream to the "token[0]" variable,
   returns 0 if not the end of C source */
int lexer2 (void)
{
  word y;
  int z = 0;
  do {
    y = lexer1 ();
    if (y == 0xFFFF)
    {				/* end of file */
      y = 0x0F00;
    }
    else if (y == 0xFFFE)
    {				/* #define state */
      y = do_define ();
    }
    else
    {
      break;
    }
  } while (y == 0xFFFE ||	/* loop if still in the #define state ... */
    (z = skiptoend ()) == 0);	/* ... or not the end of the C source yet */
  token[0] = y;
  return z;
}


/* &H7A7B: initialise various compiler variables */
void init (void)
{
  loadindex = -1;
  ungetbuf[0] = (byte) 0;
  ungetbuf[1] = (byte) 0;
  ungetbuf[2] = (byte) 0;
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  flags2 = 0;
  incldepth = 0;
  predmacros ();
}


/* &H7AA8: lexical analyzer, processes a single lexem from the input stream,
   returns its code or storage address, depending on the type, or:
   0xFFFF if end of file encountered,
   0xFFFE if in the #define state */
word lexer1 (void)
{
  byte x;

  if ((flags2 & STATE_EXPAN) != 0)
  {
    return nextdeftoken ();
  }
  do {					/* &H7AB9: */
    x = inbyte ();
    if (x == (byte) 0x1A)
    {
      return 0xFFFF;			/* end of file */
    }
    else if (x == (byte) 0x0A)
    {
      lineno++;
      if ((flags2 & STATE_DEFINE) != 0)
      {
        return 0xFFFE;			/* end of line in the #define state */
      }
    }
    else if (x == (byte) 0x00 || is_space (x) != 0)
    {
    }
    else if (x < (byte) 0x20 || x >= (byte) 0x7F)
    {
      error1 ("Unknown character");
    }
    else if (x == (byte) '/')
    {
      x = inbyte ();			/* test for EOF at &H7AFD omitted */
      if (x != (byte) '*')
      {
        ungetbuf[0] = x;
        return nonalpha ((byte) '/');
      }
      comment ();
    }
    else if (x == (byte) '#')
    {
      if (preprocessor () == 6)
      {
        return 0xFFFE;			/* #define */
      }
      /* else continue with an #include */
    }
    else
    {
      break;
    }
  } while (1);
/* &H7B13: */
  if (is_firstidchar (x) != 0)
  {
    return identifier (x);
  }
  if (x == (byte) '\"')
  {
    return str_const ();
  }
  if (x == (byte) '\'')
  {
    return char_const ();
  }
  if (is_decimal (x) != 0 ||
	(x == (byte) '.' && is_decimal (ungetbuf[0] = inbyte ()) != 0))
  {
    return num_const (x);
  }
  return nonalpha (x);
}


/* &H7B6E: skip characters until the end of a comment,
   slightly modified against the original */
void comment (void)
{
  byte x1, x2;

  x2 = (byte) 0;
  do {
    x1 = x2;
    x2 = inbyte ();
    if (x2 == (byte) 0x1A)
    {
      error1 ("Syntax error");
    }
    if (x2 == (byte) 0x0A)
    {
      lineno++;
    }
  } while (x1 != (byte) '*' && x2 != (byte) '/');
}


/* &H7B92: identifier */
word identifier (byte x)
{
  word addr = 0xFFFF;		/* any non-zero value */
  gpbuf[0] = TYPE_IDENT;
  do {
    to_gpbuf (x);
    x = inbyte ();
  } while (is_decimal (x) != 0 || is_firstidchar (x) != 0);
  ungetbuf[0] = x;
  if ((flags2 & STATE_DEFINE) == 0 && (addr = seek_defidbuf ()) != 0)
  {				/* &H7BC2: */
    flags2 = STATE_EXPAN;
    ram_read (addr, &gpbuf[1], 4);
    addr = nextdeftoken ();
  }
  else if (((flags2 & STATE_NAME) == 0 || addr == 0) &&
	(addr = is_keyword ()) != 0)
  {				/* &H7BE2: */
    gpindex = 1;
    gpbuf[0] = TYPE_CHAR;
  }
  else
  {				/* &H7BF4: */
    addr = to_idbuf ();
  }
  return addr;
}


/* &H7BF8: string constant,
   returns the address of the entry in the identifier and constant buffer,
   or 0 if #define state */
word str_const (void)
{
  byte x;

  gpbuf[0] = TYPE_STRING;
  gpindex++;
  while ((x = inbyte ()) != (byte) '\"')
  {
    if (x == (byte) 0x1A || x == (byte) 0x0A)	/* end of file or new line */
    {
      error1 ("Illegal string");
    }
    if (x == (byte) '\\' && escseq (&x) != 0)
    {
      lineno++;		/* a new line occurred after the backslash */
    }
    else
    {
      to_gpbuf (x);
    }
  }
  gpbuf[1] = (byte) (gpindex - 2);	/* store the string length */
  to_gpbuf ((byte) 0);
  return to_idbuf ();
}


/* &H7C48: character constant,
   returns the address of the entry in the identifier and constant buffer,
   or 0 if #define state */
word char_const (void)
{
  byte x;

  x = inbyte ();
  if (x == (byte) 0x1A || x == (byte) 0x0A)	/* end of file or new line */
  {
    error1 ("Illegal char constant");
  }
  if (x == (byte) '\\')
  {
    if (escseq (&x) != 0)
    {
      error1 ("Illegal char constant");
    }
  }
  gpbuf[0] = TYPE_INT;
  to_gpbuf (x);
  to_gpbuf ((byte) 0);
  x = inbyte ();
  if (x == (byte) 0x1A || x != (byte) '\'')	/* end of file or apostroph */
  {
    error1 ("Illegal char constant");
  }
  return to_idbuf ();
}


/* &H7C80: escape sequence, process the characters following the backslash,
   returns not zero if a new line occurred after the backslash */
int escseq (byte *value)
{
  byte x, y;
  int i, flag;

  flag = 0;
  x = inbyte ();
  switch (x)
  {
    case 0x1A:
      error1 ("Illegal escape sequence");
      break;
    case 0x0A:
      flag = 1;
      break;
    case (byte) '\"':
    case (byte) '\'':
    case (byte) '\\':
      break;
    case (byte) 'a':
      x = (byte) 0x07;
      break;
    case (byte) 'b':
      x = (byte) 0x08;
      break;
    case (byte) 't':
      x = (byte) 0x09;
      break;
    case (byte) 'f':
      x = (byte) 0x0C;
      break;
    case (byte) 'r':
      x = (byte) 0x0D;
      break;
    case (byte) 'n':
      x = (byte) 0x0A;
      break;
    case (byte) 'X':
    case (byte) 'x':
      x = (byte) 0;
      for (i=0; i<2; i++)
      {
        y = inbyte ();
        if (is_hex (y) != 0)
        {
          if (is_decimal (y) == 0)
          {
            y += (byte) 0x09;
          }
          x = (x << 4) | (y & (byte) 0x0F);
        }
        else
        {
          ungetbuf[0] = y;
          break;
        }
      }
      break;
    default:
      if (is_octal (x) != 0)
      {
        x &= 0x07;
        for (i=0; i<2; i++)
        {
          y = inbyte ();
          if (is_octal (y) != 0)
          {
            if (x > (byte) 31)
            {
              error1 ("Illegal escape sequence");
            }
            x = (x << 3) | (y & (byte) 0x07);
          }
          else
          {
            ungetbuf[0] = y;
            break;
          }
        }
      }
      break;
  }
  *value = x;
  return flag;
}


/* &H7D5C: numeric constant,
   returns the address of the entry in the identifier and constant buffer,
   or 0 if #define state */
word num_const (byte x)
{
  if (x == (byte) '0')
  {					/* &H7DC3: */
    x = inbyte ();
    if (x == (byte) 0x1A)
    {					/* &H7DC8: */
      to_gpbuf ((byte) '0');
      ungetbuf[0] = x;
      eval_octal ();
    }
    else if (x == (byte) 'X' || x == (byte) 'x')
    {					/* &H7E0C: */
      ungetbuf[1] = x;
      x = inbyte ();
      if (x != (byte) 0x1A && is_hex (x) != 0)
      {					/* &H7E2C: */
        ungetbuf[1] = (byte) 0;
        do {				/* &H7E32: */
          to_gpbuf (x);
          x = inbyte ();
        } while (x != (byte) 0x1A && is_hex (x) != 0);
        ungetbuf[0] = x;
      }
      else
      {					/* &H7E1C: */
        ungetbuf[0] = ungetbuf[1];
        ungetbuf[1] = x;
        to_gpbuf ((byte) '0');
      }
      eval_hex ();
    }
    else
    {					/* &H7DDC: */
      to_gpbuf ((byte) '0');
      while (x != (byte) 0x1A && is_octal (x) != 0)
      {					/* &H7DE8: */
        to_gpbuf (x);
        x = inbyte ();
      }
      if (x == (byte) 0x1A)
      {					/* &H7E01: */
        ungetbuf[0] = x;
        eval_octal ();
      }
      else if (x == (byte) '.')
      {
        fraction (x);
        eval_float ();
      }
      else if (exponent (x) != 0)
      {
        eval_float ();
      }
      else
      {
        eval_octal ();
      }
    }
  }
  else if (x == (byte) '.')
  {
    fraction (x);
    eval_float ();
  }
  else
  {					/* &H7D67: */
    do {
      to_gpbuf (x);
      x = inbyte ();
    } while (x != (byte) 0x1A && is_decimal (x) != 0);
    if (x == (byte) 0x1A)
    {					/* &H7D6F: */
      ungetbuf[0] = x;
      eval_decimal ();
    }
    else if (x == (byte) '.')
    {
      fraction (x);
      eval_float ();
    }
    else if (exponent (x) != 0)
    {
      eval_float ();
    }
    else
    {					/* &H7D88: */
      eval_decimal ();
    }
  }
  return to_idbuf ();
}


/* &H7D88: evaluate a decimal integer number in the "gpbuf",
   different method than in the original */
void eval_decimal (void)
{
  dword x = 0L;
  byte y;
  byte *bufptr = &gpbuf[1];
  while ((y = *bufptr++) != (byte) 0)
  {
    if (x > (dword) 214748364L)		/* 2^31 / 10 */
    {
/* in case of an overflow, the result saturates */
      x = (dword) 0x7FFFFFFFL;
      break;
    }
    x = x * 10 + (dword) (y & (byte) 0x0F);
    if (x > (dword) 0x7FFFFFFFL)
    {
/* in case of an overflow, the result saturates */
      x = (dword) 0x7FFFFFFFL;
      break;
    }
  }
/* &H7D95: from now on the program matches the original code */
  eval_size (x);
  if (gpbuf[0] == TYPE_UINT)
  {					/* &H7D9D: */
    gpindex = 5;
    gpbuf[0] = TYPE_LONG;
  }
  else if (gpbuf[0] == TYPE_UINT)
  {					/* &H7DAE: */
    gpbuf[0] = TYPE_LONG;
    gpbuf[1] = (byte) 0xFF;
    gpbuf[2] = (byte) 0xFF;
    gpbuf[3] = (byte) 0xFF;
    gpbuf[4] = (byte) 0x7F;
  }
}


/* &H7E4A: append decimal digits after the decimal point and an optional
   exponent to the "gpbuf" */
void fraction (byte x)
{
  do {
    to_gpbuf (x);
    x = inbyte ();
  } while (x != (byte) 0x1A && is_decimal (x) != 0);
  (void) exponent (x);
}


/* &H7E62: evaluate a positive floating point number in the "gpbuf",
   correct format of input data is assumed,
   different method than in the original */
void eval_float (void)
{
  dword mant_lo, mant_hi;
  unsigned int exponent1, exponent2;
  int i;
  int flag; /* 1=decimal point, 2=positive exponent, 3=negative exponent */
  byte x;

  mant_lo = mant_hi = 0L;
  exponent1 = 112;
  exponent2 = 0;
  flag = 0;
  i = 1;

  while ((x = gpbuf[i++]) != (byte) 0)
  {
    if (x == (byte) '.')
    {
      flag = 1;
    }
    else if (x == (byte) 'E' || x == (byte) 'e')
    {
      flag = 2;
    }
    else if (x == (byte) '-')
    {
      flag = 3;
    }
    else if (is_decimal (x) != 0)
    {
      if (flag <= 1)
      {
        if ((mant_hi & (dword) 0xFFFF0000) == 0L)
        {
          mant_hi = (mant_hi << 4) + (mant_lo >> 28);
          mant_lo = (mant_lo << 4) + (dword) (x & (byte) 0x0F);
          if (flag == 1)
          {
            exponent1--;
          }
        }
        else
        {
          if (flag == 0)
          {
            exponent1++;
          }
        }
      }
      else
      {
        exponent2 = exponent2 * 10 + (unsigned int) (x & (byte) 0x0F);
        if (exponent2 > 99)
        {
          error1 ("Invalid number");
        }
      }
    }
  }

  if ((mant_lo | mant_hi) == 0L)
  {
    exponent1 = 0;
  }
  else
  {		/* normalisation */
    while ((mant_hi & (dword) 0xFFFF0000) == 0L)
    {
      mant_hi = (mant_hi << 4) + (mant_lo >> 28);
      mant_lo = (mant_lo << 4) + (dword) (x & (byte) 0x0F);
      exponent1--;
    }
  }

  if (flag == 2)
  {
    exponent1 += exponent2;
  }
  else if (flag == 3)
  {
    exponent1 -= exponent2;
  }

  if (exponent1 > 199)
  {
    error1 ("Invalid number");
  }

  i=1;
  while (i<5)
  {
    gpbuf[i++] = (byte) mant_lo;
    mant_lo >>= 8;
  }
  while (i<8)
  {
    gpbuf[i++] = (byte) mant_hi;
    mant_hi >>= 8;
  }
  gpbuf[7] |= (byte) ((exponent1 % 10) << 4);
  exponent1 /= 10;
  gpbuf[8] = (byte) ((exponent1 % 10) | ((exponent1 / 10) << 4));
  gpbuf[0] = TYPE_DOUBLE;
  gpindex = 9;
}


/* &H7E88: optional exponent of a floating point number */
int exponent (byte x)
{
  if (x != (byte) 'E' && x != (byte) 'e')
  {					/* &H7E92 */
    ungetbuf[0] = x;
    return 0;
  }
  ungetbuf[2] = x;
  x = inbyte ();			/* test for EOF at &H7EA3 omitted */
  if (x == (byte) '+' || x == (byte) '-')
  {					/* &H7EC3: */
    ungetbuf[1] = ungetbuf[2];
    ungetbuf[2] = x;
    x = inbyte ();
    ungetbuf[0] = ungetbuf[1];
    ungetbuf[1] = ungetbuf[2];
    ungetbuf[2] = x;			/* test for EOF at &H7ED9 omitted */
  }
  else
  {					/* &H7EAF: */
    ungetbuf[0] = ungetbuf[2];
    ungetbuf[1] = x;
    ungetbuf[2] = (byte) 0;
  }
  if (is_decimal (x) == 0)
  {
    return 0;
  }
/* &H7EE0: */
  to_gpbuf (inbyte ());
  to_gpbuf (inbyte ());
  while (is_decimal(x=inbyte()) != 0)	/* test for EOF at &H7EEF omitted */
  {					/* &H7EF6: */
    to_gpbuf (x);
  }
  ungetbuf[0] = x;
  return 1;
}


/* &H7F08: evaluate an octal number in the "gpbuf" */
void eval_octal (void)
{
  dword x = 0L;
  byte y;
  byte *bufptr = &gpbuf[1];
  while ((y = *bufptr++) != (byte) 0)
  {
    if ((x & (dword) 0xE0000000L) != 0L)
    {
/* in case of an overflow, the result saturates */
      x = (dword) 0x7FFFFFFFL;
      break;
    }
    x = (x << 3) + (dword) (y & (byte) 0x07);
  }
  eval_size (x);
}


/* &H7F3C: evaluate a hexadecimal number in the "gpbuf" */
void eval_hex (void)
{
  dword x = 0L;
  byte y;
  byte *bufptr = &gpbuf[1];
  while ((y = *bufptr++) != (byte) 0)
  {
    if ((x & (dword) 0xF0000000L) != 0L)
    {
/* in case of an overflow, the result saturates */
      x = (dword) 0x7FFFFFFFL;
      break;
    }
    if (is_decimal (y) == 0)
    {
      y += (byte) 0x09;
    }
    x = (x << 4) + (dword) (y & (byte) 0x0F);
  }
  eval_size (x);
}


/* &H7F78: choose between a 16-bit or 32-bit, signed or unsigned integer,
   the result is stored in the "gpbuf" */
void eval_size (dword x)
{
  int i;

  if (ungetbuf[0] == (byte) 'L' || ungetbuf[0] == (byte) 'l')
  {
/* &H7F88: long integer size was specified with a suffix 'L' or 'l' */
    (void) inbyte ();
    if ((x & (dword) 0x80000000L) != 0L)
    {
/* in case of an overflow, the result saturates */
      x = (dword) 0x7FFFFFFFL;
    }
    gpbuf[0] = TYPE_LONG;
    gpindex = 5;			/* number of bytes */
  }
  else
  {
/* &H7FA8: the size wasn't specified, choose short or long depending on the
   value */
    if ((x & (dword) 0xFFFF0000L) == 0L)
    {					/* &H7FAD: 16-bit */
      gpbuf[0] = ((x & (dword) 0x00008000L) == 0L) ? TYPE_INT : TYPE_UINT;
      gpindex = 3;			/* number of bytes */
    }
    else
    {					/* &H7FBF: 32-bit */
      gpbuf[0] = ((x & (dword) 0x80000000L) == 0L) ? TYPE_LONG : TYPE_ULONG;
      gpindex = 5;			/* number of bytes */
    }
  }
/* &H7FCF: store the result in the "gpbuf", terminated with a zero byte */
  for (i=1; i<6; i++)
  {
    gpbuf[i] = (byte) x;
    x >>= 8;
  }
}


/* &H8008: preprocessor, returns 7 if "include" or 6 if "define" */
int preprocessor (void)
{
  byte x;
  int length, flag;

  gpbuf[0] = TYPE_IDENT;
  length = 0;
  do {
    if ((x = inbyte ()) == (byte) 0x1A)
    {
      error1 ("Illegal preprocessor");
    }
    if ((flag = is_firstidchar (x)) != 0)
    {
      to_gpbuf (x);
      length++;
    }
  } while (flag != 0);
  ungetbuf[0] = x;
  if (length == 7 && cmpstrgpbuf ("include") == 0)
  {
    do_include ();
  }
  else if (length == 6 && cmpstrgpbuf ("define") == 0)
  {
    flags2 = STATE_DEFINE;
  }
  else
  {
    error1 ("Illegal preprocessor");
  }
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  return length;
}


/* &H8082: preprocessor #include */
void do_include (void)
{
  byte x;

/* include depth overflow test moved to the function "open_src", because of
   the extended function of the variable "incldepth" */
  do {
    x = inbyte ();
    if (x == (byte) 0x1A || x == (byte) 0x0A)
    {
      error1 ("Illegal preprocessor");
    }
  } while (x != (byte) '\"' && x != (byte) '<');
  gpindex = 1;
  gpbuf[0] = TYPE_STRING;
  do {
    x = inbyte ();
    if (x == (byte) 0x1A || x == (byte) 0x0A)
    {
      error1 ("Illegal preprocessor");
    }
    if (x == (byte) '\"' || x == (byte) '>')
    {
      x = (byte) 0;
    }
    to_gpbuf (x);
  } while (x != (byte) 0);
  open_src (&gpbuf[1]);
}


/* &H80E1: pre-defined macros */
void predmacros (void)
{
  word addr;

/* #define NULL 0 */
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (2, 0x0000);		/* link, 0 means first in chain */
  gpindex = strtogpbuf ("NULL") + 8;
/* the function "to_defidbuf" cannot be used yet, because it expects at least
   one entry in the #define identifier string buffer */
  addr = peek (0x0A94) - (word) gpindex;
  poke (0x0A94, addr);
  ram_write (addr, gpbuf, (int) gpindex);
  addr += gpindex - 4;
  poke (addr, peek (0x0A92));
  gpbuf[0] = TYPE_INT;
  wordtogpbuf (1, 0x0000);		/* value = 0 */
  gpbuf[3] = (byte) 0;
  gpindex = 3;
  poke (addr+2, to_deftokbuf (0));

/* #define EOF (-1) */
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (1, 0x0000);
  gpindex = strtogpbuf ("EOF") + 8;
  addr = to_defidbuf ();
  poke (addr, peek (0x0A92));
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (1, 0x0000);
  (void) strtogpbuf ("(");
  (void) to_deftokbuf (is_keyword ());
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (1, 0x0000);
  (void) strtogpbuf ("-");
  (void) to_deftokbuf (is_keyword ());
  gpbuf[0] = TYPE_INT;
  wordtogpbuf (1, 0x0001);		/* value = 1 */
  gpbuf[3] = (byte) 0;
  gpindex = 3;
  (void) to_deftokbuf (0);
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (1, 0x0000);
  (void) strtogpbuf (")");
  poke (addr+2, to_deftokbuf (is_keyword ()));

/* #define FILE char */
  gpbuf[0] = TYPE_IDENT;
  wordtogpbuf (1, 0x0000);
  gpindex = strtogpbuf ("FILE") + 8;
  addr = to_defidbuf ();
  poke (addr, peek (0x0A92));
  gpbuf[0] = TYPE_IDENT;
  (void) strtogpbuf ("char");
  poke (addr+2, to_deftokbuf (is_keyword ()));
}


/* &H8240: process a macro definition following the #define directive */
word do_define (void)
{
  word addr, y;
  byte x;

/* name of the macro */
  flags2 += STATE_NAME;
  if (lexer1 () >= 0xFFFE || gpbuf[0] != TYPE_IDENT)
  {
    error1 ("Illegal preprocessor");
  }
  gpindex += 4;
  addr = to_defidbuf ();
  flags2 -= STATE_NAME;
/* first token separated from the name by a space */
  x = inbyte ();
  if (is_space (x) == 0 || x == (byte) 0x0A)
  {
    error1 ("Illegal preprocessor");
  }
  y = lexer1 ();
  if (y >= 0xFFFE)
  {
    error1 ("Illegal preprocessor");
  }
  poke (addr, peek (0x0A92));	/* pointer to the begin of the token string */
  addr += 2;			/* pointer to the end of the token string */
/* rest of the token string */
  do {
    poke (addr, to_deftokbuf (y));
    y = lexer1 ();
  } while (y < 0xFFFE);
  flags2 = 0;
  return y;
}


/* &H82BA: get the next token from the #define token string buffer,
   return its code or address, depending on the type
   if the token is a keyword, the code is returned
   if the token is a constant, it is added to the identifier and constant
   buffer, and the address in the buffer is returned */
word nextdeftoken (void)
{
  word current, ending;			/* pointers to the token string */
  word x;

  current = wordfromgpbuf (1);
  ending = wordfromgpbuf (3);
/* &H82C3: the function &H893C was merged into this one */
/* &H893C: */
  gpindex = (unsigned int) peek (current);
  current += 2;
  if (gpindex == 0)			/* keyword code or constant? */
  {					/* &H8945: keyword code */
    x = peek (current);
    current += 2;
    gpindex = 1;
    gpbuf[0] = TYPE_CHAR;
  }
  else
  {					/* &H8956: constant */
    ram_read (current, gpbuf, (int) gpindex);
    current += gpindex;
    x = to_idbuf ();
  }
/* end of the merged function &H893C */
/* &H82C8: */
  if (current == ending)		/* end of the token string reached? */
  {					/* &H82D7: */
    flags2 = 0;
  }
  else
  {					/* &H82CD: */
    wordtogpbuf (1, current);
    wordtogpbuf (3, ending);
  }
  return x;
}


/* &H82DE: process the longest sequence of characters forming a keyword from
   the input stream, returns the code of the matching keyword
   The function is intended to handle sequences of characters which are not
   alphanumeric, for example > >> >>= */ 
word nonalpha (byte x)
{
  word code, temp;
  gpbuf[0] = TYPE_IDENT;
  to_gpbuf (x);
  code = is_keyword ();
  if (code == 0)
  {
    error1 ("Syntax error");
  }
  while ((ungetbuf[0] = inbyte ()) != (byte) 0x1A)
  {
    to_gpbuf (ungetbuf[0]);
    temp = is_keyword ();
    if (temp == 0)
    {
      break;
    }
    ungetbuf[0] = (byte) 0;
    code = temp;
  }
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  return code;
}


/* &H831A: append the byte "x" to the string stored in the "gpbuf",
   gpbuf[0] contains the data type (an identifier if 0, otherwise a constant),
   in case of an identifier:
   gpbuf[1] contains the string length,
   gpbuf[2] and gpbuf[3] are reserved for the link,
   the string of up to 8 characters begins from the location gpbuf[4] */
void to_gpbuf (byte x)
{
  if (gpindex > 257)
  {
    error1 ("Illegal string");
  }
  else if (gpindex != 257)
  {
    if (gpbuf[0] == TYPE_IDENT)
    {
      if (gpindex > 11)
      {
        return;			/* drop the excess characters */
      }
      if (gpindex < 4)
      {
        gpindex = 4;
      }
    }
    gpbuf[gpindex] = x;
    gpbuf[gpindex+1] = (byte) 0;
  }
  gpindex++;
  if (gpbuf[0] == TYPE_IDENT)
  {
    gpbuf[1] = (byte) (gpindex-4);
  }
}


/* &H8367: look for a keyword matching the string stored at gpbuf[4] of the
   length in gpbuf[1], returns the keyword code or 0 if not found */
word is_keyword (void)
{
  tcode *ptr;

  if (gpbuf[1] > (byte) 8)
  {
    return 0;
  }
  ptr = (allkeywords-1)[(unsigned int) gpbuf[1]];
  while (ptr->code != 0)
  {
    if (cmpstrgpbuf (ptr->string) == 0)
    {
      return ptr->code;
    }
    ptr++;
  }
  return 0;
}


/* &H87A9: add an entry to the identifier and constant buffer,
   source in the "gpbuf", number of bytes in the "gpindex",
   returns the entry address, or 0 if #define state */
word to_idbuf (void)
{
  word x;
  if ((flags2 & STATE_DEFINE) != 0)
  {
    return 0;
  }
  if (gpbuf[0] == TYPE_IDENT)
  {
    x = seek_idbuf ();
    if (x != 0)
    {				/* the identifier already is in the buffer */
      gpindex = 1;
      gpbuf[0] = TYPE_CHAR;
      return x;
    }
    wordtogpbuf (2, idbuflink);
  }
  x = peek (0x0A8C) - (word) gpindex;
  if (x < peek (0x0A8A))
  {
    error1 ("Symbol overflow");
  }
  poke (0x0A8C, x);
  ram_write (x, gpbuf, (int) gpindex);
  if (gpbuf[0] == TYPE_IDENT)
  {
    idbuflink = x;
  }
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  return x;
}


/* &H8819: search the identifier and constant buffer for an identifier stored
   in the gpbuf, returns the entry address or 0 if not found */
word seek_idbuf (void)
{
  word x = idbuflink;
  while (x != 0 &&				/* end of the chain? */
	(cpeek (x+1) != gpbuf[1] ||		/* compare string lengths */
	ram_compare (x+4, &gpbuf[4], (int) gpbuf[1]) != 0))
  {
    x = peek (x+2);
  }
  return x;
}	


/* &H884C: add an entry to the #define identifier string buffer
   source in the gpbuf, number of bytes in the gpindex
   returns the pointer to the "starting address of the token string" in the
   entry, or 0 if the identifier was already in the buffer */
word to_defidbuf (void)
{
  word x;
  x = seek_defidbuf ();
  if (x == 0)
  {
    wordtogpbuf (2, peek (0x0A94));	/* link to the previous entry */
    x = peek (0x0A94) - (word) gpindex;
    if (x < peek (0x0A92))
    {
      error1 ("Stack overflow");
    }
    poke (0x0A94, x);
    ram_write (x, gpbuf, (int) gpindex);
    x += gpindex - 4;
  }
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  return x;
}


/* &H88A3: search the #define identifier string buffer for an identifier stored
   in the gpbuf, returns the entry address (more precisely the pointer to the
   "starting address of the token string" in the entry), or 0 if not found */
word seek_defidbuf (void)
{
  word x;
  x = peek (0x0A94);	/* top of the #define identifier string buffer */
  do {			/* expects at least one entry in the buffer */
    if (cpeek (x+1) == gpbuf[1] &&	/* compare string lengths */
	ram_compare (x+4, &gpbuf[4], (int) gpbuf[1]) == 0)
    {
      return x + (word) gpbuf[1] + 4;	/* found */
    }
    x = peek (x+2);
  } while (x != 0);			/* first in chain? */
  return x;				/* not found */
}


/* &H88E0: append a token to the #define token string buffer,
   returns the contents of the &H0A92 variable, i.e. the ending address of
   the token string buffer */
word to_deftokbuf (word code)
{
  word bytes, length, addr1, addr2;
  if (code == 0)	/* is the token a keyword code or a constant? */
  {
/* &H88E5: append a constant stored in the gpbuf, of the length in gpindex,
   preceded by the length word */
    length = (word) gpindex;
    bytes = length + 2;
  }
  else
  {
/* &H88F3: append a keyword code preceded by a word 0x0000 */
    wordtogpbuf (0, 0x0000);
    wordtogpbuf (2, code);
    bytes = length = 4;
  }
  addr1 = peek (0x0A92);
  addr2 = addr1 + bytes;
  if (peek (0x0A94) < addr2)
  {
    error1 ("Stack overflow");
  }
  poke (0x0A92, addr2);
  if (code == 0)	/* is the token a keyword code or a constant? */
  {
    poke (addr1, length);	/* append the length word for a constant */
    addr1 += 2;
  }
  ram_write (addr1, gpbuf, (int) length);
  gpindex = 1;
  gpbuf[0] = TYPE_CHAR;
  return addr2;
}


/* &H8972: is "x" a space, tab, carriage return, new line, vertical tab,
   or formfeed (0x09 to 0x0D, 0x20) ? */
int is_space (byte x)
{
  return ((x >= (byte) 0x09 && x <= (byte) 0x0D) || x == (byte) ' ') ? 1 : 0;
}


/* &H8988: is "x" a decimal digit? */
int is_decimal (byte x)
{
  return (x >= (byte) '0' && x <= (byte) '9') ? 1 : 0;
}


/* &H8999: is "x" a letter or an underscore? */
int is_firstidchar (byte x)
{
  return ((x >= (byte) 'A' && x <= (byte) 'Z') ||
	(x >= (byte) 'a' && x <= (byte) 'z') |	x == (byte) '_') ? 1 : 0;
}


/* &H89D4: is "x" an octal digit? */
int is_octal (byte x)
{
  return (x >= (byte) '0' && x < (byte) '8') ? 1 : 0;
}


/* &H89E5: is "x" a hexadecimal digit?
   unlike the original function, this one doesn't convert "x" to upper case */
int is_hex (byte x)
{
  return ((x >= (byte) '0' && x <= (byte) '9') ||
	 (x >= (byte) 'A' && x <= (byte) 'F') ||
	 (x >= (byte) 'a' && x <= (byte) 'f')) ? 1 : 0;
}


/* &H8A0D: skip all characters until the end of the line,
   returns 0 if not the end of C source */
int skiptoend (void)
{
  byte x;
  do {
    if (incldepth == 0)
    {
      return 1;			/* end of the C source */
    }
    close_src ();
    x = inbyte ();
  } while (x == (byte) 0x1A);
  while (x != (byte) 0x0A)
  {
    x = inbyte ();
  }
  lineno++;
  return 0;
}


/* &H8A35: open the C source file */
void open_src (byte *name)
{
  FILE *ptr;

/* include depth overflow test moved here from the function "do_include",
   because of the extended function of the variable "incldepth" */
  if (incldepth > MAXINCLDEPTH-1)
  {
    error1 ("Too many include");
  }
  load_check (name);
  is_filename (name);
  ptr = fopen ((char*) name, "rt");
  if (ptr == NULL)
  {
    error1 ("File not found");
  }
  load_append (name);
  incl_save (ptr);
}


/* &H8A57: close the C source file */
void close_src (void)
{
  if (incldepth > 0)
  {
    (void) fclose (infp);
    incl_restore ();
    loadindex--;
  }
}


/* &H8A6E: get a byte from the source file, returns 0x1A if end of file */
byte inbyte (void)
{
  byte x;
  int y;

  x = ungetbuf[0];
  if (x != (byte) 0)
  {
/* shift the contents of the "unget" buffer */
    for (y=0; y < (int) (sizeof(ungetbuf)/sizeof(byte)) - 1; y++)
    {
      ungetbuf[y] = ungetbuf[y+1];
    }
    ungetbuf[y] = (byte) 0;
  }
  else				/* buffer empty */
  {
    do {
      y = getc (infp);
    } while (y == 0x0D);	/* skip the carriage return bytes */
    x = (y != EOF) ? (byte) y : (byte) 0x1A;
  }
  return x;
}


/* &H8AA7: check if the zero terminated file name can be added to the LOAD
   file table */
void load_check (byte *name)
{
  word addr;
  int y, length;
  length = 0;
  while (name[length++] != (byte) 0)
    ;
  addr = peek (0x0A84);		/* top of the LOAD file table */
/* check if the file name already is in the table */
  y = (int) (peek (0x0A86) - addr) / 16;	/* number of entries */
  while (y != 0)
  {
    if (cpeek (addr++) == (byte) 1 &&
	ram_compare (addr, name, length) == 0)
    {
      error1 ("File already exists");
    }
    addr += 15;
    y--;
  }
/* check the available space */
  if (peek (0x0A84) - 16 < peek (0x0A82))
  {
    error1 ("P-code overflow");
  }
}


/* &H8AFD: append the zero terminated file name to the LOAD file table */
void load_append (byte *name)
{
  byte x;
  int length;
  word addr;

/* overflow checks omitted */
  if (loadindex < 0)
  {
    loadindex = (int) (peek (0x0A86) - peek (0x0A84)) / 16;
    x = (byte) 1;
  }
  else
  {
    loadindex++;
    x = (byte) 2;
  }
  addr = peek (0x0A84) - 16;
  poke (0x0A84, addr);
  ram_clear (addr, 16);
  cpoke (addr++, x);
  length = 0;
  while (name[length] != (byte) 0)
  {
    length++;
  }
  ram_write (addr, name, length);
}


/* &H8B58: save the file handle and the line number to the #include stack,
   then select the file of the handle "nfp" as the source for the compiler */
void incl_save (FILE *nfp)
{
  if (incldepth > 0)		/* if not a root source file */
  {
    (incl_stack-1)[incldepth].handle = infp;
    (incl_stack-1)[incldepth].lineno = lineno;
  }
  incldepth++;
  infp = nfp;
  lineno = 1;
}


/* &H8BA4: restore the file handle and the line number from the #include
   stack */
void incl_restore (void)
{
  incldepth--;
  if (incldepth > 0)		/* if not a root source file */
  {
    infp = (incl_stack-1)[incldepth].handle;
    lineno = (incl_stack-1)[incldepth].lineno;
  }
}


/* &H8BC5: main compilation loop */
void compile_all (void)
{
  int status = 0;

  flags1 = 0;
  while (1)
  {					/* &H8BCB: */
    if (status >= 0)
    {
      scope = SCOPE_GLOBAL;
      var141e = 0;
      funcA762 ();
      if (lexer2 () != 0)
      {
        return;
      }
      (void) decl_storage_class ();
      (void) decl_data_type ();
    }
/* &H8BE5: */
    funcA7AC ();
    status = decl_identifier ();
    if (status == 3)
    {					/* &H8BEF: */
      func92B6 ();
      if (token[0] != 0x0360)		/* code of a semicolon */
      {					/* &H8BFD: */
        var141e++;
        (void) lexer2 ();
        status = -1;
      }
    }
    else if (status == 1)
    {
      if (var141e != 0)
      {
        error1 ("Syntax error");
      }
      parse_function ();
    }
  }
}


/*** Symbol declaration functions ***/

/* &H8C17: storage class declaration */
int decl_storage_class (void)
{
  if ((token[0] & 0xFF00) != 0x0000)
  {			
    return 0;		/* not a storage class */
  }
  switch (token[0])
  {
    case 0x0003:	/* extern */
      if (scope != SCOPE_GLOBAL && scope != SCOPE_LOCAL)
      {
        error1 ("Illegal storage class");
      }
      cpoke (SYMB1+OFFSET_17, CLASS_EXTERN);
      cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
      break;
    case 0x0002:	/* static */
      if (scope != SCOPE_LOCAL)
      {
        error1 ("Illegal storage class");
      }
      cpoke (SYMB1+OFFSET_17, CLASS_STATIC);
      cpoke (SYMB1+OFFSET_STORCLASS, CLASS_STATIC);
      break;
    case 0x0001:	/* auto */
    case 0x0004:	/* register */
      if (scope != SCOPE_ARGUMENT && scope != SCOPE_LOCAL)
      {
        error1 ("Illegal storage class");
      }
      break;
    default:
      error1 ("Illegal storage class");
  }
  (void) lexer2 ();
  return 1;
}


/* &H8C78: data type declaration */
int decl_data_type (void)
{
  byte type;
  word size;

  if ((token[0] & 0xFF00) != 0x0100)
  {					/* &H8C82: not a data type token */
    return 0;
  }

  switch (token[0])
  {

    case 0x0108:			/* &H8C8C: void */
      type = TYPE_VOID;
      size = 0;
      (void) lexer2 ();
      break;

    case 0x010E:			/* &H8C99: float */
      type = TYPE_FLOAT;
      size = 4;
      (void) lexer2 ();
      break;

    case 0x010F:			/* &H8CA8: double */
      type = TYPE_DOUBLE;
      size = 8;
      (void) lexer2 ();
      break;

    case 0x0110:			/* &H8CB7: struct */
      cpoke (SYMB1+OFFSET_VALTYPE, TYPE_STRUCT);
      decl_struct ();
      type = TYPE_STRUCT;
      size = var15ab;
      break;

    case 0x0111:			/* &H8CD2: union */
      cpoke (SYMB1+OFFSET_VALTYPE, TYPE_UNION);
      decl_struct ();
      type = TYPE_UNION;
      size = var15ab;
      break;

    case 0x010D:			/* &H8CF0: unsigned */
      (void) lexer2 ();
      type = TYPE_UINT;
      size = 2;
      if ((token[0] & 0xFF00) == 0x0100)
      {
        type = func8D01 ((byte) 1, &size);
      }
      break;

    default:
      type = func8D01 ((byte) 0, &size);

  }

  cpoke (SYMB1+OFFSET_18, (byte) type);
  cpoke (SYMB1+OFFSET_VALTYPE, (byte) type);
  poke (SYMB1+OFFSET_19, size);
  poke (SYMB1+OFFSET_VALSIZE, size);
  return 1;
}


/* &H8D01: part of the original function "decl_data_type" moved into a separate
   function, returns data type and size */
byte func8D01 (
	byte u1,			/* 0 if signed, 1 if unsigned */
	/*@out@*/ word *size		/* returned data size */
) {
  byte type;

  type = TYPE_INT + u1;
  *size = 2;

  switch (token[0])
  {

    case 0x0109:			/* &H8D06: char */
      type = TYPE_CHAR + u1;
      *size = 1;
      (void) lexer2 ();
      break;

    case 0x010B:			/* &H8D15: int */
      (void) lexer2 ();
      break;

    case 0x010A:			/* &H8D26: short */
      (void) lexer2 ();
      if (token[0] == 0x010B)		/* int */
      {
        (void) lexer2 ();
      }
      break;

    case 0x010C:			/* &H8D47: long */
      type = TYPE_LONG + u1;
      *size = 4;
      (void) lexer2 ();
      if (token[0] == 0x010E)		/* float */
      {					/* &H8D57: */
        if (u1 == (byte) 0)
        {				/* &H8CA8: */
          type = TYPE_DOUBLE;		/* long float */
          *size = 8;
          (void) lexer2 ();
        }
        else
        {				/* &H8D59: */
          error1 ("Syntax error");
        }
      }
      else if (token[0] == 0x010B)	/* int */
      {					/* &H8D64: */
        (void) lexer2 ();
      }
      break;

    default:
      if (u1 == (byte) 0)
      {					/* &H8D80: */
        error1 ("Illegal type");
      }

  }

  return type;
}


/* &H8DAA: structure/union declaration */
void decl_struct (void)
{
  word addr;

  if ((flags1 & 0x20) != 0)
  {
    error1 ("Illegal struct/union");
  }
  flags1 |= 0x20;
  ram_copy (SYMB2, SYMB1, 23);
  funcA762 ();
  funcA7AC ();
  cpoke (SYMB1+OFFSET_SYMTYPE, STRUCT_UNION);
  cpoke (SYMB1+OFFSET_VALTYPE, cpeek (SYMB2+OFFSET_VALTYPE));
  (void) lexer2 ();
  if (funcA74E () == TYPE_IDENT)
  {					/* &H8DEE: */
    poke (SYMB1+OFFSET_IDADDR, token[0]);
    (void) lexer2 ();
    if (token[0] != 0x035D)		/* opening curly bracket */
    {					/* &H8DFF: */
      var15a7 = peek (SYMB1+OFFSET_IDADDR);
      addr = symtab_first ((scope == SCOPE_GLOBAL) ? 3 : 1, STRUCT_UNION);
      if (addr == 0 ||
	cpeek (SYMB1+OFFSET_VALTYPE) != cpeek (addr+OFFSET_VALTYPE) )
      {
        error2 ("undefined");
      }
      var15ab = peek (addr+OFFSET_VALSIZE);
      poke (SYMB2+OFFSET_21, addr);
    }
    else
    {					/* &H8E43: */
      var15a7 = peek (SYMB1+OFFSET_IDADDR);
      addr = symtab_first ((scope == SCOPE_GLOBAL) ? 3 : 0, STRUCT_UNION);
      if (addr == 0)
      {
        error2 ("redefined");
      }
      func8E71 ();
    }
  }
  else
  {					/* &H8E68: */
    if (token[0] != 0x035D)		/* opening curly bracket */
    {
      error1 ("Syntax error");
    }
    func8E71 ();
  }

  ram_copy (SYMB1, SYMB2, 23);
  flags1 &= ~0x20;
}


/* &H8E71: part of the original function "decl_struct" moved into a separate
   function */
void func8E71 (void)
{
  func8EAF ();
  poke (SYMB2+OFFSET_21, peek (0x0A8A));
  if (scope == SCOPE_GLOBAL)
  {					/* &H8E8C: */
    to_symtab3 (SYMB1);
  }
  else
  {					/* &H8E91: */
    to_symtab4 (SYMB1);
  }
}


/* &H8EAF: declaration of structure/union members */
void func8EAF (void)
{
  word temp;

  ram_copy (SYMB3, SYMB1, 23);
  var15a5 = 0;
  var15ab = 0;
  (void) lexer2 ();
  if (token[0] == 0x035E)		/* closing curly bracket */
  {
    error1 ("Syntax error");
  }

  do {					/* &H8ED8: */
    funcA762 ();
    if (decl_data_type () == 0)
    {
      error1 ("Syntax error");
    }

    do {				/* &H8EE1: */
      funcA7AC ();
      cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_SUMEMBER);
      if (decl_identifier () == 0 ||
	(token[0] != 0x0356 &&		/* comma */
	token[0] != 0x0360) )		/* semicolon */
      {
        error1 ("Syntax error");
      }
      func8F45 ();
      temp = token[0];
      (void) lexer2 ();
    } while (temp == 0x0356);		/* comma */

  } while (token[0] != 0x035E);		/* closing curly bracket */

/* &H8F26: */
  (void) lexer2 ();
  ram_copy (SYMB1, SYMB3, 23);
  poke (SYMB1+OFFSET_VALSIZE, var15ab);
}


/* &H8F45: */
void func8F45 (void)
{
  word addr;

  addr = peek (SYMB3+OFFSET_MEMBLINK);
  var15a7 = peek (SYMB1+OFFSET_IDADDR);
  while (addr != 0)
  {					/* &H8F5C: */
    if (peek (addr+OFFSET_IDADDR) == var15a7)
    {
      error2 ("redefined");
    }
    addr = peek (addr+OFFSET_LINK);
  }
/* the size of a structure will be equal to the sum of the sizes of its
 members */
  if (cpeek (SYMB3+OFFSET_VALTYPE) == TYPE_STRUCT)
  {					/* &H8F75: */
    poke (SYMB1+OFFSET_VALADDR, var15ab);
    var15ab += peek (SYMB1+OFFSET_VALSIZE);
  }
/* the size of an union will be equal to the size of its largest member */
  else if (var15ab < peek (SYMB1+OFFSET_VALSIZE))
  {					/* &H8F9C: */
    poke (SYMB1+OFFSET_VALSIZE, var15ab);
  }
  to_symtab5 (SYMB1);
}


/* &H8FA6: identifier declaration */
int decl_identifier (void)
{
  byte type;
  type = cpeek (SYMB1+OFFSET_VALTYPE);

  if (token[0] == 0x032D)		/* code of an asterisk */
  {
/* &H8FB2: asterisk - pointer declaration */
    if (type == TYPE_VOID)
    {
      error1 ("Illegal pointer declaration");
    }
    type |= TYPE_PTR;
    cpoke (SYMB1+OFFSET_VALTYPE, type);
    poke (SYMB1+OFFSET_VALSIZE, 2);
    (void) lexer2 ();
/* &H8FCF: pointer to a pointer is not supported */
    if (token[0] == 0x032D)		/* code of an asterisk */
    {
      error1 ("Illegal pointer declaration");
    }
  }

  if (funcA74E () != TYPE_IDENT)
  {
/* &H8FDF: standard function names are reserved */
    if ((token[0] & 0xFF00) == 0x0500)	/* standard function */
    {
      error1 ("Illegal function declaration");
    }
/* &H8FE5: */
    if (token[0] != 0x0360 ||		/* code of a semicolon */
	(type & TYPE_PTR) != (byte) 0)
    {
      error1 ("Syntax error");
    }
    return 0;
  }

/* &H8FFD: an identifier declared */
  poke (SYMB1+OFFSET_IDADDR, token[0]);
  (void) lexer2 ();
  if (token[0] == 0x0329)		/* opening parenthesis */
  {

/* &H900E: function declaration */
    cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_FUNCTION);
    if ((scope == SCOPE_ARGUMENT) ||
	type == TYPE_STRUCT ||
	type == TYPE_UNION ||
	(flags1 & 0x20) != 0)
    {
      error1 ("Illegal function declaration");
    }

    (void) lexer2 ();
    if (token[0] == 0x035B)		/* &H9049: closing parenthesis */
    {
      argcnt = 0;
      (void) lexer2 ();
      if (token[0] == 0x0356 || token[0] == 0x0360) /* comma or semicolon */
      {
        func90B3 ();
        return 3;
      }
/* &H9064: function cannot be initialized */
      if (token[0] == 0x034B)		/* code of a keyword: = */
      {
        error1 ("Illegal initialization");
      }
    }
    else
    {				/* &H906F: */
      argcnt = 1;
    }
  }

  else
  {				/* &H9077 */
    if (type == TYPE_VOID)
    {
      error1 ("Illegal type");
    }
    if (token[0] == 0x032A)	/* &H908C: opening square bracket */
    {
      decl_array ();
    }
    if (token[0] == 0x034B)	/* &H909B: code of a keyword: = */
    {
      decl_assign ();
    }
/* &H909E: */
    if (token[0] != 0x0356 && token[0] != 0x0360) /* comma and semicolon */
    {
      error1 ("Syntax error");
    }
    func90B3 ();
    return 3;
  }

/* &H90E1: */
  if (scope != SCOPE_GLOBAL)
  {
    error1 ("Syntax error");
  }
  return 1;
}


/* &H90B3: part of the original function "decl_identifier" moved into a
   separate function */
void func90B3 (void)
{
  if (	cpeek (SYMB1+OFFSET_VALTYPE) == TYPE_ARRAY &&
	peek (SYMB1+OFFSET_DIMENSION) == 0 &&
	scope != SCOPE_GLOBAL &&
	scope != SCOPE_ARGUMENT &&
	cpeek (SYMB1+OFFSET_STORCLASS) != CLASS_EXTERN)
  {
    error1 ("Illegal array declaration");
  }
}


/* &H90F5: array declaration */
void decl_array (void)
{
  int temp;

  stkptr1 = stack1;			/* clear the array dimension stack */
  (void) lexer2 ();
  if (token[0] == 0x035C)		/* code of a keyword: ] */
  {
/* &H910A: array of unspecified dimension */
    if ((flags1 & 0x20) != 0)
    {
      error1 ("Illegal array declaration");
    }
    pushdim (0);
  }

  else
  {
/* &H911D: array dimension specified */
    dim_array ();
  }

/* &H9166: */
  (void) lexer2 ();

  while (token[0] == 0x032A)		/* code of a keyword: [ */
  {
/* &H9171: multidimensional array */
    (void) lexer2 ();
    dim_array ();
    (void) lexer2 ();
  }

/* &H9176: process the values stored on the array dimension stack */
  do {
    to_symtab2 (SYMB1);
    cpoke (SYMB1+OFFSET_VALTYPE, TYPE_ARRAY);
    arysize (popdim (&temp));
  } while (temp == 0);
}


/* &H911D: array dimension, part of the original function "decl_array" moved
   into a separate function */
void dim_array (void)
{
  byte x;

  x = funcA74E ();
  if (x == TYPE_IDENT)
  {
    error1 ("Syntax error");
  }
  if (token[0] == 0x035C)		/* code of a keyword: ] */
  {
    error1 ("Illegal array declaration");
  }
  if (x == (byte) 0xFF)	/* keyword code? */
  {
    error1 ("Syntax error");
  }
/* the array dimension can be of type int, unsigned int, long */
  if (x != TYPE_INT && x != TYPE_UINT && x != TYPE_LONG)
  {
    error1 ("Illegal array declaration");
  }
  if (x == TYPE_LONG && peek (token[0]+3) /* upper word */ != 0)
/* dimension must be less than 65536 */
  {
    error1 ("Illegal array declaration");
  }
  pushdim (peek (token[0]+1));		/* dimension value */
  (void) lexer2 ();
  if (token[0] != 0x035C)		/* code of a keyword: ] */
  {
    error1 ("Syntax error");
  }
}


/* &H9192: push an entry on the array dimension stack */
void pushdim (word x)
{
  if (stkptr1 >= &stack1[STK1_SIZE])
  {
    error1 ("Illegal array declaration");
  }
  *stkptr1++ = x;
}


/* &H91AE: pop an entry from the array dimension stack,
   status != 0 when top of the stack reached */
word popdim (/*@out@*/ int *status)
{
  *status = (--stkptr1 <= stack1) ? 1 : 0;
  return *stkptr1;
}


/* &H91D1: multiply the SYMB1 value size by the array dimension "x" */
void arysize (word x)
{
  dword y;
  poke (SYMB1+OFFSET_DIMENSION, x);
  y = (dword) peek (SYMB1+OFFSET_VALSIZE) * (dword) x;
  if (y > (dword) 65535)
  {
    error1 ("Illegal array declaration");
  }
  poke (SYMB1+OFFSET_VALSIZE, (word) y);
}


/* &H91E8: value assigned to a declared symbol */
void decl_assign (void)
{
  byte x;
  word size;

  if ((flags1 & 0x20) != 0)
  {
    error1 ("Syntax error");
  }
  poke (SYMB1+OFFSET_MEMBLINK, peek (0x0A82));
  (void) lexer2 ();
  out_lineno ();
  x = cpeek (SYMB1+OFFSET_STORCLASS);
  if (x == CLASS_EXTERN || x == CLASS_ARGUMENT)
  {
    error1 ("Illegal initialization");
  }
  x = cpeek (SYMB1+OFFSET_VALTYPE);
  if (	(x & 0xF0) != (byte) 0 ||	/* pointer or ... */
	x < TYPE_STRUCT)		/* ... numeric type symbol? */
  {
    func928E ();
  }
  else
  {
/* &H9235: character array expected */
    if (cpeek (SYMB1+OFFSET_STORCLASS) == CLASS_LOCAL ||
	token[0] == 0x035D ||		/* opening curly bracket */
	cpeek (SYMB1+OFFSET_VALTYPE) != TYPE_ARRAY)
    {
      error1 ("Illegal initialization");
    }
    x = cpeek (peek (SYMB1+OFFSET_ARYLINK) + OFFSET_VALTYPE);
    if ((x != TYPE_CHAR && x != TYPE_UCHAR) ||
	funcA74E () != TYPE_STRING)
    {
      error1 ("Illegal initialization");
    }
    out_word (token[0]);
    if (peek (SYMB1+OFFSET_DIMENSION) == 0)
    {
/* &H927B: if the array dimension isn't specified, it is assigned the string
   length along with the terminating byte '\0' */
      size = (word) cpeek (token[0]+1) + 1;
      poke (SYMB1+OFFSET_VALSIZE, size);
      poke (SYMB1+OFFSET_DIMENSION, size);
    }
  }
/* &H922A: */
  out_word (0x0F00);
  (void) lexer2 ();
}


/* &H928E: */
void func928E (void)
{
  byte x;
/* the initializing value can be preceded by a minus sign (even a string,
   but this will be caught at the RUN time) */
  if (token[0] == 0x032F)		/* &H929C: minus sign? */
  {
    out_word (0x032F);
    (void) lexer2 ();
  }
  x = funcA74E ();
  if (x == TYPE_IDENT || x == (byte) 0xFF /* keyword code? */)
  {
    error1 ("Syntax error");
  }
  out_word (token[0]);
}


/* &H92B6: */
void func92B6 (void)
{
  word addr;

  var15a7 = peek (SYMB1+OFFSET_IDADDR);

  if (cpeek (SYMB1+OFFSET_SYMTYPE) == TYPE_VARIABLE)
  {						/* &H92D1: */

    if (cpeek (SYMB1+OFFSET_STORCLASS) == CLASS_GLOBAL)
    {						/* &H92DC: */

      if (cpeek (SYMB1+OFFSET_VALTYPE) == TYPE_ARRAY &&
		peek (SYMB1+OFFSET_DIMENSION) == 0)
      {						/* &H933B */
        cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
      }

      else if ((addr = symtab_first (6, VAR_OR_FUNC)) != 0)
      {						/* &H92F7: */
        check_redef_symbol (addr, TYPE_VARIABLE);
        do {					/* &H92FA: */
          if (cpeek (addr+OFFSET_STORCLASS) == CLASS_GLOBAL &&
		peek (SYMB1+OFFSET_MEMBLINK) == 0)
          {					/* &H930B: */
            cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
          }
          else
          {					/* &H9313: */
            if (peek (addr+OFFSET_MEMBLINK) != 0 ||
		peek (0x0A88) + (word) (4 * SYMTAB_ENTRY_SIZE) > addr)
            {
              error2 ("redefined");
            }
            cpoke (addr+OFFSET_STORCLASS, CLASS_EXTERN);
          }
          addr = symtab_next (6, VAR_OR_FUNC, addr);
        } while (addr != 0);
      }

    }

    else if ((addr = symtab_first (6, VAR_OR_FUNC)) != 0)
    {						/* &H92F7: */
      check_redef_symbol (addr, TYPE_VARIABLE);
    }
  }

  else
  {						/* &H9347: */
    cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
    if ((addr = symtab_first (4, VAR_OR_FUNC)) != 0)
    {						/* &H9355: */
      check_redef_symbol (addr, TYPE_FUNCTION);
    }
  }

  to_symtab3 (SYMB1);
}


/* &H9360: &H9393: check if the symbol is not redefined */
void check_redef_symbol (word addr, byte symtype)
{
  byte x;
  x = cpeek (addr+OFFSET_VALTYPE);

  if (cpeek (addr+OFFSET_SYMTYPE) != symtype ||
	x != cpeek (SYMB1+OFFSET_VALTYPE))
  {
    error2 ("redefined");
  }
  x &= 0x0F;
  
  if (x == TYPE_ARRAY)
  {					/* &H938B: */
    check_redef_array (addr, SYMB1);
  }
  else if (x >= TYPE_STRUCT)
  {					/* &H9386: */
    check_redef_struct (addr, SYMB1);
  }
}


/* &H939D: check if the structure/union is not redefined */
void check_redef_struct (word ix, word iz)
{
  ix = peek (ix+OFFSET_ARYLINK);
  iz = peek (iz+OFFSET_ARYLINK);
  if (peek (ix+OFFSET_VALSIZE) != peek (iz+OFFSET_VALSIZE))
  {
    error2 ("redefined");
  }
  do {
    ix = peek (ix+OFFSET_MEMBLINK);
    iz = peek (iz+OFFSET_MEMBLINK);
    if (cpeek (ix+OFFSET_VALTYPE) != cpeek (iz+OFFSET_VALTYPE))
    {
      error2 ("redefined");
    }
    if ((cpeek (ix+OFFSET_VALTYPE) & 0x0F) == TYPE_ARRAY)
    {
      check_redef_array (ix, iz);
    }
    if ((peek (ix+OFFSET_LINK) == 0 && peek (iz+OFFSET_LINK) != 0) ||
	(peek (ix+OFFSET_LINK) != 0 && peek (iz+OFFSET_LINK) == 0))
    {
      error2 ("redefined");
    }
  } while (peek (ix+OFFSET_LINK) != 0);
}


/* &H93FC: check if the array is not redefined */
void check_redef_array (word ix, word iz)
{
  do {
    if (peek (ix+OFFSET_DIMENSION) != 0 &&
	peek (iz+OFFSET_DIMENSION) != 0 &&
	peek (ix+OFFSET_DIMENSION) != peek (iz+OFFSET_DIMENSION))
    {
      error2 ("redefined");
    }
    ix = peek (ix+OFFSET_ARYLINK);
    iz = peek (iz+OFFSET_ARYLINK);
    if (cpeek (ix+OFFSET_VALTYPE) != cpeek (iz+OFFSET_VALTYPE))
    {
      error2 ("redefined");
    }
  } while (cpeek (ix+OFFSET_VALTYPE) == TYPE_ARRAY);
}


/* &H942E: parse a function */
void parse_function (void)
{
  decl_function ();
  scope = SCOPE_ARGUMENT;
  if (argcnt != 0)
  {					/* &H9442: */
    argument_list ();
  }

/* &H9445: */
  while (token[0] != 0x035D)		/* opening curly bracket */
  {					/* &H9451: */
    decl_arguments ();
  }

/* &H9456: */
  func95A8 ();
  (void) lexer2 ();
  func95CF ();
}


/* &H9460: function declaration - type of returned value, identifier */
void decl_function (void)
{
  word addr;
  var15a7 = peek (SYMB1+OFFSET_IDADDR);
  if ((addr = symtab_first (4, VAR_OR_FUNC)) != 0)
  {					/* &H9477: */
    check_redef_symbol (addr, TYPE_FUNCTION);
    do {				/* &H947A: */
      if (cpeek (addr+OFFSET_STORCLASS) == CLASS_GLOBAL)
      {
        error2 ("redefined");
      }
      addr = symtab_next (4, VAR_OR_FUNC, addr);
    } while (addr != 0);
  }
/* &H9487: */
  cpoke (SYMB1+OFFSET_STORCLASS, CLASS_GLOBAL);
  poke (SYMB1+OFFSET_MEMBLINK, peek (0x0A88));
  symfunctop = peek (0x0A8A);
  to_symtab3 (SYMB1);
}


/* &H94AD: list of function arguments */
void argument_list (void)
{
  word temp;
  funcA762 ();
  funcA7AC ();
  do {				/* &H94B3: this loop parses the arguments */
    if (funcA74E () != TYPE_IDENT)
    {
      error1 ("Syntax error");
    }
    poke (SYMB1+OFFSET_IDADDR, token[0]);
    func94FA ();
    (void) lexer2 ();
    if (token[0] == 0x0356)		/* comma */
    {
      argcnt++;
    }
    else if (token[0] != 0x035B)	/* closing parenthesis */
    {
      error1 ("Syntax error");
    }
    temp = token[0];
    (void) lexer2 ();
  } while (temp != 0x035B); /* next argument if not a closing parenthesis */
  poke (symfunctop+OFFSET_DIMENSION, argcnt);
}


/* &H94FA: process an argument */
void func94FA (void)
{
  var15a7 = peek (SYMB1+OFFSET_IDADDR);
  if (symtab_first (0, TYPE_VARIABLE) != 0)
  {
    error2 ("redefined");
  }
  to_symtab4 (SYMB1);
}


/* &H9519: declaration of function arguments */
void decl_arguments (void)
{
  word temp;
  funcA762 ();
  (void) decl_storage_class ();
  (void) decl_data_type ();
  do {				/* &H9522: */
    funcA7AC ();
    if (decl_identifier () != 0)
    {
      temp = token[0];
      func9545 ();
    }
    else
    {
      temp = 0x0360;
    }
    (void) lexer2 ();
  } while (temp != 0x0360);	/* code of a semicolon */
}


/* &H9545: declaration of a function argument */
void func9545 (void)
{
  byte x;
  word addr;
  x = cpeek (SYMB1+OFFSET_VALTYPE);
  if (x == TYPE_STRUCT || x == TYPE_UNION)
  {
    error1 ("Illegal argument declaration");
  }
  var15a7 = peek (SYMB1+OFFSET_IDADDR);
  addr = symtab_first (0, TYPE_VARIABLE);
  if (addr == 0)
  {
    error1 ("Illegal argument declaration");
  }
/* declared arguments are marked by setting the bit 7 of the "storage class"
   field in the symbol table entry */
  if ((cpeek (addr+OFFSET_STORCLASS) & (byte) 0x80) != (byte) 0)
  {
    error2 ("redefined");
  }
  cpoke (SYMB1+OFFSET_STORCLASS, cpeek (SYMB1+OFFSET_STORCLASS) | (byte) 0x80);
/* arguments of the type "float" will be changed to the type "double" */
  if (x == TYPE_FLOAT)
  {					/* &H958D: */
    cpoke (SYMB1+OFFSET_VALTYPE, TYPE_DOUBLE);
    poke (SYMB1+OFFSET_VALSIZE, 8);
  }
  ram_copy (addr, SYMB1, 15);
}


/* &H95A8: remove the declaration marks placed by the function "func9545"
   from the "storage class" fields in the symbol table */
void func95A8 (void)
{
  word addr, offset;
  addr = symfunctop;
  offset = OFFSET_MEMBLINK;
  while ((addr = peek (addr+offset)) != peek (0x0A88))
  {
    cpoke (addr+OFFSET_STORCLASS, cpeek (addr+OFFSET_STORCLASS) & (byte) 0x7F);
    offset = OFFSET_LINK;
  }
}


/* &H95CF: function body */
void func95CF (void)
{
  int temp;
  scope = SCOPE_LOCAL;

  do {					/* &H95D6: */

    funcA762 ();
    temp = decl_storage_class ();
    if (decl_data_type () != 0 || temp != 0)
    {				/* &H95E8: declarations of local symbols */
      do {				/* &H95E8: */
        funcA7AC ();
        temp = decl_identifier ();
        if (temp != 0)
        {				/* &H95F0: */
          func9634 ();
          temp = (int) token[0];
        }
        (void) lexer2 ();
      } while (temp == 0x0356);		/* comma */
    }

    else
    {					/* &H9613: statements */
      scope = SCOPE_NONE;
      func96C0 ();
/* &H961F: */
      while (token[0] != 0x035E)	/* closing curly bracket */
      {					/* &H962B: */
        parse_block ();
      }
/* &H9630: */
      func96AE ();
      return;
    }

  } while (token[0] != 0x035E);		/* closing curly bracket */

/* &H960E: */
  func96C0 ();
  func96AE ();
}


/* &H9634: */
void func9634 (void)
{
  word addr;
  var15a7 = peek (SYMB1+OFFSET_IDADDR);
  if (cpeek (SYMB1+OFFSET_SYMTYPE) == TYPE_VARIABLE)
  {					/* &H964B: */
    if (cpeek (SYMB1+OFFSET_STORCLASS) != CLASS_EXTERN)
    {					/* &H9655: */
      if (symtab_first (0, TYPE_VARIABLE) != 0)
      {
        error2 ("redefined");
      }
    }
    else
    {					/* &H9662: */
      addr = symtab_first (6, VAR_OR_FUNC);
      if (addr != 0)
      {					/* &H966D: */
        check_redef_symbol (addr, TYPE_VARIABLE);
      }
      addr = symtab_first (0, TYPE_VARIABLE);
      if (addr != 0)
      {					/* &H967A: */
        check_redef_symbol (addr, TYPE_VARIABLE);
        do {				/* &H967D: */
          if (cpeek (addr+OFFSET_STORCLASS) != CLASS_GLOBAL)
          {
            error2 ("redefined");
          }
          addr = symtab_next (0, TYPE_VARIABLE, addr);
        } while (addr != 0);
      }
    }
    to_symtab4 (SYMB1);
  }
  else
  {					/* &H9692: */
    addr = symtab_first (4, VAR_OR_FUNC);
    if (addr != 0)
    {
      check_redef_symbol (addr, TYPE_FUNCTION);
    }
    cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
    to_symtab3 (SYMB1);
  }
}


/* &H96AE: return followed by an empty compound statement */
void func96AE (void)
{
  out_return ();
  out_word (0x0600);
  out_word (0x0700);
}


/* &H96C0: */
void func96C0 (void)
{
  poke (symfunctop+OFFSET_VALADDR, peek (0x0A82));
  var1421 = 0;
  stkptr2 = stack2;
  btabptr = bctab;
  ctabptr = &bctab[BCTABSIZE];
}


/* &H96F8: parse a code block */
void parse_block (void)
{
  if (++recursion_depth > MAX_RECURSION_DEPTH)
  {
    error1 ("Too many nests");
  }

  if (token[0] == 0x035D)	/* opening curly bracket */
  {				/* &H970F: */
    (void) lexer2 ();
    while (token[0] != 0x035E)	/* closing curly bracket */
    {				/* &H971C: */
      parse_block ();
    }
    (void) lexer2 ();
  }

  else
  {				/* &H9723: */
    out_lineno ();

    if ((token[0] & 0xFF00) == 0x0200)
    {				/* &H9731: flow control statements */
      switch (token[0])
      {
        case 0x0218:		/* if */
          parse_if ();
          break;
        case 0x021A:		/* while */
          parse_while ();
          break;
        case 0x021B:		/* do */
          parse_do ();
          break;
        case 0x021C:		/* for */
          parse_for ();
          break;
        case 0x0220:		/* break */
          parse_break ();
          break;
        case 0x0221:		/* continue */
          parse_continue ();
          break;
        case 0x0222:		/* return */
          parse_return ();
          break;
        case 0x0223:		/* goto */
          parse_goto ();
          break;
        default:
          error1 ("Syntax error");
      }
    }

    else if ((token[0] & 0xF000) != 0 && cpeek (token[0]+0) == TYPE_IDENT)
    {				/* &H9749: */
      var130a = token[0];
      (void) lexer2 ();
      if (token[0] == 0x035F)	/* code of a colon */
      {				/* &H975A: */
        parse_label ();
        (void) lexer2 ();
        parse_block ();
      }
      else
      {				/* &H9765: */
        flags1 = 0;
        func9E73 ();
        token[1] = var130a;
        func9D78 ();
        (void) lexer2 ();
      }
    }

    else
    {				/* &H977F: */
      flags1 = 0;
      func9D52 ();
      (void) lexer2 ();
    }
  }
  recursion_depth--;
}


/* &H97A7: write the source line number to the P-code buffer */
void out_lineno (void)
{
  out_word ((word) loadindex & 0xFF);
  out_word ((word) lineno);
}


/* &H97BD: statement "if" */
void parse_if (void)
{
  push_stack2 ();
  out_word (token[0]);
  out_word (peek (0x0A82) + (word) 6);
  out_word (PLACEHOLDER);
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0329)		/* opening parenthesis */
  {
    error1 ("Syntax error");
  }
  flags1 = 0x80;
  (void) lexer2 ();
  func9D52 ();
  poke (addr_from_stack2 () + (word) 4, peek (0x0A82));
  (void) lexer2 ();
  var1421++;
  parse_block ();
  var1421--;
  if (token[0] != 0x0219)		/* code of the keyword "else" */
  {					/* &H9838: */
    poke (addr_from_stack2 () + (word) 6, peek (0x0A82));
    drop_stack2 ();
  }
  else
  {					/* &H984A: */
    poke (addr_from_stack2 () + (word) 6, peek (0x0A82) + (word) 4);
    drop_stack2 ();
    push_stack2 ();
    out_word (0x0225);	/* "goto", destination specified by an address */
    out_word (PLACEHOLDER);
    out_lineno ();
    out_word (token[0]);
    (void) lexer2 ();
    var1421++;
    parse_block ();
    var1421--;
    poke (addr_from_stack2 () + (word) 2, peek (0x0A82));
    drop_stack2 ();
  }
}


/* &H98B3: statement "while" */
void parse_while (void)
{
  push_stack2 ();
  out_word (token[0]);
  out_word (peek (0x0A82) + (word) 6);
  out_word (PLACEHOLDER);
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0329)		/* opening parenthesis */
  {
    error1 ("Syntax error");
  }
  flags1 = 0x80;
  (void) lexer2 ();
  func9D52 ();
  poke (addr_from_stack2 () + (word) 4, peek (0x0A82));
  (void) lexer2 ();
  var1421++;
  parse_block ();
  var1421--;
  update_continue ();
  out_word (0x0225);	/* "goto", destination specified by an address */
  out_word (addr_from_stack2 () - (word) 4);
  poke (addr_from_stack2 () + (word) 6, peek (0x0A82));
  drop_stack2 ();
  update_break ();
}


/* &H994F: statement "do" */
void parse_do (void)
{
  word addr;
  push_stack2 ();
  out_word (token[0]);
  (void) lexer2 ();
  var1421++;
  parse_block ();
  var1421--;
  if (token[0] != 0x021A)		/* "while" */
  {
    error1 ("Syntax error");
  }
  update_continue ();
  out_lineno ();
  out_word (token[0]);
  out_word (peek (0x0A82) + (word) 6);
  out_word (addr_from_stack2 () - (word) 4);
  addr = peek (0x0A82);
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0329)		/* opening parenthesis */
  {
    error1 ("Syntax error");
  }
  flags1 = 0x80;
  (void) lexer2 ();
  func9D52 ();
  poke (addr, peek (0x0A82));
  (void) lexer2 ();
  if (token[0] != 0x0360)		/* semicolon */
  {
    error1 ("Syntax error");
  }
  drop_stack2 ();
  update_break ();
  (void) lexer2 ();
}


/* &H99FF: statement "for" */
void parse_for (void)
{
  out_word (0x0224);			/* "for" wrapper */
  out_lineno ();
  push_stack2 ();
  out_word (token[0]);
  out_word (peek (0x0A82) + (word) 10);
  out_word (PLACEHOLDER);
  out_word (PLACEHOLDER);
  out_word (PLACEHOLDER);
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0329)		/* opening parenthesis */
  {
    error1 ("Syntax error");
  }
  flags1 = 0x00;
  (void) lexer2 ();
  func9D52 ();
  poke (addr_from_stack2 () + (word) 4, peek (0x0A82));
  flags1 = 0x00;
  (void) lexer2 ();
  func9D52 ();
  poke (addr_from_stack2 () + (word) 6, peek (0x0A82));
  flags1 = 0x80;
  (void) lexer2 ();
  func9D52 ();
  poke (addr_from_stack2 () + (word) 8, peek (0x0A82));
  (void) lexer2 ();
  var1421++;
  parse_block ();
  var1421--;
  update_continue ();
  out_word (0x0225);	/* "goto", destination specified by an address */
  out_word (addr_from_stack2 () - (word) 4);
  poke (addr_from_stack2 () + (word) 10, peek (0x0A82));
  drop_stack2 ();
  update_break ();
}


/* &H9AE1: statement "break" */
void parse_break (void)
{
  check_break ();
  append_break ();
  out_word (0x0225);	/* "goto", destination specified by an address */
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0360)		/* semicolon */
  {
    error1 ("Syntax error");
  }
  (void) lexer2 ();
}


/* &H9B16: "break" can be used only within a "while", "do" or "for" loop */
void check_break (void)
{
  tflow *ptr;
  word x;
  ptr = stkptr2;
  do {
    if (ptr <= stack2)
    {
      error1 ("Illegal break");
    }
    x = (--ptr)->token;
  } while (x != 0x021A && x != 0x021B && x != 0x021C);	/* while/do/for */
}


/* &H9B3F: update the addresses in the break table */
void update_break (void)
{
  while (btabptr > bctab && (btabptr - 1)->level > var1421)
  {
    poke ((--btabptr)->addr + (word) 2, peek (0x0A82));
  }
}


/* &H9B7F: statement "continue" */
void parse_continue (void)
{
  check_continue ();
  append_continue ();
  out_word (0x0225);	/* "goto", destination specified by an address */
  out_word (PLACEHOLDER);
  (void) lexer2 ();
  if (token[0] != 0x0360)		/* semicolon */
  {
    error1 ("Syntax error");
  }
  (void) lexer2 ();
}


/* &H9BB4: "continue" can be used only within a "while", "do" or "for" loop */
void check_continue (void)
{
  tflow *ptr;
  word x;
  ptr = stkptr2;
  do {
    if (ptr <= stack2)
    {
      error1 ("Illegal continue");
    }
    x = (--ptr)->token;
  } while (x != 0x021A && x != 0x021B && x != 0x021C);	/* while/do/for */
}


/* &H9BDD: update the addresses in the continue table */
void update_continue (void)
{
  while (ctabptr < &bctab[BCTABSIZE] && ctabptr->level > var1421)
  {
    poke ((ctabptr++)->addr + (word) 2, peek (0x0A82));
  }
}


/* &H9C19: statement "return" */
void parse_return (void)
{
  out_return ();
  flags1 = 0;
  (void) lexer2 ();
  func9D52 ();
  (void) lexer2 ();
}


/* &H9C2D: return followed by subsequent address */
void out_return (void)
{
  out_word (0x0222);
  out_word (peek (0x0A82) + (word) 2);
}


/* &H9C44: statement "goto" */
void parse_goto (void)
{
  out_word (token[0]);
  (void) lexer2 ();
  if (funcA74E () != TYPE_IDENT)
  {
    error1 ("Syntax error");
  }
  out_word (token[0]);
  (void) lexer2 ();
  if (token[0] != 0x0360)	/* semicolon */
  {
    error1 ("Syntax error");
  }
  (void) lexer2 ();
}


/* &H9C71: label */
void parse_label (void)
{
  var15a7 = var130a;
  if (symtab_first (0, TYPE_LABEL) != 0)
  {
    error2 ("redefined");
  }
  ram_clear (SYMB1, SYMTAB_ENTRY_SIZE);
  cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_LABEL);
  poke (SYMB1+OFFSET_IDADDR, var130a);
  poke (SYMB1+OFFSET_VALADDR, peek (0x0A82) - 4);
  to_symtab4 (SYMB1);
}


/* &H9CC0: returns the last address stored on the flow control stack */
word addr_from_stack2 (void)
{
  return (stkptr2 - 1) -> addr;
}


/* &H9CD0: push an entry on the flow control stack */
void push_stack2 (void)
{
  if (stkptr2 > &stack2[STK2_SIZE-1])
  {
    error1 ("Too many nests");
  }
  stkptr2->token = token[0];
  stkptr2->level = var1421;
  stkptr2->addr = peek (0x0A82);
  stkptr2++;
}


/* &H9CEF: pop an entry from the flow control stack */
void pop_stack2 (void)
{
  drop_stack2 ();
  token[0] = stkptr2->token;
  var1421 = stkptr2->level;
  poke (0x0A82, stkptr2->addr);
}


/* &H9CEF: drop an entry from the flow control stack */
void drop_stack2 (void)
{
  if (stkptr2 < &stack2[1])
  {
    error2 ("C undefined error");
  }
  stkptr2--;
}


/* &H9D0E: append an entry to the "break" table */
void append_break (void)
{
  if (btabptr+1 > ctabptr)
  {
    error1 ("Too many break/continue");
  }
  btabptr->token = token[0];
  btabptr->level = var1421;
  btabptr->addr = peek (0x0A82);
  btabptr++;
}


/* &H9D30: append an entry to the "continue" table */
void append_continue (void)
{
  if (ctabptr-1 < btabptr)
  {
    error1 ("Too many break/continue");
  }
  ctabptr--;
  ctabptr->token = token[0];
  ctabptr->level = var1421;
  ctabptr->addr = peek (0x0A82);
}


/* &H9D52: parse an expression */
void func9D52 (void)
{
  func9E73 ();
  func9D78 ();
}


/* &H9D78: parse an expression */
void func9D78 (void)
{
  int x, y, z;

  do {						/* &H9D78: */

    z = 2;
    y = func9EAB (token[0]);
    x = func9EAB (token[1]);
    switch (tab9f7b [x-1] [y-1] >> 4)
    {
      case (byte) 1:				/* &HA3BC: */
        /* do nothing */
        break;
      case (byte) 2:				/* &HA3BD: */
        funcA3BD ();
        break;
      case (byte) 3:				/* &HA42C: */
        funcA42C ();
        break;
      case (byte) 4:				/* &HA44A: */
        token[0]++;
        break;
      case (byte) 5:				/* &HA455: */
        *(stkptr1 - 2) = 0;
        break;
      default:
        error1 ("Syntax error");
    }

    if ((token[0] & 0xFF00) == 0x0300)
    {						/* &H9DAC: */
      y = x;
      x = func9EAB (token[0]);
      if (y != 30 && y != 31)
      {
        func9DF4 ();
      }
      else
      {						/* &H9DC3: */
        if ((flags1 & 0x10) != 0)
        {
          error1 ("Illegal sizeof");
        }
        if (y != 30)
        {
          if (x == 1)
          {					/* &H9DD8: */
            funcA468 ();
          }
          else
          {					/* &H9DDD: */
            if (token[2] != 0x032B &&		/* dot */
		token[2] != 0x032C)		/* -> */
            {					/* &H9DF1: */
              funcA4CB ();
            }
            func9DF4 ();
          }
        }
      }

      do {					/* &H9E07: */
        y = func9EAB (*stkptr1);
        switch (tab9f7b [x-1] [y-1] & (byte) 0x0F)
        {
          case (byte) 1:			/* &HA4F5: */
            z = funcA4F5 ();
            break;
          case (byte) 2:			/* &HA5D8: */
            z = funcA5D8 ();
            break;
          case (byte) 3:			/* &HA665: */
            z = funcA665 ();
            break;
          case (byte) 4:			/* &HA6A7: */
            z = funcA6A7 ();
            break;
          case (byte) 5:			/* &HA6CB: */
            z = funcA6CB ();
            break;
          case (byte) 6:			/* &HA6E9: */
            ++*(stkptr1 - 2);
            z = 2;
            break;
          default:
            error1 ("Syntax error");
        }
      } while (z == 1);

    }

    if (z == 2)
    {						/* &H9E2D: */
      token[2] = token[1];
      token[1] = token[0];
/* &H9D57: */
      if ((flags1 & 0x40) == 0)
      {						/* &H9D62: */
        (void) lexer2 ();
      }
      else
      {						/* &H9D67: */
        flags1 &= ~0x40;
        token[0] = var130a;
      }
    }

  } while (z == 2);

/* &H9E46: */
  out_word (0x0700);
}


/* &H9DF4: part of the original function "func9D78" moved into a separate
   function */
void func9DF4 (void)
{
  word x;
  x = token[1] & 0xFF00;
  if (x != 0x0300 && x != 0x0F00)
  {						/* &H9E04: */
    out_word (token[1]);
  }
}


/* &H9E73: */
void func9E73 (void)
{
  stkptr1 = stack1;
  stack1[0] = 0x0F00;
  token[1] = 0x0F00;
  token[2] = 0x0F00;
  var1422 = (byte) 0;
  var1423 = 0;
  out_word (0x0600);
}


/* &H9EAB: */
int func9EAB (word code)
{
  /* &H9F1C: */
  static int tab9f1c[]	= {
     1,  2,  3,  3,	/* 0x0329-0x032C */
     4,  5,  6,  7,	/* 0x032D-0x0330 */
     7,  8,  9, 10,	/* 0x0331-0x0334 */
    11,  7,  7, 12,	/* 0x0335-0x0338 */
    12, 12, 13, 13,	/* 0x0339-0x033C */
    14, 14, 15, 15,	/* 0x033D-0x0340 */
    15, 15, 16, 16,	/* 0x0341-0x0344 */
    17, 18, 19, 20,	/* 0x0345-0x0348 */
    21, 22, 23, 23,	/* 0x0349-0x034C */
    23, 23, 23, 23,	/* 0x034D-0x0350 */
    23, 23, 23, 23,	/* 0x0351-0x0354 */
    23, 24 };		/* 0x0355-0x0356 */
  int x;

  if ((code & 0xF000) == 0)
  {				/* &H9EB0: token code */
    switch (code & 0xFF00)
    {
      case 0x0300:
        if (code < 0x0357)
        {
          x = tab9f1c [code-0x0329];
        }
        else
        {
          switch (code)
          {
            case 0x035A:
              x = 25;
              break;
            case 0x035B:	/* closing parenthesis */
              x = 26;
              break;
            case 0x035C:	/* closing square bracket */
              x = 27;
              break;
            case 0x035F:	/* colon */
              x = 28;
              break;
            case 0x0360:	/* semicolon */
              x = 29;
              break;
            default:
              error1 ("Syntax error");
              x = 0;
          }
        }
        break;
      case 0x0500:
        x = 30;
        break;
      case 0x0F00:
        x = 33;
        break;
      default:
        error1 ("Syntax error");
        x = 0;
    }
  }
  else
  {		/* &H9F0E: address in the identifier and constant buffer */
    x = (cpeek (code) == TYPE_IDENT) ? 31 : 32;
  }
  return x;
}


/* &HA3BD: */
void funcA3BD (void)
{
  byte x;
  (void) lexer2 ();
  if (decl_data_type () != 0)
  {					/* &HA3C5: */
    x = cpeek (SYMB1+OFFSET_VALTYPE);
    if (token[0] == 0x032D)		/* code of an asterisk */
    {					/* &HA3D1: */
      cpoke (SYMB1+OFFSET_VALTYPE, x | TYPE_PTR);
      (void) lexer2 ();
    }
    if (token[0] != 0x035B)		/* closing parenthesis */
    {
      error1 ("Syntax error");
    }
    if (x == TYPE_VOID || x == TYPE_STRUCT || x == TYPE_UNION)
    {
      error1 ("Illegal cast");
    }
    token[0] = 0x0337;			/* explicit type cast */
  }
  else
  {					/* &HA40E: */
    flags1 |= 0x40;
    var130a = token[0];
    token[0] = 0x035A;
  }
}


/* &HA42C: */
void funcA42C (void)
{
  if (token[0] == 0x032D)	/* code of an asterisk */
  {
    token[0] = 0x0338;		/* asterisk as multiplication operator */
  }
  else if (token[0] == 0x032E)	/* code of an ampersand */
  {
    token[0] = 0x0345;		/* ampersand as bitwise AND operator */
  }
  else
  {
    token[0] = 0x033C;		/* minus sign as subtraction operator */
  }
}


/* &HA468: */
void funcA468 (void)
{
  word addr;
  var15a7 = token[1];
  addr = symtab_first (3, VAR_OR_FUNC);
  if (addr != 0)
  {					/* &HA47F: */
    if (cpeek (addr+OFFSET_SYMTYPE) != TYPE_FUNCTION)
    {
      error2 ("not a function");
    }
  }
  else
  {					/* &HA488: */
    addr = symtab_first (4, VAR_OR_FUNC);
    if (addr != 0)
    {					/* &HA490: */
      if (cpeek (addr+OFFSET_SYMTYPE) != TYPE_FUNCTION)
      {
        error2 ("not a function");
      }
      if (cpeek (addr+OFFSET_VALTYPE) != TYPE_INT)
      {
        error2 ("redefined");
      }
    }
    funcA762 ();
    funcA7AC ();
    cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_FUNCTION);
    poke (SYMB1+OFFSET_IDADDR, token[1]);
    cpoke (SYMB1+OFFSET_STORCLASS, CLASS_EXTERN);
    to_symtab3 (SYMB1);
  }
}


/* &HA4CB: */
void funcA4CB (void)
{
  word addr;
  var15a7 = token[1];
  addr = symtab_first (0, TYPE_VARIABLE);
  if (addr == 0)
  {					/* &HA4DF: */
    addr = symtab_first (3, VAR_OR_FUNC);
    if (addr == 0)
    {
      error2 ("undefined");
    }
    if (cpeek (addr+OFFSET_SYMTYPE) != TYPE_VARIABLE)
    {
      error2 ("not a variable");
    }
  }
}


/* &HA4F5: */
int funcA4F5 (void)
{
  byte x;
  if (	var1423 != 0 &&
	token[0] >= 0x032F &&		/* unary minus */
	token[0] != 0x0336 &&		/* sizeof */
	token[0] != 0x035A)
  {					/* &HA512: */
    if (token[0] != 0x032F)		/* unary minus */
    {
      error1 ("Illegal sizeof");
    }
    flags1 |= 0x10;
  }

/* &HA523: */
  switch (token[0])
  {
    case 0x0329:			/* &HA528: function call, destination
					   specified by an address */
      push_stack1 (0x0001);
      push_stack1 (token[1]);
      /*@fallthrough@*/
    case 0x032A:			/* &HA541: */
    case 0x035A:			/* &HA5BF: */
      var1422 += (byte) 1;
      break;
    case 0x0336:			/* &HA54B: sizeof */
      var1423++;
      break;
    case 0x0337:			/* &HA558: explicit type cast */
      x = cpeek (SYMB1+OFFSET_VALTYPE);
      if (x == TYPE_PTR+TYPE_STRUCT || x == TYPE_PTR+TYPE_UNION)
      {					/* &HA568: */
        push_stack1 (peek (SYMB1+OFFSET_21));
      }
      push_stack1 ((word) 0x0100 | (word) cpeek (SYMB1+OFFSET_VALTYPE));
      break;
    case 0x0348:			/* &HA583: logical AND && */
      out_word ((word) 0x0800 | (word) var1422);
      break;
    case 0x0349:			/* &HA596: logical OR || */
      out_word ((word) 0x0A00 | (word) var1422);
      break;
    case 0x034A:		/* &HA5A9: question mark (ternary operator) */
      var1422 += (byte) 1;
      out_word ((word) 0x0C00 | (word) var1422);
      break;
  }
  push_stack1 (token[0]);
  return 2;
}


/* &HA5D8: */
int funcA5D8 (void)
{
  word x;
  x = pop_stack1 ();
  switch (x)
  {
    case 0x0336:			/* &HA5E0: sizeof */
      if (var1423 == 1)
      {
        flags1 &= ~0x10;
      }
      out_word (x);
      break;
    case 0x0337:			/* &HA5FA: explicit type cast */
      out_word (x);
      x = pop_stack1 ();
      out_word (x);
      if (x == 0x0219 || x == 0x021A)	/* "else" or "while" */
      {					/* &HA611: */
        out_word (pop_stack1 ());
      }
      break;
    case 0x0348:			/* &HA620: logical AND && */
      out_word ((word) 0x0900 | (word) var1422);
      break;
    case 0x0349:			/* &HA633: logical OR || */
      out_word ((word) 0x0B00 | (word) var1422);
      break;
    case 0x035F:			/* &HA646: colon (ternary operator) */
      out_word ((word) 0x0E00 | (word) var1422);
      var1422 -= (byte) 1;
      break;
    default:				/* &HA65A: */
      out_word (x);
  }
  return 1;
}


/* &HA665: */
int funcA665 (void)
{
  word x;
  x = pop_stack1 ();
  if (x == 0x0329)			/* opening parenthesis */
  {					/* &HA66D: */
    if (var1423 != 0)
    {
      x = 0x0328;
    }
    out_word (x);
    out_word (pop_stack1 ());
    out_word (pop_stack1 ());
  }
  else if (x != 0x035A)
  {					/* &HA696: */
    out_word (x);
  }
  var1422 -= (byte) 1;
  return 2;
}


/* &HA6A7: */
int funcA6A7 (void)
{
  if (	token[0] !=
	( ((flags1 & 0x80) == 0) ?
	(word) 0x0360 :			/* semicolon */
	(word) 0x035B) )		/* closing parenthesis */
  {
    error1 ("Syntax error");
  }
  return 0;
}


/* &HA6CB: */
int funcA6CB (void)
{
  (void) pop_stack1 ();
  push_stack1 (token[0]);
  out_word ((word) 0x0D00 | (word) var1422);
  return 2;
}


/* &HA6FF: push a word on the expression parser stack */
void push_stack1 (word x)
{
  if (++stkptr1 == &stack1[STK1_SIZE])
  {
    error1 ("Too complex expression");
  }
  *stkptr1 = x;
}


/* &HA718: pop a word from the expression parser stack */
word pop_stack1 (void)
{
  word x;
  x = *stkptr1;
  if (stkptr1 == stack1)
  {
    error1 ("C undefined error");
  }
  stkptr1--;
  return x;
}


/* &HA731: write a word to the P-code buffer */
void out_word (word x)
{
  word addr;
  addr = peek (0x0A82);
  if (peek (0x0A84) < addr+2)
  {
    error1 ("P-code overflow");
  }
  poke (0x0A82, addr+2);
  poke (addr, x);
}


/* &HA74E: returns the data type if the "token[0]" variable represents an
   address of an identifier/constant buffer entry (code >= 0x1000) or 0xFF if
   it represents a keyword code (code < 0x1000) */
byte funcA74E (void)
{
  return ((token[0] & 0xF000) != 0) ? cpeek (token[0]) : (byte) 0xFF;
}


/*** Functions accessing the symbol table ***/

/* &HA762: */
void funcA762 (void)
{
  byte x;
  if (scope == SCOPE_GLOBAL)
  {
    x = CLASS_GLOBAL;
  }
  else if (scope == SCOPE_ARGUMENT)
  {
    x = CLASS_ARGUMENT;
  }
  else
  {
    x = CLASS_LOCAL;
  }
  cpoke (SYMB1+OFFSET_17, x);
  cpoke (SYMB1+OFFSET_STORCLASS, x);
  cpoke (SYMB1+OFFSET_18, TYPE_INT);
  cpoke (SYMB1+OFFSET_VALTYPE, TYPE_INT);
  poke (SYMB1+OFFSET_19, 2);
  poke (SYMB1+OFFSET_VALSIZE, 2);
  poke (SYMB1+OFFSET_21, 0);
}


/* &HA7AC: */
void funcA7AC (void)
{
  cpoke (SYMB1+OFFSET_SYMTYPE, TYPE_VARIABLE);
  cpoke (SYMB1+OFFSET_STORCLASS, cpeek (SYMB1+OFFSET_17));
  cpoke (SYMB1+OFFSET_VALTYPE, cpeek (SYMB1+OFFSET_18));
  poke (SYMB1+OFFSET_VALSIZE, peek (SYMB1+OFFSET_19));
  poke (SYMB1+OFFSET_IDADDR, 0);
  poke (SYMB1+OFFSET_VALADDR, 0);
  poke (SYMB1+OFFSET_ARYLINK, peek (SYMB1+OFFSET_21));
  poke (SYMB1+OFFSET_DIMENSION, 0);
  poke (SYMB1+OFFSET_MEMBLINK, 0);
  poke (SYMB1+OFFSET_LINK, 0);
}


/* &HA7F8: add an entry to the symbol table */
void to_symtab3 (word src /* address of the source symbol in the RAM */)
{
  word addr;
  addr = peek (0x0A8A);
  if (var159d == 0)
  {				/* &HA809: */
    var159d = addr;
  }
  if (symvartop != 0)
  {				/* &HA816: */
    poke (symvartop + OFFSET_LINK, addr);
  }
  symvartop = addr;
  to_symtab1 (src);
}


/* &HA823: add an entry to the symbol table */
void to_symtab4 (word src /* $16,$17 */)
{
  word addr1, addr2;
  addr1 = peek (0x0A88);	/* begin of the symbol table */
  addr2 = peek (0x0A8A);	/* end of the symbol table */
  if (peek (symfunctop+OFFSET_MEMBLINK) == addr1)
  {					/* &HA841: */
    poke (symfunctop+OFFSET_MEMBLINK, addr2);
  }
  else
  {					/* &HA845: */
    poke (var15a3+OFFSET_LINK, addr2);
  }
  var15a3 = addr2;
  poke (src+OFFSET_LINK, addr1);
  to_symtab1 (src);
}


/* &HA863: add an entry to the symbol table */
void to_symtab5 (word src)
{
  word addr;
  addr = peek (0x0A8A);		/* end of the symbol table */
  if (var15a5 == 0)
  {				/* &HA874: */
    poke (SYMB3+OFFSET_MEMBLINK, addr);
  }
  else
  {				/* &HA87C: */
    poke (var15a5+OFFSET_LINK, addr);
  }
  var15a5 = addr;
  to_symtab1 (src);
}



/* &HA889: add an array dimension entry to the symbol table */
void to_symtab2 (word src /* address of the source symbol in the RAM */)
{
  word addr;
  addr = peek (0x0A8A);
  to_symtab1 (src);
  poke (SYMB1+OFFSET_ARYLINK, addr);
}


/* &HA89D: add an entry to the symbol table */
void to_symtab1 (word src /* address of the source symbol in the RAM */)
{
  word addr;
  addr = peek (0x0A8A) + (word) SYMTAB_ENTRY_SIZE;
  if (peek (0x0A8C) < addr)
  {
    error1 ("Symbol overflow");
  }
  poke (0x0A8A, addr);
  ram_copy (addr - (word) SYMTAB_ENTRY_SIZE, src, SYMTAB_ENTRY_SIZE);
}


/* &HA8C2: search the symbol table for the first symbol of an identifier
   pointed to by the "var15a7" variable */
word /* address IX */ symtab_first (int mode /* $16 */, byte symtype /* $17 */)
{
  word addr;

  if (mode < 3)
  {
    addr = peek (symfunctop + OFFSET_MEMBLINK);
  }
  else if (mode == 4 || mode == 6)
  {
    addr = peek (0x0A88);		/* begin of the symbol table */
  }
  else
  {
    addr = var159d;
    if (addr == 0)
    {
      return 0;
    }
  }
  return funcA8F3 (mode, symtype, addr);
}


/* &HA8F3: */
word /* address $4,$5 */ funcA8F3 (int mode /* $16 */, byte symtype /* $17 */,
	word addr /* $4,$5 */)
{
  word temp;	/* additional variable to make the code more structured */
  byte mask;

/* if the lower nibble of the "symtype" is equal 0, the lower nibble of the
   "symbol type" field will be ignored */
  mask = ((symtype & 0x0F) == (byte) 0) ? (byte) 0xF0 : (byte) 0xFF;

  while (1)
  {

    temp = 0;
    if (mode < 2)
    {					/* &HA909: */
      if (addr != peek (0x0A88))	/* begin of the symbol table */
      {
        temp = 1;
      }
      else
      {					/* &HA90E: */
        if (mode == 0)
        {
          addr = 0;
          break;			/* not found */
        }
        addr = var159d;
        mode += 10;
      }
    }

    if (temp == 0)
    {
      if (mode < 15)
      {					/* &HA920: */
        if (addr == 0)
        {
          break;			/* not found */
        }
      }
      else if (addr == peek (0x0A88))	/* begin of the symbol table */
      {					/* &HA92C: */
        addr = peek (var15a9 + OFFSET_LINK);
        mode -= 10;
        continue;
      }
      else if (cpeek (addr + OFFSET_STORCLASS) != CLASS_EXTERN)
      {					/* &HA95E: */
        addr = funcA975 (&mode, addr);
        continue;
      }
    }

/* &HA945: */

    if ((cpeek (addr + OFFSET_SYMTYPE) & mask) == symtype &&
	(var15a7 == 0 || var15a7 == peek (addr + OFFSET_IDADDR)) )
    {
      break;				/* found */
    }
    addr = funcA975 (&mode, addr);

  }
  return addr;
}


/* &HA96F: search the symbol table for the next symbol of an identifier
   pointed to by the "var15a7" variable */
word /* address IX */ symtab_next (int mode /* $16 */, byte symtype /* $17 */,
	word addr /* IX */)
{
  return funcA8F3 (mode, symtype, funcA975 (&mode, addr));
}


/* &HA975: */
word /* address $4,$5 */ funcA975 (int *mode /* $16 */, word addr /* IX */)
{
  if (	(*mode == 5 || *mode == 6) &&
	cpeek (addr + OFFSET_SYMTYPE) == TYPE_FUNCTION &&
	cpeek (addr + OFFSET_STORCLASS) == CLASS_GLOBAL	)
  {					/* &HA98B: */
    var15a9 = addr;
    addr = peek (addr + OFFSET_MEMBLINK);
    *mode += 10;
  }
  else
  {					/* &HA99C: */
    addr = peek (addr + OFFSET_LINK);
  }
  return addr;
}
