WORK1:	EQU	&H0CE6		;work buffer

; CASL/COMET variables in the RAM
L692C:	EQU	&H0AC8		;&H00=PRTOFF, &H01=PRT ON

MYWORK:	EQU	&H0D9E		;IOBUF - SAVE/LOAD I/O buffer
L6FD7:	EQU	MYWORK+0	;top of the local symbol table, grows downwards
L6FD9:	EQU	MYWORK+2	;top of the global symbol table, grows downwards
L6FDB:	EQU	MYWORK+4	;bottom of the symbol table
L6FDD:	EQU	MYWORK+6	;default object code execution address
L6FDF:	EQU	MYWORK+8	;pointer to the begin of the object code
L6FE1:	EQU	MYWORK+10	;last address in the object code
L6FE3:	EQU	MYWORK+12	;Program Counter PC
L6FE5:	EQU	MYWORK+14	;&H00=TROFF, &H01=TRON, &H02=LTRON
L6FE6:	EQU	MYWORK+15
L6FE7:	EQU	MYWORK+16	;&H00=breakpoint not set, &H01=breakpoint set
L6FE8:	EQU	MYWORK+17	;breakpoint address

L6FEE:	EQU	MYWORK+23	;register index
L6FEF:	EQU	MYWORK+24	;register GR0
L6FF1:	EQU	MYWORK+26	;register GR1
L6FF3:	EQU	MYWORK+28	;register GR2
L6FF5:	EQU	MYWORK+30	;register GR3
L6FF7:	EQU	MYWORK+32	;register GR4
L6FF9:	EQU	MYWORK+34	;register FR

L692D:	EQU	MYWORK+35
L692E:	EQU	MYWORK+36

	ORG	&H9890

; pointers to submenus
	DW	LF329, &H606A, &H605E, &H603D	;dump, load, save, disk
	DW	LF2B9, LF31A, LF33E, LF335	;CASL, asmbl, PRT_SW, TR_SW

	ORG	&H98A0

; menu "CASL"
	LDW	$2,L54CD	;jump address
	CAL	&H391D		;BRSTR, set ACJMP
	JR	L54C7

	ORG	&H98B0

; the file list needs to be scrolled
	CAL	L549C		;reload the list of up to 6 displayed files
	JP	&H31CE

	ORG	&H98C0

; handle a printable character $16
	SBC	$16,&H7F
	RTN	Z
	PRE	IX,&H0ABD	;OUTDV, output device
	SBC	(IX+$SX),$30
	JP	C,&H2B99	;if OUTDV=&H00 then display it on the LCD
; if OUTDV=&H01 then put the character to the EDTOP buffer
	PRE	IX,&H08CB	;EDCSR, cursor position
	LDD	$0,(IX+$SX)
	AD	(IX+$SX),$30	;increment the cursor position
	PRE	IX,&H0100
	STD	$16,(IX+$SZ)	;EDTOP buffer at the cursor position
	RTN

; reload the list of up to 6 displayed files
L549C:	CAL	&H2AC4		;CLEDB, clear screen
	PRE	IZ,&H0100	;EDTOP buffer
	LD	$29,6		;counter of displayed directory entries
	LDW	$27,&H0D6F	;table of 6 pointers to directory entries
; this loop places up to 6 ramdisk directory entries into the EDTOP buffer
L54AA:	LDW	$6,($27)	;$6,$7 <- pointer to the directory entry
	ADW	$27,$SY
	ADW	$27,$SY
	SBCW	$6,$SY
	JR	C,L54C4
	PRE	IX,$6		;IX points to a directory entry
	CAL	&H4AFC		;convert directory entry to a printable form
	STIM	$0,(IZ+$SX),8
	STIM	$8,(IZ+$SX),8
	SB	$29,$SY
	JR	NZ,L54AA	;next directory entry
L54C4:	JP	&H4B53		;display the file list from the EDTOP buffer

; BREAK handle routine
L54CD:	CAL	MENU1
	PRE	SS,&H0FEF
	CAL	&H9258		;US <- &H0CE2, initialise the user stack
	CAL	&H392C		;select the LCD as the output device
	CAL	L549C		;reload the list of up to 6 displayed files
L54C7:	LDW	$7,&H040C	;$7 = submenu mode "CASL"
	LDW	$21,LF39C	;string '[asmbl ][source][edit  ][PRT SW]'
	JR	LED8C

; test the PRT_ON/PRTOFF flag
LED34:	PRE	IX,L692C
	SBC	(IX+$SX),$31
	RTN

; menu "TRON"
LED3B:	LD	$0,$SY,JR LED4A
; menu "TROFF"
LED3E:	LD	$0,$SX,JR LED4A
; menu "LTRON"
LED41:	CAL	&H4A47		;$1 <- (OPTCD)
	JP	Z,&H31CE	;jump if the I/O device not present
	LD	$0,&H02
LED4A:	PRE	IX,L6FE5
	JR	LED59

; menu "PRT ON"
LED50:	LD	$0,$SY,JR LED55
; menu "PRTOFF"
LED53:	LD	$0,$SX
LED55:	PRE	IX,L692C
LED59:	STD	$0,(IX+$SX)
	JP	&H3979

; CASL menu "PRT SW"
LED5E:	CAL	&H4A47		;$1 <- (OPTCD)
	JP	Z,&H31CE	;jump if the I/O device not present
	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	LDW	$0,&H5250	;"PR"
	LDW	$2,&H0154	;"T"
	CAL	&H622F		;display the string $0..$15
	LDW	$0,&H4F20	;" O"
	LDW	$2,&H014E	;"N"
	CAL	LED34		;test the PRT_ON/PRTOFF flag
	JR	NZ,LED7E	;skip if PRT ON
	LDW	$0,&H464F	;"OF"
	LDW	$2,&H0146	;"F"
LED7E:	CAL	&H622F		;display the string $0..$15
	LDW	$7,&H0210	;$7 = submenu mode "PRT SW"
	LDW	$21,LEDC5	;string "[PRT ON][PRTOFF]"
LED85:	PHSW	$8
	CAL	&H4A3C		;clear the bufer &H08A7
	PPSW	$7
LED8C:	PRE	IX,&H0D0D
	STD	$7,(IX+$SX)
	PRE	IX,$21
	LD	$29,$SY		;don't display the number $17,$18
	CAL	&H49E5		;copy menu items to &H08A7
	JP	&H5913

; menu "TR SW"
LED9C:	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	LFE9F		;test the Trace mode
	LDW	$0,&H5254	;"TR"
	LDW	$2,&H4E4F	;"ON"
	LDW	$4,&H0120	;" "
	JR	Z,LEDB4		;skip if TRON
	LDW	$3,&H4646	;"FF"
	JR	C,LEDB4		;skip if TROFF
	LDW	$0,&H544C	;"LT"
	LDW	$2,&H4F52	;"RO"
	LDW	$4,&H014E	;"N"
LEDB4:	CAL	&H622F		;display the string $0..$15
	LD	$8,&H02
	LDW	$21,LEDD5	;string "[TRON  ][TROFF ][LTRON ]"
	CAL	&H4A47		;$1 <- (OPTCD)
	JR	Z,LEDC1		;branch if the I/O device not present
	AD	$8,$SY
LEDC1:	LD	$7,&H12,JR LED85	;$7 = submenu mode "TR SW"

LEDC5:	DB	"[PRT ON][PRTOFF]"
LEDD5:	DB	"[TRON  ][TROFF ][LTRON ]"

; submenu entries for the menu "CASL"
LF2B9:	DB	&HFC	;"asmbl"
	DW	LF432
	DB	&HFD	;"source"
	DW	&H56E3
	DB	&HFE	;"edit"
	DW	&H566D
	DB	&HFF	;"PRT SW"
	DW	LED5E
	DB	&H0D	;EXE - assemble the selected file
	DW	LF42F
	DB	&H1C	;cursor right
	DW	&H556C
	DB	&H1D	;cursor left
	DW	&H55E9
	DB	&H1E	;cursor up
	DW	&H55D0
	DB	&H1F	;cursor down
	DW	&H5594
	DB	&H02	;line top
	DW	&H5612
	DB	&H06	;line end
	DW	&H561B

; submenu entries for the menu "asmbl" after successful assembly
LF31A:	DB	&HFC	;"go"
	DW	LF7AB
	DB	&HFD	;"dump"
	DW	LF7A0
	DB	&HFE	;"edit"
	DW	&H566D
	DB	&HFF	;"TR SW"
	DW	LED9C
	DB	&H0D	;EXE - run the object code from the beginning
	DW	LF7D1

; submenu entries for the menu "dump"
LF329:	DB	&HFC	;"object"
	DW	LF9A5
	DB	&HFD	;"regist"
	DW	LF926
	DB	&HFE	;"bpoint"
	DW	LF6E0
	DB	&H0D	;EXE - dump the object code at the address &H0000
	DW	LF9A1

; submenu entries for the menu "TR SW"
LF335:	DB	&HFC	;"TRON"
	DW	LED3B
	DB	&HFD	;"TROFF"
	DW	LED3E
	DB	&HFE	;"LTRON"
	DW	LED41

; submenu entries for the menu "PRT SW"
LF33E:	DB	&HFC	;"PRT ON"
	DW	LED50
	DB	&HFD	;"PRTOFF"
	DW	LED53
	DB	&H0D	;key EXE
	DW	&H3979
	DB	&H00	;no matching code found
	DW	&H31CE

LF39C:	DB	"[asmbl ][source][edit  ][PRT SW]"
LF3BC:	DB	"[go    ][dump  ][edit  ][TR SW ]"
LF3DC:	DB	"[object][regist][bpoint]"

; selecting a file in the menu mode "CASL"
LF42F:	LD	$0,$SY,JR LF434	;quick asembly and execution flag
; menu "asmbl"
LF432:	LD	$0,$SX
LF434:	PRE	IX,L692E
	STD	$0,(IX+$SX)
;
; pass 1
	CAL	&H5884		;addresses of the file selected from the menu
	SBC	$29,&H24	;file type
	JP	NZ,&H31CE	;not a sequential file
	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	&H29E0		;clear the bit 3 of the LCDST variable,
				;otherwise the assembly error messages are
				;displayed in a single line
	CAL	&H2F2B		;PF display, 3-line scroll
	PRE	IZ,$25		;starting address of the source file
	PRE	IX,&H0AAF
	LDM	$23,(IX-$SY),4	;$23,$24=MEMEN, $25,$26=DATDI
	LDW	$27,(IX+$SY)	;$27,$28=DATDI
	LDW	$19,$SY		;line counter = 1
	SBW	$21,$21		;location counter
	PRE	IX,L6FDD
	STM	$21,(IX+$SX),4	;default execution address = &H0000
				;begin of the object code = (MEMEN)
	LD	$29,$SX,JR LF462
;
LF45A:	SBC	$0,&H1A		;EOF?
	JR	Z,LF4BF		;SO error if yes
	CAL	LFE64		;next line of the source code
; look for a START directive obligatory preceded by a label
LF462:	AN	$29,&H0F
	CAL	LFC90		;parse the label field and the operation field
	JR	Z,LF45A		;loop if no instruction or directive found
	ANC	$29,&H04
	JR	Z,LF4BF		;SO error if the label field is empty
	CAL	LFD48		;advance the Location Counter $21,$22
	SBC	$11,&H02	;START directive?
	JR	NZ,LF4BF	;SO error if not
	OR	$29,&H30
	CAL	LFD8B		;end of statement?
	JR	Z,LF497		;skip if yes
; optional START operand, must be a label
	CAL	LFC2C		;fetch a label name pointed to by IZ to $8-$13
	ANC	$29,&H04
	JR	Z,LF4BF		;SO error if no label found
	CAL	LFD88		;end of statement expected
	JR	NZ,LF4BF	;otherwise SO error
	OR	$29,&H40	;START is followed by a not yet defined label
	PRE	IX,WORK1	;work buffer
	STI	$29,(IX+$SX)
	CAL	LFDB2		;store the label and block address at WORK1+1
; look for an END directive
LF497:	CAL	LFE64		;next line of the source code
	CAL	LFC90		;parse the label field and the operation field
	JR	Z,LF4BA		;branch if no instruction or directive found
	CAL	LFD48		;advance the Location Counter $21,$22
	SBC	$11,$SY		;END directive?
	JR	NZ,LF497	;loop if not
;
	CAL	LFD8B		;end of statement expected
	JR	NZ,LF4BF	;otherwise SO error
	ANC	$29,&H44
	JR	NZ,LF4BF	;SO error if START operand undefined or END
				;preceded by a label
	CAL	LFE64		;next line of the source code
	SBC	$0,&H1A		;EOF?
	JR	Z,LF4C8		;pass 2 if yes
	JR	LF462		;parse next block
;
LF4BA:	SBC	$0,&H1A		;EOF
	JR	NZ,LF497
LF4BF:	LD	$2,2		;index of the acronym "SO"
	CAL	LF677		;report an assembly error
LF4C5:	JP	&H3979

; pass 2
LF4C8:	ANC	$29,$SY
	JR	NZ,LF4C5
	SBCW	$21,$SY
	JR	C,LF4C5
	PRE	IX,L6FD9
	STM	$25,(IX+$SX),4
	CAL	&H49A0		;get starting/ending address of current file
	PRE	IZ,$25
	PRE	IX,L6FD9
	LDW	$25,(IX+$SX)
	LDW	$19,$SY		;line counter = 1
	SBW	$21,$21		;location counter
	LD	$29,$SX
LF4E9:	OR	$29,&H10
	LDW	$27,$25
	PRE	IX,WORK1+16
	GRE	IZ,$17
	STM	$17,(IX+$SX),6
LF4F8:	CAL	LFC90		;parse the label field and the operation field
	JR	Z,LF50F		;branch if no instruction or directive found
	CAL	LFD48		;advance the Location Counter $21,$22
	SBC	$11,&H02
	JR	C,LF527		;pass 3 if END
	JR	NZ,LF50A
; START
	AN	$29,&H0F
LF50A:	CAL	LFE64		;next line of the source code
	JR	LF4F8
LF50F:	SBC	$0,&H1A
	JR	NZ,LF50A
	ANC	$29,$SY
	JR	NZ,LF4C5
	JP	LF717

LF51B:	SBC	$11,$SY
	JR	NZ,LF584	;branch if START
; END
	CAL	LFE05		;print a line of the assembly listing
	CAL	LFE64		;next line of the source code
	JR	LF4E9		;next block, pass 2
;
; pass 3
LF527:	OR	$29,&H10
	PRE	IX,WORK1+16
	LDM	$17,(IX+$SX),6
	PRE	IZ,$17
LF533:	PRE	IX,WORK1+10
	STIM	$21,(IX+$SX),4
	GRE	IZ,$0
	STW	$0,(IX+$SY)
	CAL	LFC90		;parse the label field and the operation field
	JR	Z,LF584		;branch if no instruction or directive found
	PRE	IX,WORK1+14
	STD	$11,(IX+$SX)
	CAL	LFD48		;advance the Location Counter $21,$22
	JP	C,LF5E6		;OM error
; parse the operand field
	SBW	$12,$12
	LD	$10,$SX
	SBC	$11,&H03
	JR	C,LF51B		;START, END
	JR	NZ,LF55F
	LD	$11,&H90,JR LF57C	;EXIT, change the opcode to &H9000
LF55F:	SBC	$11,&H06
	JP	Z,LF60C		;DC
	JP	C,LF5EF		;IN, OUT
	SBC	$11,&H07
	JR	Z,LF5D3		;DS
	SBC	$11,&H60
	JR	C,LF58C
	SBC	$11,&H71
	JR	Z,LF58C		;POP
	SBC	$11,&H81
	JR	NZ,LF59F	;branch if not RET
LF57C:	CAL	LFD88		;end of statement expected
	JR	NZ,LF5CB	;otherwise OR error
	CAL	LF65D		;write two words of the object code
LF584:	CAL	LFE05		;print a line of the assembly listing
	CAL	LFE64		;next line of the source code
	JR	LF533

; operands: GR, adr, [,XR]
LF58C:	CAL	LFA97		;parse for a GR register
	JR	NC,LF5CB	;OR error if not found
	LD	$10,$SZ
	DIU	$10
	SBC	$11,&H71
	JR	Z,LF57C		;POP
	CAL	&H01F9		;test for a comma
	JR	NZ,LF5CB	;OR error if not found
; jumps/CALL/push operands: adr [, XR]
LF59F:	CAL	&H01DF		;is next character a letter?
	JR	NC,LF5B3	;branch if not
; address specified by a label
	PHSW	$11
	CAL	LF6C4		;search the symbol table
	LDW	$12,$6
	PPSW	$10
	JR	NZ,LF5BB	;branch if the label found
LF5B0:	LD	$2,$SX,JR LF5CE	;otherwise LA error
; address specified by a signed decimal number
LF5B3:	CAL	LFAB8		;$17,$18 <- value of a number pointed to by IZ
	JR	NC,LF5CB	;OR error
	LDW	$12,$17
; optional index register XR
LF5BB:	CAL	&H01F9		;test for a comma
	JR	NZ,LF57C
	CAL	LFA97		;parse for a GR register
	JR	NC,LF5CB	;OR error if not found
	OR	$10,$SZ
	SBC	$0,$SX		;GR0 cannot be used as an index register
	JR	NZ,LF57C
LF5CB:	LD	$2,6		;index of the acronym "OR"
LF5CE:	CAL	LF677		;report an assembly error
	JR	LF584

; DS operand
LF5D3:	CAL	LFD8B		;end of statement expected
	JR	NZ,LF5CB	;otherwise OR error
	BIUW	$17
	JR	C,LF5E4
	ADW	$23,$17		;$23,$24 = pointer to the end of object code
	JR	C,LF5E4
	SBCW	$25,$23		;$25,$26 = pointer to the end of free area
LF5E4:	JR	NC,LF584
LF5E6:	LD	$2,4		;index of the acronym "OM"
	CAL	LF677		;report an assembly error
	JP	&H3979

; IN/OUT operands
LF5EF:	SB	$11,&H73	;change the opcode to &H9100/&H9200
	CAL	LF65D		;write two words of the object code
	LDD	$0,(IZ+$SX)
	CAL	LF6C4		;search the symbol table
	JR	Z,LF5B0		;LA error if not found
	CAL	&H01F9		;test for a comma
	JR	NZ,LF5CB	;OR error if not found
	CAL	&H0049		;NEXTC, get next character other than space
	CAL	LF666		;write a word of the object code
	CAL	LF6C4		;search the symbol table
	JR	LF61E

; DC operand
LF60C:	LDD	$0,(IZ+$SX)
	SBC	$0,&H27		;apostrophe? (begin of a string)
	JR	Z,LF637
	CAL	LFC2C		;fetch a label name pointed to by IZ to $8-$13
	ANC	$29,&H04
	JR	Z,LF62D		;branch if no label found
; label
	CAL	LF6CB		;search the symbol table
LF61E:	JP	Z,LF5B0		;LA error if not found
LF621:	CAL	LFD88		;end of statement expected
LF624:	JP	NZ,LF5CB	;otherwise OR error
	CAL	LF666		;write a word of the object code
LF62A:	JP	LF584
; number
LF62D:	CAL	LFAB3		;$17,$18 <- value of a number pointed to by IZ
LF630:	JP	NC,LF5CB	;OR error if the value > 65535
	LDW	$6,$17,JR LF621
; string
LF637:	LD	$7,$SX
	LDD	$0,(IZ+$SY)
	SBC	$0,&H27		;apostrophe?
	JR	Z,LF630		;OR error if an empty string
LF640:	SBC	$0,&H27		;apostrophe? (end of the string)
	JR	Z,LF653
	CAL	LFD91		;premature end_of_line or end_of_file?
	JR	Z,LF630		;OR error if yes
	LD	$6,$SZ
	CAL	LF666		;write a word of the object code
	LDD	$0,(IZ+$SY)
	JR	LF640
LF653:	CAL	&H004D
	CAL	LFD8B		;end of statement expected
	JR	NZ,LF624	;otherwise OR error
	JR	LF62A

; write two words of the object code
LF65D:	LDW	$6,$10
	CAL	LF666		;write a word of the object code
	LDW	$6,$12
; write a word of the object code
LF666:	PRE	IX,$23		;pointer to the end of object code
	ADW	$23,$SY
	ADW	$23,$SY
	SBCW	$25,$23		;$25,$26 = pointer to the end of free area
	JP	C,LF5E6		;OM error
	STW	$6,(IX+$SX)
	RTN

LF675:	LD	$2,$SX		;index of the acronym "LA"
; report an assembly error - display or print an error message of the index $2
; followed by the line number $19
LF677:	OR	$29,$SY
	CAL	LED34		;test the PRT_ON/PRTOFF flag
	CAL	NZ,&H3928	;printer as the output device if PRT ON
	CAL	LF6AD		;display the acronym of the index $2
	CAL	LF6A1		;display the string "error "
	LDW	$2,$19		;line number
	CAL	&H81EC		;display the word $2,$3 decimal
	CAL	&H41BD		;OUTCR, display CR-LF
	CAL	&H392C		;select the LCD as the output device
	CAL	LED34		;test the PRT_ON/PRTOFF flag
	RTN	NZ		;return if PRT ON
; wait for a key
LF695:	GRE	IZ,$0
	PHSW	$1
	CAL	&H57AA		;KYIN
	PPSW	$0
	PRE	IZ,$0
	RTN

; display the string "error "
LF6A1:	LDW	$0,&H7265	;"er"
	LDW	$2,&H6F72	;"ro"
	LDW	$4,&H2072	;"r "
	LD	$6,$SY
	CAL	&H622F		;display the string $0..$15
	CAL	&H9258		;US <- &H0CE2, initialise the user stack
	JR	LF6C1		;display a space

; display the acronym of the index $2
LF6AD:	PRE	IX,LFEDD	;table of acronyms
	PST	UA,&H44
	LDW	$15,(IX+$2)	;fetch two characters from the table
	PST	UA,&H54
	CAL	&H41C6		;display the character $16
	BYUW	$15
	CAL	&H41C6		;display the character $16
LF6C1:	JP	&H41B4		;display a space

; search the symbol table for a label pointed to by IZ
; pointers $25,$26 and $27,$28 enclose the scope in the local symbol table
LF6C4:	CAL	LFC2C		;fetch a label name pointed to by IZ to $8-$13
	ANC	$29,&H04
	RTN	Z		;return if no label found
; search the symbol table for a label in $8-$13
LF6CB:	CAL	LFC69		;search the symbol table
	RTN	C		;return if found
	PHSM	$28,4
	PRE	IX,L6FD9
	LDM	$25,(IX+$SX),4	;pointers to the global symbol table
	CAL	LFC69		;search the symbol table
	PPSM	$25,4
	RTN

STR_BR:	LDW	$0,&H7242	;"Br"
	LDW	$2,&H6165	;"ea"
	LDW	$4,&H206B	;"k "
	LD	$6,$SY
	RTN

; submenu "bpoint" of the menu "dump"
LF6E0:	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	STR_BR		;$0-$6 <- string "Break "
	CAL	&H622F		;display the string $0..$15
	PRE	IX,L6FE6
	LDM	$17,(IX+$SX),4
	ANC	$18,$SY		;is the breakpoint set?
	CAL	NZ,LFEB1	;display address $19,$20 and optional label
	CAL	&H9258		;US <- &H0CE2, initialise the user stack
	CAL	LFA39		;ask the user for an address
	JR	Z,LF74F
	PRE	IX,L6FE1	;last address in the object code
	SBW	$4,$4
	SBCW	(IX+$SX),$6
	JR	C,LF70B		;skip if the specified address invalid
	LD	$5,$SY		;set the breakpoint
LF70B:	PRE	IX,L6FE6
	STIM	$4,(IX+$SX),4
	JR	LF74F

; BREAK handle routine
LF714:	LD	$0,$SY,JR LF749

; assembly completed successfully
LF717:	PRE	IX,L6FE5
	STI	$31,(IX+$SX)	;TROFF
	LD	$0,$SX
	STW	$31,(IX+$SX)	;clear the breakpoint
	LDD	$0,(IX-15)	;IX<-L6FD7
	STW	$25,(IX+$SX)
	LDD	$0,(IX+10)	;IX<-L6FE1
	SBW	$21,$SY		;decrement the location counter
	STW	$21,(IX+$SX)	;last address in the object code
	PRE	IX,L6FEF
	SBBM	$0,$SZ,8
	STIM	$0,(IX+$SX),8	;clear the registers GR0 to GR3
	SBW	$0,$SY
	STM	$0,(IX+$SX),3	;GR4=&HFFFF, FR=0
LF73C:	PRE	IX,L6FDD
	LDW	$1,(IX+$SX)
	PRE	IX,L6FE3
	STW	$1,(IX+$SX)	;PC = default object code execution address
	LD	$0,$SX
LF749:	PRE	IX,L692D
	STD	$0,(IX+$SX)
LF74F:	CAL	MENU1
	PRE	SS,&H0FEF
	CAL	&H9258		;US <- &H0CE2, initialise the user stack
	LDW	$2,LF74F	;jump address
	CAL	&H391D		;BRSTR, set ACJMP
	CAL	&H5549
	CAL	LFECF		;normal display, 4-line scroll
	ST	&H03,($SZ)	;DSPMD = MENU display
	PRE	IX,L692E
	SBC	(IX+$SX),$31
	JR	Z,LF773
	STD	$31,(IX+$SX)
	JP	LF7D1		;execute the object code
LF773:	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	STR_BR		;$0-$6 <- string "Break "
	PRE	IX,L692D
	SBC	(IX+$SX),$30	;quick asembly and execution?
	STD	$31,(IX+$SX)
	JR	Z,LF78A		;branch if yes
	PRE	IX,L6FE6
	SBC	(IX+$SX),$30	;was a breakpoint reached?
LF78A:	CAL	Z,&H622F	;display the string $0..$15 if yes
	CAL	LFEA6		;display 'PC', PC value and an optional label
	LDW	$21,LF3BC	;string '[go    ][dump  ][edit  ][TR SW ]'
	LDW	$7,&H040E	;$7 = submenu mode "asmbl"
	JP	LED8C

MENU1:	LDW	$0,&H5F9C	;&H5462: LDW $3,&H5F9C
	SBCW	$3,$SZ		;was the MENU key pressed?
	JP	Z,&H54CD	;if yes then go to the main menu
	RTN

; submenu "dump" of the menu "asmbl" after successful assembly
LF7A0:	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	LDW	$21,LF3DC	;string '[object][regist][bpoint]'
	LDW	$7,&H0304	;$7 = submenu mode "dump"
	JP	LED85

; submenu "go" of the menu "asmbl" after successful assembly
LF7AB:	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	LFEA6		;display 'PC', PC value and an optional label
LF7B1:	LDW	$19,&H6318	;$19=&H18: offset of the string "go?     "
	CAL	LFA3D		;ask the user for a number or label name
	JR	Z,LF7D1
	PRE	IX,L6FE1	;last address in the object code
	SBCW	(IX+$SX),$6
	JR	C,LF7B1		;ask again if the specified address invalid
	LDW	$0,L6FF7
	STW	&HFFFF,($SZ)	;GR4<-&HFFFF
	PRE	IX,L6FE3
	STIW	$6,(IX+$SX)	;PC<-specified_address
	STD	$31,(IX+$SY)
LF7D1:	LDW	$2,LF714	;jump address
	CAL	&H391D		;BRSTR, set ACJMP
	CAL	LFECF		;normal display, 4-line scroll
	CAL	&H2AC4		;CLEDB
	CAL	&H29FE		;DOTDS
	CAL	&H4A36
LF7E1:	PRE	IX,L6FE3
	LDW	$19,(IX+$SX)
	PRE	IX,L6FE1
	SBCW	(IX+$SX),$19
LF7EC:	LD	$2,14		;index of the acronym "AD"
	JP	C,LFC16		;report a run-time error
	PRE	IX,L6FE6
	LDM	$0,(IX+$SX),4
	ANC	$0,$SY
	LD	$0,$SX
	JR	NZ,LF80A	;skip if no breakpoint set
	SBC	$1,$SY
	JR	NZ,LF80A
	SBCW	$2,$19		;compare the PC with the breakpoint address
	JR	NZ,LF80A	;skip if they aren't equal
	LD	$0,$SY
LF80A:	STD	$0,(IX+$SX)	;flag "breakpoint was reached"
	JP	Z,LF74F
	CAL	&H3959		;test the OFF switch and BRK key
	CAL	LF914		;convert an adress $19,$20 to a pointer IX
	LDIM	$17,(IX+$SX),4
	SBC	$18,&H90	;EXIT?
	JP	Z,LF73C
	SBC	$18,&H91	;IN?
	JP	Z,LF8D2
	SBC	$18,&H92	;OUT?
	JR	Z,LF89A
	SBC	$18,$SX
	JR	UZ,LF894	;CD error
	LD	$29,&H08
	CAL	LFD02		;search the mnemonic table for the opcode $18
	JR	NZ,LF894	;CD error if not found
	PRE	IX,L6FEF
	DIDW	$17
	DID	$16
	SBC	$16,5		;XR index
	JR	NC,LF894	;CD error
	SBW	$2,$2
	SBC	$16,$SX
	JR	Z,LF84E		;skip if no XR specified
	BIU	$16
	LDW	$2,(IX+$16)	;$2,$3 = contents of the XR register
LF84E:	ADW	$19,$2		;$19,$20 = effective address
	LDW	$0,$19
	ADW	$0,$SZ
	SBC	$1,&HFF
	JR	NZ,LF862
	LDW	$14,&H0BE2
	LD	$1,$SX,JR LF870
LF862:	SBC	$11,&H11
	JR	NZ,LF870
	PRE	IZ,L6FE1
	SBCW	(IZ+$SX),$19
	JP	C,LF7EC		;AD error
LF870:	ADW	$14,$SZ
	SBC	$17,5		;GR index
	JR	NC,LF894	;CD error
	BIU	$17
	LDD	$0,(IX+$17)	;IX<-IX+2*index, pointer to the GR storage
	DIDW	$18		;$18 <- upper nibble of the operation code
	SB	$18,$SY
	BIU	$18
	PRE	IZ,LFF0D	;adresses of instruction handler procedures
	PST	UA,&H14
	LDW	$0,(IZ+$18)
	PST	UA,&H54
	PRE	IZ,$14		;IZ = pointer to memory corresponding to the EA
	DID	$17		;operation code
	JP	$0
LF894:	LD	$2,12		;index of the acronym "CD"
	JP	LFC16		;report a run-time error

; operation code &H9200 - OUT
LF89A:	LDM	$19,(IX+$SX),4
	CAL	LF909		;convert a pair of adresses to pointers
	LDW	$21,($21)	;string length
LF8A3:	SBW	$21,$SY
	JR	C,LF8B1
	LDIW	$16,(IZ+$SX)
	CAL	&H41C6		;display the character $16
	CAL	&H3959		;test the OFF switch and BRK key
	JR	LF8A3		;next character
LF8B1:	CAL	&H57AA		;KYIN
LF8B4:	CAL	&H41BD		;OUTCR, display CR-LF
	PRE	IX,L6FE3
	LDW	$19,(IX+$SX)
	LDW	$0,4
	ADW	$19,$SZ
LF8C2:	PRE	IX,L6FE3
	LDW	$17,(IX+$SX)
	STW	$19,(IX+$SX)
	CAL	LFE9F		;test the Trace mode
	CAL	NC,LFE6C	;... if LTRON
	JP	LF7E1

; operation code &H9100 - IN
LF8D2:	LDM	$0,(IX+$SX),4
	PHSM	$3,4
	LDW	$0,&H08CA	;LCDST
	ST	&H07,($SZ)
	CAL	&H32D2
	CAL	&H2F1B
	GRE	IZ,$12
	PPSM	$19,4
	CAL	LF909		;convert a pair of adresses to pointers
	PRE	IX,$12
	SBBM	$5,$5,3
LF8F2:	SBC	$6,&H50
	JR	Z,LF902
	LDI	$4,(IX+$SX)
	SBC	$4,$SX
	JR	Z,LF902
	STIW	$4,(IZ+$SX)
	AD	$6,$SY,JR LF8F2
LF902:	CAL	LFECF		;normal display, 4-line scroll
	STW	$6,($21),JR LF8B4

; conversion of a pair of CASL addresses in $19,$20 and $21,$22 to memory
; pointers IX and IZ
LF909:	CAL	LF914		;convert an adress $19,$20 to a pointer IX
	BIUW	$21
	ADW	$21,$14
	PRE	IZ,$2
	RTN

; conversion of a CASL address in $19,$20 to a memory pointer IX
LF914:	PRE	IX,L6FDF
	LDW	$2,(IX+$SX)	;begin of the object code
	LDW	$14,(IX+$SX)
	LDW	$0,$19
	BIUW	$0
	ADW	$2,$SZ
	PRE	IX,$2
	RTN

; submenu "regist" of the menu "dump"
LF926:	PRE	IX,L6FEE
	STD	$31,(IX+$SX)
LF92C:	CAL	&H2AC4		;CLEDB
	CAL	L9187		;select the EDTOP buffer as the output device
	LD	$28,$SX		;register index
; this loop displays the contents of the GR registers
LF934:	ld	$16,'G'
	CAL	L96B4		;display the character $16 followed by 'R'
	LD	$16,$28		;register index
	CAL	L96C0		;display the character $16 + '0'
	CAL	L96B0		;display a colon
	PRE	IX,L6FEF
	LD	$0,$28
	AD	$0,$SZ		;*2
	LDD	$0,(IX+$SZ)	;IX<-IX+2*$28
	LDW	$0,(IX+$SX)
	PHSW	$1
	LDW	$14,$SZ
	CAL	LFDBF		;display hexadecimal the word $14,$15
	CAL	&H41B4		;display a space
	PPSW	$2
	CAL	&H81EC		;display the word $2,$3 decimal
	CAL	L96D4		;display a tab
	AD	$28,$SY		;increment the register index
	SBC	$28,5		;up to 5 registers
	JR	NZ,LF934	;next register
; display the contents of the FR register
	LD	$16,'F'
	CAL	L96B4		;display the character $16 followed by 'R'
	CAL	&H41B4		;display a space
	CAL	L96B0		;display a colon
	PRE	IZ,L6FF9
	CAL	L96BB		;display a 2-bit number pointed to by IZ
	CAL	LB867		;copy the EDTOP buffer to the LCD driver
; edit the contents of a GR register of an index in L6FEE
	LDW	$19,&H6400	;$19=&H00: offset of the string "GR ?    "
	CAL	LFA3D		;ask the user for a number or label name
	PRE	IX,L6FEF
	JR	Z,LF992
	LD	$0,(IX-$SY)
	BIU	$0
	STW	$6,(IX+$SZ)
LF992:	LDD	$0,(IX-$SY)
	AD	$0,$SY		;increment the register index
	SBC	$0,5		;up to 5 registers
	JR	C,LF99D
	LD	$0,$SX
LF99D:	STD	$0,(IX+$SX)	;store the register index
	JR	LF92C

LF9A1:	SBW	$6,$6,JR LF9A8
; submenu "object" of the menu "dump"
LF9A5:	CAL	LFA39		;ask the user for an address
LF9A8:	LDW	$17,$6
LF9AB:	PRE	IX,L6FDF
	LDM	$19,(IX+$SX),4
	SBCW	$21,$17
	JR	C,LF9A5
	PHSW	$18
	CAL	LFECF		;normal display, 4-line scroll
	CAL	&H2AC4		;CLEDB
	CAL	L9187		;select the EDTOP buffer as the output device
	LD	$23,4,JR LF9C9	;number of displayed rows
; row loop
LF9C6:	CAL	&H41BD		;OUTCR, display CR-LF
LF9C9:	SBCW	$21,$17		;last_addres - current_address
	JR	C,LF9EB		;branch if end of object code reached
	CAL	LFDB9		;display hexadecimal the address $17,$18
	CAL	L96D4		;display a tab
	CAL	LFEBA		;display the name of an optional label
	CAL	L96D4		;display a tab
	LDW	$0,$17
	BIUW	$0
	ADW	$0,$19		;$0 = begin_of_the_object_code + 2*address
	CAL	LFDBD		;display hexadecimal the data word ($0)
	ADW	$17,$SY		;increment the address
	SB	$23,$SY		;decrement the counter of displayed rows
	JR	NZ,LF9C6	;next row
;
LF9EB:	PPSW	$17
	CAL	LB867		;copy the EDTOP buffer to the LCD driver
LF9F0:	CAL	&H57AA		;KYIN
	SBC	$0,&HF5		;key Etc?
	JP	Z,&H3979
	SBC	$0,&H0D		;key EXE?
	JR	Z,LFA0E
	SB	$0,&H1C		;cursor key right?
	JR	Z,LFA21
	SB	$0,&H02
	JR	C,LFA21		;cursor key left
	JR	Z,LFA16		;cursor key up
; cursor key down
	SB	$0,$SY
	JR	NZ,LF9F0
LFA0E:	SBCW	$17,$21
	JR	Z,LF9F0
	ADW	$17,$SY,JR LFA1C	;increment the address
; cursor key up
LFA16:	SBCW	$17,$SY
	JR	C,LF9F0
	SBW	$17,$SY		;decrement the address
LFA1C:	CAL	&H0453		;conditionally set the key repeat flag
	JR	LFA36
; cursor key left or right
LFA21:	LDW	$19,&H6510	;$19=&H10: offset of the string "data?   "
	PHSW	$18
	CAL	LFA3D		;ask the user for a number or label name
	PPSW	$19
	JR	Z,LFA33
	CAL	LF914		;convert an adress $19,$20 to a pointer IX
	STW	$6,(IX+$SX)
LFA33:	LDW	$17,$19
LFA36:	JP	LF9AB

LFA39:	LDW	$19,&H6808	;$19=&H08: offset of the string "address?"
; display a prompt then ask the user for a number or label name
; on entry:
; $19 = offset to the table of prompts
; $20 = value for TOARE, cursor movement range top
; returns the value in $6,$7
LFA3D:	CAL	&H4A36
	PRE	IX,LFF1D	;table of prompts
	LDD	$0,(IX+$19)	;= IX<-IX+$19
	LD	$8,$SY		;1 item
	LD	$29,$SY		;don't display the number $17,$18
	CAL	&H49E5		;copy menu items to &H08A7
	SBC	$19,$SX
	JR	NZ,LFA5C	;skip if not a GR
	PRE	IX,L6FEE
	LDD	$0,(IX+$SX)	;register index
	OR	$0,'0'		;convert to ASCII
	PRE	IX,&H08A7+2
	STD	$0,(IX+$SX)
LFA5C:	LD	$6,$20		;value for TOARE, cursor movement range top
	PHSW	$20
	CAL	&H4A51
	PPSW	$19
	SBW	$6,$6
	PRE	IZ,&H0100	;EDTOP
	LDD	$0,(IZ+$20)
	SBC	$0,$SX
	RTN	Z		;return if nothing entered
	CAL	&H01DF		;is next character a letter?
	JR	C,LFA7A		;branch if yes
; number
	CAL	LFAB3		;$17,$18 <- value of a number pointed to by IZ
	JR	NC,LFA3D	;ask again if the value > 65535
	LDW	$6,$17,JR LFA84
; label
LFA7A:	CAL	LFC2C		;fetch a label name pointed to by IZ to $8-$13
	LD	$29,$SX
	CAL	LFC57		;$6,$7 <- value of a label with a name $8-$13
	JR	Z,LFA3D
LFA84:	CAL	&H003C		;ENDSC, end of the BASIC line?
	JR	NC,LFA3D	;ask again if invalid characters entered
	RTN

; apparently the "GR" string is optional, a sole index is accepted too
LFA8A:	SB	$0,'0'
	JR	C,LFADB
	SBC	$0,5
	RTN	NC
	LDD	$1,(IZ+$SY)	;IZ<-IZ+1
	JR	LFAB0
; parse for a GR register, returns the index in $0 and Carry set if found
LFA97:	LDW	$0,(IZ+$SX)
	LDW	$2,&H5247	;'GR'
	SBCW	$2,$SZ
	JR	NZ,LFA8A
	LD	$0,(IZ+2)
	SB	$0,'0'
	JR	C,LFADB
	SBC	$0,5
	RTN	NC
	LDD	$1,(IZ+3)	;IZ<-IZ+3
LFAB0:	SBC	$31,$SY		;set Carry
	RTN

; conversion of a string pointed to by IZ to an integer number in $17,$18
LFAB3:	CAL	&H0201		;test for '#' (prefix of a hexadecimal number)
	JR	Z,LFACD
; decimal number
LFAB8:	LD	$4,$SZ
	SBC	$0,'-'
	CAL	Z,&H004D
	CAL	L991E		;$17,$18 <- value of ASCII decimal number
	JR	C,LFADB		;branch if an overflow
	SBC	$4,'-'
	JR	NZ,LFAB0
	CMPW	$17,JR LFAB0
; hexadecimal number
LFACD:	SBW	$17,$17
	CAL	&H0049		;NEXTC, get next character other than space
	CAL	&H01D3		;CHEX1, hex to binary conversion
	RTN	NC
LFAD7:	SBC	$18,$SX
	JR	UZ,LFADE
LFADB:	SBC	$31,$SX		;clear Carry (overflow)
	RTN
LFADE:	DIUW	$17
	OR	$17,$SZ
	LDD	$0,(IZ+$SY)
	CAL	&H01D3		;CHEX1, hex to binary conversion
	JR	NC,LFAB0
	JR	LFAD7

; set the Flag Register according to the operation result in $19,$20
LFB03:	PRE	IX,L6FF9
	STD	$30,(IX+$SX)	;FR=01
	SBCW	$19,$SY
	RTN	C		;return if the result is 0
	ADCW	$19,$19
LFB0F:	JR	C,LFB14		;branch if the result is negative
	STD	$31,(IX+$SX)	;FR=00
	RTN
LFB14:	AD	(IX+$SX),$30	;FR=10
	RTN

; operation code &H2xxx - ADD, SUB
LFB17:	LDW	$0,(IZ+$SX)
	LDW	$19,(IX+$SX)
	SBC	$17,$SY
	JR	Z,LFB22
	ADW	$19,$SZ,JR LFB71
LFB22:	SBW	$19,$SZ,JR LFB71

; operation code &H3xxx - AND, OR, EOR
LFB25:	LDW	$0,(IZ+$SX)
	LDW	$19,(IX+$SX)
	SBC	$17,$SY
	JR	C,LFB32
	JR	NZ,LFB35
	ORW	$19,$SZ,JR LFB71
LFB32:	ANW	$19,$SZ,JR LFB71
LFB35:	XRW	$19,$SZ,JR LFB71

; operation code &H4xxx - CPA, CPL
LFB38:	LDW	$19,(IX+$SX)
	LDW	$0,(IZ+$SX)
	SBC	$17,$SY
	JR	Z,LFB46
	AD	$20,&H80
	AD	$1,&H80
LFB46:	PRE	IX,L6FF9
	STD	$30,(IX+$SX)
	SBW	$19,$SZ
	CAL	NZ,LFB0F
	JR	LFB76

; operation code &H7xxx - PUSH, POP
LFB53:	LDW	$21,$19
	CAL	LFBE1		;operation on the stack
	SBC	$17,$SY		;push or pop?
	JR	NZ,LFB76
	JR	LFB61

; operation code &H10xx - LD
LFB5F:	LDW	$19,(IZ+$SX)	;contents of the effective address
LFB61:	STW	$19,(IX+$SX)	;store it to a GR register
	JR	LFB76		;don't affect the Flag Register

; operation code &H11xx - ST
LFB65:	LDW	$0,(IX+$SX)	;contents of a GR register
	STW	$0,(IZ+$SX)	;store it to the effective address
	JR	LFB76		;don't affect the Flag Register

; operation code &H1xxx - LD, ST, LEA
LFB6B:	SBC	$17,$SY
	JR	C,LFB5F		;LD
	JR	Z,LFB65		;ST
LFB71:	STW	$19,(IX+$SX)	;store the result to a GR register
	CAL	LFB03		;set the Flag Register
LFB76:	PRE	IX,L6FE3
	LDW	$19,(IX+$SX)
	ADW	$19,$SY
	ADW	$19,$SY,JR LFB8C

; operation code &H8xxx - CALL, RET
LFB80:	PRE	IX,L6FE3
	LDW	$21,(IX+$SX)
	ADW	$21,$SY
	ADW	$21,$SY
	CAL	LFBE1		;operation on the stack
LFB8C:	JP	LF8C2

; operation code &H5xxx - SLA, SRA, SLL, SRL
LFB8F:	SBC	$20,$SY
	JR	C,LFB95
	NA	$19,$SX
LFB95:	BYDW	$19
	LDW	$19,(IX+$SX)
	SBW	$0,$SZ
	NAW	$2,$SZ
	ANC	$17,&h02
	JR	NZ,LFBAA
	LD	$1,$20
	AN	$1,&h80
	BIDW	$3
LFBAA:	SB	$18,$SY
	JR	C,LFB71
	ANC	$17,$SY
	JR	NZ,LFBBA
	BIUW	$19
LFBB4:	ANW	$19,$2
	ORW	$19,$SZ,JR LFBAA
LFBBA:	BIDW	$20,JR LFBB4

; operation code &H6xxx - JPZ, JMI, JNZ, JZE, JMP
LFBBD:	PRE	IX,L6FF9
	LDD	$0,(IX+$SX)	;register FR
	SBC	$17,&H03
	JR	Z,LFBD7
	JR	NC,LFBD5
	SBC	$17,$SY
	JR	C,LFBDA
	JR	NZ,LFBDE
	SBC	$0,&H02
LFBD3:	JR	NZ,LFB76
LFBD5:	JR	LFB8C
LFBD7:	SBC	$0,$SY,JR LFBD3
LFBDA:	ANC	$0,&H02,JR LFBD3
LFBDE:	ANC	$0,$SY,JR LFBD3

; if $17=0 then push the word $21,$22 to the stack,
; else pop the word $19,$20 from the stack
LFBE1:	PRE	IZ,L6FF7
	LDW	$0,(IZ+$SX)	;register GR4
	LDW	$4,$SZ
	LDW	$2,&HFF80
	SBW	$0,$2
	JR	C,LFC13		;ST error
; the stack of size &H80 words occupies the User Stack area
	BIUW	$0
	LDW	$2,&H0BE2
	ADW	$2,$SZ		;pointer to the memory
	SBC	$17,$SX		;push or pop?
	JR	NZ,LFC0F
; push
	SB	$4,$SY		;decrement GR4
	SBC	$4,&H80
	JR	C,LFC13		;ST error
	STW	$4,(IZ+$SX)
	PRE	IZ,$2
	LDD	$0,(IZ-2)
	STW	$21,(IZ+$SX)
	RTN
; pop
LFC0F:	AD	$4,$SY		;increment GR4
	JR	NC,LFC25
; stack overflow/underflow
LFC13:	LD	$2,10		;index of the acronym "ST"
; report a run-time error
LFC16:	CAL	LF6AD		;display the acronym of the index $2
	CAL	LF6A1		;display the string "error "
	CAL	LFEAC		;display the PC value and an optional label
	CAL	LF695		;wait for a key
	JP	&H3979
;
LFC25:	STW	$4,(IZ+$SX)
	PRE	IZ,$2
	LDW	$19,(IZ+$SX)
	RTN

; fetch a label name pointed to by IZ to $8-$13, right aligned
LFC2C:	AN	$29,&HFB
	SBBM	$8,$8,8
	SBC	$0,' '
	RTN	Z
; A label can contain upper case letters and digits. The first character must
; not be a digit.
LFC36:	SBC	$0,'A'
	RTN	C		;return with Not Zero 
	SBC	$0,'Z'+1
	JR	NC,LFC7D	;return with Not Zero
LFC3F:	OR	$29,&H04	;label found
	ADC	$8,&HFF		;test $8 for zero
	RTN	C		;return with NZ if already 6 characters copied
	BYDM	$13,6
	LD	$13,$SZ
	LDD	$0,(IZ+$SY)
	CAL	&H002B		;OKNM1, is $0 a digit?
	JR	NC,LFC36	;branch if not
	JR	LFC3F

; $0-$5 <- name of a label with a value $17,$18
LFC54:	LD	$29,&H08
; $6,$7 <- value of a label with a name $8-$13
LFC57:	PRE	IX,L6FD9
	LDM	$25,(IX+$SX),4	;pointers to the global symbol table
	CAL	LFC69		;search the symbol table
	RTN	NZ		;return if found
	PRE	IX,L6FD7
	LDM	$25,(IX+$SX),4	;pointers to the local symbol table
; search the symbol table between the pointers $25,$26 and $27,$28 for a name
; or value, depending on the bit 3 of the register $29
LFC69:	PRE	IX,$27
; loop
LFC6B:	GRE	IX,$0
	SBCW	$25,$SZ
	RTN	Z		;end of the table, not found
	LDDM	$7,(IX-$SY),8
	ANC	$29,&H08
	JR	NZ,LFC80
	XRCM	$8,$SZ,6	;compare the names
LFC7B:	JR	NZ,LFC6B	;next table entry if they don't match
LFC7D:	SBC	$31,$SY		;Not Zero, Carry
	RTN			;found
LFC80:	SBCW	$17,$6		;compare the values
	JR	NC,LFC7B
	SBC	$31,$SX		;Zero
	RTN			;not found

LFC88:	OR	$29,&H02
	CAL	LFD99		;add an entry to the symbol table
	JR	LFCDD
; parse the label field and the operation field
LFC90:	AN	$29,&HFD
	CAL	LFD8B		;end of statement?
	RTN	Z		;return if yes
; label field
	CAL	LFC2C		;fetch a label pointed to by IX to $8-$13
	JR	Z,LFCDD		;skip if the label field is empty
	ANC	$29,&H04
LFC9F:	LD	$2,$SX		;index of the acronym "LA"
	JR	Z,LFCFA		;LA error if no label found
	SBC	$29,&H10
	JR	UZ,LFCDD
	JR	C,LFC88
	PRE	IX,$25		;pointer to the top of the symbol table
	LDM	$0,(IX+$SX),6	;global label of the current block
	XRCM	$8,$SZ,6	;local label cannot be the same
	JR	Z,LFC9F		;otherwise LA error
	SBC	$29,&H30
	JR	UZ,LFCDD	;skip if there's no undefined START operand
	PRE	IX,WORK1	;work buffer
	LDIM	$0,(IX+$SX),7	;$1-$6 = START operand
	XRCM	$8,$1,6		;compare with the local label
	JR	NZ,LFCDD	;skip if they don't match
	SBCW	(IX+$SX),$30	;address of the block
	JR	NC,LFCCE	;skip if not &H0000 (i.e. not the first block)
	PRE	IX,L6FDD
	STW	$21,(IX+$SX)	;default execution address = location counter
LFCCE:	AN	$29,&H3F	;the START operand is no longer undefined
	ANC	$0,&H02		;was an entry added to the symbol table?
	JR	Z,LFCDD		;skip if not (superfluous safety measure)
; change the value of the last global symbol to the value of the START operand
	PRE	IX,$25		;pointer to the top of the symbol table
	LDD	$0,(IX+&H06)	;IX<-IX+6, skip the label field
	STW	$21,(IX+$SX)	;replace the value with the location counter
; operation field
LFCDD:	CAL	&H01DF		;is next character a letter?
	JR	NC,LFCF3	;branch if not
	LDM	$0,(IZ+$SX),5
	CAL	LFD02		;search the mnemonic table for a string $0-$4
	JR	NZ,LFCF7	;OC error if not found
	LDD	$0,(IZ+$5)	;IZ <- IZ+mnemonic_length
	CAL	&H0049		;NEXTC, get next character other than space
LFCF0:	SBC	$30,$SX		;Not Zero
	RTN
LFCF3:	CAL	LFD8B		;end of statement expected
	RTN	Z
LFCF7:	LD	$2,8		;index of the acronym "OC"
LFCFA:	PPSW	$0
	CAL	LF677		;report an assembly error
	JP	LF497

; search the mnemonic table, Zero if found
; if bit 3 of the register $29 is cleared then
;   $11 <- opcode of the mnemonic in $0-$4
; else
;   IX <- mnemonic of the opcode $18
LFD02:	PRE	IX,L8BD7	;table of CASL mnemonics and opcodes
LFD06:	PST	UA,&H44
	SBBM	$5,$5,6
; fetch the mnemonic from the table to $10-$14, right aligned
LFD0B:	BYDM	$10,5
	LDI	$10,(IX+$SX)
	AD	$5,$SY		;mnemonic length
	ANC	$10,&H80	;last character of the keyword?
	JR	Z,LFD0B		;loop if not
	SB	$10,&H80	;get rid of the of the last character mark
	LDI	$11,(IX+$SX)	;opcode
	ANC	$29,&H08
	JR	NZ,LFD44
	SBC	$5,4
	JR	Z,LFD38		;branch if mnemonic length = 4
	JR	NC,LFD3C	;branch if mnemonic length = 5
	ANC	$5,$SY
	JR	NZ,LFD40	;branch if mnemonic length = 3
	SBCW	$9,$SZ		;comparison, mnemonic length = 2
LFD2E:	PST	UA,&H54
	RTN	Z		;mnemonic found, Zero flag
	SBC	$11,&H02	;end of the mnemonic table?
	JR	NC,LFD06	;loop if not
	RTN			;mnemonic not found, Not Zero flag
; comparison of strings
LFD38:	XRCM	$7,$SZ,4,JR LFD2E	;mnemonic length = 4
LFD3C:	XRCM	$6,$SZ,5,JR LFD2E	;mnemonic length = 5
LFD40:	XRCM	$8,$SZ,3,JR LFD2E	;mnemonic length = 3
; comparison of opcodes
LFD44:	SBC	$11,$18,JR LFD2E

; advance the Location Counter $21,$22 by the instruction size
LFD48:	LDW	$17,2		;size of most instructions
	SBC	$11,&H07	;instruction opcode
	JR	Z,LFD79		;DS
	JR	NC,LFD7D
	SBC	$11,&H03
	JR	Z,LFD7D		;EXIT
	JR	C,LFCF0		;if START or END then return with Not Carry
	SBC	$11,&H06
	JR	NZ,LFD81	;IN, OUT
; DC
	SBC	$0,&H27		;apostrophe? (begin of a string)
	LDW	$17,$SY
	JR	NZ,LFD7D	;branch if not
; determine the string length
	GRE	IZ,$2
	LD	$17,$SX
LFD6A:	LDD	$0,(IZ+$SY)
	SBC	$0,&H27		;apostrophe? (end of a string)
	JR	Z,LFD85
	CAL	LFD91		;premature end_of_line or end_of_file?
	JR	Z,LFD85		;branch if yes
	AD	$17,$SY,JR LFD6A
; the operand of DS must be a decimal number
LFD79:	CAL	L991E		;$17,$18 <- value of ASCII decimal number
	RTN	C
LFD7D:	ADW	$21,$17	;add the instruction size to the location counter
	RTN
; IN, OUT
LFD81:	LD	$17,4,JR LFD7D
LFD85:	PRE	IZ,$2,JR LFD7D

; end of statement expected
LFD88:	CAL	&H0049		;NEXTC, get next character other than space
LFD8B:	LDD	$0,(IZ+$SX)
	SBC	$0,&H3B		;semicolon?
	RTN	Z
LFD91:	SBC	$0,&H0D		;end_of_line?
	RTN	Z
	SBC	$0,&H1A		;end_of_file?
	RTN

; add an entry to the symbol table
; label name in $0-$5, label value (location counter) in $21,$22,
; pointer to the top of the table in $25,$26,
; pointer to the begin of the free area in $23,$24
LFD99:	CAL	LFC69		;search the symbol table
	JR	Z,LFDA4		;skip if label not yet defined
	CAL	LF675		;display "LA error" message and line number
	SBBM	$8,$8,8
LFDA4:	LDW	$0,8		;size of the symbol table entry
	SBW	$25,$SZ
	SBCW	$25,$23
	JP	C,LF5E6		;OM error
	PRE	IX,$25
LFDB2:	LDW	$14,$21
	STM	$8,(IX+$SX),8
	RTN

; display hexadecimal the word $17,$18
LFDB9:	LDW	$14,$17,JR LFDBF
; display hexadecimal the word pointed to by the $0,$1 register pair
LFDBD:	LDW	$14,($SZ)
; display hexadecimal the word $14,$15
LFDBF:	LD	$11,4		;counter of digits (originally $10)
; this loop expands the hexadecimal number and displays the digits
LFDC2:	DIUM	$14,3		;shift the next digit to $16
	CAL	&H4189		;display the hex digit $16
	SB	$11,$SY		;decrement the digit counter
	JR	NZ,LFDC2	;next digit
	RTN

; display hexadecimal up to two object code words pointed to by the $0,$1
; register pair
LFDD8:	LD	$11,4
LFDDB:	SBCW	$23,$SZ		;$23,$24 = pointer to the end of object code
	RTN	Z
	SB	$11,2
	RTN	C		;return with Carry set if two words displayed
	PHSW	$1
	CAL	LFDBD		;display hexadecimal the word ($0)
	PPSW	$0
	ADW	$0,$SY
	ADW	$0,$SY,JR LFDDB

; display the source line
LFDEE:	CAL	&H41B4		;display a space
	CAL	&H41B4		;display a space
	PRE	IX,WORK1+15
	LDW	$0,(IX+$SX)	;pointer to the source line
	GRE	IZ,$2
	PHSW	$3
	PRE	IZ,$0
	CAL	LC187		;display a line of a text file
	PPSW	$0
	PRE	IZ,$0
	RTN

; print a line of the assembly listing, example output:
; 00007:0006  12000001  L1 LEA GR0,1
LFE05:	CAL	LED34		;test the PRT_ON/PRTOFF flag
	RTN	Z		;return if PRTOFF
	CAL	&H3928		;select the printer as the output device
	CAL	L9697		;display the line number $19,$20 and a colon
	PRE	IX,WORK1+10
	LDW	$14,(IX+$SX)	;address
	CAL	LFDBF		;display hexadecimal the word $14,$15
	CAL	&H41B4		;display a space
	CAL	&H41B4		;display a space
	PRE	IX,WORK1+14
	LDDM	$2,(IX+$SX),3	;$2 = opcode, $0,$1 = pointer to object code
	SBC	$2,&H07		;DS?
	JR	NZ,LFE2A	;skip if not
	LDW	$0,$23		;don't display any object code words
LFE2A:	CAL	LFDD8		;display hexadecimal up to 2 object code words
	JR	C,LFE3E		;branch if 2 object code words displayed
LFE2F:	SB	$11,$SY
	JR	C,LFE38
	CAL	&H41B4		;display a space
	CAL	&H41B4		;display a space
	JR	LFE2F
LFE38:	CAL	LFDEE		;display the source line
LFE3B:	JP	&H392C		;select the LCD as the output device
LFE3E:	PHSW	$1
	CAL	LFDEE		;display the source line
LFE43:	PPSW	$0
	PHSW	$1
	LD	$11,12
LFE4A:	CAL	&H41B4		;display a space
	SB	$11,$SY
	JR	NZ,LFE4A
	PPSW	$0
	CAL	LFDD8		;display hexadecimal up to 2 object code words
	JR	C,LFE5D
	CAL	&H41BD		;OUTCR, display CR-LF
	JR	LFE3B
LFE5D:	PHSW	$1
	CAL	&H41BD		;OUTCR, display CR-LF
	JR	LFE43

; next line of the source code
LFE64:	CAL	&H0BB6		;move the pointer IZ to the next line
	ADW	$19,$SY		;increment the line counter
	LDD	$0,(IZ+$SX)
	RTN

LFE6C:	CAL	NZ,&H3928	;select the printer as the output device
	CAL	LFEB4		;display address $17,$18 and optional label
	CAL	&H41BD		;OUTCR, display CR-LF
	LD	$11,5
LFE7B:	CAL	&H41B4		;display a space
	SB	$11,$SY
	JR	NZ,LFE7B
	PRE	IZ,L6FEF
	LD	$29,5		;number of GR registers
; this loop displays the contents of the GR registers
LFE85:	LDIW	$14,(IZ+$SX)
	CAL	LFDBF		;display hexadecimal the word $14,$15
	CAL	&H41B4		;display a space
	SB	$29,$SY
	JR	NZ,LFE85	;next GR register
	CAL	L96BB		;display a 2-bit number pointed to by IZ
	CAL	LFE9F		;test the Trace mode
	CAL	Z,&H57AA	;call KYIN if TRON
	CAL	&H41BD		;OUTCR, display CR-LF
	JR	LFE3B

; test the Trace mode
LFE9F:	PRE	IX,L6FE5
	SBC	(IX+$SX),$30
	RTN

; display the 'PC' string, PC value and the name of an optional label
LFEA6:	LD	$2,16		;index of the acronym "PC"
	CAL	LF6AD		;display the string
; display the PC value and the name of an optional label
LFEAC:	PRE	IX,L6FE3
	LDW	$19,(IX+$SX)
; display the address $19,$20 and the name of an optional label
LFEB1:	LDW	$17,$19
LFEB4:	CAL	LFDB9		;display hexadecimal the word $17,$18
	CAL	&H41B4		;display a space
	CAL	&H41B4		;display a space
; display the name of an optional label
LFEBA:	CAL	LFC54		;$0-$5 <- name of a label with a value $17,$18
	RTN	Z
	LD	$14,6		;name length
	GRE	IX,$0
	PRE	IZ,$0
LFEC5:	LDI	$16,(IZ+$SX)
	CAL	&H41C6		;display the character $16
	SB	$14,$SY
	JR	NZ,LFEC5
	RTN

; normal display, 4-line scroll
LFECF:	LDW	$0,&H08D3	;DSPMD
	STW	&H8000,($SZ)
	RTN

LFEDD:	DB	"ALOSMOROCOTSDCDACP"	;table of 2-letter acronyms

; adresses of handler procedures for instructions with operation codes
; &H1xxx, &H2xxx, ... , &H7xxx, &H8xxx
LFF0D:	DW	LFB6B, LFB17, LFB25, LFB38
	DW	LFB8F, LFBBD, LFB53, LFB80

LFF1D:	DB	"GR ?    "
	DB	"address?"
	DB	"data?   "
	DB	"go?     "

; table of CASL mnemonics and opcodes
L8BD7:	DB	"STAR", "T"+&H80, &H02
	DB	"L", "D"+&H80, &H10
	DB	"S", "T"+&H80, &H11
	DB	"LE", "A"+&H80, &H12
	DB	"AD", "D"+&H80, &H20
	DB	"SU", "B"+&H80, &H21
	DB	"I", "N"+&H80, &H04
	DB	"OU", "T"+&H80, &H05
	DB	"D", "C"+&H80, &H06
	DB	"D", "S"+&H80, &H07
	DB	"AN", "D"+&H80, &H30
	DB	"O", "R"+&H80, &H31
	DB	"EO", "R"+&H80, &H32
	DB	"JP", "Z"+&H80, &H60
	DB	"JM", "I"+&H80, &H61
	DB	"JN", "Z"+&H80, &H62
	DB	"JZ", "E"+&H80, &H63
	DB	"JM", "P"+&H80, &H64
	DB	"PUS", "H"+&H80, &H70
	DB	"PO", "P"+&H80, &H71
	DB	"CAL", "L"+&H80, &H80
	DB	"RE", "T"+&H80, &H81
	DB	"CP", "A"+&H80, &H40
	DB	"CP", "L"+&H80, &H41
	DB	"SL", "A"+&H80, &H50
	DB	"SR", "A"+&H80, &H51
	DB	"SL", "L"+&H80, &H52
	DB	"SR", "L"+&H80, &H53
	DB	"EXI", "T"+&H80, &H03
	DB	"EN", "D"+&H80, &H01

; select the EDTOP buffer as the output device
L9187:	LD	$0,$SY
	JP	&H392E

; display the word $19,$20 decimal followed by a colon
L9697:	LDW	$3,$19
	CAL	&H0B53		;binary to BCD conversion
	LD	$11,5		;counter of digits
; this loop expands the BCD number and displays the digits
L96A3:	AN	$16,&H0F	;separate the top digit
	CAL	L96C0		;display the character $16 + '0'
	DIUM	$14,3		;shift the next digit to $16
	SB	$11,$SY		;decrement the digit counter
	JR	NZ,L96A3	;next digit
L96B0:	LD	$16,':',JR L96E1

; display the character $16 followed by 'R'
L96B4:	CAL	L96E1
	LD	$16,'R',JR L96E1

; display a 2-bit number pointed to by IZ
L96BB:	LDD	$16,(IZ+$SX)
	AN	$16,&H03
L96C0:	AD	$16,'0',JR L96E1

L96D4:	LD	$16,&H09	;tab
L96E1:	JP	&H41C6		;display the character $16

; Converts a string pointed to by IZ to an unsigned integer number in $17,18.
; Returns IZ pointing to the first character which is not a decimal digit.
; Returns Carry set if the result exceeded 65535.
L991E:	LD	$16,&H03	;prefix of a binary line number
	SBW	$17,$17		;initial result <- 0
	LDW	$2,6554
L9928:	CAL	&H0029		;NEXTC + OKNM1, is $0 a digit?
	RTN	NC
	SBCW	$17,$2
	JR	NC,L9945	;result out of the limit
	AN	$0,&H0F
	LD	$1,$SX
; $17,$18 <- $17,$18 * 10
	BIUW	$17		;*2
	ADW	$0,$17
	BIUW	$17		;*4
	BIUW	$17		;*8
	ADW	$17,$SZ		;*(8+2)
	LDD	$0,(IZ+$SY)
	JR	NC,L9928
L9945:	SBC	$31,$SY		;overflow, return with Carry set
	RTN

; copy the EDTOP buffer to the LCD driver
LB867:	CAL	&H392C		;select the LCD as the output device
	LDW	$10,&H7F00	;address range &H0100 to &H017F
	JP	&H49DF		;DOTMK followed by DOTDS

LC184:	CAL	&H41C6		;display the character $16
; display a line of a text file
LC187:	LDI	$16,(IZ+$SX)	;fetch a character from the file
	SBC	$16,&H1A	;EOF?
	JR	Z,LC19B
	SBC	$16,&H0D	;CR?
	JR	NZ,LC184
	LDD	$0,(IZ-$SY)
	CAL	&H0BB6		;move the pointer IZ to the next line
	JP	&H41BD		;OUTCR, display CR-LF
LC19B:	LDD	$0,(IZ-$SY)	;IZ <- IZ-1
	RTN

; Other changes to the BASIC ROM:
;
; 3272:	db	"[basic ][data  ][edit  ][disk  ]"
;
; 3272:	db	"[CASL  ][basic ][edit  ][disk  ]"
;
;
; 601F:	dw	56C8, 56E3, 566D, 5E59	;basic, data, edit, disk
;
; 601F:	dw	98A0, 56C8, 566D, 5E59	;CASL, basic, edit, disk
;
;
; 5525:	pre	ix,&H6031	;= &H6037 - 6, pointers to submenus
;
; 5525:	pre	ix,&H988C	;= &H9890 - 4, pointers to submenus
;
;
; 3404:	std	$0,(ix+$sx)
;
; 3404:	nop			;frees the system variable &H0AC8
; 3405:	nop
;
;
; 55C7:	jp	&H549C
;
; 55C7:	jp	&H98B0
;
;
; 2B95:	sbc	$16,&H7F
;
; 2B95:	jp	&H98C0

