/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : main module, the only hardware dependent one
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include <stdint.h>
#include <unistd.h>
#include "common.h"
#include "basic.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
SPI_HandleTypeDef hspi1;

/* USER CODE BEGIN PV */
extern uint8_t ram[RAMSIZE];
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_SPI1_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* equivalent of writing to the address range 0x0080-0x00FF */
void lcd (unsigned int addr, uint8_t data)
{
  while ((hspi1.Instance->SR & SPI_FLAG_TXE) == 0)
    ;
  hspi1.Instance->DR = ~addr;
  while ((hspi1.Instance->SR & SPI_FLAG_TXE) == 0)
    ;
  while ((hspi1.Instance->SR & SPI_FLAG_BSY) != 0)
    ;
  HAL_GPIO_WritePin(SYNC_GPIO_Port, SYNC_Pin, GPIO_PIN_RESET);
  while ((hspi1.Instance->SR & SPI_FLAG_TXE) == 0)
    ;
  hspi1.Instance->DR = ~data;
  while ((hspi1.Instance->SR & SPI_FLAG_TXE) == 0)
    ;
  while ((hspi1.Instance->SR & SPI_FLAG_BSY) != 0)
    ;
  HAL_GPIO_WritePin(SYNC_GPIO_Port, SYNC_Pin, GPIO_PIN_SET);
}


void HAL_GPIO_EXTI_Callback(uint16_t GPIO_Pin)
{
  if (GPIO_Pin == STOP_KEY_Pin)
  {
/* 00F4: */
    ram[0x8265u-RAMSTART] |= 0x01;
  }
  if (GPIO_Pin == OFF_SW_Pin)
  {
    HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_SET); /* TEST */
    HAL_GPIO_WritePin(GPIOA, PWR_Pin, GPIO_PIN_RESET);
    HAL_SuspendTick();
    HAL_NVIC_DisableIRQ(EXTI0_IRQn);
    HAL_NVIC_DisableIRQ(EXTI1_IRQn);
    HAL_NVIC_DisableIRQ(EXTI15_10_IRQn);
    HAL_PWR_EnterSTOPMode(PWR_LOWPOWERREGULATOR_ON, PWR_STOPENTRY_WFI);
  }
}


/* roughly 0144: stops the CPU then waits for a key to be pressed */
void key_wait (void)
{
  HAL_GPIO_WritePin(KEYB_GPIO_Port, PPX_Pins, GPIO_PIN_RESET);
  if ((~KEYB_GPIO_Port->IDR & KBX_Pins) == 0)
  {
    HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_SET); /* TEST */
    HAL_SuspendTick();
    HAL_PWR_EnterSTOPMode(PWR_LOWPOWERREGULATOR_ON, PWR_STOPENTRY_WFI);
    HAL_ResumeTick();
    HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_RESET); /* TEST */
  }
}


#define NDEBOUNCE 4
#define NKEYS 20
#define KEY_SCAN_DELAY 2
#define KEY_REPEAT_DELAY 72
#define KEY_REPEAT_PERIOD 8

/* roughly 0820 to 08DA: returns the scan code of the pressed key, or 0 if the
 key is not pressed or not recognized */
int key_scan (void)
{
/* 0051: table of keyboard bit patterns */
  const unsigned int tab0051[NKEYS] = {
    KB2_Pin | KB3_Pin,		/* W, Mode, AC */
    KB2_Pin | KB4_Pin,		/* S, <-, Del */
    KB2_Pin | KB5_Pin,		/* F, [S], / */
    KB2_Pin | KB6_Pin,		/* Q, U, 9 */
    KB2_Pin | KB7_Pin,		/* C, H, 6 */
    KB3_Pin | KB4_Pin,		/* E, ->, Init */
    KB3_Pin | KB5_Pin,		/* G, [F], 7 */
    KB3_Pin | KB6_Pin,		/* X, I, * */
    KB3_Pin | KB7_Pin,		/* A, J, - */
    KB4_Pin | KB5_Pin,		/* Z, Y, 8 */
    KB4_Pin | KB6_Pin,		/* D, O, 4 */
    KB4_Pin | KB7_Pin,		/* R, K, 1 */
    KB5_Pin | KB6_Pin,		/* B, P, 5 */
    KB5_Pin | KB7_Pin,		/* T, L, 2 */
    KB6_Pin | KB7_Pin,		/* V, ANS, 3 */
    KB2_Pin | KB8_Pin,		/* none, M, + */
    KB3_Pin | KB8_Pin,		/* none, N, 0 */
    KB4_Pin | KB8_Pin,		/* none, space, dot */
    KB5_Pin | KB8_Pin,		/* none, =, EXE */
    KB6_Pin | KB8_Pin		/* none, EE, none */
  };
/* 0946: conversion table: index to tab0051 -> key scan code */
  const int tab0946[3][20] = {
/* 0946: row PP3 */
    { 0x33, 0x2F, 0x22, 0x2D,	/* W, S, F, Q */
      0x1F, 0x21, 0x23, 0x34,	/* C, E, G, X */
      0x1D, 0x36, 0x20, 0x2E,	/* A, Z, D, R */
      0x1E, 0x30, 0x32, 0x00,	/* B, T, V */
      0x00, 0x00, 0x00, 0x00				},
/* 0955: row PP2 */
    { 0x01, 0x05, 0x02, 0x31,	/* Mode, <-, [S], U */
      0x24, 0x06, 0x03, 0x25,	/* H, ->, [F], I */
      0x26, 0x35, 0x2B, 0x27,	/* J, Y, O, K */
      0x2C, 0x28, 0x09, 0x29,	/* P, L, ANS, M */
      0x2A, 0x15, 0x1C, 0x1B	/* N, space, = EE */	},
/* 0969: row PP1 */
    { 0x07, 0x08, 0x1A, 0x14,	/* AC, DEL, /, 9 */
      0x11, 0x0A, 0x12, 0x19,	/* 6, Init, 7, * */
      0x17, 0x13, 0x0F, 0x0C,	/* -, 8, 4, 1 */
      0x10, 0x0D, 0x0E, 0x18,	/* 5, 2, 3, + */
      0x0B, 0x16, 0x04, 0x00	/* 0, dot, EXE */	}
  };
  const unsigned int rowpins[3] = { PP3_Pin, PP2_Pin, PP1_Pin };
  int i, j;
  uint16_t x, y;

  for (i=0; i<3; ++i)
  {
/* select the keyboard matrix row */
    HAL_GPIO_WritePin(KEYB_GPIO_Port, PPX_Pins & ~rowpins[i], GPIO_PIN_SET);
    HAL_GPIO_WritePin(KEYB_GPIO_Port, rowpins[i], GPIO_PIN_RESET);
    delay_ms (KEY_SCAN_DELAY);
    x = ~KEYB_GPIO_Port->IDR & KEYB_Pins;
    y = x & KBX_Pins;
    if (y != 0)
    {
/* 083C: key debounce loop */
      for (j=0; j<NDEBOUNCE; ++j)
      {
    	delay_ms (KEY_SCAN_DELAY);
        if (y != (~KEYB_GPIO_Port->IDR & KBX_Pins))
        {
          break;
        }
      }
      if (j == NDEBOUNCE)
      {
/* 0848: key accepted */
        if (x != read16 (0x825E /*previous keyboard state*/))
        {
/* 0886: keyboard state changed */
          ram[0x8266u /*keyboard timer*/ - RAMSTART] = 0;
        }
        else
        {
/* 085A: still the same key pressed, test the keyboard timer for autorepeat */
          if (++ram[0x8266u /*keyboard timer*/ - RAMSTART] < KEY_REPEAT_DELAY)
          {
/* 08A4: */ 
            HAL_GPIO_WritePin(KEYB_GPIO_Port, PPX_Pins, GPIO_PIN_RESET);
            return 0;
          }
/* 0872: */
          ram[0x8266u-RAMSTART] -= KEY_REPEAT_PERIOD;
          ram[0x8262u-RAMSTART] &= 0x30;		/* bits [S], [F] */
          ram[0x8263u-RAMSTART] &= 0x20;		/* bit mode_on */
/* 087E: copy keyboard mode to mode */
          ram[0x8256u-RAMSTART] |= ram[0x8262u-RAMSTART];
          ram[0x8257u-RAMSTART] |= ram[0x8263u-RAMSTART];
        }
/* 088A: identify the keyboard bit pattern */
        for (j=0; j<NKEYS; ++j)
        {
          if (y == tab0051[j])
          {
/* 08B4: valid pattern found */
            write16 (0x825E /*previous keyboard state*/, x);
/* 08BC: copy mode to keyboard mode */
            ram[0x8262u-RAMSTART] = ram[0x8256u-RAMSTART];
            ram[0x8262u-RAMSTART] = ram[0x8256u-RAMSTART];
            HAL_GPIO_WritePin(KEYB_GPIO_Port, PPX_Pins, GPIO_PIN_RESET);
            return tab0946[i][j];
          }
        }
      }
    }
  }
/* 089C: key not pressed or not identified */
  ram[0x825Eu -RAMSTART] = 0;
  ram[0x825Fu-RAMSTART] = 0;
  ram[0x8266u-RAMSTART] = 0;
/* 08A4: */
  HAL_GPIO_WritePin(KEYB_GPIO_Port, PPX_Pins, GPIO_PIN_RESET);
  return 0;
}


void delay_ms (unsigned int x)
{
  HAL_Delay (x);
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */
  int i;
  /* USER CODE END 1 */
  

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_SPI1_Init();
  /* USER CODE BEGIN 2 */
  __HAL_SPI_ENABLE(&hspi1);
  reset ();
/* 0B9C: */
  ram[0x8265u-RAMSTART] = 0;
  ram[0x8264u-RAMSTART] &= 0x20;
  /* USER CODE END 2 */
 
 

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    do {
      ram[0x8258u-RAMSTART] = 0;
      ram[0x8259u-RAMSTART] = 0;
      i = do_direct ();
    } while (i >= 0 || i == DONE);
    error_handler (i);
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the CPU, AHB and APB busses clocks 
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_NONE;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }
  /** Initializes the CPU, AHB and APB busses clocks 
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_HSI;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV8;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_0) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief SPI1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_SPI1_Init(void)
{

  /* USER CODE BEGIN SPI1_Init 0 */

  /* USER CODE END SPI1_Init 0 */

  /* USER CODE BEGIN SPI1_Init 1 */

  /* USER CODE END SPI1_Init 1 */
  /* SPI1 parameter configuration*/
  hspi1.Instance = SPI1;
  hspi1.Init.Mode = SPI_MODE_MASTER;
  hspi1.Init.Direction = SPI_DIRECTION_2LINES;
  hspi1.Init.DataSize = SPI_DATASIZE_8BIT;
  hspi1.Init.CLKPolarity = SPI_POLARITY_LOW;
  hspi1.Init.CLKPhase = SPI_PHASE_2EDGE;
  hspi1.Init.NSS = SPI_NSS_SOFT;
  hspi1.Init.BaudRatePrescaler = SPI_BAUDRATEPRESCALER_4;
  hspi1.Init.FirstBit = SPI_FIRSTBIT_LSB;
  hspi1.Init.TIMode = SPI_TIMODE_DISABLE;
  hspi1.Init.CRCCalculation = SPI_CRCCALCULATION_DISABLE;
  hspi1.Init.CRCPolynomial = 10;
  if (HAL_SPI_Init(&hspi1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN SPI1_Init 2 */

  /* USER CODE END SPI1_Init 2 */

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_SET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, SYNC_Pin|PWR_Pin, GPIO_PIN_SET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, PP1_Pin|PP2_Pin|PP3_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin : LED_Pin */
  GPIO_InitStruct.Pin = LED_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(LED_GPIO_Port, &GPIO_InitStruct);

  /*Configure GPIO pins : SYNC_Pin PWR_Pin */
  GPIO_InitStruct.Pin = SYNC_Pin|PWR_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pins : STOP_KEY_Pin OFF_SW_Pin KB3_Pin KB4_Pin 
                           KB5_Pin KB6_Pin KB7_Pin KB8_Pin */
  GPIO_InitStruct.Pin = STOP_KEY_Pin|OFF_SW_Pin|KB3_Pin|KB4_Pin 
                          |KB5_Pin|KB6_Pin|KB7_Pin|KB8_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_IT_FALLING;
  GPIO_InitStruct.Pull = GPIO_PULLUP;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /*Configure GPIO pins : PP1_Pin PP2_Pin PP3_Pin */
  GPIO_InitStruct.Pin = PP1_Pin|PP2_Pin|PP3_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_OD;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /*Configure GPIO pin : KB2_Pin */
  GPIO_InitStruct.Pin = KB2_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_PULLUP;
  HAL_GPIO_Init(KB2_GPIO_Port, &GPIO_InitStruct);

  /* EXTI interrupt init*/
  HAL_NVIC_SetPriority(EXTI0_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(EXTI0_IRQn);

  HAL_NVIC_SetPriority(EXTI1_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(EXTI1_IRQn);

  HAL_NVIC_SetPriority(EXTI15_10_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(EXTI15_10_IRQn);

}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  while (1)
  {
    HAL_GPIO_TogglePin(LED_GPIO_Port, LED_Pin);
    HAL_Delay(100);
  }

  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
